/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issue;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.migration.export.core.issue.CloudChangeItemConverter;
import com.atlassian.jira.migration.export.core.issue.CustomFieldToChangeItemMatchingTechniques;
import com.atlassian.jira.migration.export.core.issue.JiraChangeHistory;
import com.atlassian.jira.migration.export.core.issue.JiraIssueMetadata;
import com.atlassian.jira.migration.export.core.issue.JsdChangeGroupExtractor;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.core.text.TextDocument;
import com.atlassian.migration.jira.core.ChangeGroup;
import com.atlassian.migration.jira.core.ChangeItem;
import com.atlassian.migration.jira.core.Issue;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0002H\u0016J\b\u0010(\u001a\u00020\u001eH\u0007J\u001e\u0010)\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020$0#H\u0007J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020,0#2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0#H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/atlassian/jira/migration/export/core/issue/ChangeGroupExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/issue/JiraChangeHistory;", "Lcom/atlassian/migration/jira/core/ChangeGroup;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "customFieldToChangeItemMatchingTechniques", "Lcom/atlassian/jira/migration/export/core/issue/CustomFieldToChangeItemMatchingTechniques;", "statusManager", "Lcom/atlassian/jira/config/StatusManager;", "issueTypeManager", "Lcom/atlassian/jira/config/IssueTypeManager;", "resolutionManager", "Lcom/atlassian/jira/config/ResolutionManager;", "jsdChangeGroupExtractor", "Lcom/atlassian/jira/migration/export/core/issue/JsdChangeGroupExtractor;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/core/issue/CustomFieldToChangeItemMatchingTechniques;Lcom/atlassian/jira/config/StatusManager;Lcom/atlassian/jira/config/IssueTypeManager;Lcom/atlassian/jira/config/ResolutionManager;Lcom/atlassian/jira/migration/export/core/issue/JsdChangeGroupExtractor;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapAuthor", "Lcom/atlassian/migration/base/mri/MRI;", "wrapper", "mapChangeHistoryItems", "", "Lcom/atlassian/migration/jira/core/ChangeItem;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "processUserRefsInChangeItems", "changeItems", "textDocsToStrings", "", "textDocs", "Lcom/atlassian/migration/core/text/TextDocument;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nChangeGroupExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeGroupExporter.kt\ncom/atlassian/jira/migration/export/core/issue/ChangeGroupExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1855#2:246\n1855#2,2:247\n1855#2,2:249\n1856#2:251\n1549#2:252\n1620#2,3:253\n1603#2,9:257\n1855#2:266\n1856#2:268\n1612#2:269\n1#3:256\n1#3:267\n*S KotlinDebug\n*F\n+ 1 ChangeGroupExporter.kt\ncom/atlassian/jira/migration/export/core/issue/ChangeGroupExporter\n*L\n161#1:246\n167#1:247,2\n171#1:249,2\n161#1:251\n179#1:252\n179#1:253,3\n208#1:257,9\n208#1:266\n208#1:268\n208#1:269\n208#1:267\n*E\n"})
public final class ChangeGroupExporter
implements Exporter<Long, JiraChangeHistory, ChangeGroup> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final CustomFieldToChangeItemMatchingTechniques customFieldToChangeItemMatchingTechniques;
    @NotNull
    private final StatusManager statusManager;
    @NotNull
    private final IssueTypeManager issueTypeManager;
    @NotNull
    private final ResolutionManager resolutionManager;
    @NotNull
    private final JsdChangeGroupExtractor jsdChangeGroupExtractor;
    private final Logger log;

    @Inject
    public ChangeGroupExporter(@NotNull ExportService exportService, @NotNull CustomFieldToChangeItemMatchingTechniques customFieldToChangeItemMatchingTechniques, @NotNull StatusManager statusManager, @NotNull IssueTypeManager issueTypeManager, @NotNull ResolutionManager resolutionManager, @NotNull JsdChangeGroupExtractor jsdChangeGroupExtractor) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)customFieldToChangeItemMatchingTechniques, (String)"customFieldToChangeItemMatchingTechniques");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)issueTypeManager, (String)"issueTypeManager");
        Intrinsics.checkNotNullParameter((Object)resolutionManager, (String)"resolutionManager");
        Intrinsics.checkNotNullParameter((Object)jsdChangeGroupExtractor, (String)"jsdChangeGroupExtractor");
        this.exportService = exportService;
        this.customFieldToChangeItemMatchingTechniques = customFieldToChangeItemMatchingTechniques;
        this.statusManager = statusManager;
        this.issueTypeManager = issueTypeManager;
        this.resolutionManager = resolutionManager;
        this.jsdChangeGroupExtractor = jsdChangeGroupExtractor;
        this.log = LoggerFactory.getLogger(ChangeGroupExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, JiraChangeHistory.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(ChangeGroup.Companion.getEntityType());
    }

    @Override
    @NotNull
    public ChangeGroup exportData(@NotNull ExportContext ctx, @NotNull JiraChangeHistory entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        List<ChangeItem> mappedChangedItems = this.mapChangeHistoryItems(ctx, entity);
        this.processUserRefsInChangeItems(ctx, mappedChangedItems);
        Object[] objectArray = new Object[]{entity.getId(), entity.getIssueId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting changeGroup {} associated with issue {} for migration {} under exportMode {}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        MRI mRI2 = MriExtensionsKt.mri$default(Issue.Companion.getEntityType(), entity.getIssueId(), null, 2, null);
        MRI mRI3 = this.mapAuthor(ctx, entity);
        Timestamp timestamp = entity.getTimePerformed();
        Intrinsics.checkNotNull((Object)timestamp);
        Instant instant = timestamp.toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return new ChangeGroup(mRI, mRI2, null, mRI3, instant, false, mappedChangedItems, 4, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull JiraChangeHistory entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for changeHistory {} for migration {} under exportMode {}", objectArray);
        this.mapAuthor(ctx, entity);
        this.processUserRefsInChangeItems(ctx, this.mapChangeHistoryItems(ctx, entity));
    }

    @VisibleForTesting
    public final void processUserRefsInChangeItems(@NotNull ExportContext ctx, @NotNull List<? extends ChangeItem> changeItems) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(changeItems, (String)"changeItems");
        Iterable $this$forEach$iv = changeItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            Object element$iv2;
            Iterator iterator2;
            boolean $i$f$forEach2;
            Object $this$forEach$iv2;
            List texts;
            ChangeItem item = (ChangeItem)element$iv;
            boolean bl = false;
            ctx.sendProgressUpdate();
            ChangeItem changeItem = item;
            if (changeItem instanceof ChangeItem.GenericChangeItem) {
                Object[] objectArray = new TextDocument[]{((ChangeItem.GenericChangeItem)item).getOldString(), ((ChangeItem.GenericChangeItem)item).getNewString()};
                Collection collection = this.textDocsToStrings(CollectionsKt.listOfNotNull((Object[])objectArray));
                objectArray = new String[]{((ChangeItem.GenericChangeItem)item).getNewValue(), ((ChangeItem.GenericChangeItem)item).getOldValue()};
                texts = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
                $this$forEach$iv2 = texts;
                $i$f$forEach2 = false;
                iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    it = (String)element$iv2;
                    boolean bl2 = false;
                    this.exportService.extractUserRefs(ctx, it);
                }
                continue;
            }
            if (!(changeItem instanceof ChangeItem.TextValueChangeItem)) continue;
            $this$forEach$iv2 = new TextDocument[]{((ChangeItem.TextValueChangeItem)item).getOldValue(), ((ChangeItem.TextValueChangeItem)item).getNewValue()};
            texts = this.textDocsToStrings(CollectionsKt.listOfNotNull((Object[])$this$forEach$iv2));
            $this$forEach$iv2 = texts;
            $i$f$forEach2 = false;
            iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv2 = iterator2.next();
                it = (String)element$iv2;
                boolean bl3 = false;
                this.exportService.extractUserRefs(ctx, it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> textDocsToStrings(List<? extends TextDocument> textDocs) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = textDocs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void textDoc;
            TextDocument textDocument = (TextDocument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = textDoc;
            if (var11_11 instanceof TextDocument.Wiki) {
                string = ((TextDocument.Wiki)textDoc).getData();
            } else if (var11_11 instanceof TextDocument.PlainText) {
                string = ((TextDocument.PlainText)textDoc).getData();
            } else if (var11_11 instanceof TextDocument.Adf) {
                string = ((TextDocument.Adf)textDoc).getData().asText();
            } else {
                throw new IllegalArgumentException("Unsupported text document type: " + Reflection.getOrCreateKotlinClass(textDoc.getClass()).getSimpleName());
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull JiraChangeHistory entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(ChangeGroup.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MRI mapAuthor(ExportContext ctx, JiraChangeHistory wrapper) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(wrapper.getAuthorKey());
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ChangeItem> mapChangeHistoryItems(ExportContext ctx, JiraChangeHistory entity) {
        void $this$mapNotNullTo$iv$iv;
        List changedItemBeansByNewest = CollectionsKt.reversed((Iterable)entity.getChangeItemBeans());
        Iterable $this$mapNotNull$iv = changedItemBeansByNewest;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ChangeItem it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ChangeItemBean it = (ChangeItemBean)element$iv$iv;
            boolean bl2 = false;
            if (new CloudChangeItemConverter(ctx, this.exportService, this.customFieldToChangeItemMatchingTechniques, this.statusManager, it, new JiraIssueMetadata(entity.getIssueId(), this.issueTypeManager.getIssueType(entity.getIssueType()), entity.getProjectId()), this.issueTypeManager, this.resolutionManager, this.jsdChangeGroupExtractor).convert() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    @Override
    @Nullable
    public JiraChangeHistory extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull JiraChangeHistory entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

