/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issue;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.export.core.issue.ChangeGroupExporterKt;
import com.atlassian.jira.migration.export.core.issue.ChangeItemBeanWithMetadata;
import com.atlassian.jira.migration.export.core.issue.ChangeItemCustomFieldData;
import com.atlassian.jira.migration.export.core.issue.CloudChangeItemConverterKt;
import com.atlassian.jira.migration.export.core.issue.CustomFieldToChangeItemMatchingTechniques;
import com.atlassian.jira.migration.export.core.issue.CustomFieldToChangeItemMatchingTechniquesProviderKt;
import com.atlassian.jira.migration.export.core.issue.JiraIssueMetadata;
import com.atlassian.jira.migration.export.core.issue.JsdChangeGroupExtractor;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.JSDConstants;
import com.atlassian.jira.migration.export.model.TextDocumentType;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.TextSanitizer;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.MRIType;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.core.text.TextDocument;
import com.atlassian.migration.jira.classic.Project;
import com.atlassian.migration.jira.classic.customfield.CustomFieldOption;
import com.atlassian.migration.jira.classic.issuesecurity.IssueSecurityLevel;
import com.atlassian.migration.jira.classic.issuestatus.IssueStatus;
import com.atlassian.migration.jira.classic.software.sprint.Sprint;
import com.atlassian.migration.jira.classic.worklogs.Worklog;
import com.atlassian.migration.jira.core.ChangeItem;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.JiraCoreMriRegistry;
import com.atlassian.migration.jira.core.Priority;
import com.atlassian.migration.jira.core.ProjectComponent;
import com.atlassian.migration.jira.core.Resolution;
import com.atlassian.migration.jira.core.attachment.FileAttachment;
import com.atlassian.migration.jira.core.version.ProjectVersion;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ]2\u00020\u0001:\u0001]BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J*\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0002J<\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0/0-H\u0002J\"\u00100\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u00102\u001a\u0002032\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0002J*\u00104\u001a\u0002052\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\"\u00106\u001a\u0002032\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u00107\u001a\u0002032\u0006\u00108\u001a\u00020.H\u0002J\"\u00109\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010:\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010;\u001a\u00020\u0016H\u0002JO\u0010<\u001a\u00020.\"\b\b\u0000\u0010=*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010>\u001a\u00020.2#\u0010?\u001a\u001f\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b@\u0012\b\bA\u0012\u0004\b\b(>\u0012\u0006\u0012\u0004\u0018\u0001H=0-H\u0002J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001a0/2\u0006\u0010C\u001a\u00020.2\u0006\u0010D\u001a\u00020EH\u0002J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001a0/2\u0006\u0010G\u001a\u00020.H\u0002J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001a0/2\u0006\u0010I\u001a\u00020.H\u0002J\u0010\u0010J\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020LH\u0002J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001a0/2\u0006\u0010N\u001a\u00020.H\u0002J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001a0/2\u0006\u0010P\u001a\u00020.H\u0002J \u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020T0/2\b\u0010\n\u001a\u0004\u0018\u00010.H\u0002J\n\u0010U\u001a\u0004\u0018\u00010EH\u0002JO\u0010V\u001a\u00020\u000b\"\b\b\u0000\u0010=*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2#\u0010?\u001a\u001f\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b@\u0012\b\bA\u0012\u0004\b\b(>\u0012\u0006\u0012\u0004\u0018\u0001H=0-H\u0002J\u0010\u0010W\u001a\u00020\u001a2\u0006\u00108\u001a\u00020.H\u0002J\n\u0010X\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u0010Y\u001a\u0004\u0018\u00010\u00162\u0006\u0010D\u001a\u00020EH\u0007J\u0018\u0010Z\u001a\u00020\u000b2\u0006\u0010[\u001a\u00020\\2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/atlassian/jira/migration/export/core/issue/CloudChangeItemConverter;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "customFieldToChangeItemMatchingTechniques", "Lcom/atlassian/jira/migration/export/core/issue/CustomFieldToChangeItemMatchingTechniques;", "statusManager", "Lcom/atlassian/jira/config/StatusManager;", "bean", "Lcom/atlassian/jira/issue/history/ChangeItemBean;", "jiraIssueMetadata", "Lcom/atlassian/jira/migration/export/core/issue/JiraIssueMetadata;", "issueTypeManager", "Lcom/atlassian/jira/config/IssueTypeManager;", "resolutionManager", "Lcom/atlassian/jira/config/ResolutionManager;", "jsdChangeGroupExtractor", "Lcom/atlassian/jira/migration/export/core/issue/JsdChangeGroupExtractor;", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/core/issue/CustomFieldToChangeItemMatchingTechniques;Lcom/atlassian/jira/config/StatusManager;Lcom/atlassian/jira/issue/history/ChangeItemBean;Lcom/atlassian/jira/migration/export/core/issue/JiraIssueMetadata;Lcom/atlassian/jira/config/IssueTypeManager;Lcom/atlassian/jira/config/ResolutionManager;Lcom/atlassian/jira/migration/export/core/issue/JsdChangeGroupExtractor;)V", "convert", "Lcom/atlassian/migration/jira/core/ChangeItem;", "createCascadeSelectChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$CascadeSelectChangeItem;", "mri", "Lcom/atlassian/migration/base/mri/MRI;", "nextChanged", "Ljava/time/Instant;", "createDateChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$DateChangeItem;", "createDateTimeChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$DateTimeChangeItem;", "createGenericChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$GenericChangeItem;", "docType", "Lcom/atlassian/jira/migration/export/model/TextDocumentType;", "createIdRefChangeItemForWorkLogId", "Lcom/atlassian/migration/jira/core/ChangeItem$IdReferenceChangeItem;", "entityType", "Lcom/atlassian/migration/base/mri/registry/EntityType;", "createMultiReferenceChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$MultiReferenceChangeItem;", "fieldMri", "toMris", "Lkotlin/Function1;", "", "", "createMultiSprintReferenceChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$SprintChangeItem;", "createSingleReferenceChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$SingleReferenceChangeItem;", "createTextValueChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$TextValueChangeItem;", "createUserReferenceChangeItem", "createVersionHistory", "fieldId", "createWorkflowChangeItem", "customFieldToCloudChangeItem", "defineChangeItemForStatus", "exportedOrBlank", "JiraEntity", "id", "entityGetter", "Lkotlin/ParameterName;", "name", "getGroupRefs", "groupRefs", "fieldData", "Lcom/atlassian/jira/migration/export/core/issue/ChangeItemCustomFieldData;", "getOptionRefs", "optionRefs", "getSprintRefs", "sprintRefs", "getUserRefOrThrow", "userRef", "Lcom/atlassian/jira/migration/export/model/UserRef;", "getUserRefs", "userRefs", "getVersionRefs", "versionRefs", "isUnknownOptionValue", "", "someOptions", "Lcom/atlassian/jira/issue/customfields/option/Option;", "locateIssueDataForCustomFieldChangeItem", "onlyIfMigrated", "standardFieldMri", "standardFieldToCloudChangeItem", "toCustomFieldChangeItem", "unmigratedBean", "field", "Lcom/atlassian/jira/issue/fields/CustomField;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudChangeItemConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudChangeItemConverter.kt\ncom/atlassian/jira/migration/export/core/issue/CloudChangeItemConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,658:1\n1#2:659\n1#2:673\n2624#3,3:660\n1603#3,9:663\n1855#3:672\n1856#3:674\n1612#3:675\n1549#3:676\n1620#3,3:677\n1549#3:680\n1620#3,3:681\n1549#3:684\n1620#3,3:685\n1549#3:688\n1620#3,3:689\n1549#3:692\n1620#3,3:693\n*S KotlinDebug\n*F\n+ 1 CloudChangeItemConverter.kt\ncom/atlassian/jira/migration/export/core/issue/CloudChangeItemConverter\n*L\n578#1:673\n287#1:660,3\n578#1:663,9\n578#1:672\n578#1:674\n578#1:675\n579#1:676\n579#1:677,3\n587#1:680\n587#1:681,3\n599#1:684\n599#1:685,3\n605#1:688\n605#1:689,3\n608#1:692\n608#1:693,3\n*E\n"})
public final class CloudChangeItemConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportContext ctx;
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final CustomFieldToChangeItemMatchingTechniques customFieldToChangeItemMatchingTechniques;
    @NotNull
    private final StatusManager statusManager;
    @NotNull
    private final ChangeItemBean bean;
    @NotNull
    private final JiraIssueMetadata jiraIssueMetadata;
    @NotNull
    private final IssueTypeManager issueTypeManager;
    @NotNull
    private final ResolutionManager resolutionManager;
    @NotNull
    private final JsdChangeGroupExtractor jsdChangeGroupExtractor;
    private static final Logger log = LoggerFactory.getLogger(CloudChangeItemConverter.class);
    @NotNull
    public static final String LINK_FIELD = "Link";
    @NotNull
    public static final String PARENT = "Parent";
    @NotNull
    public static final String KEY_FIELD = "Key";
    @NotNull
    public static final String EPIC_CHILD = "Epic Child";
    @NotNull
    public static final String WORKFLOW_FIELD = "Workflow";
    @NotNull
    public static final String ARCHIVED = "Archived";
    @NotNull
    public static final String RESTORED = "Restored";
    @NotNull
    public static final String COMPONENT = "Component";
    @NotNull
    public static final String FIXED_VERSION = "Fix Version";
    @NotNull
    public static final String AFFECTED_VERSION = "Version";
    @NotNull
    public static final String REMOTE_ISSUE_LINK = "RemoteIssueLink";
    @NotNull
    private static final Set<String> PLAIN_TEXT_CUSTOM_TYPES;
    @NotNull
    private static final Set<String> WIKI_TEXT_CUSTOM_TYPES;
    @NotNull
    private static final Set<String> SINGLE_SELECT_CUSTOM_TYPES;

    public CloudChangeItemConverter(@NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull CustomFieldToChangeItemMatchingTechniques customFieldToChangeItemMatchingTechniques, @NotNull StatusManager statusManager, @NotNull ChangeItemBean bean, @NotNull JiraIssueMetadata jiraIssueMetadata, @NotNull IssueTypeManager issueTypeManager, @NotNull ResolutionManager resolutionManager, @NotNull JsdChangeGroupExtractor jsdChangeGroupExtractor) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)customFieldToChangeItemMatchingTechniques, (String)"customFieldToChangeItemMatchingTechniques");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)jiraIssueMetadata, (String)"jiraIssueMetadata");
        Intrinsics.checkNotNullParameter((Object)issueTypeManager, (String)"issueTypeManager");
        Intrinsics.checkNotNullParameter((Object)resolutionManager, (String)"resolutionManager");
        Intrinsics.checkNotNullParameter((Object)jsdChangeGroupExtractor, (String)"jsdChangeGroupExtractor");
        this.ctx = ctx;
        this.exportService = exportService;
        this.customFieldToChangeItemMatchingTechniques = customFieldToChangeItemMatchingTechniques;
        this.statusManager = statusManager;
        this.bean = bean;
        this.jiraIssueMetadata = jiraIssueMetadata;
        this.issueTypeManager = issueTypeManager;
        this.resolutionManager = resolutionManager;
        this.jsdChangeGroupExtractor = jsdChangeGroupExtractor;
    }

    @Nullable
    public final ChangeItem convert() {
        this.ctx.sendProgressUpdate();
        return Intrinsics.areEqual((Object)this.bean.getFieldType(), (Object)"custom") ? this.customFieldToCloudChangeItem() : this.standardFieldToCloudChangeItem();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ChangeItem customFieldToCloudChangeItem() {
        ChangeItem changeItem;
        this.ctx.sendProgressUpdate();
        String string = this.bean.getField();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 10254401: {
                    if (!string.equals(EPIC_CHILD)) break;
                    n = 1;
                    break;
                }
                case -1651663870: {
                    if (!string.equals(ARCHIVED)) break;
                    n = 2;
                    break;
                }
                case -271981642: {
                    if (!string.equals(RESTORED)) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    changeItem = (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri(EPIC_CHILD), null, this.bean, Issue.Companion.getEntityType());
                    return changeItem;
                }
                case 2: {
                    changeItem = (ChangeItem)this.createGenericChangeItem(this.standardFieldMri(ARCHIVED), null, this.bean, TextDocumentType.PLAIN_TEXT);
                    return changeItem;
                }
                case 3: {
                    changeItem = (ChangeItem)this.createGenericChangeItem(this.standardFieldMri(RESTORED), null, this.bean, TextDocumentType.PLAIN_TEXT);
                    return changeItem;
                }
            }
        }
        ChangeItemCustomFieldData changeItemCustomFieldData = this.locateIssueDataForCustomFieldChangeItem();
        if (changeItemCustomFieldData == null) return null;
        ChangeItemCustomFieldData it = changeItemCustomFieldData;
        boolean bl = false;
        changeItem = this.toCustomFieldChangeItem(it);
        return changeItem;
    }

    /*
     * Unable to fully structure code
     */
    private final ChangeItem standardFieldToCloudChangeItem() {
        block48: {
            block55: {
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                block50: {
                                    block49: {
                                        block47: {
                                            this.ctx.sendProgressUpdate();
                                            var1_1 = this.bean.getField();
                                            if (!Intrinsics.areEqual((Object)var1_1, (Object)"Parent")) break block47;
                                            v0 = this.bean.getField();
                                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getField(...)");
                                            v1 = (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri(v0), null, this.bean, Issue.Companion.getEntityType());
                                            break block48;
                                        }
                                        if (!Intrinsics.areEqual((Object)var1_1, (Object)"Component")) break block49;
                                        v1 = (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri("components"), null, this.bean, ProjectComponent.Companion.getEntityType());
                                        break block48;
                                    }
                                    if (!Intrinsics.areEqual((Object)var1_1, (Object)"Fix Version")) break block50;
                                    v1 = (ChangeItem)this.createVersionHistory("fixVersions");
                                    break block48;
                                }
                                if (!Intrinsics.areEqual((Object)var1_1, (Object)"Version")) break block51;
                                v1 = (ChangeItem)this.createVersionHistory("versions");
                                break block48;
                            }
                            if (Intrinsics.areEqual((Object)var1_1, (Object)"attachment")) {
                                v2 = true;
                            } else {
                                v3 = var1_1;
                                var2_2 = "attachment";
                                if (((CharSequence)var2_2).length() > 0) {
                                    var3_3 = var2_2.charAt(0);
                                    var6_6 = new StringBuilder();
                                    var5_7 = v3;
                                    $i$a$-replaceFirstCharWithCharSequence-CloudChangeItemConverter$standardFieldToCloudChangeItem$1 = 0;
                                    var7_9 = CharsKt.titlecase((char)it);
                                    v3 = var5_7;
                                    v4 = var6_6.append((Object)var7_9);
                                    it = var2_2;
                                    $i$a$-replaceFirstCharWithCharSequence-CloudChangeItemConverter$standardFieldToCloudChangeItem$1 = 1;
                                    v5 = it.substring($i$a$-replaceFirstCharWithCharSequence-CloudChangeItemConverter$standardFieldToCloudChangeItem$1);
                                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
                                    v6 = v4.append(v5).toString();
                                } else {
                                    v6 = var2_2;
                                }
                                v2 = Intrinsics.areEqual((Object)v3, (Object)v6);
                            }
                            if (!v2) break block52;
                            v1 = (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri("attachment"), null, this.bean, FileAttachment.Companion.getEntityType());
                            break block48;
                        }
                        if (!Intrinsics.areEqual((Object)var1_1, (Object)"issuetype")) break block53;
                        v7 = this.bean.getField();
                        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getField(...)");
                        v1 = (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri(v7), null, this.onlyIfMigrated(this.ctx, this.exportService, this.bean, (Function1)new Function1<String, IssueType>(this){
                            final /* synthetic */ CloudChangeItemConverter this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @Nullable
                            public final IssueType invoke(@NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return CloudChangeItemConverter.access$getIssueTypeManager$p(this.this$0).getIssueType(it);
                            }
                        }), com.atlassian.migration.jira.classic.issuetype.IssueType.Companion.getEntityType());
                        break block48;
                    }
                    if (var1_1 == null) break block54;
                    switch (var1_1.hashCode()) {
                        case -1857640538: {
                            if (!var1_1.equals("summary")) {
                                break;
                            }
                            ** GOTO lbl72
                        }
                        case -1681827083: {
                            if (!var1_1.equals("timeestimate")) {
                                break;
                            }
                            ** GOTO lbl72
                        }
                        case 55011009: {
                            if (!var1_1.equals("timespent")) {
                                break;
                            }
                            ** GOTO lbl72
                        }
                        case 201418438: {
                            if (!var1_1.equals("timeoriginalestimate")) {
                                break;
                            }
                            ** GOTO lbl72
                        }
                        case -1110417409: {
                            if (!var1_1.equals("labels")) break;
lbl72:
                            // 5 sources

                            v8 = true;
                            break block55;
                        }
                    }
                }
                v8 = Intrinsics.areEqual((Object)var1_1, (Object)"WorklogTimeSpent");
            }
            if (v8) {
                v9 = this.bean.getField();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getField(...)");
                v1 = (ChangeItem)this.createGenericChangeItem(this.standardFieldMri(v9), null, this.bean, TextDocumentType.PLAIN_TEXT);
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"Key")) {
                v1 = (ChangeItem)this.createGenericChangeItem(this.standardFieldMri("issuekey"), null, this.bean, TextDocumentType.PLAIN_TEXT);
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"description") != false ? true : Intrinsics.areEqual((Object)var1_1, (Object)"environment")) {
                v10 = this.bean.getField();
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getField(...)");
                v1 = (ChangeItem)this.createGenericChangeItem(this.standardFieldMri(v10), null, this.bean, TextDocumentType.WIKI);
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"project")) {
                v11 = this.bean.getField();
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getField(...)");
                v1 = (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri(v11), null, this.bean, Project.Companion.getEntityType());
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"status")) {
                v1 = this.defineChangeItemForStatus();
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"priority")) {
                v12 = this.bean.getField();
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getField(...)");
                v1 = (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri(v12), null, this.bean, Priority.Companion.getEntityType());
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"WorklogId")) {
                v13 = this.bean.getField();
                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"getField(...)");
                v1 = (ChangeItem)this.createIdRefChangeItemForWorkLogId(this.standardFieldMri(v13), null, this.bean, Worklog.Companion.getEntityType());
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"resolution")) {
                v14 = this.bean.getField();
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getField(...)");
                v1 = (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri(v14), null, this.onlyIfMigrated(this.ctx, this.exportService, this.bean, (Function1)new Function1<String, com.atlassian.jira.issue.resolution.Resolution>(this){
                    final /* synthetic */ CloudChangeItemConverter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final com.atlassian.jira.issue.resolution.Resolution invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return CloudChangeItemConverter.access$getResolutionManager$p(this.this$0).getResolution(it);
                    }
                }), Resolution.Companion.getEntityType());
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"reporter") != false ? true : Intrinsics.areEqual((Object)var1_1, (Object)"assignee")) {
                v15 = this.bean.getField();
                Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"getField(...)");
                v1 = (ChangeItem)this.createUserReferenceChangeItem(this.standardFieldMri(v15), null, this.bean);
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"duedate")) {
                v16 = this.bean.getField();
                Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"getField(...)");
                v1 = (ChangeItem)this.createDateChangeItem(this.standardFieldMri(v16), null, this.bean);
            } else if (Intrinsics.areEqual((Object)var1_1, (Object)"security")) {
                v17 = this.bean.getField();
                Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"getField(...)");
                v1 = (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri(v17), null, this.bean, IssueSecurityLevel.Companion.getEntityType());
            } else if ((Intrinsics.areEqual((Object)var1_1, (Object)"Link") != false ? true : Intrinsics.areEqual((Object)var1_1, (Object)"RemoteIssueLink")) != false ? true : Intrinsics.areEqual((Object)var1_1, (Object)"issuelinks")) {
                v1 = (ChangeItem)this.createGenericChangeItem(this.standardFieldMri("issuelinks"), null, this.bean, TextDocumentType.WIKI);
            } else {
                if (Intrinsics.areEqual((Object)var1_1, (Object)"comment")) {
                    v18 = true;
                } else {
                    v19 = var1_1;
                    var2_2 = "comment";
                    if (((CharSequence)var2_2).length() > 0) {
                        it = var2_2.charAt(0);
                        var6_6 = new StringBuilder();
                        var5_7 = v19;
                        $i$a$-replaceFirstCharWithCharSequence-CloudChangeItemConverter$standardFieldToCloudChangeItem$4 = 0;
                        var7_9 = CharsKt.titlecase((char)it);
                        v19 = var5_7;
                        v20 = var6_6.append((Object)var7_9);
                        it = var2_2;
                        $i$a$-replaceFirstCharWithCharSequence-CloudChangeItemConverter$standardFieldToCloudChangeItem$4 = 1;
                        v21 = it.substring($i$a$-replaceFirstCharWithCharSequence-CloudChangeItemConverter$standardFieldToCloudChangeItem$4);
                        Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"substring(...)");
                        v22 = v20.append(v21).toString();
                    } else {
                        v22 = var2_2;
                    }
                    v18 = Intrinsics.areEqual((Object)v19, (Object)v22);
                }
                if (v18) {
                    v1 = (ChangeItem)this.createTextValueChangeItem(this.standardFieldMri("comment"), null, this.bean, TextDocumentType.WIKI);
                } else if (Intrinsics.areEqual((Object)var1_1, (Object)"Workflow")) {
                    v23 = this.bean.getField();
                    Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"getField(...)");
                    v1 = (ChangeItem)this.createWorkflowChangeItem(this.standardFieldMri(v23), null, this.bean);
                } else {
                    CloudChangeItemConverter.log.debug(this.bean.getField() + " on Issue " + this.jiraIssueMetadata.getIssueId() + " can't be converted to cloud change item");
                    it = Unit.INSTANCE;
                    $i$a$-let-CloudChangeItemConverter$standardFieldToCloudChangeItem$5 = false;
                    v1 = null;
                }
            }
        }
        return v1;
    }

    private final ChangeItem defineChangeItemForStatus() {
        String string = this.bean.getField();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getField(...)");
        return (ChangeItem)this.createSingleReferenceChangeItem(this.standardFieldMri(string), null, this.onlyIfMigrated(this.ctx, this.exportService, this.bean, (Function1)new Function1<String, Status>(this){
            final /* synthetic */ CloudChangeItemConverter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Status invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CloudChangeItemConverter.access$getStatusManager$p(this.this$0).getStatus(it);
            }
        }), IssueStatus.Companion.getEntityType());
    }

    private final <JiraEntity> ChangeItemBean onlyIfMigrated(ExportContext ctx, ExportService exportService, ChangeItemBean bean, Function1<? super String, ? extends JiraEntity> entityGetter) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        block7: {
            block6: {
                String string6;
                String string7;
                String string8;
                block5: {
                    block4: {
                        string5 = bean.getFieldType();
                        string4 = bean.getField();
                        string3 = bean.getFrom();
                        if (string3 == null) break block4;
                        String string9 = string3;
                        string8 = string4;
                        string7 = string5;
                        boolean bl = false;
                        String string10 = bean.getFrom();
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getFrom(...)");
                        string6 = this.exportedOrBlank(ctx, exportService, string10, entityGetter);
                        string5 = string7;
                        string4 = string8;
                        String string11 = string6;
                        string3 = string11;
                        if (string11 != null) break block5;
                    }
                    string3 = "";
                }
                string2 = bean.getFromString();
                string = bean.getTo();
                if (string == null) break block6;
                String it = string;
                String string12 = string2;
                string6 = string3;
                string8 = string4;
                string7 = string5;
                boolean bl = false;
                String string13 = bean.getTo();
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getTo(...)");
                String string14 = this.exportedOrBlank(ctx, exportService, string13, entityGetter);
                string5 = string7;
                string4 = string8;
                string3 = string6;
                string2 = string12;
                String string15 = string14;
                string = string15;
                if (string15 != null) break block7;
            }
            string = "";
        }
        String string16 = bean.getToString();
        String string17 = string;
        String string18 = string2;
        String string19 = string3;
        String string20 = string4;
        String string21 = string5;
        return new ChangeItemBean(string21, string20, string19, string18, string17, string16);
    }

    private final <JiraEntity> String exportedOrBlank(ExportContext ctx, ExportService exportService, String id, Function1<? super String, ? extends JiraEntity> entityGetter) {
        boolean bl;
        Object object = entityGetter.invoke((Object)id);
        if (object != null) {
            Object it = object;
            boolean bl2 = false;
            bl = exportService.checkExported(ctx, it).isExported();
        } else {
            bl = false;
        }
        return bl ? id : "";
    }

    private final ChangeItem.SingleReferenceChangeItem createVersionHistory(String fieldId) {
        this.ctx.sendProgressUpdate();
        return this.createSingleReferenceChangeItem(this.standardFieldMri(fieldId), null, this.bean, ProjectVersion.Companion.getEntityType());
    }

    private final ChangeItemCustomFieldData locateIssueDataForCustomFieldChangeItem() {
        ChangeItemCustomFieldData changeItemCustomFieldData;
        CustomField customField = (CustomField)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.customFieldToChangeItemMatchingTechniques), (Function1)((Function1)new Function1<Function1<? super ChangeItemBeanWithMetadata, ? extends CustomField>, CustomField>(this){
            final /* synthetic */ CloudChangeItemConverter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final CustomField invoke(@NotNull Function1<? super ChangeItemBeanWithMetadata, ? extends CustomField> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (CustomField)it.invoke((Object)new ChangeItemBeanWithMetadata(CloudChangeItemConverter.access$getBean$p(this.this$0), CloudChangeItemConverter.access$getJiraIssueMetadata$p(this.this$0)));
            }
        })));
        if (customField != null) {
            CustomField it = customField;
            boolean bl = false;
            changeItemCustomFieldData = new ChangeItemCustomFieldData(this.unmigratedBean(it, this.bean), it, null);
        } else {
            changeItemCustomFieldData = null;
        }
        CustomField it = customField = changeItemCustomFieldData;
        boolean bl = false;
        if (it == null) {
            log.debug("no field matched to change item with field name: " + this.bean.getField() + " in issue: " + this.jiraIssueMetadata.getIssueId());
        }
        return customField;
    }

    private final ChangeItemBean unmigratedBean(CustomField field, ChangeItemBean bean) {
        List<Option> someOptions2 = this.ctx.getOrPutOptions(field, (Function0<? extends List<? extends Option>>)((Function0)new Function0<List<? extends Option>>(field){
            final /* synthetic */ CustomField $field;
            {
                this.$field = $field;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Option> invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$flatMapTo$iv$iv2;
                List list = this.$field.getConfigurationSchemes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurationSchemes(...)");
                Iterable $this$flatMap$iv = list;
                boolean $i$f$flatMap22 = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv2) {
                    FieldConfigScheme it = (FieldConfigScheme)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = CollectionsKt.filterNotNull((Iterable)it.getConfigs().values());
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                CustomField $i$f$flatMap22 = this.$field;
                boolean $i$f$mapNotNull22 = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> bl = $this$forEach$iv$iv$iv.iterator();
                while (bl.hasNext()) {
                    Options it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = bl.next();
                    boolean bl2 = false;
                    FieldConfig it = (FieldConfig)element$iv$iv;
                    boolean bl3 = false;
                    if ($i$f$flatMap22.getOptions("", it, null) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv2;
                boolean $i$f$flatMap = false;
                Iterable $i$f$mapNotNull22 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    Options it = (Options)element$iv$iv;
                    boolean bl5 = false;
                    List list2 = it.getRootOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRootOptions(...)");
                    Iterable list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
            }
        }));
        if (CollectionsKt.any((Iterable)someOptions2)) {
            if (this.isUnknownOptionValue(someOptions2, bean.getFromString())) {
                bean.setFrom("");
            }
            if (this.isUnknownOptionValue(someOptions2, bean.getToString())) {
                bean.setTo("");
            }
        }
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnknownOptionValue(List<? extends Option> someOptions2, String bean) {
        Option it;
        CharSequence charSequence = bean;
        if (charSequence == null) return false;
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        Iterable $this$none$iv = someOptions2;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (Option)element$iv;
            boolean bl2 = false;
        } while (!Intrinsics.areEqual((Object)it.getValue(), (Object)bean));
        return false;
    }

    @VisibleForTesting
    @Nullable
    public final ChangeItem toCustomFieldChangeItem(@NotNull ChangeItemCustomFieldData fieldData) {
        ChangeItem changeItem;
        Intrinsics.checkNotNullParameter((Object)fieldData, (String)"fieldData");
        MRI issueCustomFieldMri = this.exportService.mri(fieldData.getCustomField());
        String string = fieldData.getCustomField().getCustomFieldType().getKey();
        if (PLAIN_TEXT_CUSTOM_TYPES.contains(string) ? true : Intrinsics.areEqual((Object)string, (Object)"com.atlassian.teams:rm-teams-custom-field-team")) {
            changeItem = (ChangeItem)this.createGenericChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem(), TextDocumentType.PLAIN_TEXT);
        } else if (WIKI_TEXT_CUSTOM_TYPES.contains(string)) {
            changeItem = (ChangeItem)this.createGenericChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem(), TextDocumentType.WIKI);
        } else if (SINGLE_SELECT_CUSTOM_TYPES.contains(string)) {
            changeItem = (ChangeItem)this.createSingleReferenceChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem(), CustomFieldOption.Companion.getEntityType());
        } else if ((Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:datepicker") ? true : Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jpo:jpo-custom-field-baseline-end")) ? true : Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jpo:jpo-custom-field-baseline-start")) {
            changeItem = (ChangeItem)this.createDateChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem());
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:datetime")) {
            changeItem = (ChangeItem)this.createDateTimeChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem());
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:userpicker")) {
            changeItem = (ChangeItem)this.createUserReferenceChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem());
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker")) {
            changeItem = (ChangeItem)this.createMultiReferenceChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem(), (Function1<? super String, ? extends List<MRI>>)((Function1)new Function1<String, List<? extends MRI>>((Object)this){

                @NotNull
                public final List<MRI> invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return CloudChangeItemConverter.access$getUserRefs((CloudChangeItemConverter)this.receiver, p0);
                }
            }));
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiselect") ? true : Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes")) {
            changeItem = (ChangeItem)this.createMultiReferenceChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem(), (Function1<? super String, ? extends List<MRI>>)((Function1)new Function1<String, List<? extends MRI>>((Object)this){

                @NotNull
                public final List<MRI> invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return CloudChangeItemConverter.access$getOptionRefs((CloudChangeItemConverter)this.receiver, p0);
                }
            }));
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:grouppicker") ? true : Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker")) {
            changeItem = (ChangeItem)this.createMultiReferenceChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem(), (Function1<? super String, ? extends List<MRI>>)((Function1)new Function1<String, List<? extends MRI>>(this, fieldData){
                final /* synthetic */ CloudChangeItemConverter this$0;
                final /* synthetic */ ChangeItemCustomFieldData $fieldData;
                {
                    this.this$0 = $receiver;
                    this.$fieldData = $fieldData;
                    super(1);
                }

                @NotNull
                public final List<MRI> invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return CloudChangeItemConverter.access$getGroupRefs(this.this$0, it, this.$fieldData);
                }
            }));
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.pyxis.greenhopper.jira:gh-epic-link") ? true : Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jpo:jpo-custom-field-parent")) {
            changeItem = (ChangeItem)this.createSingleReferenceChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem(), Issue.Companion.getEntityType());
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.pyxis.greenhopper.jira:gh-sprint")) {
            changeItem = (ChangeItem)this.createMultiSprintReferenceChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem());
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect")) {
            changeItem = (ChangeItem)this.createCascadeSelectChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem());
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:version") ? true : Intrinsics.areEqual((Object)string, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion")) {
            changeItem = (ChangeItem)this.createMultiReferenceChangeItem(issueCustomFieldMri, fieldData.getNextChange(), fieldData.getChangeItem(), (Function1<? super String, ? extends List<MRI>>)((Function1)new Function1<String, List<? extends MRI>>((Object)this){

                @NotNull
                public final List<MRI> invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return CloudChangeItemConverter.access$getVersionRefs((CloudChangeItemConverter)this.receiver, p0);
                }
            }));
        } else if (JSDConstants.INSTANCE.getJSD_CUSTOM_FIELDS().contains(string)) {
            changeItem = this.jsdChangeGroupExtractor.toCustomFieldChangeItem(fieldData, this.jiraIssueMetadata, this.ctx);
        } else {
            log.debug("CustomField Type " + fieldData.getCustomField().getCustomFieldType().getKey() + " on Issue " + this.jiraIssueMetadata.getIssueId() + " can't be converted to cloud change item");
            changeItem = null;
        }
        return changeItem;
    }

    private final ChangeItem.GenericChangeItem createGenericChangeItem(MRI mri, Instant nextChanged, ChangeItemBean bean, TextDocumentType docType) {
        String string = bean.getFrom();
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        String string2 = TextSanitizer.sanitizedNullableText$default(TextSanitizer.INSTANCE, string, logger2, "old value of change item " + mri, 0, 8, null);
        String string3 = bean.getFromString();
        Logger logger3 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
        TextDocument textDocument = docType.createOrNull(TextSanitizer.sanitizedNullableText$default(TextSanitizer.INSTANCE, string3, logger3, "old string value of change item " + mri, 0, 8, null));
        String string4 = bean.getTo();
        Logger logger4 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"log");
        String string5 = TextSanitizer.sanitizedNullableText$default(TextSanitizer.INSTANCE, string4, logger4, "new value of change item " + mri, 0, 8, null);
        String string6 = bean.getToString();
        Logger logger5 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"log");
        return new ChangeItem.GenericChangeItem(mri, nextChanged, string2, textDocument, string5, docType.createOrNull(TextSanitizer.sanitizedNullableText$default(TextSanitizer.INSTANCE, string6, logger5, "new string value of change item " + mri, 0, 8, null)));
    }

    private final ChangeItem.GenericChangeItem createWorkflowChangeItem(MRI mri, Instant nextChanged, ChangeItemBean bean) {
        String string = bean.getFromString();
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        TextDocument textDocument = TextDocumentType.PLAIN_TEXT.createOrNull(TextSanitizer.sanitizedNullableText$default(TextSanitizer.INSTANCE, string, logger2, "old string value of change item " + mri, 0, 8, null));
        String string2 = bean.getToString();
        Logger logger3 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
        return new ChangeItem.GenericChangeItem(mri, nextChanged, null, textDocument, null, TextDocumentType.PLAIN_TEXT.createOrNull(TextSanitizer.sanitizedNullableText$default(TextSanitizer.INSTANCE, string2, logger3, "new string value of change item " + mri, 0, 8, null)));
    }

    private final ChangeItem.SingleReferenceChangeItem createUserReferenceChangeItem(MRI mri, Instant nextChanged, ChangeItemBean bean) {
        MRI mRI;
        MRI mRI2;
        MRI mRI3;
        UserRef it;
        MRI mRI4;
        Instant instant;
        MRI mRI5 = mri;
        Instant instant2 = nextChanged;
        UserRef userRef = UserRef.Companion.fromString(bean.getFrom());
        if (userRef != null) {
            UserRef userRef2 = userRef;
            instant = instant2;
            mRI4 = mRI5;
            boolean bl = false;
            mRI3 = this.getUserRefOrThrow(it);
            mRI5 = mRI4;
            instant2 = instant;
            mRI2 = mRI3;
        } else {
            mRI2 = null;
        }
        String string = bean.getFromString();
        UserRef userRef3 = UserRef.Companion.fromString(bean.getTo());
        if (userRef3 != null) {
            it = userRef3;
            String string2 = string;
            mRI3 = mRI2;
            instant = instant2;
            mRI4 = mRI5;
            boolean bl = false;
            MRI mRI6 = this.getUserRefOrThrow(it);
            mRI5 = mRI4;
            instant2 = instant;
            mRI2 = mRI3;
            string = string2;
            mRI = mRI6;
        } else {
            mRI = null;
        }
        String string3 = bean.getToString();
        MRI mRI7 = mRI;
        String string4 = string;
        MRI mRI8 = mRI2;
        Instant instant3 = instant2;
        MRI mRI9 = mRI5;
        return new ChangeItem.SingleReferenceChangeItem(mRI9, instant3, mRI8, string4, mRI7, string3);
    }

    private final ChangeItem.MultiReferenceChangeItem createMultiReferenceChangeItem(MRI fieldMri, Instant nextChanged, ChangeItemBean bean, Function1<? super String, ? extends List<MRI>> toMris) {
        String string = bean.getFrom();
        String string2 = bean.getTo();
        return new ChangeItem.MultiReferenceChangeItem(fieldMri, nextChanged, string != null ? (List)toMris.invoke((Object)string) : null, bean.getFromString(), string2 != null ? (List)toMris.invoke((Object)string2) : null, bean.getToString());
    }

    private final ChangeItem.SprintChangeItem createMultiSprintReferenceChangeItem(MRI mri, Instant nextChanged, ChangeItemBean bean) {
        List<MRI> list;
        List<MRI> list2;
        List<MRI> list3;
        MRI mRI;
        Instant instant;
        MRI mRI2 = mri;
        Instant instant2 = nextChanged;
        String string = bean.getFrom();
        if (string != null) {
            String string2 = string;
            instant = instant2;
            mRI = mRI2;
            boolean bl = false;
            String string3 = bean.getFrom();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFrom(...)");
            list3 = this.getSprintRefs(string3);
            mRI2 = mRI;
            instant2 = instant;
            list2 = list3;
        } else {
            list2 = null;
        }
        String string4 = bean.getFromString();
        String string5 = bean.getTo();
        if (string5 != null) {
            String it = string5;
            String string6 = string4;
            list3 = list2;
            instant = instant2;
            mRI = mRI2;
            boolean bl = false;
            String string7 = bean.getTo();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getTo(...)");
            List<MRI> list4 = this.getSprintRefs(string7);
            mRI2 = mRI;
            instant2 = instant;
            list2 = list3;
            string4 = string6;
            list = list4;
        } else {
            list = null;
        }
        String string8 = bean.getToString();
        List<MRI> list5 = list;
        String string9 = string4;
        List<MRI> list6 = list2;
        Instant instant3 = instant2;
        MRI mRI3 = mRI2;
        return new ChangeItem.SprintChangeItem(mRI3, instant3, list6, string9, list5, string8);
    }

    private final ChangeItem.CascadeSelectChangeItem createCascadeSelectChangeItem(MRI mri, Instant nextChanged, ChangeItemBean bean) {
        List<MRI> fromOptions = CustomFieldToChangeItemMatchingTechniquesProviderKt.toCascadeOptions(bean.getFromString());
        List<MRI> toOptions = CustomFieldToChangeItemMatchingTechniquesProviderKt.toCascadeOptions(bean.getToString());
        String string = bean.getFromString();
        String string2 = bean.getToString();
        return new ChangeItem.CascadeSelectChangeItem(mri, nextChanged, fromOptions, string, toOptions, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final ChangeItem.IdReferenceChangeItem createIdRefChangeItemForWorkLogId(MRI mri, Instant nextChanged, ChangeItemBean bean, EntityType entityType) {
        MRI mRI;
        MRI mRI2 = mri;
        Instant instant = nextChanged;
        MRI mRI3 = null;
        String string = StringExtensionsKt.takeUnlessNullOrBlank(bean.getFrom());
        if (string == null) {
            string = StringExtensionsKt.takeUnlessNullOrBlank(bean.getTo());
        }
        if (string != null) {
            void it;
            String string2 = string;
            MRI mRI4 = mRI3;
            Instant instant2 = instant;
            MRI mRI5 = mRI2;
            boolean bl = false;
            MRI mRI6 = MriExtensionsKt.mri$default(entityType, it, null, 2, null);
            mRI2 = mRI5;
            instant = instant2;
            mRI3 = mRI4;
            mRI = mRI6;
        } else {
            mRI = null;
        }
        MRI mRI7 = mRI;
        MRI mRI8 = mRI3;
        Instant instant3 = instant;
        MRI mRI9 = mRI2;
        return new ChangeItem.IdReferenceChangeItem(mRI9, instant3, mRI8, mRI7);
    }

    private final ChangeItem.SingleReferenceChangeItem createSingleReferenceChangeItem(MRI mri, Instant nextChanged, ChangeItemBean bean, EntityType entityType) {
        MRI mRI;
        MRI mRI2;
        MRI mRI3;
        String it;
        MRI mRI4;
        Instant instant;
        MRI mRI5 = mri;
        Instant instant2 = nextChanged;
        String string = StringExtensionsKt.takeUnlessNullOrBlank(bean.getFrom());
        if (string != null) {
            String string2 = string;
            instant = instant2;
            mRI4 = mRI5;
            boolean bl = false;
            mRI3 = MriExtensionsKt.mri$default(entityType, it, null, 2, null);
            mRI5 = mRI4;
            instant2 = instant;
            mRI2 = mRI3;
        } else {
            mRI2 = null;
        }
        String string3 = bean.getFromString();
        String string4 = StringExtensionsKt.takeUnlessNullOrBlank(bean.getTo());
        if (string4 != null) {
            it = string4;
            String string5 = string3;
            mRI3 = mRI2;
            instant = instant2;
            mRI4 = mRI5;
            boolean bl = false;
            MRI mRI6 = MriExtensionsKt.mri$default(entityType, it, null, 2, null);
            mRI5 = mRI4;
            instant2 = instant;
            mRI2 = mRI3;
            string3 = string5;
            mRI = mRI6;
        } else {
            mRI = null;
        }
        String string6 = bean.getToString();
        MRI mRI7 = mRI;
        String string7 = string3;
        MRI mRI8 = mRI2;
        Instant instant3 = instant2;
        MRI mRI9 = mRI5;
        return new ChangeItem.SingleReferenceChangeItem(mRI9, instant3, mRI8, string7, mRI7, string6);
    }

    private final ChangeItem.DateChangeItem createDateChangeItem(MRI mri, Instant nextChanged, ChangeItemBean bean) {
        LocalDate localDate;
        LocalDate localDate2;
        LocalDate localDate3;
        Object object;
        MRI mRI;
        Instant instant;
        MRI mRI2 = mri;
        Instant instant2 = nextChanged;
        String string = StringExtensionsKt.takeUnlessNullOrBlank(bean.getFrom());
        if (string != null) {
            Object $this$createDateChangeItem_u24lambda_u2418_u24lambda_u2417;
            String string2 = string;
            instant = instant2;
            mRI = mRI2;
            boolean bl = false;
            object = this;
            try {
                $this$createDateChangeItem_u24lambda_u2418_u24lambda_u2417 = object;
                boolean bl2 = false;
                $this$createDateChangeItem_u24lambda_u2418_u24lambda_u2417 = Result.constructor-impl((Object)LocalDate.parse(bean.getFrom()));
            }
            catch (Throwable bl2) {
                $this$createDateChangeItem_u24lambda_u2418_u24lambda_u2417 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$createDateChangeItem_u24lambda_u2418_u24lambda_u2417;
            localDate3 = (LocalDate)(Result.isFailure-impl((Object)object) ? null : object);
            mRI2 = mRI;
            instant2 = instant;
            localDate2 = localDate3;
        } else {
            localDate2 = null;
        }
        String string3 = StringExtensionsKt.takeUnlessNullOrBlank(bean.getTo());
        if (string3 != null) {
            Object object2;
            String it = string3;
            localDate3 = localDate2;
            instant = instant2;
            mRI = mRI2;
            boolean bl = false;
            object = this;
            try {
                CloudChangeItemConverter $this$createDateChangeItem_u24lambda_u2420_u24lambda_u2419 = (CloudChangeItemConverter)object;
                boolean bl3 = false;
                object2 = Result.constructor-impl((Object)LocalDate.parse(bean.getTo()));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object2;
            LocalDate localDate4 = (LocalDate)(Result.isFailure-impl((Object)object) ? null : object);
            mRI2 = mRI;
            instant2 = instant;
            localDate2 = localDate3;
            localDate = localDate4;
        } else {
            localDate = null;
        }
        LocalDate localDate5 = localDate;
        LocalDate localDate6 = localDate2;
        Instant instant3 = instant2;
        MRI mRI3 = mRI2;
        return new ChangeItem.DateChangeItem(mRI3, instant3, localDate6, localDate5);
    }

    private final ChangeItem.DateTimeChangeItem createDateTimeChangeItem(MRI mri, Instant nextChanged, ChangeItemBean bean) {
        Instant instant;
        Instant instant2;
        Instant instant3;
        Object object;
        MRI mRI;
        Instant instant4;
        MRI mRI2 = mri;
        Instant instant5 = nextChanged;
        String string = StringExtensionsKt.takeUnlessNullOrBlank(bean.getFrom());
        if (string != null) {
            Object $this$createDateTimeChangeItem_u24lambda_u2422_u24lambda_u2421;
            String string2 = string;
            instant4 = instant5;
            mRI = mRI2;
            boolean bl = false;
            object = this;
            try {
                $this$createDateTimeChangeItem_u24lambda_u2422_u24lambda_u2421 = object;
                boolean bl2 = false;
                $this$createDateTimeChangeItem_u24lambda_u2422_u24lambda_u2421 = Result.constructor-impl((Object)ChangeGroupExporterKt.getJIRA_DATETIME_FORMAT().parse((CharSequence)bean.getFrom(), Instant::from));
            }
            catch (Throwable bl2) {
                $this$createDateTimeChangeItem_u24lambda_u2422_u24lambda_u2421 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$createDateTimeChangeItem_u24lambda_u2422_u24lambda_u2421;
            instant3 = (Instant)(Result.isFailure-impl((Object)object) ? null : object);
            mRI2 = mRI;
            instant5 = instant4;
            instant2 = instant3;
        } else {
            instant2 = null;
        }
        string = StringExtensionsKt.takeUnlessNullOrBlank(bean.getTo());
        if (string != null) {
            Object object2;
            String it = string;
            instant3 = instant2;
            instant4 = instant5;
            mRI = mRI2;
            boolean bl = false;
            object = this;
            try {
                CloudChangeItemConverter $this$createDateTimeChangeItem_u24lambda_u2424_u24lambda_u2423 = (CloudChangeItemConverter)object;
                boolean bl3 = false;
                object2 = Result.constructor-impl((Object)ChangeGroupExporterKt.getJIRA_DATETIME_FORMAT().parse((CharSequence)bean.getTo(), Instant::from));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object2;
            Instant instant6 = (Instant)(Result.isFailure-impl((Object)object) ? null : object);
            mRI2 = mRI;
            instant5 = instant4;
            instant2 = instant3;
            instant = instant6;
        } else {
            instant = null;
        }
        Instant instant7 = instant;
        Instant instant8 = instant2;
        Instant instant9 = instant5;
        MRI mRI3 = mRI2;
        return new ChangeItem.DateTimeChangeItem(mRI3, instant9, instant8, instant7);
    }

    private final ChangeItem.TextValueChangeItem createTextValueChangeItem(MRI mri, Instant nextChanged, ChangeItemBean bean, TextDocumentType docType) {
        String string = bean.getFrom();
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        TextDocument textDocument = docType.createOrNull(TextSanitizer.sanitizedNullableText$default(TextSanitizer.INSTANCE, string, logger2, "old value of change item " + mri, 0, 8, null));
        String string2 = bean.getTo();
        Logger logger3 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
        return new ChangeItem.TextValueChangeItem(mri, nextChanged, textDocument, docType.createOrNull(TextSanitizer.sanitizedNullableText$default(TextSanitizer.INSTANCE, string2, logger3, "new value of change item " + mri, 0, 8, null)));
    }

    private final MRI standardFieldMri(String fieldId) {
        return MriExtensionsKt.mri(JiraCoreMriRegistry.INSTANCE.getStandardField(), fieldId, MRIType.RESULTING);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> getUserRefs(String userRefs) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CloudChangeItemConverterKt.access$toList(userRefs);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            UserRef it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (UserRef.Companion.fromString(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (UserRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getUserRefOrThrow((UserRef)it));
        }
        return (List)destination$iv$iv;
    }

    private final MRI getUserRefOrThrow(UserRef userRef) {
        return this.exportService.userRef(this.ctx, userRef);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> getGroupRefs(String groupRefs, ChangeItemCustomFieldData fieldData) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CloudChangeItemConverterKt.access$toList(groupRefs);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GroupRefModel groupRef = new GroupRefModel((String)it, "Field Data [" + fieldData.getCustomField().getName() + ']', String.valueOf(fieldData.getCustomField().getIdAsLong()));
            collection.add(this.exportService.groupRef(this.ctx, groupRef));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> getSprintRefs(String sprintRefs) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CloudChangeItemConverterKt.access$toList(sprintRefs);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MriExtensionsKt.mri$default(Sprint.Companion.getEntityType(), it, null, 2, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> getOptionRefs(String optionRefs) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CloudChangeItemConverterKt.access$toList(optionRefs);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MriExtensionsKt.mri$default(CustomFieldOption.Companion.getEntityType(), it, null, 2, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> getVersionRefs(String versionRefs) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CloudChangeItemConverterKt.access$toList(versionRefs);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MriExtensionsKt.mri$default(ProjectVersion.Companion.getEntityType(), it, null, 2, null));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ IssueTypeManager access$getIssueTypeManager$p(CloudChangeItemConverter $this) {
        return $this.issueTypeManager;
    }

    public static final /* synthetic */ ResolutionManager access$getResolutionManager$p(CloudChangeItemConverter $this) {
        return $this.resolutionManager;
    }

    public static final /* synthetic */ StatusManager access$getStatusManager$p(CloudChangeItemConverter $this) {
        return $this.statusManager;
    }

    public static final /* synthetic */ ChangeItemBean access$getBean$p(CloudChangeItemConverter $this) {
        return $this.bean;
    }

    public static final /* synthetic */ JiraIssueMetadata access$getJiraIssueMetadata$p(CloudChangeItemConverter $this) {
        return $this.jiraIssueMetadata;
    }

    public static final /* synthetic */ List access$getUserRefs(CloudChangeItemConverter $this, String userRefs) {
        return $this.getUserRefs(userRefs);
    }

    public static final /* synthetic */ List access$getOptionRefs(CloudChangeItemConverter $this, String optionRefs) {
        return $this.getOptionRefs(optionRefs);
    }

    public static final /* synthetic */ List access$getGroupRefs(CloudChangeItemConverter $this, String groupRefs, ChangeItemCustomFieldData fieldData) {
        return $this.getGroupRefs(groupRefs, fieldData);
    }

    public static final /* synthetic */ List access$getVersionRefs(CloudChangeItemConverter $this, String versionRefs) {
        return $this.getVersionRefs(versionRefs);
    }

    static {
        Object[] objectArray = new String[]{"com.atlassian.jira.plugin.system.customfieldtypes:float", "com.atlassian.jira.plugin.system.customfieldtypes:url", "com.atlassian.jira.plugin.system.customfieldtypes:labels", "com.pyxis.greenhopper.jira:gh-lexo-rank", "com.atlassian.jira.plugin.system.customfieldtypes:labels", "com.pyxis.greenhopper.jira:gh-lexo-rank", "com.pyxis.greenhopper.jira:gh-epic-color", "com.pyxis.greenhopper.jira:gh-epic-label"};
        PLAIN_TEXT_CUSTOM_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:readonlyfield", "com.atlassian.jira.plugin.system.customfieldtypes:textarea"};
        WIKI_TEXT_CUSTOM_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"com.atlassian.jira.plugin.system.customfieldtypes:select", "com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", "com.pyxis.greenhopper.jira:gh-epic-status"};
        SINGLE_SELECT_CUSTOM_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/export/core/issue/CloudChangeItemConverter$Companion;", "", "()V", "AFFECTED_VERSION", "", "ARCHIVED", "COMPONENT", "EPIC_CHILD", "FIXED_VERSION", "KEY_FIELD", "LINK_FIELD", "PARENT", "PLAIN_TEXT_CUSTOM_TYPES", "", "REMOTE_ISSUE_LINK", "RESTORED", "SINGLE_SELECT_CUSTOM_TYPES", "WIKI_TEXT_CUSTOM_TYPES", "WORKFLOW_FIELD", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

