/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issue;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.export.core.issue.ChangeItemBeanWithMetadata;
import com.atlassian.jira.migration.export.core.issue.CustomFieldToChangeItemMatchingTechniquesProviderKt;
import com.atlassian.jira.migration.export.core.issue.JiraIssueMetadata;
import com.atlassian.migration.base.mri.MRI;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.codehaus.jackson.map.JsonMappingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0002J\"\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160!0 2\u0006\u0010\"\u001a\u00020\u000eH\u0002J\u0010\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010$\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010%\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010'\u001a\u00020(\"\u0004\b\u0000\u0010)*\b\u0012\u0004\u0012\u0002H)0*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/atlassian/jira/migration/export/core/issue/CustomFieldToChangeItemMatchingTechniquesProvider;", "", "optionsManager", "Lcom/atlassian/jira/issue/customfields/manager/OptionsManager;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/issue/customfields/manager/OptionsManager;Lcom/atlassian/jira/issue/CustomFieldManager;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "exactMatchOnFieldName", "Lcom/atlassian/jira/issue/fields/CustomField;", "changeItemBeanWithIssue", "Lcom/atlassian/jira/migration/export/core/issue/ChangeItemBeanWithMetadata;", "findMatchingFieldOrNull", "issue", "Lcom/atlassian/jira/migration/export/core/issue/JiraIssueMetadata;", "field", "config", "Lcom/atlassian/jira/issue/fields/config/FieldConfigScheme;", "getFieldByMRI", "mri", "Lcom/atlassian/migration/base/mri/MRI;", "getFieldByOptionId", "id", "", "getFieldByOptionList", "stringValue", "mapFieldToConfigs", "", "Lkotlin/Pair;", "it", "matchOnCascadeFieldOption", "matchOnFieldName", "matchOnOptionList", "matchOnSingleOption", "hasOnlyOneElement", "", "E", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomFieldToChangeItemMatchingTechniquesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomFieldToChangeItemMatchingTechniquesProvider.kt\ncom/atlassian/jira/migration/export/core/issue/CustomFieldToChangeItemMatchingTechniquesProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,145:1\n603#2:146\n1549#3:147\n1620#3,3:148\n1603#3,9:153\n1855#3:162\n1856#3:164\n1612#3:165\n1603#3,9:166\n1855#3:175\n1856#3:177\n1612#3:178\n1603#3,9:179\n1855#3:188\n1856#3:190\n1612#3:191\n1#4:151\n1#4:163\n1#4:176\n1#4:189\n51#5:152\n*S KotlinDebug\n*F\n+ 1 CustomFieldToChangeItemMatchingTechniquesProvider.kt\ncom/atlassian/jira/migration/export/core/issue/CustomFieldToChangeItemMatchingTechniquesProvider\n*L\n67#1:146\n81#1:147\n81#1:148,3\n107#1:153,9\n107#1:162\n107#1:164\n107#1:165\n118#1:166,9\n118#1:175\n118#1:177\n118#1:178\n119#1:179,9\n119#1:188\n119#1:190\n119#1:191\n107#1:163\n118#1:176\n119#1:189\n106#1:152\n*E\n"})
public final class CustomFieldToChangeItemMatchingTechniquesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OptionsManager optionsManager;
    @NotNull
    private final CustomFieldManager customFieldManager;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(CustomFieldToChangeItemMatchingTechniquesProvider.class);

    @Inject
    public CustomFieldToChangeItemMatchingTechniquesProvider(@NotNull OptionsManager optionsManager, @NotNull CustomFieldManager customFieldManager, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)optionsManager, (String)"optionsManager");
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.optionsManager = optionsManager;
        this.customFieldManager = customFieldManager;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Nullable
    public final CustomField exactMatchOnFieldName(@NotNull ChangeItemBeanWithMetadata changeItemBeanWithIssue) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)changeItemBeanWithIssue, (String)"changeItemBeanWithIssue");
        Collection it = collection = this.customFieldManager.getCustomFieldObjectsByName(changeItemBeanWithIssue.getField());
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        Collection collection2 = this.hasOnlyOneElement(it) ? collection : null;
        return collection2 != null ? (CustomField)CollectionsKt.first((Iterable)collection2) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CustomField matchOnFieldName(@NotNull ChangeItemBeanWithMetadata changeItemBeanWithIssue) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)changeItemBeanWithIssue, (String)"changeItemBeanWithIssue");
        String fieldName = changeItemBeanWithIssue.getField();
        Collection collection = this.customFieldManager.getCustomFieldObjectsByName(fieldName);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCustomFieldObjectsByName(...)");
        Collection customFields = collection;
        if (this.hasOnlyOneElement(customFields)) {
            log.debug(StringsKt.trimIndent((String)("\n                    CustomField change " + changeItemBeanWithIssue.getChangeItemBean() + "\n                    on Issue " + changeItemBeanWithIssue.getJiraIssueMetadata().getIssueId() + " has matched with only 1 Custom Field by name (" + fieldName + ")\n                ")));
            return (CustomField)CollectionsKt.first((Iterable)customFields);
        }
        JiraIssueMetadata issueValue = changeItemBeanWithIssue.getJiraIssueMetadata();
        Sequence sequence = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)customFields), (Function1)((Function1)new Function1<CustomField, List<? extends Pair<? extends CustomField, ? extends FieldConfigScheme>>>(this){
            final /* synthetic */ CustomFieldToChangeItemMatchingTechniquesProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Pair<CustomField, FieldConfigScheme>> invoke(@NotNull CustomField it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CustomFieldToChangeItemMatchingTechniquesProvider.access$mapFieldToConfigs(this.this$0, it);
            }
        }));
        boolean $i$f$sortedBy = false;
        return (CustomField)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                FieldConfigScheme config2 = (FieldConfigScheme)pair.component2();
                pair = (Pair)b;
                Comparable comparable = Boolean.valueOf(config2.isAllProjects());
                bl = false;
                config2 = (FieldConfigScheme)pair.component2();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(config2.isAllProjects()));
            }
        }), (Function1)((Function1)new Function1<Pair<? extends CustomField, ? extends FieldConfigScheme>, Boolean>(issueValue){
            final /* synthetic */ JiraIssueMetadata $issueValue;
            {
                this.$issueValue = $issueValue;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<? extends CustomField, ? extends FieldConfigScheme> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                FieldConfigScheme config2 = (FieldConfigScheme)pair.component2();
                return config2.isAllIssueTypes() || config2.getAssociatedIssueTypes().contains(this.$issueValue.getIssueType());
            }
        })), (Function1)((Function1)new Function1<Pair<? extends CustomField, ? extends FieldConfigScheme>, CustomField>(this, issueValue){
            final /* synthetic */ CustomFieldToChangeItemMatchingTechniquesProvider this$0;
            final /* synthetic */ JiraIssueMetadata $issueValue;
            {
                this.this$0 = $receiver;
                this.$issueValue = $issueValue;
                super(1);
            }

            @Nullable
            public final CustomField invoke(@NotNull Pair<? extends CustomField, ? extends FieldConfigScheme> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                CustomField field = (CustomField)pair.component1();
                FieldConfigScheme config2 = (FieldConfigScheme)pair.component2();
                return CustomFieldToChangeItemMatchingTechniquesProvider.access$findMatchingFieldOrNull(this.this$0, this.$issueValue, field, config2);
            }
        })));
    }

    private final CustomField findMatchingFieldOrNull(JiraIssueMetadata issue2, CustomField field, FieldConfigScheme config2) {
        return config2.getAssociatedProjectIds().contains(issue2.getProjectId()) || config2.isAllProjects() ? field : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<CustomField, FieldConfigScheme>> mapFieldToConfigs(CustomField it) {
        void $this$mapTo$iv$iv;
        List list = it.getConfigurationSchemes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurationSchemes(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void config2;
            FieldConfigScheme fieldConfigScheme = (FieldConfigScheme)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)config2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final CustomField getFieldByOptionId(String id) {
        if (id == null) return null;
        Long l = StringsKt.toLongOrNull((String)id);
        if (l == null) return null;
        long it = ((Number)l).longValue();
        boolean bl = false;
        Option option = this.optionsManager.findByOptionId(Long.valueOf(it));
        if (option == null) return null;
        FieldConfig fieldConfig = option.getRelatedCustomField();
        if (fieldConfig == null) return null;
        String string = fieldConfig.getFieldId();
        if (string == null) return null;
        String string2 = string;
        CustomFieldManager customFieldManager = this.customFieldManager;
        String p0 = string2;
        boolean bl2 = false;
        CustomField customField = customFieldManager.getCustomFieldObject(p0);
        return customField;
    }

    private final CustomField getFieldByMRI(MRI mri) {
        return this.getFieldByOptionId(mri.getEntityId());
    }

    @Nullable
    public final CustomField matchOnSingleOption(@NotNull ChangeItemBeanWithMetadata changeItemBeanWithIssue) {
        Intrinsics.checkNotNullParameter((Object)changeItemBeanWithIssue, (String)"changeItemBeanWithIssue");
        CustomField customField = this.getFieldByOptionId(changeItemBeanWithIssue.getTo());
        if (customField == null) {
            customField = this.getFieldByOptionId(changeItemBeanWithIssue.getFrom());
        }
        return customField;
    }

    @Nullable
    public final CustomField matchOnOptionList(@NotNull ChangeItemBeanWithMetadata changeItemBeanWithIssue) {
        Intrinsics.checkNotNullParameter((Object)changeItemBeanWithIssue, (String)"changeItemBeanWithIssue");
        CustomField customField = this.getFieldByOptionList(changeItemBeanWithIssue.getTo());
        if (customField == null) {
            customField = this.getFieldByOptionList(changeItemBeanWithIssue.getFrom());
        }
        return customField;
    }

    /*
     * WARNING - void declaration
     */
    private final CustomField getFieldByOptionList(String stringValue) {
        CustomField customField;
        if (stringValue == null) {
            return null;
        }
        try {
            void $this$mapNotNullTo$iv$iv;
            boolean $i$f$jacksonTypeRef = false;
            List idList = (List)this.objectMapper.readValue(stringValue, (TypeReference)new TypeReference<List<? extends String>>(){});
            Intrinsics.checkNotNull((Object)idList);
            Iterable $this$mapNotNull$iv = idList;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                CustomField it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.getFieldByOptionId(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            customField = (CustomField)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }
        catch (JsonProcessingException e) {
            customField = null;
        }
        catch (JsonMappingException e) {
            customField = null;
        }
        return customField;
    }

    @Nullable
    public final CustomField matchOnCascadeFieldOption(@NotNull ChangeItemBeanWithMetadata changeItemBeanWithIssue) {
        CustomField it$iv$iv;
        boolean bl;
        MRI it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)changeItemBeanWithIssue, (String)"changeItemBeanWithIssue");
        Iterable $this$mapNotNull$iv = CustomFieldToChangeItemMatchingTechniquesProviderKt.toCascadeOptions(changeItemBeanWithIssue.getToString());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl2 = false;
            it = (MRI)element$iv$iv;
            boolean bl3 = false;
            if (this.getFieldByMRI(it) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        CustomField customField = (CustomField)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (customField == null) {
            $this$mapNotNull$iv = CustomFieldToChangeItemMatchingTechniquesProviderKt.toCascadeOptions(changeItemBeanWithIssue.getFromString());
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl2 = false;
                it = (MRI)element$iv$iv;
                boolean bl4 = false;
                if (this.getFieldByMRI(it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            customField = (CustomField)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }
        return customField;
    }

    private final <E> boolean hasOnlyOneElement(Collection<? extends E> $this$hasOnlyOneElement) {
        return $this$hasOnlyOneElement.size() == 1;
    }

    public static final /* synthetic */ List access$mapFieldToConfigs(CustomFieldToChangeItemMatchingTechniquesProvider $this, CustomField it) {
        return $this.mapFieldToConfigs(it);
    }

    public static final /* synthetic */ CustomField access$findMatchingFieldOrNull(CustomFieldToChangeItemMatchingTechniquesProvider $this, JiraIssueMetadata issue2, CustomField field, FieldConfigScheme config2) {
        return $this.findMatchingFieldOrNull(issue2, field, config2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/issue/CustomFieldToChangeItemMatchingTechniquesProvider$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

