/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issue;

import com.atlassian.jira.migration.export.core.issue.BaselineDates;
import com.atlassian.jira.migration.export.core.issue.IssueChildrenExporter;
import com.atlassian.jira.migration.export.core.issue.IssueLinks;
import com.atlassian.jira.migration.export.core.issue.IssueVotersAndWatcher;
import com.atlassian.jira.migration.export.core.issue.RemoteLinks;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.project.Project;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/export/core/issue/IssueChildrenExportService;", "", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "baselineDates", "Lcom/atlassian/jira/migration/export/core/issue/BaselineDates;", "remoteLinks", "Lcom/atlassian/jira/migration/export/core/issue/RemoteLinks;", "issueLinks", "Lcom/atlassian/jira/migration/export/core/issue/IssueLinks;", "issueVotersAndWatcher", "Lcom/atlassian/jira/migration/export/core/issue/IssueVotersAndWatcher;", "issueChildrenExporter", "", "Lcom/atlassian/jira/migration/export/core/issue/IssueChildrenExporter;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/core/issue/BaselineDates;Lcom/atlassian/jira/migration/export/core/issue/RemoteLinks;Lcom/atlassian/jira/migration/export/core/issue/IssueLinks;Lcom/atlassian/jira/migration/export/core/issue/IssueVotersAndWatcher;Ljava/util/List;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "jiraProject", "Lcom/atlassian/jira/project/Project;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueChildrenExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueChildrenExportService.kt\ncom/atlassian/jira/migration/export/core/issue/IssueChildrenExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,38:1\n1855#2:39\n1856#2:42\n1313#3,2:40\n*S KotlinDebug\n*F\n+ 1 IssueChildrenExportService.kt\ncom/atlassian/jira/migration/export/core/issue/IssueChildrenExportService\n*L\n26#1:39\n26#1:42\n28#1:40,2\n*E\n"})
public final class IssueChildrenExportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final BaselineDates baselineDates;
    @NotNull
    private final RemoteLinks remoteLinks;
    @NotNull
    private final IssueLinks issueLinks;
    @NotNull
    private final IssueVotersAndWatcher issueVotersAndWatcher;
    @NotNull
    private final List<IssueChildrenExporter> issueChildrenExporter;
    @NotNull
    private static final Logger log;

    @Inject
    public IssueChildrenExportService(@NotNull ExportService exportService, @NotNull BaselineDates baselineDates, @NotNull RemoteLinks remoteLinks, @NotNull IssueLinks issueLinks, @NotNull IssueVotersAndWatcher issueVotersAndWatcher, @NotNull List<? extends IssueChildrenExporter> issueChildrenExporter) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)baselineDates, (String)"baselineDates");
        Intrinsics.checkNotNullParameter((Object)remoteLinks, (String)"remoteLinks");
        Intrinsics.checkNotNullParameter((Object)issueLinks, (String)"issueLinks");
        Intrinsics.checkNotNullParameter((Object)issueVotersAndWatcher, (String)"issueVotersAndWatcher");
        Intrinsics.checkNotNullParameter(issueChildrenExporter, (String)"issueChildrenExporter");
        this.exportService = exportService;
        this.baselineDates = baselineDates;
        this.remoteLinks = remoteLinks;
        this.issueLinks = issueLinks;
        this.issueVotersAndWatcher = issueVotersAndWatcher;
        this.issueChildrenExporter = issueChildrenExporter;
    }

    public /* synthetic */ IssueChildrenExportService(ExportService exportService, BaselineDates baselineDates, RemoteLinks remoteLinks, IssueLinks issueLinks, IssueVotersAndWatcher issueVotersAndWatcher, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            Object[] objectArray = new IssueChildrenExporter[]{baselineDates, remoteLinks, issueLinks, issueVotersAndWatcher};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        this(exportService, baselineDates, remoteLinks, issueLinks, issueVotersAndWatcher, list);
    }

    public final void export(@NotNull ExportContext ctx, @NotNull Project jiraProject) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraProject, (String)"jiraProject");
        log.info("Starting export of decoupled issue children");
        Iterable $this$forEach$iv = this.issueChildrenExporter;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IssueChildrenExporter it = (IssueChildrenExporter)element$iv;
            boolean bl = false;
            log.info("Started Issue children export of " + it.getClass());
            Sequence<Object> $this$forEach$iv2 = it.getEntities(ctx, jiraProject);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv2;
                Object entity = element$iv2 = iterator2.next();
                boolean bl2 = false;
                ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, entity, false, 4, null);
            }
        }
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(IssueChildrenExportService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/core/issue/IssueChildrenExportService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

