/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issue;

import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.export.core.issue.ChangeItemCustomFieldData;
import com.atlassian.jira.migration.export.core.issue.JiraIssueMetadata;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.model.JSDConstants;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.ChangeItem;
import com.atlassian.migration.jira.servicedesk.customerorg.CustomerOrganization;
import com.atlassian.migration.jira.servicedesk.requestype.RequestType;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002JA\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2'\u0010\u000f\u001a#\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0010j\u0002`\u0015H\u0002JA\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2'\u0010\u000f\u001a#\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0010j\u0002`\u0015H\u0002J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u001d\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b J \u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110&*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/export/core/issue/JsdChangeGroupExtractor;", "", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "jsdExportUtil", "Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;)V", "createDateTimeChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$DateTimeChangeItem;", "fieldMri", "Lcom/atlassian/migration/base/mri/MRI;", "fieldData", "Lcom/atlassian/jira/migration/export/core/issue/ChangeItemCustomFieldData;", "createMultiReferenceChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$MultiReferenceChangeItem;", "valueParser", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "data", "Lcom/atlassian/jira/migration/export/core/issue/ValueParser;", "createSingleReferenceChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem$SingleReferenceChangeItem;", "exportUser", "userKey", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportUser$jira_migration_plugin", "isValidJsmChangeItem", "", "fieldType", "isValidJsmChangeItem$jira_migration_plugin", "toCustomFieldChangeItem", "Lcom/atlassian/migration/jira/core/ChangeItem;", "issue", "Lcom/atlassian/jira/migration/export/core/issue/JiraIssueMetadata;", "toFormattedList", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsdChangeGroupExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsdChangeGroupExtractor.kt\ncom/atlassian/jira/migration/export/core/issue/JsdChangeGroupExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n1#2:116\n1#2:129\n1603#3,9:106\n1855#3:115\n1856#3:117\n1612#3:118\n1603#3,9:119\n1855#3:128\n1856#3:130\n1612#3:131\n1549#3:132\n1620#3,3:133\n766#3:136\n857#3,2:137\n*S KotlinDebug\n*F\n+ 1 JsdChangeGroupExtractor.kt\ncom/atlassian/jira/migration/export/core/issue/JsdChangeGroupExtractor\n*L\n66#1:116\n68#1:129\n66#1:106,9\n66#1:115\n66#1:117\n66#1:118\n68#1:119,9\n68#1:128\n68#1:130\n68#1:131\n94#1:132\n94#1:133,3\n94#1:136\n94#1:137,2\n*E\n"})
public final class JsdChangeGroupExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final JsdExportUtil jsdExportUtil;
    @NotNull
    private static final DateTimeFormatter JIRA_DATETIME_FORMAT;
    private static final Logger log;

    @Inject
    public JsdChangeGroupExtractor(@NotNull ExportService exportService, @NotNull JsdExportUtil jsdExportUtil) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)jsdExportUtil, (String)"jsdExportUtil");
        this.exportService = exportService;
        this.jsdExportUtil = jsdExportUtil;
    }

    public final boolean isValidJsmChangeItem$jira_migration_plugin(@NotNull ExportContext ctx, @NotNull String fieldType) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        return this.jsdExportUtil.isJsdProjectEligibleForMigration(ctx) && JSDConstants.INSTANCE.getJSD_CUSTOM_FIELDS().contains(fieldType);
    }

    @Nullable
    public final ChangeItem toCustomFieldChangeItem(@NotNull ChangeItemCustomFieldData fieldData, @NotNull JiraIssueMetadata issue2, @NotNull ExportContext ctx) {
        ChangeItem changeItem;
        Intrinsics.checkNotNullParameter((Object)fieldData, (String)"fieldData");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        MRI issueCustomFieldMri = this.exportService.mri(fieldData.getCustomField());
        String string = fieldData.getCustomField().getCustomFieldType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        String customFieldType = string;
        if (!this.isValidJsmChangeItem$jira_migration_plugin(ctx, customFieldType)) {
            log.warn("CustomField Type " + customFieldType + " on Issue " + issue2.getIssueId() + " is not supported");
            return null;
        }
        switch (customFieldType) {
            case "com.atlassian.servicedesk:sd-request-participants": {
                changeItem = (ChangeItem)this.createMultiReferenceChangeItem(issueCustomFieldMri, fieldData, (Function1<? super String, MRI>)((Function1)new Function1<String, MRI>(this, ctx){
                    final /* synthetic */ JsdChangeGroupExtractor this$0;
                    final /* synthetic */ ExportContext $ctx;
                    {
                        this.this$0 = $receiver;
                        this.$ctx = $ctx;
                        super(1);
                    }

                    @Nullable
                    public final MRI invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.this$0.exportUser$jira_migration_plugin(it, this.$ctx);
                    }
                }));
                break;
            }
            case "com.atlassian.servicedesk:sd-customer-organizations": {
                changeItem = (ChangeItem)this.createMultiReferenceChangeItem(issueCustomFieldMri, fieldData, (Function1<? super String, MRI>)((Function1)new Function1<String, MRI>(this, ctx){
                    final /* synthetic */ JsdChangeGroupExtractor this$0;
                    final /* synthetic */ ExportContext $ctx;
                    {
                        this.this$0 = $receiver;
                        this.$ctx = $ctx;
                        super(1);
                    }

                    @Nullable
                    public final MRI invoke(@NotNull String it) {
                        ExportService.CheckExportedResult checkExportedResult;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ExportService.CheckExportedResult checkExportedResult2 = checkExportedResult = JsdChangeGroupExtractor.access$getExportService$p(this.this$0).checkExported(this.$ctx, CustomerOrganization.Companion.getEntityType(), Integer.parseInt(it));
                        boolean bl = false;
                        ExportService.CheckExportedResult checkExportedResult3 = checkExportedResult2.isExported() ? checkExportedResult : null;
                        return checkExportedResult3 != null ? checkExportedResult3.getMri() : null;
                    }
                }));
                break;
            }
            case "com.atlassian.servicedesk:vp-origin": {
                changeItem = (ChangeItem)this.createSingleReferenceChangeItem(issueCustomFieldMri, fieldData, (Function1<? super String, MRI>)((Function1)new Function1<String, MRI>(this, ctx){
                    final /* synthetic */ JsdChangeGroupExtractor this$0;
                    final /* synthetic */ ExportContext $ctx;
                    {
                        this.this$0 = $receiver;
                        this.$ctx = $ctx;
                        super(1);
                    }

                    @Nullable
                    public final MRI invoke(@NotNull String it) {
                        ExportService.CheckExportedResult checkExportedResult;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ExportService.CheckExportedResult checkExportedResult2 = checkExportedResult = JsdChangeGroupExtractor.access$getExportService$p(this.this$0).checkExported(this.$ctx, RequestType.Companion.getEntityType(), Integer.parseInt(it));
                        boolean bl = false;
                        ExportService.CheckExportedResult checkExportedResult3 = checkExportedResult2.isExported() ? checkExportedResult : null;
                        return checkExportedResult3 != null ? checkExportedResult3.getMri() : null;
                    }
                }));
                break;
            }
            case "com.atlassian.servicedesk:sd-request-feedback-date": {
                changeItem = (ChangeItem)this.createDateTimeChangeItem(issueCustomFieldMri, fieldData);
                break;
            }
            default: {
                log.warn("CustomField Type " + customFieldType + " on Issue " + issue2.getIssueId() + " is not supported");
                changeItem = null;
            }
        }
        return changeItem;
    }

    @Nullable
    public final MRI exportUser$jira_migration_plugin(@NotNull String userKey, @NotNull ExportContext ctx) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        UserRef userRef = UserRef.Companion.fromString(userKey);
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final ChangeItem.MultiReferenceChangeItem createMultiReferenceChangeItem(MRI fieldMri, ChangeItemCustomFieldData fieldData, Function1<? super String, MRI> valueParser) {
        List list;
        List list2;
        List list3;
        MRI it$iv$iv;
        boolean bl;
        String it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterator iterator2;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        boolean $i$f$mapNotNullTo;
        Collection destination$iv$iv;
        Iterable $this$mapNotNull$iv;
        boolean $i$f$mapNotNull;
        MRI mRI;
        Instant instant;
        MRI mRI2 = fieldMri;
        Instant instant2 = fieldData.getNextChange();
        Object object = fieldData.getChangeItem().getFrom();
        if (object != null && (object = this.toFormattedList((String)object)) != null) {
            Iterable iterable = (Iterable)object;
            instant = instant2;
            mRI = mRI2;
            $i$f$mapNotNull = false;
            void var6_8 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl2 = false;
                it = (String)element$iv$iv;
                boolean bl3 = false;
                if ((MRI)valueParser.invoke((Object)it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list3 = (List)destination$iv$iv;
            mRI2 = mRI;
            instant2 = instant;
            list2 = list3;
        } else {
            list2 = null;
        }
        String string = fieldData.getChangeItem().getFromString();
        Object object2 = fieldData.getChangeItem().getTo();
        if (object2 != null && (object2 = this.toFormattedList((String)object2)) != null) {
            $this$mapNotNull$iv = (Iterable)object2;
            String string2 = string;
            list3 = list2;
            instant = instant2;
            mRI = mRI2;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl2 = false;
                it = (String)element$iv$iv;
                boolean bl4 = false;
                if ((MRI)valueParser.invoke((Object)it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list4 = (List)destination$iv$iv;
            mRI2 = mRI;
            instant2 = instant;
            list2 = list3;
            string = string2;
            list = list4;
        } else {
            list = null;
        }
        String string3 = fieldData.getChangeItem().getToString();
        List list5 = list;
        String string4 = string;
        List list6 = list2;
        Instant instant3 = instant2;
        MRI mRI3 = mRI2;
        return new ChangeItem.MultiReferenceChangeItem(mRI3, instant3, list6, string4, list5, string3);
    }

    private final ChangeItem.SingleReferenceChangeItem createSingleReferenceChangeItem(MRI fieldMri, ChangeItemCustomFieldData fieldData, Function1<? super String, MRI> valueParser) {
        MRI mRI;
        MRI mRI2;
        MRI mRI3;
        String it;
        MRI mRI4;
        Instant instant;
        MRI mRI5 = fieldMri;
        Instant instant2 = fieldData.getNextChange();
        String string = StringExtensionsKt.takeUnlessNullOrBlank(fieldData.getChangeItem().getFrom());
        if (string != null) {
            String string2 = string;
            instant = instant2;
            mRI4 = mRI5;
            boolean bl = false;
            mRI3 = (MRI)valueParser.invoke((Object)it);
            mRI5 = mRI4;
            instant2 = instant;
            mRI2 = mRI3;
        } else {
            mRI2 = null;
        }
        String string3 = fieldData.getChangeItem().getFromString();
        String string4 = StringExtensionsKt.takeUnlessNullOrBlank(fieldData.getChangeItem().getTo());
        if (string4 != null) {
            it = string4;
            String string5 = string3;
            mRI3 = mRI2;
            instant = instant2;
            mRI4 = mRI5;
            boolean bl = false;
            MRI mRI6 = (MRI)valueParser.invoke((Object)it);
            mRI5 = mRI4;
            instant2 = instant;
            mRI2 = mRI3;
            string3 = string5;
            mRI = mRI6;
        } else {
            mRI = null;
        }
        String string6 = fieldData.getChangeItem().getToString();
        MRI mRI7 = mRI;
        String string7 = string3;
        MRI mRI8 = mRI2;
        Instant instant3 = instant2;
        MRI mRI9 = mRI5;
        return new ChangeItem.SingleReferenceChangeItem(mRI9, instant3, mRI8, string7, mRI7, string6);
    }

    private final ChangeItem.DateTimeChangeItem createDateTimeChangeItem(MRI fieldMri, ChangeItemCustomFieldData fieldData) {
        Instant instant;
        Instant instant2;
        Instant instant3;
        String it;
        Object object;
        MRI mRI;
        Instant instant4;
        MRI mRI2 = fieldMri;
        Instant instant5 = fieldData.getNextChange();
        String string = StringExtensionsKt.takeUnlessNullOrBlank(fieldData.getChangeItem().getFrom());
        if (string != null) {
            Object $this$createDateTimeChangeItem_u24lambda_u246_u24lambda_u245;
            String string2 = string;
            instant4 = instant5;
            mRI = mRI2;
            boolean bl = false;
            object = this;
            try {
                $this$createDateTimeChangeItem_u24lambda_u246_u24lambda_u245 = object;
                boolean bl2 = false;
                $this$createDateTimeChangeItem_u24lambda_u246_u24lambda_u245 = Result.constructor-impl((Object)JIRA_DATETIME_FORMAT.parse((CharSequence)it, Instant::from));
            }
            catch (Throwable bl2) {
                $this$createDateTimeChangeItem_u24lambda_u246_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$createDateTimeChangeItem_u24lambda_u246_u24lambda_u245;
            instant3 = (Instant)(Result.isFailure-impl((Object)object) ? null : object);
            mRI2 = mRI;
            instant5 = instant4;
            instant2 = instant3;
        } else {
            instant2 = null;
        }
        string = StringExtensionsKt.takeUnlessNullOrBlank(fieldData.getChangeItem().getTo());
        if (string != null) {
            Object object2;
            it = string;
            instant3 = instant2;
            instant4 = instant5;
            mRI = mRI2;
            boolean bl = false;
            object = this;
            try {
                JsdChangeGroupExtractor $this$createDateTimeChangeItem_u24lambda_u248_u24lambda_u247 = (JsdChangeGroupExtractor)object;
                boolean bl3 = false;
                object2 = Result.constructor-impl((Object)JIRA_DATETIME_FORMAT.parse((CharSequence)it, Instant::from));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object2;
            Instant instant6 = (Instant)(Result.isFailure-impl((Object)object) ? null : object);
            mRI2 = mRI;
            instant5 = instant4;
            instant2 = instant3;
            instant = instant6;
        } else {
            instant = null;
        }
        Instant instant7 = instant;
        Instant instant8 = instant2;
        Instant instant9 = instant5;
        MRI mRI3 = mRI2;
        return new ChangeItem.DateTimeChangeItem(mRI3, instant9, instant8, instant7);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toFormattedList(String $this$toFormattedList) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$this$toFormattedList, (CharSequence)"["), (CharSequence)"]"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ ExportService access$getExportService$p(JsdChangeGroupExtractor $this) {
        return $this.exportService;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
        Intrinsics.checkNotNull((Object)dateTimeFormatter);
        JIRA_DATETIME_FORMAT = dateTimeFormatter;
        log = LoggerFactory.getLogger(JsdChangeGroupExtractor.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/export/core/issue/JsdChangeGroupExtractor$Companion;", "", "()V", "JIRA_DATETIME_FORMAT", "Ljava/time/format/DateTimeFormatter;", "getJIRA_DATETIME_FORMAT", "()Ljava/time/format/DateTimeFormatter;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormatter getJIRA_DATETIME_FORMAT() {
            return JIRA_DATETIME_FORMAT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

