/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issue;

import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.TextSanitizer;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.core.text.TextDocument;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\u0014H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/export/core/issue/WorklogExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/worklog/Worklog;", "Lcom/atlassian/migration/jira/classic/worklogs/Worklog;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapAuthor", "Lcom/atlassian/migration/base/mri/MRI;", "jiraWorklog", "mapComment", "Lcom/atlassian/migration/core/text/TextDocument;", "truncateMessage", "", "mapUpdateAuthor", "mapVisibility", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nWorklogExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorklogExporter.kt\ncom/atlassian/jira/migration/export/core/issue/WorklogExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class WorklogExporter
implements Exporter<Long, Worklog, com.atlassian.migration.jira.classic.worklogs.Worklog> {
    @NotNull
    private final ExportService exportService;
    private final Logger log;

    @Inject
    public WorklogExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(WorklogExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, Worklog.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(com.atlassian.migration.jira.classic.worklogs.Worklog.Companion.getEntityType());
    }

    @Override
    @NotNull
    public com.atlassian.migration.jira.classic.worklogs.Worklog exportData(@NotNull ExportContext ctx, @NotNull Worklog entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting worklog with id {} for migration {} under exportMode {}", objectArray);
        objectArray = this.mriForEntity(entity);
        MRI mRI = ExportService.checkExportedOrThrow$default(this.exportService, ctx, entity.getIssue(), null, 4, null);
        MRI mRI2 = this.mapAuthor(ctx, entity);
        MRI mRI3 = this.mapUpdateAuthor(ctx, entity);
        TextDocument textDocument = this.mapComment(ctx, entity, "worklog " + entity.getId() + " comment");
        Instant instant = entity.getCreated().toInstant();
        Date date = entity.getUpdated();
        Instant instant2 = date != null ? date.toInstant() : null;
        Date date2 = entity.getStartDate();
        Instant instant3 = date2 != null ? date2.toInstant() : null;
        Long l = entity.getTimeSpent();
        MRI mRI4 = this.mapVisibility(ctx, entity);
        Intrinsics.checkNotNull((Object)instant);
        Intrinsics.checkNotNull((Object)l);
        return new com.atlassian.migration.jira.classic.worklogs.Worklog((MRI)objectArray, mRI, mRI2, mRI3, textDocument, instant, instant2, mRI4, instant3, l.longValue(), null, 1024, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull Worklog entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for jiraWorklog with id {} for migration {} under exportMode {}", objectArray);
        this.mapAuthor(ctx, entity);
        this.mapUpdateAuthor(ctx, entity);
        this.mapVisibility(ctx, entity);
        WorklogExporter.mapComment$default(this, ctx, entity, null, 4, null);
    }

    private final MRI mapAuthor(ExportContext ctx, Worklog jiraWorklog) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(jiraWorklog.getAuthorKey());
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final MRI mapUpdateAuthor(ExportContext ctx, Worklog jiraWorklog) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(jiraWorklog.getUpdateAuthorKey());
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final TextDocument mapComment(ExportContext ctx, Worklog entity, String truncateMessage) {
        String string = entity.getComment();
        if (string == null) {
            string = "";
        }
        Logger logger2 = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        String it = TextSanitizer.sanitizedText$default(TextSanitizer.INSTANCE, string, logger2, truncateMessage, 0, 8, null);
        boolean bl = false;
        this.exportService.extractUserRefs(ctx, it);
        return (TextDocument)new TextDocument.Wiki(it);
    }

    static /* synthetic */ TextDocument mapComment$default(WorklogExporter worklogExporter, ExportContext exportContext, Worklog worklog, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return worklogExporter.mapComment(exportContext, worklog, string);
    }

    private final MRI mapVisibility(ExportContext ctx, Worklog jiraWorklog) {
        String string;
        block6: {
            block5: {
                string = jiraWorklog.getGroupLevel();
                if (string == null) break block5;
                String it = string;
                boolean bl = false;
                GroupRefModel groupRef = new GroupRefModel(it, "Jira Worklog", String.valueOf(jiraWorklog.getId()));
                MRI mRI = this.exportService.groupRef(ctx, groupRef);
                string = mRI;
                if (mRI != null) break block6;
            }
            ProjectRole projectRole = jiraWorklog.getRoleLevel();
            if (projectRole != null) {
                ProjectRole it = projectRole;
                boolean bl = false;
                string = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
            } else {
                string = null;
            }
        }
        return string;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull Worklog entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.classic.worklogs.Worklog.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @Nullable
    public Worklog extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull Worklog entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

