/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issuecache;

import com.atlassian.jira.migration.db.servicedesk.comment.CommentReader;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/export/core/issuecache/PublicCommentsProvider;", "", "commentsReader", "Lcom/atlassian/jira/migration/db/servicedesk/comment/CommentReader;", "(Lcom/atlassian/jira/migration/db/servicedesk/comment/CommentReader;)V", "fromCachePerProject", "Lkotlin/Function1;", "", "", "projectId", "Companion", "jira-migration-plugin"})
public final class PublicCommentsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommentReader commentsReader;
    @NotNull
    private static final Logger log;

    @Inject
    public PublicCommentsProvider(@NotNull CommentReader commentsReader) {
        Intrinsics.checkNotNullParameter((Object)commentsReader, (String)"commentsReader");
        this.commentsReader = commentsReader;
    }

    @NotNull
    public final Function1<Long, Boolean> fromCachePerProject(long projectId) {
        List<Long> list;
        try {
            list = this.commentsReader.getInternalServiceDeskComments(projectId);
        }
        catch (Exception e) {
            log.error("Exception in getting Internal Service Desk Comments, retrying... ", (Throwable)e);
            list = this.commentsReader.getInternalServiceDeskComments(projectId);
        }
        List<Long> cache2 = list;
        log.info("publicCommentsCache stats : size: " + cache2.size());
        return (Function1)new Function1<Long, Boolean>(cache2){
            final /* synthetic */ List<Long> $cache;
            {
                this.$cache = $cache;
                super(1);
            }

            @NotNull
            public final Boolean invoke(long it) {
                return CollectionsKt.binarySearch$default(this.$cache, (Comparable)Long.valueOf(it), (int)0, (int)0, (int)6, null) < 0;
            }
        };
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(PublicCommentsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/core/issuecache/PublicCommentsProvider$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

