/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issuelink;

import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.migration.export.db.core.IssueLinkData;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.core.Constants;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.issuelink.IssueLink;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0002H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/export/core/issuelink/IssueLinkDataExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/core/IssueLinkData;", "Lcom/atlassian/migration/jira/core/issuelink/IssueLink;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "issueLinkTypeManager", "Lcom/atlassian/jira/issue/link/IssueLinkTypeManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/issue/link/IssueLinkTypeManager;)V", "clock", "Ljava/time/Clock;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Ljava/time/Clock;Lcom/atlassian/jira/issue/link/IssueLinkTypeManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForIssueKey", "entityKey", "mriForKey", "postConstruct", "", "jira-migration-plugin"})
public final class IssueLinkDataExporter
implements Exporter<Long, IssueLinkData, IssueLink> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final Clock clock;
    @NotNull
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final Logger log;

    @VisibleForTesting
    public IssueLinkDataExporter(@NotNull ExportService exportService, @NotNull Clock clock, @NotNull IssueLinkTypeManager issueLinkTypeManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)issueLinkTypeManager, (String)"issueLinkTypeManager");
        this.exportService = exportService;
        this.clock = clock;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.log = LoggerFactory.getLogger(IssueLinkDataExporter.class);
    }

    @Inject
    public IssueLinkDataExporter(@NotNull ExportService exportService, @NotNull IssueLinkTypeManager issueLinkTypeManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)issueLinkTypeManager, (String)"issueLinkTypeManager");
        Clock clock = Clock.systemUTC();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC(...)");
        this(exportService, clock, issueLinkTypeManager);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, IssueLinkData.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(new EntityType(Constants.INSTANCE.getJiraCoreNamespace(), "issueLinkV1", null, null, Boolean.valueOf(true), 12, null));
    }

    @Override
    @NotNull
    public IssueLink exportData(@NotNull ExportContext ctx, @NotNull IssueLinkData entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Instant now = this.clock.instant();
        IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(Long.valueOf(entity.getLinkTypeId()));
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting issueLink with id {} for migration {} under exportMode {}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        MRI mRI2 = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, issueLinkType, false, 4, null);
        MRI mRI3 = this.mriForIssueKey(entity.getSourceId());
        MRI mRI4 = this.mriForIssueKey(entity.getDestinationId());
        Long l = entity.getSequence();
        Long l2 = l != null ? l : 0L;
        Intrinsics.checkNotNull((Object)now);
        return new IssueLink(mRI, mRI2, mRI3, mRI4, l2, now, now);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull IssueLinkData entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(IssueLink.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MRI mriForIssueKey(long entityKey) {
        return MriExtensionsKt.mri$default(Issue.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull IssueLinkData entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public IssueLinkData extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull IssueLinkData entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

