/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issueparentassociation;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.migration.datafilters.service.DataFilterService;
import com.atlassian.jira.migration.datafilters.utils.DataFiltersUtil;
import com.atlassian.jira.migration.export.core.issuelinktype.IssueLinkTypeExtensionFunctionsKt;
import com.atlassian.jira.migration.export.core.issueparentassociation.IssueParentAssociationWrapper;
import com.atlassian.jira.migration.export.db.core.IssueLinkData;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.issueassociation.IssueParentAssociationType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"toIssueParentAssociationWrapper", "Lcom/atlassian/jira/migration/export/core/issueparentassociation/IssueParentAssociationWrapper;", "Lcom/atlassian/jira/issue/link/IssueLink;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "dataFilterService", "Lcom/atlassian/jira/migration/datafilters/service/DataFilterService;", "toIssueParentAssociationWrapperV1", "Lcom/atlassian/jira/migration/export/db/core/IssueLinkData;", "issueLinkType", "Lcom/atlassian/jira/issue/link/IssueLinkType;", "jira-migration-plugin"})
public final class IssueParentAssociationExporterKt {
    @NotNull
    public static final IssueParentAssociationWrapper toIssueParentAssociationWrapper(@NotNull IssueLink $this$toIssueParentAssociationWrapper, @NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull MigrationFeatures migrationFeatures, @NotNull DataFilterService dataFilterService) {
        IssueParentAssociationType issueParentAssociationType;
        Intrinsics.checkNotNullParameter((Object)$this$toIssueParentAssociationWrapper, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)dataFilterService, (String)"dataFilterService");
        Issue issue2 = $this$toIssueParentAssociationWrapper.getSourceObject();
        Intrinsics.checkNotNullExpressionValue((Object)issue2, (String)"getSourceObject(...)");
        MRI source = IssueParentAssociationExporterKt.toIssueParentAssociationWrapper$processIssueObject(ctx, migrationFeatures, dataFilterService, exportService, issue2);
        Issue issue3 = $this$toIssueParentAssociationWrapper.getDestinationObject();
        Intrinsics.checkNotNullExpressionValue((Object)issue3, (String)"getDestinationObject(...)");
        MRI destination = IssueParentAssociationExporterKt.toIssueParentAssociationWrapper$processIssueObject(ctx, migrationFeatures, dataFilterService, exportService, issue3);
        if ($this$toIssueParentAssociationWrapper.getIssueLinkType().isSubTaskLinkType()) {
            issueParentAssociationType = IssueParentAssociationType.SUB_TASK;
        } else {
            IssueLinkType issueLinkType = $this$toIssueParentAssociationWrapper.getIssueLinkType();
            Intrinsics.checkNotNullExpressionValue((Object)issueLinkType, (String)"getIssueLinkType(...)");
            issueParentAssociationType = IssueLinkTypeExtensionFunctionsKt.isParentLinkType(issueLinkType) ? IssueParentAssociationType.PARENT_LINK : IssueParentAssociationType.EPIC;
        }
        IssueParentAssociationType associationType = issueParentAssociationType;
        Long l = $this$toIssueParentAssociationWrapper.getDestinationId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getDestinationId(...)");
        return new IssueParentAssociationWrapper(((Number)l).longValue(), destination, source, associationType);
    }

    @NotNull
    public static final IssueParentAssociationWrapper toIssueParentAssociationWrapperV1(@NotNull IssueLinkData $this$toIssueParentAssociationWrapperV1, @NotNull IssueLinkType issueLinkType) {
        Intrinsics.checkNotNullParameter((Object)$this$toIssueParentAssociationWrapperV1, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)issueLinkType, (String)"issueLinkType");
        MRI source = MriExtensionsKt.mri$default(com.atlassian.migration.jira.core.Issue.Companion.getEntityType(), $this$toIssueParentAssociationWrapperV1.getSourceId(), null, 2, null);
        MRI destination = MriExtensionsKt.mri$default(com.atlassian.migration.jira.core.Issue.Companion.getEntityType(), $this$toIssueParentAssociationWrapperV1.getDestinationId(), null, 2, null);
        IssueParentAssociationType associationType = issueLinkType.isSubTaskLinkType() ? IssueParentAssociationType.SUB_TASK : (IssueLinkTypeExtensionFunctionsKt.isParentLinkType(issueLinkType) ? IssueParentAssociationType.PARENT_LINK : IssueParentAssociationType.EPIC);
        return new IssueParentAssociationWrapper($this$toIssueParentAssociationWrapperV1.getDestinationId(), destination, source, associationType);
    }

    private static final MRI toIssueParentAssociationWrapper$processIssueObject(ExportContext $ctx, MigrationFeatures $migrationFeatures, DataFilterService $dataFilterService, ExportService $exportService, Issue issueObject) {
        Issue $this$toIssueParentAssociationWrapper_u24processIssueObject_u24lambda_u240 = issueObject;
        boolean bl = false;
        return Intrinsics.areEqual((Object)$this$toIssueParentAssociationWrapper_u24processIssueObject_u24lambda_u240.getProjectId(), (Object)$ctx.getProject().getId()) && (!DataFiltersUtil.INSTANCE.shouldSkipReferencedIssueExport($migrationFeatures, $ctx.getDataFilterContext()) || $dataFilterService.shouldExportEntity($ctx.getDataFilterContext(), $this$toIssueParentAssociationWrapper_u24processIssueObject_u24lambda_u240)) ? ExportOrThrow.DefaultImpls.exportOrThrow$default($exportService, $ctx, $this$toIssueParentAssociationWrapper_u24processIssueObject_u24lambda_u240, false, 4, null) : $exportService.mri($this$toIssueParentAssociationWrapper_u24processIssueObject_u24lambda_u240);
    }
}

