/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issuesecurity;

import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.issuesecurity.IssueSecurityLevel;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0003H\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\u0016H\u0003R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/export/core/issuesecurity/IssueSecurityLevelExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/security/IssueSecurityLevel;", "Lcom/atlassian/migration/jira/classic/issuesecurity/IssueSecurityLevel;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "issueSecuritySchemeManager", "Lcom/atlassian/jira/issue/security/IssueSecuritySchemeManager;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/issue/security/IssueSecuritySchemeManager;Lcom/atlassian/jira/migration/export/utils/ExportFilters;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportData", "exportSecurityLevelPermissions", "jiraIssueSecurityLevel", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueSecurityLevelExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueSecurityLevelExporter.kt\ncom/atlassian/jira/migration/export/core/issuesecurity/IssueSecurityLevelExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n766#2:94\n857#2,2:95\n1855#2,2:97\n*S KotlinDebug\n*F\n+ 1 IssueSecurityLevelExporter.kt\ncom/atlassian/jira/migration/export/core/issuesecurity/IssueSecurityLevelExporter\n*L\n65#1:94\n65#1:95,2\n89#1:97,2\n*E\n"})
public final class IssueSecurityLevelExporter
implements Exporter<Long, com.atlassian.jira.issue.security.IssueSecurityLevel, IssueSecurityLevel> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    @NotNull
    private final ExportFilters exportFilters;
    private final Logger log;

    @Inject
    public IssueSecurityLevelExporter(@NotNull ExportService exportService, @NotNull IssueSecuritySchemeManager issueSecuritySchemeManager, @NotNull ExportFilters exportFilters) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)issueSecuritySchemeManager, (String)"issueSecuritySchemeManager");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        this.exportService = exportService;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.exportFilters = exportFilters;
        this.log = LoggerFactory.getLogger(IssueSecurityLevelExporter.class);
    }

    @PostConstruct
    private final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.jira.issue.security.IssueSecurityLevel.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(IssueSecurityLevel.Companion.getEntityType());
    }

    @Override
    @NotNull
    public IssueSecurityLevel exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.security.IssueSecurityLevel entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting issueSecurityLevel with id {} for migration {} under exportMode {}", objectArray);
        IssueSecurityLevelScheme issueSecurityLevelScheme = this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(entity.getSchemeId());
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new IssueSecurityLevel(mRI, string, entity.getDescription(), ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, issueSecurityLevelScheme, false, 4, null), Intrinsics.areEqual((Object)entity.getId(), (Object)issueSecurityLevelScheme.getDefaultSecurityLevelId()));
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.security.IssueSecurityLevel entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return CollectionsKt.listOf((Object)new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ IssueSecurityLevelExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ com.atlassian.jira.issue.security.IssueSecurityLevel $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportSecurityLevelPermissions(this.$ctx, this.$entity);
            }
        });
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.jira.issue.security.IssueSecurityLevel entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(IssueSecurityLevel.Companion.getEntityType(), entityKey, null, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    public final void exportSecurityLevelPermissions(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.security.IssueSecurityLevel jiraIssueSecurityLevel) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraIssueSecurityLevel, (String)"jiraIssueSecurityLevel");
        v0 = this.issueSecuritySchemeManager.getPermissionsBySecurityLevel(jiraIssueSecurityLevel.getId());
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPermissionsBySecurityLevel(...)");
        $this$filter$iv = CollectionsKt.filterNotNull((Iterable)v0);
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (IssueSecurityLevelPermission)element$iv$iv;
            $i$a$-filter-IssueSecurityLevelExporter$exportSecurityLevelPermissions$1 = false;
            var12_14 = it.getType();
            if (var12_14 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var12_14.hashCode()) {
                case -836031122: {
                    if (var12_14.equals("userCF")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3599307: {
                    if (var12_14.equals("user")) {
                        tmp = 2;
                    }
                    break;
                }
                case 293428002: {
                    if (var12_14.equals("groupCF")) {
                        tmp = 1;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 2: {
                    shouldMigrate = StringExtensionsKt.isNotNullOrBlank(it.getParameter());
                    if (!shouldMigrate) {
                        this.log.warn("Skipping IssueSecurityLevelPermission with id " + it.getId() + " due to invalid user reference.");
                    }
                    v1 = shouldMigrate;
                    break;
                }
                case 1: {
                    shouldMigrate = this.exportFilters.isSupportedFieldById(ctx, it.getParameter());
                    if (!shouldMigrate) {
                        this.log.warn("Skipping IssueSecurityLevelPermission with id " + it.getId() + " and type " + it.getType() + " + due to usage of unsupported custom field.");
                    }
                    v1 = shouldMigrate;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v1 = true;
                }
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            levelPermission = (IssueSecurityLevelPermission)element$iv;
            $i$a$-forEach-IssueSecurityLevelExporter$exportSecurityLevelPermissions$2 = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, levelPermission, false, 4, null);
        }
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.security.IssueSecurityLevel entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public com.atlassian.jira.issue.security.IssueSecurityLevel extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }
}

