/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issuesecurity;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.issuesecurity.IssueSecurityLevelPermission;
import com.atlassian.migration.jira.classic.permission.ApplicationRoleType;
import com.atlassian.migration.jira.classic.permission.PermissionHolder;
import com.atlassian.migration.jira.core.projectrole.ProjectRole;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B/\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u001a\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0007J\u0010\u0010'\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0002H\u0016J\b\u0010*\u001a\u00020\u001cH\u0003R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/atlassian/jira/migration/export/core/issuesecurity/IssueSecurityLevelPermissionExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/security/IssueSecurityLevelPermission;", "Lcom/atlassian/migration/jira/classic/issuesecurity/IssueSecurityLevelPermission;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "identifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "issueSecuritySchemeManager", "Lcom/atlassian/jira/issue/security/IssueSecuritySchemeManager;", "issueSecurityLevelManager", "Lcom/atlassian/jira/issue/security/IssueSecurityLevelManager;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/issue/security/IssueSecuritySchemeManager;Lcom/atlassian/jira/issue/security/IssueSecurityLevelManager;Lcom/atlassian/jira/issue/CustomFieldManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "handleProjectRoleExportFailed", "Lcom/atlassian/jira/migration/export/framework/ExportException;", "projectRoleMri", "Lcom/atlassian/migration/base/mri/MRI;", "mapApplicationRoleType", "Lcom/atlassian/migration/jira/classic/permission/ApplicationRoleType;", "type", "", "mapPermissionHolder", "Lcom/atlassian/migration/jira/classic/permission/PermissionHolder;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueSecurityLevelPermissionExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueSecurityLevelPermissionExporter.kt\ncom/atlassian/jira/migration/export/core/issuesecurity/IssueSecurityLevelPermissionExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class IssueSecurityLevelPermissionExporter
implements Exporter<Long, com.atlassian.jira.issue.security.IssueSecurityLevelPermission, IssueSecurityLevelPermission> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EntityIdentifierGenerator identifierGenerator;
    @NotNull
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    @NotNull
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    @NotNull
    private final CustomFieldManager customFieldManager;
    private final Logger log;

    @Inject
    public IssueSecurityLevelPermissionExporter(@NotNull ExportService exportService, @NotNull EntityIdentifierGenerator identifierGenerator, @NotNull IssueSecuritySchemeManager issueSecuritySchemeManager, @NotNull IssueSecurityLevelManager issueSecurityLevelManager, @NotNull CustomFieldManager customFieldManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)identifierGenerator, (String)"identifierGenerator");
        Intrinsics.checkNotNullParameter((Object)issueSecuritySchemeManager, (String)"issueSecuritySchemeManager");
        Intrinsics.checkNotNullParameter((Object)issueSecurityLevelManager, (String)"issueSecurityLevelManager");
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        this.exportService = exportService;
        this.identifierGenerator = identifierGenerator;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.customFieldManager = customFieldManager;
        this.log = LoggerFactory.getLogger(IssueSecurityLevelPermissionExporter.class);
    }

    @PostConstruct
    private final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.jira.issue.security.IssueSecurityLevelPermission.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(IssueSecurityLevelPermission.Companion.getEntityType());
    }

    @Override
    @NotNull
    public IssueSecurityLevelPermission exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.security.IssueSecurityLevelPermission entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting issueSecurityLevelPermission with id {} for migration {} under exportMode {}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        MRI mRI2 = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(entity.getSchemeId()), false, 4, null);
        ExportOrThrow exportOrThrow = this.exportService;
        Long l = entity.getSecurityLevelId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getSecurityLevelId(...)");
        return new IssueSecurityLevelPermission(mRI, mRI2, ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow, ctx, this.issueSecurityLevelManager.getSecurityLevel(((Number)l).longValue()), false, 4, null), this.mapPermissionHolder(ctx, entity));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.security.IssueSecurityLevelPermission entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for issueSecurityLevelPermission with id {} for migration {} under exportMode {}", objectArray);
        this.mapPermissionHolder(ctx, entity);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.jira.issue.security.IssueSecurityLevelPermission entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(IssueSecurityLevelPermission.Companion.getEntityType(), entityKey, null, 2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @NotNull
    public final PermissionHolder mapPermissionHolder(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.security.IssueSecurityLevelPermission entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String string = entity.getType();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1247292954: {
                    if (!string.equals("applicationRole")) break;
                    n = 1;
                    break;
                }
                case -836031122: {
                    if (!string.equals("userCF")) break;
                    n = 2;
                    break;
                }
                case -938961137: {
                    if (!string.equals("projectrole")) break;
                    n = 3;
                    break;
                }
                case 1158900059: {
                    if (!string.equals("sd.customer.portal.only")) break;
                    n = 4;
                    break;
                }
                case -427039519: {
                    if (!string.equals("reporter")) break;
                    n = 5;
                    break;
                }
                case -369881649: {
                    if (!string.equals("assignee")) break;
                    n = 6;
                    break;
                }
                case 3599307: {
                    if (!string.equals("user")) break;
                    n = 7;
                    break;
                }
                case 3317596: {
                    if (!string.equals("lead")) break;
                    n = 8;
                    break;
                }
                case 98629247: {
                    if (!string.equals("group")) break;
                    n = 9;
                    break;
                }
                case 293428002: {
                    if (!string.equals("groupCF")) break;
                    n = 10;
                    break;
                }
            }
            switch (n) {
                case 7: {
                    PermissionHolder permissionHolder;
                    UserRef userRef = UserRef.Companion.fromString(entity.getParameter());
                    if (userRef != null) {
                        UserRef it = userRef;
                        boolean bl = false;
                        permissionHolder = (PermissionHolder)new PermissionHolder.User(this.exportService.userRef(ctx, it));
                        return permissionHolder;
                    }
                    MRI mRI = this.mriForEntity(entity);
                    String it = EntityIdentifierGenerator.generate$default(this.identifierGenerator, this.mriForEntity(entity), entity, null, 4, null) + " contains an invalid user.";
                    ExportErrorCode bl = ExportErrorCode.PRJ_ISSUE_SECURITY_LEVEL_PERMISSION_INVALID_USER;
                    throw new ExportException(mRI, bl, it, "Please remove the invalid user.", null, null, null, 112, null);
                }
                case 9: {
                    PermissionHolder permissionHolder;
                    String string2 = entity.getParameter();
                    if (string2 != null) {
                        String it = string2;
                        boolean bl = false;
                        String string3 = entity.getParameter();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getParameter(...)");
                        GroupRefModel groupRef = new GroupRefModel(string3, "Issue Security Level Permission", String.valueOf(entity.getId()));
                        permissionHolder = (PermissionHolder)new PermissionHolder.Group(this.exportService.groupRef(ctx, groupRef));
                        return permissionHolder;
                    }
                    permissionHolder = (PermissionHolder)new PermissionHolder.Anyone();
                    return permissionHolder;
                }
                case 3: {
                    EntityType entityType = ProjectRole.Companion.getEntityType();
                    String string4 = entity.getParameter();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getParameter(...)");
                    PermissionHolder permissionHolder = (PermissionHolder)new PermissionHolder.ProjectRole(this.exportService.exportByIdOrThrow(ctx, entityType, Long.parseLong(string4), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(this, entity){
                        final /* synthetic */ IssueSecurityLevelPermissionExporter this$0;
                        final /* synthetic */ com.atlassian.jira.issue.security.IssueSecurityLevelPermission $entity;
                        {
                            this.this$0 = $receiver;
                            this.$entity = $entity;
                            super(1);
                        }

                        @NotNull
                        public final Exception invoke(@NotNull MRI projectRoleMri2) {
                            Intrinsics.checkNotNullParameter((Object)projectRoleMri2, (String)"projectRoleMri");
                            return IssueSecurityLevelPermissionExporter.access$handleProjectRoleExportFailed(this.this$0, projectRoleMri2, this.$entity);
                        }
                    })));
                    return permissionHolder;
                }
                case 5: {
                    PermissionHolder permissionHolder = (PermissionHolder)new PermissionHolder.Reporter();
                    return permissionHolder;
                }
                case 6: {
                    PermissionHolder permissionHolder = (PermissionHolder)new PermissionHolder.Assignee();
                    return permissionHolder;
                }
                case 8: {
                    PermissionHolder permissionHolder = (PermissionHolder)new PermissionHolder.ProjectLead();
                    return permissionHolder;
                }
                case 2: {
                    ExportOrThrow exportOrThrow = this.exportService;
                    CustomField customField = this.customFieldManager.getCustomFieldObject(entity.getParameter());
                    Intrinsics.checkNotNull((Object)customField);
                    PermissionHolder permissionHolder = (PermissionHolder)new PermissionHolder.UserCustomField(ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow, ctx, customField, false, 4, null));
                    return permissionHolder;
                }
                case 10: {
                    ExportOrThrow exportOrThrow = this.exportService;
                    CustomField customField = this.customFieldManager.getCustomFieldObject(entity.getParameter());
                    Intrinsics.checkNotNull((Object)customField);
                    PermissionHolder permissionHolder = (PermissionHolder)new PermissionHolder.GroupCustomField(ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow, ctx, customField, false, 4, null));
                    return permissionHolder;
                }
                case 1: {
                    PermissionHolder permissionHolder = (PermissionHolder)new PermissionHolder.ApplicationRole(this.mapApplicationRoleType(entity.getParameter(), entity));
                    return permissionHolder;
                }
                case 4: {
                    PermissionHolder permissionHolder = (PermissionHolder)new PermissionHolder.ServiceDeskCustomerPortalOnly();
                    return permissionHolder;
                }
            }
        }
        MRI mri = this.mriForEntity(entity);
        String string5 = "Issue security permission type: " + entity.getType() + " for " + EntityIdentifierGenerator.generate$default(this.identifierGenerator, mri, entity, null, 4, null) + " is not supported";
        ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_ISSUE_SECURITY_LEVEL_PERMISSION_TYPE_UNSUPPORTED;
        throw new ExportException(mri, exportErrorCode, string5, null, null, null, null, 120, null);
    }

    private final ExportException handleProjectRoleExportFailed(MRI projectRoleMri2, com.atlassian.jira.issue.security.IssueSecurityLevelPermission entity) {
        MRI mRI = this.mriForEntity(entity);
        String string = EntityIdentifierGenerator.generate$default(this.identifierGenerator, this.mriForEntity(entity), entity, null, 4, null) + " has reference to " + EntityIdentifierGenerator.generate$default(this.identifierGenerator, projectRoleMri2, null, null, 6, null) + " that failed to be exported";
        ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_ISSUE_SECURITY_LEVEL_PERMISSION_REFERRED_PROJECT_ROLE_NOT_EXPORTED;
        return new ExportException(mRI, exportErrorCode, string, null, null, null, null, 120, null);
    }

    /*
     * Unable to fully structure code
     */
    private final ApplicationRoleType mapApplicationRoleType(String type, com.atlassian.jira.issue.security.IssueSecurityLevelPermission entity) {
        block8: {
            block6: {
                block7: {
                    v0 = var3_3 = type;
                    if (v0 == null) break block6;
                    switch (v0.hashCode()) {
                        case 488515375: {
                            if (!var3_3.equals("jira-servicedesk")) {
                                ** break;
                            }
                            break block7;
                        }
                        case 645128422: {
                            if (var3_3.equals("jira-software")) break;
                            ** break;
                        }
                        case 912696926: {
                            if (!var3_3.equals("jira-core")) ** break;
                            v1 = ApplicationRoleType.CORE;
                            break block8;
                        }
                    }
                    v1 = ApplicationRoleType.SOFTWARE;
                    break block8;
                }
                v1 = ApplicationRoleType.SERVICE_DESK;
                break block8;
            }
            v1 = ApplicationRoleType.ANY;
            break block8;
lbl23:
            // 4 sources

            mri = this.mriForEntity(entity);
            var5_5 = "Application role type: " + type + " for " + EntityIdentifierGenerator.generate$default(this.identifierGenerator, mri, entity, null, 4, null) + " is not supported";
            var6_6 = ExportErrorCode.PRJ_ISSUE_SECURITY_LEVEL_PERMISSION_ROLE_TYPE_UNSUPPORTED;
            throw new ExportException(mri, var6_6, var5_5, null, null, null, null, 120, null);
        }
        return v1;
    }

    @Override
    @Nullable
    public com.atlassian.jira.issue.security.IssueSecurityLevelPermission extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.security.IssueSecurityLevelPermission entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    public static final /* synthetic */ ExportException access$handleProjectRoleExportFailed(IssueSecurityLevelPermissionExporter $this, MRI projectRoleMri2, com.atlassian.jira.issue.security.IssueSecurityLevelPermission entity) {
        return $this.handleProjectRoleExportFailed(projectRoleMri2, entity);
    }
}

