/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issuesecurity;

import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.issuesecurity.IssueSecurityScheme;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/export/core/issuesecurity/IssueSecuritySchemeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/security/IssueSecurityLevelScheme;", "Lcom/atlassian/migration/jira/classic/issuesecurity/IssueSecurityScheme;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "issueSecurityLevelManager", "Lcom/atlassian/jira/issue/security/IssueSecurityLevelManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/issue/security/IssueSecurityLevelManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportData", "exportIssueSecurityLevels", "issueSecurityLevelScheme", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueSecuritySchemeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueSecuritySchemeExporter.kt\ncom/atlassian/jira/migration/export/core/issuesecurity/IssueSecuritySchemeExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1855#2,2:57\n*S KotlinDebug\n*F\n+ 1 IssueSecuritySchemeExporter.kt\ncom/atlassian/jira/migration/export/core/issuesecurity/IssueSecuritySchemeExporter\n*L\n48#1:57,2\n*E\n"})
public final class IssueSecuritySchemeExporter
implements Exporter<Long, IssueSecurityLevelScheme, IssueSecurityScheme> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final Logger log;

    @Inject
    public IssueSecuritySchemeExporter(@NotNull ExportService exportService, @NotNull IssueSecurityLevelManager issueSecurityLevelManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)issueSecurityLevelManager, (String)"issueSecurityLevelManager");
        this.exportService = exportService;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.log = LoggerFactory.getLogger(IssueSecuritySchemeExporter.class);
    }

    @PostConstruct
    private final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, IssueSecurityLevelScheme.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(IssueSecurityScheme.Companion.getEntityType());
    }

    @Override
    @NotNull
    public IssueSecurityScheme exportData(@NotNull ExportContext ctx, @NotNull IssueSecurityLevelScheme entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting issueSecurityLevelScheme with id {} for migration {} under exportMode {}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new IssueSecurityScheme(mRI, string, entity.getDescription(), null, null, 24, null);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull IssueSecurityLevelScheme entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return CollectionsKt.listOf((Object)new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ IssueSecuritySchemeExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ IssueSecurityLevelScheme $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                IssueSecuritySchemeExporter.access$exportIssueSecurityLevels(this.this$0, this.$ctx, this.$entity);
            }
        });
    }

    private final void exportIssueSecurityLevels(ExportContext ctx, IssueSecurityLevelScheme issueSecurityLevelScheme) {
        Long l = issueSecurityLevelScheme.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        List list = this.issueSecurityLevelManager.getIssueSecurityLevels(((Number)l).longValue());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIssueSecurityLevels(...)");
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)list);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IssueSecurityLevel it = (IssueSecurityLevel)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull IssueSecurityLevelScheme entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(IssueSecurityScheme.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull IssueSecurityLevelScheme entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public IssueSecurityLevelScheme extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    public static final /* synthetic */ void access$exportIssueSecurityLevels(IssueSecuritySchemeExporter $this, ExportContext ctx, IssueSecurityLevelScheme issueSecurityLevelScheme) {
        $this.exportIssueSecurityLevels(ctx, issueSecurityLevelScheme);
    }
}

