/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.issuetype;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.migration.export.advancedroadmaps.ArHierarchyConfigDataService;
import com.atlassian.jira.migration.export.advancedroadmaps.IssueTypeHierarchyListExporterKt;
import com.atlassian.jira.migration.export.advancedroadmaps.IssueTypeHierarchyListWrapper;
import com.atlassian.jira.migration.export.db.advancedroadmaps.HierarchyConfigData;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.JiraProperties;
import com.atlassian.jira.migration.preflight.reports.ProblemType;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.issuetype.ManagedIssueTypeKey;
import com.atlassian.migration.jira.classic.scope.EntityScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010$\u001a\u00020\u0014H\u0007J\"\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010!2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/atlassian/jira/migration/export/core/issuetype/IssueTypeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/issuetype/IssueType;", "Lcom/atlassian/migration/jira/classic/issuetype/IssueType;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "arHierarchyConfigDataService", "Lcom/atlassian/jira/migration/export/advancedroadmaps/ArHierarchyConfigDataService;", "issueTypeManager", "Lcom/atlassian/jira/config/IssueTypeManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/advancedroadmaps/ArHierarchyConfigDataService;Lcom/atlassian/jira/config/IssueTypeManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addToReportsIfNameAltered", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "isManaged", "", "arjEnrichedHierarchyLevel", "Lcom/atlassian/migration/base/mri/MRI;", "issueType", "exportData", "extractServerEntity", "entityKey", "mapManagedIssueType", "Lcom/atlassian/migration/jira/classic/issuetype/ManagedIssueTypeKey;", "mriForEntity", "mriForKey", "postConstruct", "verifyIssueTypeHierarchy", "managedIssueTypeKey", "hierarchyLevel", "issueTypeMRI", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueTypeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueTypeExporter.kt\ncom/atlassian/jira/migration/export/core/issuetype/IssueTypeExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1#2:150\n288#3:151\n1549#3:152\n1620#3,3:153\n289#3:156\n*S KotlinDebug\n*F\n+ 1 IssueTypeExporter.kt\ncom/atlassian/jira/migration/export/core/issuetype/IssueTypeExporter\n*L\n109#1:151\n110#1:152\n110#1:153,3\n109#1:156\n*E\n"})
public final class IssueTypeExporter
implements Exporter<String, IssueType, com.atlassian.migration.jira.classic.issuetype.IssueType> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ArHierarchyConfigDataService arHierarchyConfigDataService;
    @NotNull
    private final IssueTypeManager issueTypeManager;
    private final Logger log;

    @Inject
    public IssueTypeExporter(@NotNull ExportService exportService, @NotNull ArHierarchyConfigDataService arHierarchyConfigDataService, @NotNull IssueTypeManager issueTypeManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)arHierarchyConfigDataService, (String)"arHierarchyConfigDataService");
        Intrinsics.checkNotNullParameter((Object)issueTypeManager, (String)"issueTypeManager");
        this.exportService = exportService;
        this.arHierarchyConfigDataService = arHierarchyConfigDataService;
        this.issueTypeManager = issueTypeManager;
        this.log = LoggerFactory.getLogger(IssueTypeExporter.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(com.atlassian.migration.jira.classic.issuetype.IssueType.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, IssueType.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public com.atlassian.migration.jira.classic.issuetype.IssueType exportData(@NotNull ExportContext ctx, @NotNull IssueType entity) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting issueType with id {} for migration {} under exportMode {}", objectArray);
        ManagedIssueTypeKey managedIssueTypeKey = this.mapManagedIssueType(entity);
        MRI hierarchyLevel = this.arjEnrichedHierarchyLevel(ctx, entity);
        MRI issueTypeMRI = this.mriForEntity(entity);
        this.verifyIssueTypeHierarchy(managedIssueTypeKey, hierarchyLevel, issueTypeMRI);
        this.addToReportsIfNameAltered(ctx, entity, managedIssueTypeKey != null);
        MRI mRI2 = issueTypeMRI;
        String string = entity.getName();
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string3 = entity.getDescription();
        boolean bl = entity.isSubTask();
        Avatar avatar = entity.getAvatar();
        if (avatar != null) {
            void it;
            Avatar avatar2 = avatar;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            MRI mRI3 = mRI2;
            boolean bl3 = false;
            MRI mRI4 = this.exportService.exportOrNull(ctx, it);
            mRI2 = mRI3;
            string2 = string5;
            string3 = string4;
            bl = bl2;
            mRI = mRI4;
        } else {
            mRI = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 384;
        EntityScope entityScope = null;
        MRI mRI5 = null;
        MRI mRI6 = hierarchyLevel;
        ManagedIssueTypeKey managedIssueTypeKey2 = managedIssueTypeKey;
        MRI mRI7 = mRI;
        boolean bl4 = bl;
        String string6 = string3;
        String string7 = string2;
        MRI mRI8 = mRI2;
        return new com.atlassian.migration.jira.classic.issuetype.IssueType(mRI8, string7, string6, bl4, mRI7, managedIssueTypeKey2, mRI6, mRI5, entityScope, n, defaultConstructorMarker);
    }

    private final void verifyIssueTypeHierarchy(ManagedIssueTypeKey managedIssueTypeKey, MRI hierarchyLevel, MRI issueTypeMRI) {
        if (managedIssueTypeKey == ManagedIssueTypeKey.JSW_STORY && Intrinsics.areEqual((Object)hierarchyLevel.getEntityId(), (Object)"-1")) {
            throw new ExportException(issueTypeMRI, ExportErrorCode.PRJ_JSW_STORY_ISSUE_TYPE_HIERARCHY_INCORRECT_LEVEL, "Issue Type JSW_STORY cannot have -1 as the Hierarchy Level", "Kindly configure your Issue Type Hierarchy correctly https://support.atlassian.com/jira-cloud-administration/docs/configure-the-issue-type-hierarchy/#Modify-the-default-hierarchy-levels", null, null, null, 112, null);
        }
    }

    private final ManagedIssueTypeKey mapManagedIssueType(IssueType issueType) {
        String string = issueType.getId();
        return Intrinsics.areEqual((Object)string, JiraProperties.INSTANCE.getJswPropertyValue("GreenHopper.Story.Default.issuetype.id")) ? ManagedIssueTypeKey.JSW_STORY : (Intrinsics.areEqual((Object)string, JiraProperties.INSTANCE.getJswPropertyValue("GreenHopper.Epic.Default.issuetype.id")) ? ManagedIssueTypeKey.JSW_EPIC : null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull IssueType entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String string = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return this.mriForKey(string);
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.classic.issuetype.IssueType.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @Nullable
    public IssueType extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return this.issueTypeManager.getIssueType(entityKey);
    }

    /*
     * WARNING - void declaration
     */
    private final MRI arjEnrichedHierarchyLevel(ExportContext ctx, IssueType issueType) {
        HierarchyConfigData hierarchyConfigData;
        Object v0;
        List<HierarchyConfigData> hierarchyConfigList2;
        block3: {
            hierarchyConfigList2 = ctx.getOrLoadCachedArHierarchyConfig((Function0<? extends List<HierarchyConfigData>>)((Function0)new Function0<List<? extends HierarchyConfigData>>(this){
                final /* synthetic */ IssueTypeExporter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final List<HierarchyConfigData> invoke() {
                    return IssueTypeExporter.access$getArHierarchyConfigDataService$p(this.this$0).getHierarchyConfig();
                }
            }));
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, new IssueTypeHierarchyListWrapper(hierarchyConfigList2), false, 4, null);
            Iterable $this$firstOrNull$iv = hierarchyConfigList2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                void $this$mapTo$iv$iv;
                HierarchyConfigData hierarchyConfigData2 = (HierarchyConfigData)element$iv;
                boolean bl = false;
                Iterable $this$map$iv = hierarchyConfigData2.getIssueTypeIds();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    long l = ((Number)item$iv$iv).longValue();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(String.valueOf((long)it));
                }
                if (!((List)destination$iv$iv).contains(issueType.getId())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((hierarchyConfigData = (HierarchyConfigData)v0) == null) {
            hierarchyConfigData = issueType.isSubTask() ? hierarchyConfigList2.get(0) : (Intrinsics.areEqual((Object)issueType.getId(), JiraProperties.INSTANCE.getJswPropertyValue("GreenHopper.Epic.Default.issuetype.id")) ? hierarchyConfigList2.get(2) : hierarchyConfigList2.get(1));
        }
        HierarchyConfigData hierarchyConfig = hierarchyConfigData;
        return IssueTypeHierarchyListExporterKt.toIssueTypeHierarchy(hierarchyConfig).getId();
    }

    private final void addToReportsIfNameAltered(ExportContext ctx, IssueType entity, boolean isManaged) {
        if (ctx.getExportMode() != ExportMode.COLLECT_REPORT_DATA && !ctx.getExportMode().isProjectPreflightOrPreprocessing()) {
            return;
        }
        if (!isManaged && (Intrinsics.areEqual((Object)entity.getName(), (Object)"Story") || Intrinsics.areEqual((Object)entity.getName(), (Object)"Epic"))) {
            String string = entity.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String string2 = entity.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            ExportContext.handleUnsupported$default(ctx, string, string2, String.valueOf((Object)ProblemType.ISSUE_TYPE), entity.getName(), null, null, 48, null);
        }
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull IssueType entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull IssueType entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    public static final /* synthetic */ ArHierarchyConfigDataService access$getArHierarchyConfigDataService$p(IssueTypeExporter $this) {
        return $this.arHierarchyConfigDataService;
    }
}

