/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.mail;

import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.mail.MailProtocol;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.MailServer;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/export/core/mail/MailServerExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/mail/server/MailServer;", "Lcom/atlassian/jira/migration/export/core/mail/JiraMailServer;", "Lcom/atlassian/migration/jira/core/MailServer;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "jira-migration-plugin"})
public final class MailServerExporter
implements Exporter<Long, com.atlassian.mail.server.MailServer, MailServer> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ExporterKey key;

    @Inject
    public MailServerExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.key = new ExporterKey(MailServer.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.mail.server.MailServer.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.mail.server.MailServer entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(MailServer.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MailServer exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.mail.server.MailServer entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        String string2 = entity.getDescription();
        String string3 = entity.getPort();
        MailProtocol mailProtocol = entity.getMailProtocol();
        String string4 = mailProtocol != null ? mailProtocol.getProtocol() : null;
        String string5 = entity.getType();
        String string6 = entity.getHostname();
        String string7 = entity.getSocksHost();
        String string8 = entity.getSocksPort();
        long l = entity.getTimeout();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)string3);
        Intrinsics.checkNotNull((Object)string5);
        Intrinsics.checkNotNull((Object)string6);
        return new MailServer(mRI, string, string2, string3, string4, string5, string6, string7, string8, null, null, null, Long.valueOf(l));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.mail.server.MailServer entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public com.atlassian.mail.server.MailServer extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.mail.server.MailServer entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

