/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.portalpage;

import com.atlassian.jira.migration.export.core.portalpage.DashboardPortletConfigResult;
import com.atlassian.jira.migration.export.core.portalpage.DashboardProjectSharePermissions;
import com.atlassian.jira.migration.export.core.portalpage.PortletConfigReportWrapper;
import com.atlassian.jira.migration.export.core.portalpage.SharePermissionWrapper;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.preflight.utils.ProjectKeysExtractorFromGadgets;
import com.atlassian.jira.migration.serverdataextractors.cpb.model.DashboardReferringProjectsInfo;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.ShareType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001AB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJD\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u00160\u0013H\u0002J\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0018\u001a\u00020\u0015J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010J\u0014\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0012\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#J\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J(\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u000e\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0011J$\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\b\u0010,\u001a\u0004\u0018\u00010!2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H\u0002J\u001c\u00101\u001a\u0002022\u0006\u00103\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010J\u0014\u00104\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010JL\u00105\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u000208070\u00132\"\u00109\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u00160\u0013J\u0014\u00105\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J:\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u0002002\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u000200070\u0013H\u0002JT\u0010=\u001a\u00020\f2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002000%2\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u00160\u00132\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u000200070\u0013H\u0002J\f\u0010?\u001a\u000202*\u00020@H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper;", "", "portalPageManager", "Lcom/atlassian/jira/portal/PortalPageManager;", "portletConfigurationManager", "Lcom/atlassian/jira/portal/PortletConfigurationManager;", "projectKeysExtractorFromGadgets", "Lcom/atlassian/jira/migration/preflight/utils/ProjectKeysExtractorFromGadgets;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "(Lcom/atlassian/jira/portal/PortalPageManager;Lcom/atlassian/jira/portal/PortletConfigurationManager;Lcom/atlassian/jira/migration/preflight/utils/ProjectKeysExtractorFromGadgets;Lcom/atlassian/jira/migration/export/utils/ExportFilters;)V", "addCorrespondingProjectIdsForDashboards", "", "portalPage", "Lcom/atlassian/jira/portal/PortalPage;", "projectKeys", "", "", "dashboardsHavingProjectPortletConfigs", "", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "extractProjectKeysFromGadget", "portletConfigurationId", "getAllPortalPages", "getDashboardsHavingPortletconfigurationsReferringProjects", "Lcom/atlassian/jira/migration/export/core/portalpage/DashboardPortletConfigResult;", "portalPageIds", "getDashboardsHavingProjectSharePermissions", "Lcom/atlassian/jira/migration/export/core/portalpage/DashboardProjectSharePermissions;", "portalPageList", "getDashboardsMigrationMode", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "crossProjectConfig", "Lcom/atlassian/jira/migration/plan/CrossProjectConfig;", "getDashboardsReferringProjectsInfoList", "", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/model/DashboardReferringProjectsInfo;", "getDashboardsReferringSelectedProjects", "selectedProjectIds", "getPortalPageName", "portalPageId", "getPortalPagesForMigrationMode", "dashboardsMigrationMode", "selectedProjectKeys", "getProjectReferencedGadgets", "", "Lcom/atlassian/jira/migration/export/core/portalpage/PortletConfigReportWrapper;", "isDashboardReferencingAnySelectedProject", "", "dashboardReferringProjectsInfo", "mapDashboardsProjectPortletConfigurations", "mapDashboardsProjectSharepermissions", "referredProjectSharePermissions", "", "Lcom/atlassian/jira/migration/export/core/portalpage/SharePermissionWrapper;", "dashboardsHavingProjectSharePermissions", "mapProjectKeysToCSV", "wrapper", "projectKeyToGadgets", "processProjectReferencedGadgets", "projectReferencedGadgets", "containsProjectReference", "Lcom/atlassian/jira/portal/PortletConfiguration;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDashboardsExtractionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DashboardsExtractionHelper.kt\ncom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,311:1\n1855#2,2:312\n766#2:314\n857#2,2:315\n1549#2:317\n1620#2,2:318\n1622#2:334\n1855#2:335\n766#2:336\n857#2,2:337\n1549#2:339\n1620#2,3:340\n1856#2:343\n1855#2,2:344\n1855#2:346\n1856#2:354\n1603#2,9:355\n1855#2:364\n1856#2:366\n1612#2:367\n1855#2:368\n1856#2:376\n766#2:385\n857#2,2:386\n1549#2:388\n1620#2,3:389\n1747#2,3:393\n372#3,7:320\n372#3,7:327\n372#3,7:347\n372#3,7:369\n1#4:365\n1#4:392\n125#5:377\n152#5,3:378\n125#5:381\n152#5,3:382\n*S KotlinDebug\n*F\n+ 1 DashboardsExtractionHelper.kt\ncom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper\n*L\n41#1:312,2\n62#1:314\n62#1:315,2\n63#1:317\n63#1:318,2\n63#1:334\n96#1:335\n99#1:336\n99#1:337,2\n100#1:339\n100#1:340,3\n96#1:343\n119#1:344,2\n140#1:346\n140#1:354\n156#1:355,9\n156#1:364\n156#1:366\n156#1:367\n158#1:368\n158#1:376\n199#1:385\n199#1:386,2\n213#1:388\n213#1:389,3\n242#1:393,3\n67#1:320,7\n77#1:327,7\n141#1:347,7\n159#1:369,7\n156#1:365\n181#1:377\n181#1:378,3\n189#1:381\n189#1:382,3\n*E\n"})
public final class DashboardsExtractionHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PortalPageManager portalPageManager;
    @NotNull
    private final PortletConfigurationManager portletConfigurationManager;
    @NotNull
    private final ProjectKeysExtractorFromGadgets projectKeysExtractorFromGadgets;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private static final Logger log;

    @Inject
    public DashboardsExtractionHelper(@NotNull PortalPageManager portalPageManager, @NotNull PortletConfigurationManager portletConfigurationManager, @NotNull ProjectKeysExtractorFromGadgets projectKeysExtractorFromGadgets, @NotNull ExportFilters exportFilters) {
        Intrinsics.checkNotNullParameter((Object)portalPageManager, (String)"portalPageManager");
        Intrinsics.checkNotNullParameter((Object)portletConfigurationManager, (String)"portletConfigurationManager");
        Intrinsics.checkNotNullParameter((Object)projectKeysExtractorFromGadgets, (String)"projectKeysExtractorFromGadgets");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        this.portalPageManager = portalPageManager;
        this.portletConfigurationManager = portletConfigurationManager;
        this.projectKeysExtractorFromGadgets = projectKeysExtractorFromGadgets;
        this.exportFilters = exportFilters;
    }

    @Nullable
    public final DashboardsMigrationMode getDashboardsMigrationMode(@Nullable CrossProjectConfig crossProjectConfig) {
        return crossProjectConfig != null ? crossProjectConfig.getCrossProjectExportConfig().getDashboardsMigrationMode() : null;
    }

    @NotNull
    public final DashboardProjectSharePermissions mapDashboardsProjectSharepermissions(@NotNull List<PortalPage> portalPageList) {
        Intrinsics.checkNotNullParameter(portalPageList, (String)"portalPageList");
        List portalPageIds = new ArrayList();
        Map referredProjectSharePermissions = new LinkedHashMap();
        Map dashboardsHavingProjectSharePermissions = new LinkedHashMap();
        Iterable $this$forEach$iv = portalPageList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PortalPage portalPage = (PortalPage)element$iv;
            boolean bl = false;
            Long l = portalPage.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            portalPageIds.add(l);
            this.mapDashboardsProjectSharepermissions(portalPage, referredProjectSharePermissions, dashboardsHavingProjectSharePermissions);
        }
        return new DashboardProjectSharePermissions(portalPageIds, referredProjectSharePermissions, dashboardsHavingProjectSharePermissions);
    }

    /*
     * WARNING - void declaration
     */
    public final void mapDashboardsProjectSharepermissions(@NotNull PortalPage portalPage, @NotNull Map<String, List<SharePermissionWrapper>> referredProjectSharePermissions, @NotNull Map<PortalPage, HashSet<Long>> dashboardsHavingProjectSharePermissions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SharePermission sharePermission;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)portalPage, (String)"portalPage");
        Intrinsics.checkNotNullParameter(referredProjectSharePermissions, (String)"referredProjectSharePermissions");
        Intrinsics.checkNotNullParameter(dashboardsHavingProjectSharePermissions, (String)"dashboardsHavingProjectSharePermissions");
        Set set = portalPage.getPermissions().getPermissionSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPermissionSet(...)");
        Iterable iterable = set;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            sharePermission = (SharePermission)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)sharePermission.getType(), (Object)ShareType.Name.PROJECT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            sharePermission = (SharePermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = sharePermission.getParam1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParam1(...)");
            Long projectId = StringsKt.toLongOrNull((String)string);
            String projectKey = this.projectKeysExtractorFromGadgets.getProjectKeyfromId(projectId);
            if (projectKey != null) {
                List list;
                boolean bl2 = false;
                Map<String, List<SharePermissionWrapper>> $this$getOrPut$iv = referredProjectSharePermissions;
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(projectKey);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(projectKey, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                Long l = sharePermission.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                long l2 = ((Number)l).longValue();
                Long l3 = portalPage.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getId(...)");
                list.add(new SharePermissionWrapper(l2, ((Number)l3).longValue()));
            }
            if (projectId != null) {
                HashSet<Long> hashSet;
                Map<PortalPage, HashSet<Long>> $this$getOrPut$iv = dashboardsHavingProjectSharePermissions;
                boolean $i$f$getOrPut = false;
                HashSet<Long> value$iv = $this$getOrPut$iv.get(portalPage);
                if (value$iv == null) {
                    boolean bl4 = false;
                    HashSet answer$iv = new HashSet();
                    $this$getOrPut$iv.put(portalPage, answer$iv);
                    hashSet = answer$iv;
                } else {
                    hashSet = value$iv;
                }
                hashSet.add(projectId);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @NotNull
    public final DashboardPortletConfigResult mapDashboardsProjectPortletConfigurations(@NotNull List<Long> portalPageIds) {
        Intrinsics.checkNotNullParameter(portalPageIds, (String)"portalPageIds");
        Set<PortletConfigReportWrapper> projectReferencedGadgets = this.getProjectReferencedGadgets(portalPageIds);
        Map dashboardsHavingProjectPortletConfigs = new LinkedHashMap();
        Map projectKeyToGadgets = new LinkedHashMap();
        this.processProjectReferencedGadgets(projectReferencedGadgets, dashboardsHavingProjectPortletConfigs, projectKeyToGadgets);
        return new DashboardPortletConfigResult(dashboardsHavingProjectPortletConfigs, projectKeyToGadgets);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PortletConfigReportWrapper> getProjectReferencedGadgets(List<Long> portalPageIds) {
        Set projectReferencedGadgets = new LinkedHashSet();
        Iterable $this$forEach$iv = portalPageIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PortletConfiguration it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            long portalPage = ((Number)element$iv).longValue();
            boolean bl = false;
            List list = this.portletConfigurationManager.getByPortalPage(Long.valueOf(portalPage));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getByPortalPage(...)");
            Iterable iterable = list;
            Set set = projectReferencedGadgets;
            boolean $i$f$filter = false;
            void var13_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PortletConfiguration)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(this.exportFilters.isSupportedForMigration(it) && this.containsProjectReference(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (PortletConfiguration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Long l = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                long l2 = ((Number)l).longValue();
                Intrinsics.checkNotNull((Object)it);
                String string = JiraExtensionsKt.getGadgetName(it);
                if (string == null) {
                    string = "gadget";
                }
                collection.add(new PortletConfigReportWrapper(portalPage, l2, string));
            }
            set.addAll(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        }
        return projectReferencedGadgets;
    }

    private final void processProjectReferencedGadgets(Set<PortletConfigReportWrapper> projectReferencedGadgets, Map<PortalPage, HashSet<Long>> dashboardsHavingProjectPortletConfigs, Map<String, List<PortletConfigReportWrapper>> projectKeyToGadgets) {
        log.info("Processing {} project referenced gadgets", (Object)projectReferencedGadgets.size());
        Iterable $this$forEach$iv = projectReferencedGadgets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PortletConfigReportWrapper wrapper = (PortletConfigReportWrapper)element$iv;
            boolean bl = false;
            PortalPage portalPage = this.portalPageManager.getPortalPageById(Long.valueOf(wrapper.getPortalPageId()));
            List<String> projectKeys = this.extractProjectKeysFromGadget(wrapper.getPortletConfigurationId());
            Object[] objectArray = new Object[]{wrapper.getGadgetName(), wrapper.getPortletConfigurationId(), wrapper.getPortalPageId(), CollectionsKt.joinToString$default((Iterable)projectKeys, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
            log.debug("Processing gadget: {} (ID: {}) for portal page ID: {}, project keys: {}", objectArray);
            this.mapProjectKeysToCSV(wrapper, projectKeys, projectKeyToGadgets);
            Intrinsics.checkNotNull((Object)portalPage);
            this.addCorrespondingProjectIdsForDashboards(portalPage, projectKeys, dashboardsHavingProjectPortletConfigs);
        }
        log.info("Processed {} project referenced gadgets", (Object)projectReferencedGadgets.size());
    }

    private final void mapProjectKeysToCSV(PortletConfigReportWrapper wrapper, List<String> projectKeys, Map<String, List<PortletConfigReportWrapper>> projectKeyToGadgets) {
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)projectKeys);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list;
            String projectKey = (String)element$iv;
            boolean bl = false;
            Map<String, List<PortletConfigReportWrapper>> $this$getOrPut$iv = projectKeyToGadgets;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(projectKey);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(projectKey, answer$iv);
                list = answer$iv;
            } else {
                list = value$iv;
            }
            list.add((PortletConfigReportWrapper)new PortletConfigReportWrapper(wrapper.getPortalPageId(), wrapper.getPortletConfigurationId(), wrapper.getGadgetName()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCorrespondingProjectIdsForDashboards(PortalPage portalPage, List<String> projectKeys, Map<PortalPage, HashSet<Long>> dashboardsHavingProjectPortletConfigs) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.filterNotNull((Iterable)projectKeys);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String projectKey = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.projectKeysExtractorFromGadgets.getProjectIdFromKey(projectKey) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            HashSet<Long> hashSet;
            long projectId = ((Number)element$iv).longValue();
            boolean bl = false;
            Map<PortalPage, HashSet<Long>> $this$getOrPut$iv = dashboardsHavingProjectPortletConfigs;
            boolean $i$f$getOrPut = false;
            HashSet<Long> value$iv = $this$getOrPut$iv.get(portalPage);
            if (value$iv == null) {
                boolean bl4 = false;
                HashSet answer$iv = new HashSet();
                $this$getOrPut$iv.put(portalPage, answer$iv);
                hashSet = answer$iv;
            } else {
                hashSet = value$iv;
            }
            HashSet<Long> projectSet = hashSet;
            projectSet.add(projectId);
        }
    }

    @NotNull
    public final DashboardProjectSharePermissions getDashboardsHavingProjectSharePermissions(@NotNull List<PortalPage> portalPageList) {
        Intrinsics.checkNotNullParameter(portalPageList, (String)"portalPageList");
        DashboardProjectSharePermissions dashboardProjectSharePermissions = this.mapDashboardsProjectSharepermissions(portalPageList);
        List<Long> portalPageIds = dashboardProjectSharePermissions.component1();
        Map<PortalPage, HashSet<Long>> dashboardsHavingProjectSharePermissions = dashboardProjectSharePermissions.component3();
        return new DashboardProjectSharePermissions(portalPageIds, null, dashboardsHavingProjectSharePermissions, 2, null);
    }

    @NotNull
    public final DashboardPortletConfigResult getDashboardsHavingPortletconfigurationsReferringProjects(@NotNull List<Long> portalPageIds) {
        Intrinsics.checkNotNullParameter(portalPageIds, (String)"portalPageIds");
        Map<PortalPage, HashSet<Long>> dashboardsHavingProjectPortletConfigurations = this.mapDashboardsProjectPortletConfigurations(portalPageIds).component1();
        return new DashboardPortletConfigResult(dashboardsHavingProjectPortletConfigurations, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<DashboardReferringProjectsInfo> getDashboardsReferringProjectsInfoList(@NotNull List<PortalPage> portalPageList) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Map<PortalPage, HashSet<Long>> dashboardsHavingProjectSharePermissions;
        Intrinsics.checkNotNullParameter(portalPageList, (String)"portalPageList");
        DashboardProjectSharePermissions dashboardProjectSharePermissions = this.getDashboardsHavingProjectSharePermissions(portalPageList);
        List<Long> portalPageIds = dashboardProjectSharePermissions.component1();
        Map<PortalPage, HashSet<Long>> $this$map$iv2 = dashboardsHavingProjectSharePermissions = dashboardProjectSharePermissions.component3();
        boolean $i$f$map22 = false;
        Map<PortalPage, HashSet<Long>> map = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            PortalPage portalPage = (PortalPage)entry.getKey();
            HashSet projectIds = (HashSet)entry.getValue();
            collection.add(new DashboardReferringProjectsInfo(portalPage, CollectionsKt.toList((Iterable)projectIds)));
        }
        List dashboardsWithSharePermissionsInfo = (List)destination$iv$iv;
        Map<PortalPage, HashSet<Long>> $i$f$map22 = this.getDashboardsHavingPortletconfigurationsReferringProjects(portalPageIds).getDashboardsHavingProjectPortletConfigs();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator3.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            PortalPage portalPage = (PortalPage)entry.getKey();
            HashSet projectIds = (HashSet)entry.getValue();
            collection.add(new DashboardReferringProjectsInfo(portalPage, CollectionsKt.toList((Iterable)projectIds)));
        }
        List dashboardsWithPortletConfigurationsInfo = (List)destination$iv$iv2;
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)dashboardsWithSharePermissionsInfo, (Iterable)dashboardsWithPortletConfigurationsInfo));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PortalPage> getDashboardsReferringSelectedProjects(@NotNull List<Long> selectedProjectIds, @NotNull List<PortalPage> portalPageList) {
        void $this$mapTo$iv$iv;
        DashboardReferringProjectsInfo info;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(selectedProjectIds, (String)"selectedProjectIds");
        Intrinsics.checkNotNullParameter(portalPageList, (String)"portalPageList");
        Iterable $this$filter$iv = this.getDashboardsReferringProjectsInfoList(portalPageList);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            info = (DashboardReferringProjectsInfo)element$iv$iv;
            boolean bl = false;
            boolean isReferencing = this.isDashboardReferencingAnySelectedProject(info, selectedProjectIds);
            if (!isReferencing) {
                log.debug("Dashboard with id: " + info.getDashboardEntity().getId() + " and name: " + info.getDashboardEntity().getName() + " is not referencing any selected project, Skipping...");
            } else {
                log.debug("Dashboard with id: " + info.getDashboardEntity().getId() + " and name: " + info.getDashboardEntity().getName() + " is referring to at-least one selected project..");
            }
            if (!isReferencing) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            info = (DashboardReferringProjectsInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDashboardEntity());
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsProjectReference(PortletConfiguration $this$containsProjectReference) {
        boolean bl;
        String it;
        String string = JiraExtensionsKt.getGadgetXml($this$containsProjectReference);
        if (string != null) {
            it = string;
            boolean bl2 = false;
            if (this.exportFilters.containsProjectReference(it)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        String string2 = JiraExtensionsKt.accessModuleKey($this$containsProjectReference);
        if (string2 == null) return false;
        it = string2;
        boolean bl3 = false;
        if (!this.exportFilters.containsProjectReference(it)) return false;
        return true;
    }

    @NotNull
    public final List<String> extractProjectKeysFromGadget(long portletConfigurationId) {
        PortletConfiguration portletConfiguration = this.portletConfigurationManager.getByPortletId(Long.valueOf(portletConfigurationId));
        Intrinsics.checkNotNull((Object)portletConfiguration);
        String string = JiraExtensionsKt.getGadgetXml(portletConfiguration);
        if (string == null) {
            string = JiraExtensionsKt.accessModuleKey(portletConfiguration);
        }
        String key = string;
        Map userPrefs = portletConfiguration.getUserPrefs();
        if (key != null) {
            List<String> list;
            if (this.exportFilters.isTypeIdGadget(key)) {
                Intrinsics.checkNotNull((Object)userPrefs);
                list = this.projectKeysExtractorFromGadgets.processTypeIdGadgets(userPrefs);
            } else if (this.exportFilters.isProjectIdGadget(key)) {
                Intrinsics.checkNotNull((Object)userPrefs);
                list = this.projectKeysExtractorFromGadgets.processProjectIdGadgets(userPrefs);
            } else if (this.exportFilters.isProjectOrCategoriesGadget(key)) {
                Intrinsics.checkNotNull((Object)userPrefs);
                list = this.projectKeysExtractorFromGadgets.processProjectOrCategoriesGadgets(userPrefs);
            } else if (this.exportFilters.isProjectOrFilterIdGadget(key)) {
                Intrinsics.checkNotNull((Object)userPrefs);
                list = this.projectKeysExtractorFromGadgets.processProjectOrFilterIdGadgets(userPrefs);
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }

    public final boolean isDashboardReferencingAnySelectedProject(@NotNull DashboardReferringProjectsInfo dashboardReferringProjectsInfo, @NotNull List<Long> selectedProjectIds) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)dashboardReferringProjectsInfo, (String)"dashboardReferringProjectsInfo");
            Intrinsics.checkNotNullParameter(selectedProjectIds, (String)"selectedProjectIds");
            Set referringProjectIds = CollectionsKt.toSet((Iterable)dashboardReferringProjectsInfo.getReferringProjectIds());
            Iterable $this$any$iv = selectedProjectIds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    long it = ((Number)element$iv).longValue();
                    boolean bl2 = false;
                    if (!referringProjectIds.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<PortalPage> getAllPortalPages() {
        List allPortalPages = new ArrayList();
        this.portalPageManager.getAll().foreach(arg_0 -> DashboardsExtractionHelper.getAllPortalPages$lambda$22(allPortalPages, arg_0));
        log.info("Retrieved {} portal pages", (Object)allPortalPages.size());
        return allPortalPages;
    }

    @NotNull
    public final List<PortalPage> getPortalPagesForMigrationMode(@Nullable DashboardsMigrationMode dashboardsMigrationMode, @NotNull List<String> selectedProjectKeys) {
        List<PortalPage> list;
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        List<PortalPage> portalPages = this.getAllPortalPages();
        if (dashboardsMigrationMode == DashboardsMigrationMode.SELECTED_PROJECTS) {
            List<Long> selectedProjectIds = this.projectKeysExtractorFromGadgets.convertProjectKeysToProjectIds(selectedProjectKeys);
            list = this.getDashboardsReferringSelectedProjects(selectedProjectIds, portalPages);
        } else {
            list = portalPages;
        }
        List<PortalPage> filteredPortalPages = list;
        log.info("Count of portal pages for migration mode {}: {}", (Object)dashboardsMigrationMode, (Object)filteredPortalPages.size());
        return filteredPortalPages;
    }

    @NotNull
    public final String getPortalPageName(@NotNull String portalPageId) {
        Intrinsics.checkNotNullParameter((Object)portalPageId, (String)"portalPageId");
        PortalPage portalPage = this.portalPageManager.getPortalPageById(StringsKt.toLongOrNull((String)portalPageId));
        String string = portalPage != null ? portalPage.getName() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final void getAllPortalPages$lambda$22(List $allPortalPages, PortalPage portalPage) {
        Intrinsics.checkNotNullParameter((Object)$allPortalPages, (String)"$allPortalPages");
        Intrinsics.checkNotNullParameter((Object)portalPage, (String)"portalPage");
        if (!portalPage.isSystemDefaultPortalPage()) {
            $allPortalPages.add(portalPage);
        }
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(DashboardsExtractionHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

