/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.portalpage;

import com.atlassian.jira.migration.analytics.crossproject.service.CrossProjectEntityStatsEventService;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.dashboardstats.EntityType;
import com.atlassian.jira.migration.dashboardstats.ExportStats;
import com.atlassian.jira.migration.export.core.portalpage.PortalPageSharePermissionWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.log.MessageEntityIdentifier;
import com.atlassian.jira.migration.preflight.reports.ProblemType;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.portalpage.Layout;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 B2\u0018\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0001:\u0001BB/\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u001c\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u0004H\u0016J0\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u00042\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0007J0\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u00042\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0007J\u001c\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u0004H\u0016J \u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u001c\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0014\u0010-\u001a\u00020.2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u0004H\u0002J$\u0010/\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u00042\u0006\u00101\u001a\u000200H\u0002J\u0014\u00102\u001a\u0002002\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\u0002H\u0016JT\u00105\u001a\u00020\u0018\"\u0004\b\u0000\u001062\u0006\u0010\u0019\u001a\u00020\u001a2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H60\u00162\u0006\u00108\u001a\u00020 2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u00020\u00180:H\u0002J\b\u0010;\u001a\u00020\u0018H\u0007J,\u0010<\u001a\u00020\u00182\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u00108\u001a\u00020 2\u0006\u0010=\u001a\u00020!H\u0002J\u0016\u0010>\u001a\u0004\u0018\u00010'2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0014\u0010?\u001a\u00020'2\n\u0010\u001b\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0010\u0010@\u001a\u00020A*\u00060\u0003j\u0002`\u0004H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/PortalPageExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/portal/PortalPage;", "Lcom/atlassian/jira/migration/export/core/portalpage/JiraPortalPage;", "Lcom/atlassian/migration/jira/core/portalpage/PortalPage;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "portletConfigurationManager", "Lcom/atlassian/jira/portal/PortletConfigurationManager;", "identifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "crossProjectEntityStatsEventService", "Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/utils/ExportFilters;Lcom/atlassian/jira/portal/PortletConfigurationManager;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportData", "exportPortletConfiguration", "statsMap", "", "Lcom/atlassian/jira/migration/dashboardstats/EntityType;", "Lcom/atlassian/jira/migration/dashboardstats/ExportStats;", "exportSharePermissions", "exportUsersAndGroups", "isSupportedForMigration", "", "portalPageId", "", "portletConfiguration", "Lcom/atlassian/jira/portal/PortletConfiguration;", "isSupportedSharePermission", "sharePermission", "Lcom/atlassian/jira/sharing/SharePermission;", "mapLayout", "Lcom/atlassian/migration/jira/core/portalpage/Layout;", "mapOwner", "Lcom/atlassian/migration/base/mri/MRI;", "mri", "mriForEntity", "mriForKey", "entityKey", "performExportOperation", "T", "totalEntities", "entityType", "exportOperation", "Lkotlin/Function1;", "postConstruct", "updateExportedStats", "exportStats", "validateAndGetDescription", "validateAndGetName", "identifier", "Lcom/atlassian/jira/migration/log/MessageEntityIdentifier;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPortalPageExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortalPageExporter.kt\ncom/atlassian/jira/migration/export/core/portalpage/PortalPageExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n1#2:238\n766#3:239\n857#3,2:240\n766#3:242\n857#3,2:243\n1855#3,2:245\n*S KotlinDebug\n*F\n+ 1 PortalPageExporter.kt\ncom/atlassian/jira/migration/export/core/portalpage/PortalPageExporter\n*L\n127#1:239\n127#1:240,2\n157#1:242\n157#1:243,2\n186#1:245,2\n*E\n"})
public final class PortalPageExporter
implements Exporter<Long, PortalPage, com.atlassian.migration.jira.core.portalpage.PortalPage> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final PortletConfigurationManager portletConfigurationManager;
    @NotNull
    private final EntityIdentifierGenerator identifierGenerator;
    @NotNull
    private final CrossProjectEntityStatsEventService crossProjectEntityStatsEventService;
    @NotNull
    private final ExporterKey key;
    private static final Logger log = LoggerFactory.getLogger(PortalPageExporter.class);

    @Inject
    public PortalPageExporter(@NotNull ExportService exportService, @NotNull ExportFilters exportFilters, @NotNull PortletConfigurationManager portletConfigurationManager, @NotNull EntityIdentifierGenerator identifierGenerator, @NotNull CrossProjectEntityStatsEventService crossProjectEntityStatsEventService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        Intrinsics.checkNotNullParameter((Object)portletConfigurationManager, (String)"portletConfigurationManager");
        Intrinsics.checkNotNullParameter((Object)identifierGenerator, (String)"identifierGenerator");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityStatsEventService, (String)"crossProjectEntityStatsEventService");
        this.exportService = exportService;
        this.exportFilters = exportFilters;
        this.portletConfigurationManager = portletConfigurationManager;
        this.identifierGenerator = identifierGenerator;
        this.crossProjectEntityStatsEventService = crossProjectEntityStatsEventService;
        this.key = new ExporterKey(com.atlassian.migration.jira.core.portalpage.PortalPage.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, PortalPage.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull PortalPage entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.core.portalpage.PortalPage.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public com.atlassian.migration.jira.core.portalpage.PortalPage exportData(@NotNull ExportContext ctx, @NotNull PortalPage entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), ctx.getExportMode()};
        log.debug("[MigrationId:{}] Exporting jiraPortalPage with id {} under exportMode:{}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        String string = this.validateAndGetName(entity);
        String string2 = this.validateAndGetDescription(entity);
        Long l = entity.getFavouriteCount();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFavouriteCount(...)");
        long l2 = ((Number)l).longValue();
        Layout layout = this.mapLayout(entity);
        MRI mRI2 = this.mapOwner(ctx, entity, this.mriForEntity(entity));
        Long l3 = entity.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getVersion(...)");
        return new com.atlassian.migration.jira.core.portalpage.PortalPage(mRI, string, string2, l2, layout, mRI2, ((Number)l3).longValue());
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull PortalPage entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        log.debug("Exporting users and groups for portalPage with id {} for migration {} under exportMode {}", objectArray);
        this.mapOwner(ctx, entity, this.mriForEntity(entity));
    }

    private final MRI mapOwner(ExportContext ctx, PortalPage entity, MRI mri) {
        MRI mRI;
        block3: {
            block2: {
                UserRef userRef = UserRef.Companion.fromString(entity.getOwnerUserName());
                if (userRef == null) break block2;
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
                if (mRI != null) break block3;
            }
            String string = this.identifier(entity) + " has no owner assigned or no longer exists";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_DASHBOARD_HAS_NO_OWNER;
            throw new ExportException(mri, exportErrorCode, string, "Please set an owner for this portal page.", null, null, null, 112, null);
        }
        return mRI;
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull PortalPage entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Map statsMap = new LinkedHashMap();
        Object[] objectArray = new Function0[]{new Function0<Unit>(this, ctx, entity, (Map<EntityType, ExportStats>)statsMap){
            final /* synthetic */ PortalPageExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ PortalPage $entity;
            final /* synthetic */ Map<EntityType, ExportStats> $statsMap;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                this.$statsMap = $statsMap;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportSharePermissions(this.$ctx, this.$entity, this.$statsMap);
            }
        }, new Function0<Unit>(this, ctx, entity, (Map<EntityType, ExportStats>)statsMap){
            final /* synthetic */ PortalPageExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ PortalPage $entity;
            final /* synthetic */ Map<EntityType, ExportStats> $statsMap;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                this.$statsMap = $statsMap;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportPortletConfiguration(this.$ctx, this.$entity, this.$statsMap);
            }
        }, new Function0<Unit>(this, ctx, (Map<EntityType, ExportStats>)statsMap, entity){
            final /* synthetic */ PortalPageExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ Map<EntityType, ExportStats> $statsMap;
            final /* synthetic */ PortalPage $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$statsMap = $statsMap;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                try {
                    CrossProjectEntityStatsEventService crossProjectEntityStatsEventService = PortalPageExporter.access$getCrossProjectEntityStatsEventService$p(this.this$0);
                    Long l = this.$entity.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                    crossProjectEntityStatsEventService.sendDashboardChildrenEntitiesStatsEvent(this.$ctx, this.$statsMap, ((Number)l).longValue());
                }
                catch (Exception e) {
                    PortalPageExporter.access$getLog$cp().warn("Failed to send dashboard children entities stats event for entity with ID " + this.$entity.getId() + " due to " + e);
                }
            }
        }};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final Layout mapLayout(PortalPage entity) {
        if (entity.getLayout() == null) {
            MRI mRI = this.mriForEntity(entity);
            String string = "Layout for " + this.identifier(entity) + " doesn't exist.";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_DASHBOARD_VALIDATION_ERROR;
            throw new ExportException(mRI, exportErrorCode, string, "Layout is mandatory for portal page.", null, null, null, 112, null);
        }
        return Layout.valueOf((String)entity.getLayout().name());
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void exportPortletConfiguration(@NotNull ExportContext ctx, @NotNull PortalPage entity, @NotNull Map<EntityType, ExportStats> statsMap) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(statsMap, (String)"statsMap");
        List list = this.portletConfigurationManager.getByPortalPage(entity.getId());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getByPortalPage(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PortletConfiguration it = (PortletConfiguration)element$iv$iv;
            boolean bl = false;
            String string = String.valueOf(entity.getId());
            Intrinsics.checkNotNull((Object)it);
            if (!this.isSupportedForMigration(ctx, string, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List totalPortletConfigurations = (List)destination$iv$iv;
        this.performExportOperation(ctx, totalPortletConfigurations, EntityType.PORTLET_CONFIGURATION, statsMap, (Function1)new Function1<PortletConfiguration, Unit>(entity, this, ctx){
            final /* synthetic */ PortalPage $entity;
            final /* synthetic */ PortalPageExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.$entity = $entity;
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            public final void invoke(PortletConfiguration it) {
                Logger logger2 = PortalPageExporter.access$getLog$cp();
                StringBuilder stringBuilder = new StringBuilder().append("Exporting portlet configuration '");
                Intrinsics.checkNotNull((Object)it);
                logger2.debug(stringBuilder.append(JiraExtensionsKt.getGadgetName(it)).append('[').append(it.getId()).append("]' for portal page ").append(this.$entity.getName()).append('[').append(this.$entity.getId()).append(']').toString());
                ExportOrThrow.DefaultImpls.exportOrThrow$default(PortalPageExporter.access$getExportService$p(this.this$0), this.$ctx, it, false, 4, null);
                PortalPageExporter.access$getLog$cp().debug("Exporting portlet configuration '" + JiraExtensionsKt.getGadgetName(it) + '[' + it.getId() + "]' for portal page " + this.$entity.getName() + '[' + this.$entity.getId() + "] completed successfully");
            }
        });
    }

    private final boolean isSupportedForMigration(ExportContext ctx, String portalPageId, PortletConfiguration portletConfiguration) {
        boolean result2 = this.exportFilters.isSupportedForMigration(portletConfiguration);
        if (!result2) {
            log.debug("PortletConfiguration " + JiraExtensionsKt.getGadgetName(portletConfiguration) + " [" + portletConfiguration.getId() + "] for portal page " + portalPageId + " is not supported. Skipping...");
            String string = String.valueOf(portletConfiguration.getId());
            String string2 = JiraExtensionsKt.getGadgetName(portletConfiguration);
            if (string2 == null) {
                string2 = "gadget";
            }
            ExportContext.handleUnsupported$default(ctx, string, string2, ProblemType.UNSUPPORTED_PORTLET_CONFIGURATION.toString(), "PortletConfiguration", "PortalPage-" + portalPageId, null, 32, null);
        }
        return result2;
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    public final void exportSharePermissions(@NotNull ExportContext ctx, @NotNull PortalPage entity, @NotNull Map<EntityType, ExportStats> statsMap) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(statsMap, (String)"statsMap");
        v0 = entity.getPermissions().getPermissionSet();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPermissionSet(...)");
        var5_4 = v0;
        $i$f$filter = false;
        var7_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            sharePermission = (SharePermission)element$iv$iv;
            $i$a$-filter-PortalPageExporter$exportSharePermissions$totalPortalPageSharePermissions$1 = false;
            Intrinsics.checkNotNull((Object)sharePermission);
            if (!this.isSupportedSharePermission(sharePermission, entity)) ** GOTO lbl-1000
            v1 = this.exportService;
            v2 = sharePermission;
            v3 = var14_13 = sharePermission.getParam1();
            if (v3 != null) {
                Intrinsics.checkNotNull((Object)v3);
                var15_14 = var14_13;
                var16_15 = v2;
                var17_16 = v1;
                $i$a$-let-PortalPageExporter$exportSharePermissions$totalPortalPageSharePermissions$1$1 = false;
                var19_18 = sharePermission.getParam1();
                v1 = var17_16;
                v2 = var16_15;
                v4 = var19_18;
            } else {
                v4 = null;
            }
            v5 = var20_19 = v4;
            if (v5 == null) {
                v6 = "undefined";
            } else {
                Intrinsics.checkNotNull(v5);
                v6 = var20_19;
            }
            var21_20 = this.identifier(entity).toString();
            var22_21 = "Portal Share Page";
            var23_22 = v6;
            if (v1.skipInvalidGroup(v2, new GroupRefModel(var23_22, var22_21, var21_20))) {
                v7 = true;
            } else lbl-1000:
            // 2 sources

            {
                v7 = false;
            }
            if (!v7) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        totalPortalPageSharePermissions = (List)destination$iv$iv;
        this.performExportOperation(ctx, totalPortalPageSharePermissions, EntityType.PORTAL_PAGE_SHARE_PERMISSIONS, statsMap, (Function1)new Function1<SharePermission, Unit>(entity, this, ctx){
            final /* synthetic */ PortalPage $entity;
            final /* synthetic */ PortalPageExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.$entity = $entity;
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            public final void invoke(SharePermission it) {
                PortalPageExporter.access$getLog$cp().debug("Exporting share permission with '" + it.getId() + "' for portal page " + this.$entity.getName());
                ExportOrThrow exportOrThrow = PortalPageExporter.access$getExportService$p(this.this$0);
                Intrinsics.checkNotNull((Object)it);
                ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow, this.$ctx, new PortalPageSharePermissionWrapper(this.$entity, it), false, 4, null);
                PortalPageExporter.access$getLog$cp().debug("Exporting share permission with '" + it.getId() + "' for portal page " + this.$entity.getName() + " completed successfully");
            }
        });
    }

    private final void updateExportedStats(Map<EntityType, ExportStats> statsMap, EntityType entityType, ExportStats exportStats) {
        statsMap.put(entityType, exportStats);
    }

    private final <T> void performExportOperation(ExportContext ctx, List<? extends T> totalEntities, EntityType entityType, Map<EntityType, ExportStats> statsMap, Function1<? super T, Unit> exportOperation) {
        try {
            long totalEntitiesExported = 0L;
            Iterable $this$forEach$iv = totalEntities;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object entity = element$iv = iterator2.next();
                boolean bl = false;
                exportOperation.invoke(entity);
                ++totalEntitiesExported;
            }
            this.updateExportedStats(statsMap, entityType, new ExportStats(totalEntitiesExported, totalEntities.size()));
        }
        catch (Exception ex) {
            log.error("Export of " + (Object)((Object)entityType) + " for " + ctx.getMigrationId() + " under export mode " + (Object)((Object)ctx.getExportMode()) + " failed with " + ex);
            throw ex;
        }
    }

    private final String validateAndGetName(PortalPage entity) {
        CharSequence charSequence = entity.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = this.mriForEntity(entity);
            String string = "Portal Page with Id: " + entity.getId() + " has no name associated with it";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_DASHBOARD_VALIDATION_ERROR;
            throw new ExportException((MRI)charSequence, exportErrorCode, string, "Set a name for the dashboard.", null, null, null, 112, null);
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getName()) && entity.getName().length() > 255) {
            log.warn(this.identifier(entity) + ", has name longer than 255, hence trimming it to desired length");
            String string = entity.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return StringsKt.take((String)string, (int)255);
        }
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private final String validateAndGetDescription(PortalPage entity) {
        if (StringExtensionsKt.isNotNullOrBlank(entity.getDescription()) && entity.getDescription().length() > 255) {
            log.warn(this.identifier(entity) + " has description longer than 255, hence trimming it to desired length");
            String string = entity.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            return StringsKt.take((String)string, (int)255);
        }
        return entity.getDescription();
    }

    private final boolean isSupportedSharePermission(SharePermission sharePermission, PortalPage entity) {
        boolean bl;
        boolean it = bl = this.exportFilters.isSupportedSharePermission(sharePermission);
        boolean bl2 = false;
        if (!it) {
            log.warn("SharePermission " + sharePermission.getId() + " [" + sharePermission.getType() + "] for portal page (" + this.identifier(entity) + ") is not supported. Skipping...");
        }
        return bl;
    }

    private final MessageEntityIdentifier identifier(PortalPage $this$identifier) {
        return EntityIdentifierGenerator.generate$default(this.identifierGenerator, this.mriForEntity($this$identifier), $this$identifier, null, 4, null);
    }

    @Override
    @Nullable
    public PortalPage extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    public static final /* synthetic */ CrossProjectEntityStatsEventService access$getCrossProjectEntityStatsEventService$p(PortalPageExporter $this) {
        return $this.crossProjectEntityStatsEventService;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ ExportService access$getExportService$p(PortalPageExporter $this) {
        return $this.exportService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/PortalPageExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

