/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.portalpage.userpref;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.db.UserNameEmailData;
import com.atlassian.jira.migration.export.core.portalpage.userpref.PortletConfigurationSubType;
import com.atlassian.jira.migration.export.core.portalpage.userpref.UserPrefExportHelper;
import com.atlassian.jira.migration.export.core.portalpage.userpref.UserPrefExporter;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserReader;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.issuetype.IssueType;
import com.atlassian.migration.jira.core.ProjectCategory;
import com.atlassian.migration.jira.core.portalpage.UserPrefValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ8\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0002H\u0016J>\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J<\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0002JR\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/userpref/ActivityStreamUserPrefExporter;", "Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExporter;", "Lcom/atlassian/jira/migration/export/core/portalpage/userpref/PortletConfigurationSubType;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "jiraUserReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserReader;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserReader;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "exportUserPref", "", "", "Lcom/atlassian/migration/jira/core/portalpage/UserPrefValue;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "userPrefValues", "gadgetId", "", "getUserPrefExporterKey", "mapActivityStreamRules", "activityStreamRules", "projectCategoryMRIList", "", "Lcom/atlassian/migration/base/mri/MRI;", "issueTypeMRIList", "mapIssueTypeAndProjectCategory", "", "provider", "Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper$Provider;", "mapUsernamesToEmails", "userNameEmailMap", "updateActivityStreamUserPrefValues", "activityStreamRulesJSON", "Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper$ActivityStreamRules;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nActivityStreamUserPrefExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityStreamUserPrefExporter.kt\ncom/atlassian/jira/migration/export/core/portalpage/userpref/ActivityStreamUserPrefExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1855#2:207\n1603#2,9:208\n1855#2:217\n1856#2:219\n1612#2:220\n1856#2:221\n1855#2:222\n1603#2,9:223\n1855#2:232\n1856#2:234\n1612#2:235\n1603#2,9:236\n1855#2:245\n1856#2:247\n1612#2:248\n1856#2:249\n1855#2,2:250\n1208#2,2:253\n1238#2,4:255\n1855#2,2:259\n1#3:218\n1#3:233\n1#3:246\n1#3:252\n*S KotlinDebug\n*F\n+ 1 ActivityStreamUserPrefExporter.kt\ncom/atlassian/jira/migration/export/core/portalpage/userpref/ActivityStreamUserPrefExporter\n*L\n56#1:207\n59#1:208,9\n59#1:217\n59#1:219\n59#1:220\n56#1:221\n73#1:222\n75#1:223,9\n75#1:232\n75#1:234\n75#1:235\n86#1:236,9\n86#1:245\n86#1:247\n86#1:248\n73#1:249\n108#1:250,2\n127#1:253,2\n127#1:255,4\n128#1:259,2\n59#1:218\n75#1:233\n86#1:246\n*E\n"})
public final class ActivityStreamUserPrefExporter
implements UserPrefExporter<PortletConfigurationSubType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final JiraUserReader jiraUserReader;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final String USER = "user";
    @NotNull
    private static final String STREAMS = "streams";
    @NotNull
    private static final String ISSUES = "issues";
    @NotNull
    private static final String ISSUE_TYPE = "issue_type";
    @NotNull
    private static final String PROJECT_CATEGORIES = "project_category";
    private static final Logger log = LoggerFactory.getLogger(ActivityStreamUserPrefExporter.class);

    @Inject
    public ActivityStreamUserPrefExporter(@NotNull ExportService exportService, @NotNull JiraUserReader jiraUserReader, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)jiraUserReader, (String)"jiraUserReader");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.exportService = exportService;
        this.jiraUserReader = jiraUserReader;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @Override
    @NotNull
    public PortletConfigurationSubType getUserPrefExporterKey() {
        return PortletConfigurationSubType.ActivityStreamUserPrefExporter;
    }

    /*
     * WARNING - void declaration
     */
    private final void mapUsernamesToEmails(UserPrefExportHelper.Provider provider, Map<String, String> userNameEmailMap) {
        block3: {
            List<UserPrefExportHelper.Rule> list = provider.getRules();
            if (list == null) break block3;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapNotNullTo$iv$iv;
                int n;
                CharSequence charSequence;
                Object object;
                UserPrefExportHelper.Rule rule = (UserPrefExportHelper.Rule)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)rule.getRule(), (Object)USER)) continue;
                Object object2 = rule.getValue();
                Object object3 = object2 instanceof String ? (String)object2 : null;
                if (object3 == null || (object3 = (object = new Regex("\\s+")).split(charSequence = (CharSequence)object3, n = 0)) == null) {
                    object3 = CollectionsKt.emptyList();
                }
                Object usernames = object3;
                Iterable $this$mapNotNull$iv = (Iterable)usernames;
                boolean $i$f$mapNotNull = false;
                object = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    String it = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (userNameEmailMap.get(it) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                String usernameEmails = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                rule.setValue(usernameEmails);
            }
        }
    }

    private final void mapIssueTypeAndProjectCategory(ExportContext ctx, UserPrefExportHelper.Provider provider, List<MRI> projectCategoryMRIList, List<MRI> issueTypeMRIList, long gadgetId) {
        block10: {
            List<UserPrefExportHelper.Rule> list = provider.getRules();
            if (list == null) break block10;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Boolean it$iv$iv;
                boolean bl;
                Boolean bl2;
                MRI mri;
                String it;
                boolean bl3;
                Object element$iv$iv;
                Object element$iv$iv$iv;
                Iterator iterator2;
                boolean $i$f$forEach2;
                Object $this$forEach$iv$iv$iv;
                Object $this$mapNotNullTo$iv$iv;
                boolean $i$f$mapNotNullTo;
                Collection destination$iv$iv;
                boolean $i$f$mapNotNull;
                Object $this$mapNotNull$iv;
                UserPrefExportHelper.Rule rule = (UserPrefExportHelper.Rule)element$iv;
                boolean bl4 = false;
                if (Intrinsics.areEqual((Object)rule.getRule(), (Object)ISSUE_TYPE)) {
                    Object object = rule.getValue();
                    List list2 = object instanceof List ? (List)object : null;
                    if (list2 == null) continue;
                    $this$mapNotNull$iv = list2;
                    $i$f$mapNotNull = false;
                    Object object2 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach2 = false;
                    iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = iterator2.next();
                        bl3 = false;
                        it = (String)element$iv$iv;
                        boolean bl5 = false;
                        try {
                            mri = ExportService.exportByIdOrThrow$default(this.exportService, ctx, IssueType.Companion.getEntityType(), it, null, 8, null);
                            boolean bl6 = false;
                            bl2 = issueTypeMRIList.add(mri);
                        }
                        catch (Exception ex) {
                            log.warn("Exception occurred while exporting issue type " + it + " with error: " + ex.getMessage() + " for gadgetId: " + gadgetId);
                            bl2 = null;
                        }
                        if (bl2 == null) continue;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)rule.getRule(), (Object)PROJECT_CATEGORIES)) continue;
                $this$mapNotNull$iv = rule.getValue();
                List list3 = $this$mapNotNull$iv instanceof List ? (List)$this$mapNotNull$iv : null;
                if (list3 == null) continue;
                $this$mapNotNull$iv = list3;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach2 = false;
                iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator2.next();
                    bl3 = false;
                    it = (String)element$iv$iv;
                    boolean bl7 = false;
                    try {
                        mri = ExportService.exportByIdOrThrow$default(this.exportService, ctx, ProjectCategory.Companion.getEntityType(), Long.parseLong(it), null, 8, null);
                        boolean bl8 = false;
                        bl2 = projectCategoryMRIList.add(mri);
                    }
                    catch (Exception ex) {
                        log.warn("Exception occurred while exporting project category " + it + " with error: " + ex.getMessage() + " for gadgetId: " + gadgetId);
                        bl2 = null;
                    }
                    if (bl2 == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List cfr_ignored_1 = (List)destination$iv$iv;
            }
        }
    }

    private final void updateActivityStreamUserPrefValues(ExportContext ctx, UserPrefExportHelper.ActivityStreamRules activityStreamRulesJSON, Map<String, String> userNameEmailMap, List<MRI> projectCategoryMRIList, List<MRI> issueTypeMRIList, long gadgetId) {
        block2: {
            Object object = activityStreamRulesJSON;
            if (object == null || (object = ((UserPrefExportHelper.ActivityStreamRules)object).getProviders()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UserPrefExportHelper.Provider provider = (UserPrefExportHelper.Provider)element$iv;
                boolean bl = false;
                String string = provider.getProvider();
                if (Intrinsics.areEqual((Object)string, (Object)STREAMS)) {
                    this.mapUsernamesToEmails(provider, userNameEmailMap);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)ISSUES)) continue;
                this.mapIssueTypeAndProjectCategory(ctx, provider, projectCategoryMRIList, issueTypeMRIList, gadgetId);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String mapActivityStreamRules(ExportContext ctx, String activityStreamRules, List<MRI> projectCategoryMRIList, List<MRI> issueTypeMRIList, long gadgetId) {
        try {
            Object element$iv2;
            void $this$associateByTo$iv$iv;
            List<String> usernames = UserPrefExportHelper.INSTANCE.extractUsernamesFromActivityStreamRules(activityStreamRules, this.objectMapper, gadgetId);
            boolean it = !((Collection)usernames).isEmpty();
            boolean bl = false;
            List<UserNameEmailData> userNameEmailData = this.jiraUserReader.getEmailsByUsernames(usernames);
            Iterable $this$associateBy$iv = userNameEmailData;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                UserNameEmailData userNameEmailData2 = (UserNameEmailData)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                UserNameEmailData it2 = (UserNameEmailData)element$iv$iv;
                String string = it2.getUserName();
                boolean bl3 = false;
                String string2 = it2.getEmailAddress();
                map.put(string, string2);
            }
            Map userNameEmailMap = destination$iv$iv;
            Iterable $this$forEach$iv = usernames;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                String it3 = (String)element$iv2;
                boolean bl4 = false;
                if (userNameEmailMap.containsKey(it3)) continue;
                log.warn("Exception occurred while mapping username " + it3 + " to email for gadgetId: " + gadgetId);
            }
            String activityStreamRulesDecodedString = UserPrefExportHelper.INSTANCE.decodeActivityStreamRules(activityStreamRules, gadgetId);
            UserPrefExportHelper.ActivityStreamRules activityStreamRulesJSON = UserPrefExportHelper.INSTANCE.parseActivityStreamRules(activityStreamRulesDecodedString, this.objectMapper, gadgetId);
            this.updateActivityStreamUserPrefValues(ctx, activityStreamRulesJSON, userNameEmailMap, projectCategoryMRIList, issueTypeMRIList, gadgetId);
            Map updatedActivityStreamRulesJSON = (Map)this.objectMapper.convertValue((Object)activityStreamRulesJSON, Map.class);
            Intrinsics.checkNotNull((Object)updatedActivityStreamRulesJSON);
            element$iv2 = updatedActivityStreamRulesJSON;
            String string = "rules";
            Object var15_18 = null;
            TypeIntrinsics.asMutableMap(element$iv2).remove(string, var15_18);
            element$iv2 = updatedActivityStreamRulesJSON;
            string = "providers";
            var15_18 = null;
            TypeIntrinsics.asMutableMap(element$iv2).remove(string, var15_18);
            String updatedActivityStreamRulesString = this.objectMapper.writeValueAsString((Object)updatedActivityStreamRulesJSON);
            String string3 = URLEncoder.encode(updatedActivityStreamRulesString, StandardCharsets.UTF_8.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encode(...)");
            return StringsKt.replace$default((String)string3, (String)"+", (String)"%20", (boolean)false, (int)4, null);
        }
        catch (Exception ex) {
            log.warn("Exception occurred while updating Activity stream rules with error: " + ex.getMessage() + " for gadgetId: " + gadgetId);
            String string = activityStreamRules;
            if (string == null) {
                string = "";
            }
            return string;
        }
    }

    @Override
    @NotNull
    public Map<String, UserPrefValue> exportUserPref(@NotNull ExportContext ctx, @NotNull Map<String, String> userPrefValues, long gadgetId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(userPrefValues, (String)"userPrefValues");
        List projectCategoryMRIList = new ArrayList();
        List issueTypeMRIList = new ArrayList();
        Pair[] pairArray = new Pair[12];
        String string = userPrefValues.get("isConfigured");
        Intrinsics.checkNotNull((Object)string);
        pairArray[0] = TuplesKt.to((Object)"isConfigured", (Object)new UserPrefValue.UserPrefData(string));
        String string2 = userPrefValues.get("keys");
        Intrinsics.checkNotNull((Object)string2);
        pairArray[1] = TuplesKt.to((Object)"keys", (Object)new UserPrefValue.UserPrefData(string2));
        String string3 = userPrefValues.get("refresh");
        Intrinsics.checkNotNull((Object)string3);
        pairArray[2] = TuplesKt.to((Object)"refresh", (Object)new UserPrefValue.UserPrefData(string3));
        String string4 = userPrefValues.get("isReallyConfigured");
        Intrinsics.checkNotNull((Object)string4);
        pairArray[3] = TuplesKt.to((Object)"isReallyConfigured", (Object)new UserPrefValue.UserPrefData(string4));
        String string5 = userPrefValues.get("rules");
        Intrinsics.checkNotNull((Object)string5);
        pairArray[4] = TuplesKt.to((Object)"rules", (Object)new UserPrefValue.UserPrefData(this.mapActivityStreamRules(ctx, string5, projectCategoryMRIList, issueTypeMRIList, gadgetId)));
        String string6 = userPrefValues.get("title");
        Intrinsics.checkNotNull((Object)string6);
        pairArray[5] = TuplesKt.to((Object)"title", (Object)new UserPrefValue.UserPrefData(string6));
        String string7 = userPrefValues.get("titleRequired");
        Intrinsics.checkNotNull((Object)string7);
        pairArray[6] = TuplesKt.to((Object)"titleRequired", (Object)new UserPrefValue.UserPrefData(string7));
        String string8 = userPrefValues.get("itemKeys");
        Intrinsics.checkNotNull((Object)string8);
        pairArray[7] = TuplesKt.to((Object)"itemKeys", (Object)new UserPrefValue.UserPrefData(string8));
        String string9 = userPrefValues.get("numofentries");
        Intrinsics.checkNotNull((Object)string9);
        pairArray[8] = TuplesKt.to((Object)"numofentries", (Object)new UserPrefValue.UserPrefData(string9));
        String string10 = userPrefValues.get("maxProviderLabelCharacters");
        Intrinsics.checkNotNull((Object)string10);
        pairArray[9] = TuplesKt.to((Object)"maxProviderLabelCharacters", (Object)new UserPrefValue.UserPrefData(string10));
        String string11 = userPrefValues.get("renderingContext");
        Intrinsics.checkNotNull((Object)string11);
        pairArray[10] = TuplesKt.to((Object)"renderingContext", (Object)new UserPrefValue.UserPrefData(string11));
        String string12 = userPrefValues.get("username");
        Intrinsics.checkNotNull((Object)string12);
        pairArray[11] = TuplesKt.to((Object)"username", (Object)new UserPrefValue.UserPrefData(string12));
        Map userPrefMap = MapsKt.mutableMapOf((Pair[])pairArray);
        if (!((Collection)projectCategoryMRIList).isEmpty()) {
            userPrefMap.put("projectCategoriesList", new UserPrefValue.UserPrefReferenceListWithDelimiter("|", projectCategoryMRIList));
        }
        if (!((Collection)issueTypeMRIList).isEmpty()) {
            userPrefMap.put("issueTypesList", new UserPrefValue.UserPrefReferenceListWithDelimiter("|", issueTypeMRIList));
        }
        return MapsKt.toMap((Map)userPrefMap);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/userpref/ActivityStreamUserPrefExporter$Companion;", "", "()V", "ISSUES", "", "ISSUE_TYPE", "PROJECT_CATEGORIES", "STREAMS", "USER", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

