/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.portalpage.userpref;

import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.export.core.portalpage.userpref.EntityId;
import com.atlassian.jira.migration.export.core.portalpage.userpref.PortletConfigurationSubType;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.software.board.RapidViewExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.MRIType;
import com.atlassian.migration.jira.classic.Project;
import com.atlassian.migration.jira.classic.customfield.CustomField;
import com.atlassian.migration.jira.classic.issuestatus.IssueStatus;
import com.atlassian.migration.jira.classic.software.sprint.Sprint;
import com.atlassian.migration.jira.core.Filter;
import com.atlassian.migration.jira.core.JiraCoreMriRegistry;
import com.atlassian.migration.jira.core.ProjectCategory;
import com.atlassian.migration.jira.core.portalpage.UserPrefValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003XYZB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001c\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fJ4\u0010$\u001a\b\u0012\u0004\u0012\u00020%0!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010,\u001a\u0004\u0018\u00010\u00172\u0006\u0010-\u001a\u00020\u0004J&\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ&\u00101\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00102\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ.\u00103\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ(\u00106\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\u0006\u00107\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u00108\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\u0006\u00107\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ*\u00109\u001a\u0004\u0018\u00010%2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\u0006\u0010:\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020\u0004J&\u0010=\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ.\u0010=\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010?\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ(\u0010C\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\u0006\u0010D\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u0010E\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010F\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010G\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010H\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010I\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ,\u0010K\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\u001e\u001a\u00020\u001fJ:\u0010M\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040!2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010O\u001a\u00020P2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040!J\u0014\u0010Q\u001a\u00020/2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040!J&\u0010R\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\"\u0010S\u001a\u0004\u0018\u00010T2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010U\u001a\u0004\u0018\u00010%2\u0006\u0010V\u001a\u00020WR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006["}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper;", "", "()V", "ALL_CATEGORIES", "", "ALL_PROJECTS", "AUTO", "BLANK_STRING", "CATEGORIES_PREFIX", "DEFAULT", "FILTER", "FILTER_PREFIX", "HYPHEN_DELIMITER", "PIPE_DELIMITER", "PROJECT", "PROJECT_PREFIX", "SPLIT_SIZE", "", "delimiters", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "gadgetsToUserPrefExporter", "", "Lcom/atlassian/jira/migration/export/core/portalpage/userpref/PortletConfigurationSubType;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "decodeActivityStreamRules", "activityStreamRules", "gadgetId", "", "extractUsernamesFromActivityStreamRules", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getReferencesBySplitting", "Lcom/atlassian/migration/base/mri/MRI;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "value", "delimiter", "getUserPrefExporterKey", "key", "mapColumns", "Lcom/atlassian/migration/jira/core/portalpage/UserPrefValue;", "columnNames", "mapDateField", "dateField", "mapId", "type", "id", "mapIssueStatusList", "statuses", "mapIssueStatuses", "mapProjectCategory", "projectCategory", "mapProjectId", "projectId", "mapProjectOrFilterId", "projectOrFilterId", "mapRapidView", "rapidViewExportService", "Lcom/atlassian/jira/migration/export/software/board/RapidViewExportService;", "rapidViewId", "mapSingleIssueStatus", "status", "mapSortColumns", "sortFieldType", "mapSprint", "sprintId", "mapStatType", "statType", "mapToProjectCategoriesReference", "projectCategories", "mapToProjectOrCategories", "projects", "mapToProjectsReference", "Lcom/atlassian/migration/jira/core/portalpage/UserPrefValue$UserPrefReferenceListWithDelimiter;", "mapToProjectsReferenceWithProjectsOrCategories", "mapToSingleProjectCategoryReference", "parseActivityStreamRules", "Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper$ActivityStreamRules;", "toMri", "entityId", "Lcom/atlassian/jira/migration/export/core/portalpage/userpref/EntityId;", "ActivityStreamRules", "Provider", "Rule", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUserPrefExportHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserPrefExportHelper.kt\ncom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,592:1\n1549#2:593\n1620#2,3:594\n1603#2,9:597\n1855#2:606\n1856#2:609\n1612#2:610\n1603#2,9:611\n1855#2:620\n1856#2:622\n1612#2:623\n1360#2:624\n1446#2,5:625\n766#2:630\n857#2,2:631\n1360#2:633\n1446#2,5:634\n1855#2,2:639\n1603#2,9:641\n1855#2:650\n1856#2:652\n1612#2:653\n1603#2,9:654\n1855#2:663\n1856#2:665\n1612#2:666\n1#3:607\n1#3:608\n1#3:621\n1#3:651\n1#3:664\n*S KotlinDebug\n*F\n+ 1 UserPrefExportHelper.kt\ncom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper\n*L\n174#1:593\n174#1:594,3\n175#1:597,9\n175#1:606\n175#1:609\n175#1:610\n387#1:611,9\n387#1:620\n387#1:622\n387#1:623\n478#1:624\n478#1:625,5\n479#1:630\n479#1:631,2\n480#1:633\n480#1:634,5\n551#1:639,2\n563#1:641,9\n563#1:650\n563#1:652\n563#1:653\n590#1:654,9\n590#1:663\n590#1:665\n590#1:666\n175#1:608\n387#1:621\n563#1:651\n590#1:664\n*E\n"})
public final class UserPrefExportHelper {
    @NotNull
    public static final UserPrefExportHelper INSTANCE = new UserPrefExportHelper();
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Map<String, PortletConfigurationSubType> gadgetsToUserPrefExporter;
    @NotNull
    public static final String DEFAULT = "--Default--";
    @NotNull
    public static final String FILTER = "filter";
    @NotNull
    public static final String PROJECT = "project";
    @NotNull
    public static final String FILTER_PREFIX = "filter-";
    @NotNull
    public static final String PROJECT_PREFIX = "project-";
    public static final int SPLIT_SIZE = 2;
    @NotNull
    public static final String BLANK_STRING = "";
    @NotNull
    public static final String ALL_PROJECTS = "allprojects";
    @NotNull
    public static final String ALL_CATEGORIES = "catallCategories";
    @NotNull
    public static final String CATEGORIES_PREFIX = "cat";
    @NotNull
    public static final String PIPE_DELIMITER = "|";
    @NotNull
    public static final String HYPHEN_DELIMITER = "-";
    @NotNull
    private static final String AUTO = "auto";
    @NotNull
    private static final HashSet<String> delimiters;

    private UserPrefExportHelper() {
    }

    @NotNull
    public final Logger getLog() {
        return log;
    }

    @Nullable
    public final PortletConfigurationSubType getUserPrefExporterKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return gadgetsToUserPrefExporter.get(key);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MRI> getReferencesBySplitting(@NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull String value, @NotNull String delimiter, long gadgetId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        if (delimiters.contains(delimiter)) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = StringExtensionsKt.splitBy(value, delimiter);
            EntityId.Companion companion = EntityId.Companion;
            boolean $i$f$map22 = false;
            void var10_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(companion.fromString((String)p0));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            void $i$f$map22 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                MRI it$iv$iv;
                MRI mRI;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                EntityId entityId = (EntityId)element$iv$iv;
                boolean bl2 = false;
                try {
                    MRI mRI2;
                    if (INSTANCE.toMri(entityId) != null) {
                        MRI mri;
                        boolean bl3 = false;
                        mRI2 = exportService.exportFieldByMri(ctx, mri);
                    } else {
                        mRI2 = null;
                    }
                    mRI = mRI2;
                }
                catch (Exception e) {
                    log.warn("Exception occurred while exporting custom field with id: " + entityId + " for gadget id: " + gadgetId, (Throwable)e);
                    mRI = null;
                }
                if (mRI == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final UserPrefValue mapStatType(@NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull String statType, long gadgetId) {
        UserPrefValue userPrefValue;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)statType, (String)"statType");
        try {
            UserPrefValue userPrefValue2;
            EntityId entityId = EntityId.Companion.fromString(statType);
            MRI mri = this.toMri(entityId);
            if (mri != null) {
                MRI mRI = exportService.exportFieldByMri(ctx, mri);
                if (mRI != null) {
                    MRI it = mRI;
                    boolean bl = false;
                    userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefReference(it);
                } else {
                    userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
                }
            } else {
                userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
            }
            userPrefValue = userPrefValue2;
        }
        catch (Exception e) {
            log.warn("Exception occurred while processing statType: '" + statType + "' for gadgetId: " + gadgetId, (Throwable)e);
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
        }
        return userPrefValue;
    }

    @NotNull
    public final UserPrefValue mapSortColumns(@NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull String sortFieldType, long gadgetId) {
        UserPrefValue userPrefValue;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)sortFieldType, (String)"sortFieldType");
        if (StringsKt.isBlank((CharSequence)sortFieldType)) {
            return (UserPrefValue)new UserPrefValue.UserPrefData(sortFieldType);
        }
        String sortFieldId = StringsKt.substringBefore$default((String)sortFieldType, (String)":", null, (int)2, null);
        try {
            UserPrefValue userPrefValue2;
            EntityId entityId = EntityId.Companion.fromString(sortFieldId);
            MRI mri = this.toMri(entityId);
            if (mri != null) {
                MRI mRI = exportService.exportFieldByMri(ctx, mri);
                if (mRI != null) {
                    MRI it = mRI;
                    boolean bl = false;
                    userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefReference(it);
                } else {
                    userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
                }
            } else {
                userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
            }
            userPrefValue = userPrefValue2;
        }
        catch (Exception e) {
            log.warn("Exception occurred while exporting sort column reference of type '" + sortFieldType + "' with ID '" + sortFieldId + "' for gadgetId: " + gadgetId + "  :", (Throwable)e);
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
        }
        return userPrefValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final MRI toMri(@NotNull EntityId entityId) {
        MRI mRI;
        String string;
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        String string2 = EntityId.Companion.toStringOrNull(entityId);
        if (string2 == null) return null;
        String it = string = string2;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)DEFAULT)) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        String string3 = string;
        String string4 = string3;
        if (string4 == null) return null;
        String value = string4;
        boolean bl3 = false;
        if (StringsKt.startsWith$default((String)value, (String)"customfield_", (boolean)false, (int)2, null)) {
            Long l = StringsKt.toLongOrNull((String)StringsKt.substringAfter$default((String)value, (String)"customfield_", null, (int)2, null));
            if (l == null) return null;
            long it2 = ((Number)l).longValue();
            boolean bl4 = false;
            mRI = MriExtensionsKt.mri$default(CustomField.Companion.getEntityType(), it2, null, 2, null);
            return mRI;
        } else {
            mRI = MriExtensionsKt.mri(JiraCoreMriRegistry.INSTANCE.getStandardField(), value, MRIType.RESULTING);
        }
        return mRI;
    }

    @NotNull
    public final UserPrefValue mapId(@NotNull ExportService exportService, @NotNull ExportContext ctx, @NotNull String type, @NotNull String id, long gadgetId) {
        UserPrefValue userPrefValue;
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)FILTER)) {
            UserPrefValue userPrefValue2;
            try {
                userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefReference(ExportService.exportByIdOrThrow$default(exportService, ctx, Filter.Companion.getEntityType(), Long.parseLong(id), null, 8, null));
            }
            catch (Exception ex) {
                log.warn("Exception occurred while exporting filter with ID: " + id + " for gadgetId: " + gadgetId, (Throwable)ex);
                userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
            }
            userPrefValue = userPrefValue2;
        } else {
            userPrefValue = Intrinsics.areEqual((Object)string, (Object)PROJECT) ? (UserPrefValue)new UserPrefValue.UserPrefReference(MriExtensionsKt.mri$default(Project.Companion.getEntityType(), id, null, 2, null)) : (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
        }
        return userPrefValue;
    }

    @NotNull
    public final UserPrefValue mapProjectOrFilterId(@NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull String projectOrFilterId, long gadgetId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)projectOrFilterId, (String)"projectOrFilterId");
        String[] stringArray = new String[]{HYPHEN_DELIMITER};
        List splitResult = StringsKt.split$default((CharSequence)projectOrFilterId, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        return splitResult.size() == 2 ? INSTANCE.mapProjectOrFilterId(exportService, ctx, (String)splitResult.get(0), (String)splitResult.get(1), gadgetId) : INSTANCE.mapProjectOrFilterId(exportService, ctx, BLANK_STRING, BLANK_STRING, gadgetId);
    }

    @NotNull
    public final UserPrefValue mapProjectOrFilterId(@NotNull ExportService exportService, @NotNull ExportContext ctx, @NotNull String type, @NotNull String id, long gadgetId) {
        UserPrefValue userPrefValue;
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)FILTER)) {
            UserPrefValue userPrefValue2;
            try {
                userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefReferenceWithPrefix(FILTER_PREFIX, ExportService.exportByIdOrThrow$default(exportService, ctx, Filter.Companion.getEntityType(), Long.parseLong(id), null, 8, null));
            }
            catch (Exception ex) {
                log.warn("Exception occurred while exporting entity having prefix as filter with ID: " + id + " and gadgetId: " + gadgetId + " :", (Throwable)ex);
                userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
            }
            userPrefValue = userPrefValue2;
        } else {
            userPrefValue = Intrinsics.areEqual((Object)string, (Object)PROJECT) ? (UserPrefValue)new UserPrefValue.UserPrefReferenceWithPrefix(PROJECT_PREFIX, MriExtensionsKt.mri$default(Project.Companion.getEntityType(), id, null, 2, null)) : (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
        }
        return userPrefValue;
    }

    @NotNull
    public final UserPrefValue mapProjectId(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        String[] stringArray = new String[]{HYPHEN_DELIMITER};
        List splitResult = StringsKt.split$default((CharSequence)projectId, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (splitResult.size() == 2 && Intrinsics.areEqual(splitResult.get(0), (Object)PROJECT)) {
            return (UserPrefValue)new UserPrefValue.UserPrefReferenceWithPrefix(PROJECT_PREFIX, MriExtensionsKt.mri$default(Project.Companion.getEntityType(), splitResult.get(1), null, 2, null));
        }
        return (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
    }

    @NotNull
    public final UserPrefValue mapRapidView(@NotNull ExportContext ctx, @NotNull RapidViewExportService rapidViewExportService, @NotNull String rapidViewId, long gadgetId) {
        UserPrefValue userPrefValue;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)rapidViewExportService, (String)"rapidViewExportService");
        Intrinsics.checkNotNullParameter((Object)rapidViewId, (String)"rapidViewId");
        try {
            MRI mri = rapidViewExportService.exportRapidViewById(ctx, Long.parseLong(rapidViewId));
            userPrefValue = mri != null ? (UserPrefValue)new UserPrefValue.UserPrefReference(mri) : (UserPrefValue)new UserPrefValue.UserPrefData("9223372036854775807");
        }
        catch (Exception e) {
            log.warn("Exception occurred while exporting RapidView with ID: " + rapidViewId + " for gadgetId:" + gadgetId + ' ', (Throwable)e);
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefData("9223372036854775807");
        }
        return userPrefValue;
    }

    @NotNull
    public final UserPrefValue mapSprint(@NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull String sprintId, long gadgetId) {
        UserPrefValue userPrefValue;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)sprintId, (String)"sprintId");
        try {
            userPrefValue = Intrinsics.areEqual((Object)sprintId, (Object)AUTO) ? (UserPrefValue)new UserPrefValue.UserPrefData(sprintId) : (UserPrefValue)new UserPrefValue.UserPrefReference(ExportService.exportByIdOrThrow$default(exportService, ctx, Sprint.Companion.getEntityType(), Long.parseLong(sprintId), null, 8, null));
        }
        catch (Exception e) {
            log.warn("Exception occurred while exporting Sprint with ID: " + sprintId + " for gadgetId: " + gadgetId, (Throwable)e);
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
        }
        return userPrefValue;
    }

    @NotNull
    public final UserPrefValue mapIssueStatuses(@NotNull ExportService exportService, @NotNull ExportContext ctx, @NotNull String statuses, long gadgetId) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)statuses, (String)"statuses");
        return StringsKt.isBlank((CharSequence)statuses) ? (UserPrefValue)new UserPrefValue.UserPrefData(statuses) : (StringsKt.contains$default((CharSequence)statuses, (CharSequence)PIPE_DELIMITER, (boolean)false, (int)2, null) ? this.mapIssueStatusList(exportService, ctx, statuses, gadgetId) : this.mapSingleIssueStatus(exportService, ctx, statuses, gadgetId));
    }

    /*
     * WARNING - void declaration
     */
    private final UserPrefValue mapIssueStatusList(ExportService exportService, ExportContext ctx, String statuses, long gadgetId) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{PIPE_DELIMITER};
        List statusIds = StringsKt.split$default((CharSequence)statuses, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$mapNotNull$iv = statusIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MRI it$iv$iv;
            MRI mRI;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String statusId = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                mRI = ExportService.exportByIdOrThrow$default(exportService, ctx, IssueStatus.Companion.getEntityType(), statusId, null, 8, null);
            }
            catch (Exception e) {
                log.warn("Exception occurred while exporting status with ID: " + statusId + ": for gadgetId: " + gadgetId, (Throwable)e);
                mRI = null;
            }
            if (mRI == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List statusReferences = (List)destination$iv$iv;
        return (UserPrefValue)new UserPrefValue.UserPrefReferenceListWithDelimiter(PIPE_DELIMITER, statusReferences);
    }

    private final UserPrefValue mapSingleIssueStatus(ExportService exportService, ExportContext ctx, String status, long gadgetId) {
        UserPrefValue userPrefValue;
        try {
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefReference(ExportService.exportByIdOrThrow$default(exportService, ctx, IssueStatus.Companion.getEntityType(), status, null, 8, null));
        }
        catch (Exception e) {
            log.warn("Exception occurred while exporting status with ID: " + status + " for gadgetId: " + gadgetId + ' ', (Throwable)e);
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
        }
        return userPrefValue;
    }

    @NotNull
    public final UserPrefValue mapColumns(@NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull String columnNames, long gadgetId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)columnNames, (String)"columnNames");
        return (UserPrefValue)new UserPrefValue.UserPrefReferenceListWithDelimiter(PIPE_DELIMITER, this.getReferencesBySplitting(ctx, exportService, columnNames, PIPE_DELIMITER, gadgetId));
    }

    @NotNull
    public final String decodeActivityStreamRules(@Nullable String activityStreamRules, long gadgetId) {
        String string;
        String string2 = activityStreamRules;
        if (string2 != null) {
            String string3;
            String rules = string2;
            boolean bl = false;
            try {
                string3 = URLDecoder.decode(rules, StandardCharsets.UTF_8.toString());
            }
            catch (Exception ex) {
                log.warn("Exception occurred while decoding activity stream rules " + activityStreamRules + " with error: " + ex.getMessage() + " for gadgetId: " + gadgetId);
                string3 = BLANK_STRING;
            }
            string = string3;
        } else {
            string = null;
        }
        String string4 = string;
        return string4 == null ? BLANK_STRING : string4;
    }

    @Nullable
    public final ActivityStreamRules parseActivityStreamRules(@Nullable String activityStreamRules, @NotNull ObjectMapper objectMapper2, long gadgetId) {
        ActivityStreamRules activityStreamRules2;
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        String string = activityStreamRules;
        if (string != null) {
            ActivityStreamRules activityStreamRules3;
            String rules = string;
            boolean bl = false;
            try {
                activityStreamRules3 = (ActivityStreamRules)objectMapper2.readValue(rules, ActivityStreamRules.class);
            }
            catch (Exception ex) {
                log.warn("Exception occurred while parsing activity stream rules " + activityStreamRules + " with error: " + ex.getMessage() + " for gadgetId: " + gadgetId);
                activityStreamRules3 = null;
            }
            activityStreamRules2 = activityStreamRules3;
        } else {
            activityStreamRules2 = null;
        }
        return activityStreamRules2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> extractUsernamesFromActivityStreamRules(@Nullable String activityStreamRules, @NotNull ObjectMapper objectMapper2, long gadgetId) {
        Object object;
        block11: {
            block10: {
                List list;
                List<Provider> list2;
                Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
                object = activityStreamRules;
                if (object == null) break block10;
                String rules = object;
                boolean bl = false;
                String activityStreamRulesDecodedString = INSTANCE.decodeActivityStreamRules(rules, gadgetId);
                ActivityStreamRules activityStreamRulesJSON = INSTANCE.parseActivityStreamRules(activityStreamRulesDecodedString, objectMapper2, gadgetId);
                if (activityStreamRulesJSON != null && (list2 = activityStreamRulesJSON.getProviders()) != null) {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void $this$flatMapTo$iv$iv2;
                    void $this$flatMap$iv2;
                    Iterable iterable = list2;
                    boolean $i$f$flatMap22 = false;
                    void var12_12 = $this$flatMap$iv2;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                        Provider it = (Provider)element$iv$iv;
                        boolean bl2 = false;
                        List list3 = it.getRules();
                        if (list3 == null) {
                            list3 = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = list3;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    Iterable $i$f$flatMap22 = (List)destination$iv$iv;
                    boolean $i$f$filter22 = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Object object2;
                        Rule it = (Rule)element$iv$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual((Object)it.getRule(), (Object)"user") && StringExtensionsKt.isNotNullOrBlank((object2 = it.getValue()) instanceof String ? (String)object2 : null))) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    Iterable $i$f$filter22 = (List)destination$iv$iv2;
                    boolean $i$f$flatMap = false;
                    destination$iv$iv2 = $this$flatMap$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        int n;
                        CharSequence charSequence;
                        Regex regex;
                        Rule it = (Rule)element$iv$iv;
                        boolean bl4 = false;
                        Object object3 = it.getValue();
                        Object object4 = object3 instanceof String ? (String)object3 : null;
                        if (object4 == null || (object4 = (regex = new Regex("\\s+")).split(charSequence = (CharSequence)object4, n = 0)) == null) {
                            object4 = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = (Iterable)object4;
                        CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv3;
                } else {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                if (list != null) break block11;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final UserPrefValue mapDateField(@NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull String dateField, long gadgetId) {
        UserPrefValue userPrefValue;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)dateField, (String)"dateField");
        try {
            UserPrefValue userPrefValue2;
            EntityId entityId = EntityId.Companion.fromString(dateField);
            MRI mri = this.toMri(entityId);
            if (mri != null) {
                MRI mRI = exportService.exportFieldByMri(ctx, mri);
                if (mRI != null) {
                    MRI it = mRI;
                    boolean bl = false;
                    userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefReference(it);
                } else {
                    userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
                }
            } else {
                userPrefValue2 = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
            }
            userPrefValue = userPrefValue2;
        }
        catch (Exception e) {
            log.warn("Exception occurred while processing dateField: '" + dateField + "' for gadgetId: " + gadgetId, (Throwable)e);
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
        }
        return userPrefValue;
    }

    private final MRI mapProjectCategory(ExportService exportService, ExportContext ctx, long projectCategory, long gadgetId) {
        MRI mRI;
        try {
            mRI = ExportService.exportByIdOrThrow$default(exportService, ctx, ProjectCategory.Companion.getEntityType(), projectCategory, null, 8, null);
        }
        catch (Exception ex) {
            log.warn("Exception occurred while exporting project category with id: " + projectCategory + " for gadgetId: " + gadgetId, (Throwable)ex);
            mRI = null;
        }
        return mRI;
    }

    @NotNull
    public final UserPrefValue mapToProjectOrCategories(@NotNull ExportContext ctx, @NotNull ExportService exportService, @NotNull List<String> projects, @NotNull List<String> projectCategories, long gadgetId) {
        UserPrefValue userPrefValue;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Intrinsics.checkNotNullParameter(projectCategories, (String)"projectCategories");
        if (projectCategories.isEmpty() && !((Collection)projects).isEmpty()) {
            userPrefValue = this.mapToProjectsReferenceWithProjectsOrCategories(projects);
        } else if (projectCategories.size() == 1) {
            userPrefValue = this.mapToSingleProjectCategoryReference(exportService, ctx, projectCategories.get(0), gadgetId);
        } else {
            Iterable $this$forEach$iv = projectCategories;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String projectCategory = (String)element$iv;
                boolean bl = false;
                INSTANCE.mapProjectCategory(exportService, ctx, Long.parseLong(StringsKt.removePrefix((String)projectCategory, (CharSequence)CATEGORIES_PREFIX)), gadgetId);
            }
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefData(CollectionsKt.joinToString$default((Iterable)projectCategories, (CharSequence)PIPE_DELIMITER, null, null, (int)0, null, null, (int)62, null));
        }
        return userPrefValue;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UserPrefValue.UserPrefReferenceListWithDelimiter mapToProjectsReference(@NotNull List<String> projects) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Iterable iterable = projects;
        String string = PIPE_DELIMITER;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MRI it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (MriExtensionsKt.mri$default(Project.Companion.getEntityType(), it, null, 2, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new UserPrefValue.UserPrefReferenceListWithDelimiter(string2, list);
    }

    @NotNull
    public final UserPrefValue mapToProjectsReferenceWithProjectsOrCategories(@NotNull List<String> projects) {
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        return projects.size() == 1 ? (UserPrefValue)new UserPrefValue.UserPrefReference(MriExtensionsKt.mri$default(Project.Companion.getEntityType(), projects.get(0), null, 2, null)) : (UserPrefValue)this.mapToProjectsReference(projects);
    }

    @NotNull
    public final UserPrefValue mapToSingleProjectCategoryReference(@NotNull ExportService exportService, @NotNull ExportContext ctx, @NotNull String projectCategory, long gadgetId) {
        UserPrefValue userPrefValue;
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)projectCategory, (String)"projectCategory");
        String categoryId = StringsKt.removePrefix((String)projectCategory, (CharSequence)CATEGORIES_PREFIX);
        MRI mRI = this.mapProjectCategory(exportService, ctx, Long.parseLong(categoryId), gadgetId);
        if (mRI != null) {
            MRI it = mRI;
            boolean bl = false;
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefReferenceWithPrefix(CATEGORIES_PREFIX, it);
        } else {
            userPrefValue = (UserPrefValue)new UserPrefValue.UserPrefData(BLANK_STRING);
        }
        return userPrefValue;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UserPrefValue mapToProjectCategoriesReference(@NotNull ExportService exportService, @NotNull ExportContext ctx, @NotNull List<String> projectCategories, long gadgetId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(projectCategories, (String)"projectCategories");
        Iterable iterable = projectCategories;
        String string = PIPE_DELIMITER;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MRI it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.mapProjectCategory(exportService, ctx, Long.parseLong(StringsKt.removePrefix((String)it, (CharSequence)CATEGORIES_PREFIX)), gadgetId) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        String string2 = string;
        return (UserPrefValue)new UserPrefValue.UserPrefReferenceListWithDelimiter(string2, list);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(UserPrefExportHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:filter-results-gadget/gadgets/filter-results-gadget.xml", (Object)((Object)PortletConfigurationSubType.FilterResultsUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:pie-chart-gadget/gadgets/piechart-gadget.xml", (Object)((Object)PortletConfigurationSubType.PieChartUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:quicklinks-gadget/gadgets/quicklinks-gadget.xml", (Object)((Object)PortletConfigurationSubType.QuickLinksUserPrefExporter)), TuplesKt.to((Object)"com.atlassian.jira.gadgets:introduction-dashboard-item", (Object)((Object)PortletConfigurationSubType.IntroductionUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:two-dimensional-stats-gadget/gadgets/two-dimensional-stats-gadget.xml", (Object)((Object)PortletConfigurationSubType.TwoDimensionalStatsUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:assigned-to-me-gadget/gadgets/assigned-to-me-gadget.xml", (Object)((Object)PortletConfigurationSubType.AssignedToMeUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:favourite-filters-gadget/gadgets/favourite-filters-gadget.xml", (Object)((Object)PortletConfigurationSubType.FavoriteFiltersUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:stats-gadget/gadgets/stats-gadget.xml", (Object)((Object)PortletConfigurationSubType.IssueStatisticsUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:recently-created-chart-gadget/gadgets/recently-created-gadget.xml", (Object)((Object)PortletConfigurationSubType.RecentlyCreatedChartUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:watched-gadget/gadgets/watched-gadget.xml", (Object)((Object)PortletConfigurationSubType.WatchedIssuesUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:in-progress-gadget/gadgets/in-progress-gadget.xml", (Object)((Object)PortletConfigurationSubType.IssuesInProgressUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:resolution-time-gadget/gadgets/resolution-time-gadget.xml", (Object)((Object)PortletConfigurationSubType.ResolutionTimeUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin:activitystream-gadget/gadgets/activitystream-gadget.xml", (Object)((Object)PortletConfigurationSubType.ActivityStreamUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.ext.charting:firstresponse-gadget/com/atlassian/jira/ext/charting/gadget/firstresponse-gadget.xml", (Object)((Object)PortletConfigurationSubType.TimeToFirstResponseUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:average-age-chart-gadget/gadgets/average-age-gadget.xml", (Object)((Object)PortletConfigurationSubType.AverageAgeChartUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:voted-gadget/gadgets/voted-gadget.xml", (Object)((Object)PortletConfigurationSubType.VotedIssuesUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:created-vs-resolved-issues-chart-gadget/gadgets/createdvsresolved-gadget.xml", (Object)((Object)PortletConfigurationSubType.CreatedVsResolvedGadgetUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.atlassian-wallboard-plugin:spacer-gadget/gadgets/spacerGadget.xml", (Object)((Object)PortletConfigurationSubType.WallboardSpacerUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.ext.charting:workloadpie-gadget/com/atlassian/jira/ext/charting/gadget/workloadpie-gadget.xml", (Object)((Object)PortletConfigurationSubType.WorkloadPieChartUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:heat-map-gadget/gadgets/heatmap-gadget.xml", (Object)((Object)PortletConfigurationSubType.HeatmapUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:labels-gadget/gadgets/labels-gadget.xml", (Object)((Object)PortletConfigurationSubType.LabelsUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.ext.charting:timeinstatus-gadget/com/atlassian/jira/ext/charting/gadget/timeinstatus-gadget.xml", (Object)((Object)PortletConfigurationSubType.AverageTimeInStatusUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-gadget-sprint-health/gadgets/greenhopper-sprint-health.xml", (Object)((Object)PortletConfigurationSubType.SprintHealthUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-gadget-sprint-burndown/gadgets/greenhopper-sprint-burndown.xml", (Object)((Object)PortletConfigurationSubType.SprintBurnDownUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-gadget-sprint-days-remaining/gadgets/greenhopper-sprint-days-remaining.xml", (Object)((Object)PortletConfigurationSubType.SprintDaysRemainingUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.ext.charting:numberoftimesinstatus-gadget/com/atlassian/jira/ext/charting/gadget/numberoftimesinstatus-gadget.xml", (Object)((Object)PortletConfigurationSubType.AverageNumberOfTimeInStatusUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:road-map-gadget/gadgets/roadmap-gadget.xml", (Object)((Object)PortletConfigurationSubType.JiraRoadMapUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml", (Object)((Object)PortletConfigurationSubType.TimeSinceUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.ext.calendar:issuescalendar-gadget/templates/plugins/jira/portlets/calendar/gadget/calendar-gadget.xml", (Object)((Object)PortletConfigurationSubType.IssuesCalendarUserPrefExporter)), TuplesKt.to((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:project-gadget/gadgets/project-gadget.xml", (Object)((Object)PortletConfigurationSubType.ProjectsUserPrefExporter))};
        gadgetsToUserPrefExporter = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{PIPE_DELIMITER, HYPHEN_DELIMITER};
        delimiters = SetsKt.hashSetOf((Object[])objectArray);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B)\u0012\u0010\b\u0001\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0010\b\u0001\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003H\u00c6\u0003J-\u0010\f\u001a\u00020\u00002\u0010\b\u0003\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper$ActivityStreamRules;", "", "providers", "", "Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper$Provider;", "rules", "(Ljava/util/List;Ljava/util/List;)V", "getProviders", "()Ljava/util/List;", "getRules", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class ActivityStreamRules {
        @Nullable
        private final List<Provider> providers;
        @Nullable
        private final List<Object> rules;

        public ActivityStreamRules(@JsonProperty(value="providers") @Nullable List<Provider> providers, @JsonProperty(value="rules") @Nullable List<? extends Object> rules) {
            this.providers = providers;
            this.rules = rules;
        }

        @Nullable
        public final List<Provider> getProviders() {
            return this.providers;
        }

        @Nullable
        public final List<Object> getRules() {
            return this.rules;
        }

        @Nullable
        public final List<Provider> component1() {
            return this.providers;
        }

        @Nullable
        public final List<Object> component2() {
            return this.rules;
        }

        @NotNull
        public final ActivityStreamRules copy(@JsonProperty(value="providers") @Nullable List<Provider> providers, @JsonProperty(value="rules") @Nullable List<? extends Object> rules) {
            return new ActivityStreamRules(providers, rules);
        }

        public static /* synthetic */ ActivityStreamRules copy$default(ActivityStreamRules activityStreamRules, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = activityStreamRules.providers;
            }
            if ((n & 2) != 0) {
                list2 = activityStreamRules.rules;
            }
            return activityStreamRules.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "ActivityStreamRules(providers=" + this.providers + ", rules=" + this.rules + ')';
        }

        public int hashCode() {
            int result2 = this.providers == null ? 0 : ((Object)this.providers).hashCode();
            result2 = result2 * 31 + (this.rules == null ? 0 : ((Object)this.rules).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActivityStreamRules)) {
                return false;
            }
            ActivityStreamRules activityStreamRules = (ActivityStreamRules)other;
            if (!Intrinsics.areEqual(this.providers, activityStreamRules.providers)) {
                return false;
            }
            return Intrinsics.areEqual(this.rules, activityStreamRules.rules);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ8\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper$Provider;", "", "provider", "", "rules", "", "Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper$Rule;", "disabled", "", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;)V", "getDisabled", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getProvider", "()Ljava/lang/String;", "getRules", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;)Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper$Provider;", "equals", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class Provider {
        @Nullable
        private final String provider;
        @Nullable
        private final List<Rule> rules;
        @Nullable
        private final Boolean disabled;

        public Provider(@Nullable String provider, @Nullable List<Rule> rules, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable Boolean disabled) {
            this.provider = provider;
            this.rules = rules;
            this.disabled = disabled;
        }

        @Nullable
        public final String getProvider() {
            return this.provider;
        }

        @Nullable
        public final List<Rule> getRules() {
            return this.rules;
        }

        @Nullable
        public final Boolean getDisabled() {
            return this.disabled;
        }

        @Nullable
        public final String component1() {
            return this.provider;
        }

        @Nullable
        public final List<Rule> component2() {
            return this.rules;
        }

        @Nullable
        public final Boolean component3() {
            return this.disabled;
        }

        @NotNull
        public final Provider copy(@Nullable String provider, @Nullable List<Rule> rules, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable Boolean disabled) {
            return new Provider(provider, rules, disabled);
        }

        public static /* synthetic */ Provider copy$default(Provider provider, String string, List list, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = provider.provider;
            }
            if ((n & 2) != 0) {
                list = provider.rules;
            }
            if ((n & 4) != 0) {
                bl = provider.disabled;
            }
            return provider.copy(string, list, bl);
        }

        @NotNull
        public String toString() {
            return "Provider(provider=" + this.provider + ", rules=" + this.rules + ", disabled=" + this.disabled + ')';
        }

        public int hashCode() {
            int result2 = this.provider == null ? 0 : this.provider.hashCode();
            result2 = result2 * 31 + (this.rules == null ? 0 : ((Object)this.rules).hashCode());
            result2 = result2 * 31 + (this.disabled == null ? 0 : ((Object)this.disabled).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Provider)) {
                return false;
            }
            Provider provider = (Provider)other;
            if (!Intrinsics.areEqual((Object)this.provider, (Object)provider.provider)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rules, provider.rules)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.disabled, (Object)provider.disabled);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J9\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/export/core/portalpage/userpref/UserPrefExportHelper$Rule;", "", "rule", "", "operator", "value", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V", "getOperator", "()Ljava/lang/String;", "getRule", "getType", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class Rule {
        @Nullable
        private final String rule;
        @Nullable
        private final String operator;
        @Nullable
        private Object value;
        @Nullable
        private final String type;

        public Rule(@Nullable String rule, @Nullable String operator, @Nullable Object value, @Nullable String type) {
            this.rule = rule;
            this.operator = operator;
            this.value = value;
            this.type = type;
        }

        @Nullable
        public final String getRule() {
            return this.rule;
        }

        @Nullable
        public final String getOperator() {
            return this.operator;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        public final void setValue(@Nullable Object object) {
            this.value = object;
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String component1() {
            return this.rule;
        }

        @Nullable
        public final String component2() {
            return this.operator;
        }

        @Nullable
        public final Object component3() {
            return this.value;
        }

        @Nullable
        public final String component4() {
            return this.type;
        }

        @NotNull
        public final Rule copy(@Nullable String rule, @Nullable String operator, @Nullable Object value, @Nullable String type) {
            return new Rule(rule, operator, value, type);
        }

        public static /* synthetic */ Rule copy$default(Rule rule, String string, String string2, Object object, String string3, int n, Object object2) {
            if ((n & 1) != 0) {
                string = rule.rule;
            }
            if ((n & 2) != 0) {
                string2 = rule.operator;
            }
            if ((n & 4) != 0) {
                object = rule.value;
            }
            if ((n & 8) != 0) {
                string3 = rule.type;
            }
            return rule.copy(string, string2, object, string3);
        }

        @NotNull
        public String toString() {
            return "Rule(rule=" + this.rule + ", operator=" + this.operator + ", value=" + this.value + ", type=" + this.type + ')';
        }

        public int hashCode() {
            int result2 = this.rule == null ? 0 : this.rule.hashCode();
            result2 = result2 * 31 + (this.operator == null ? 0 : this.operator.hashCode());
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rule)) {
                return false;
            }
            Rule rule = (Rule)other;
            if (!Intrinsics.areEqual((Object)this.rule, (Object)rule.rule)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operator, (Object)rule.operator)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)rule.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)rule.type);
        }
    }
}

