/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.project;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.export.utils.JiraServerEventNotifications;
import com.atlassian.jira.migration.export.utils.JiraServerNotification;
import com.atlassian.jira.migration.export.utils.JiraServerNotificationScheme;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.reports.ProblemType;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.notification.type.NotificationType;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.notification.EventNotifications;
import com.atlassian.migration.jira.classic.notification.Notification;
import com.atlassian.migration.jira.classic.notification.NotificationScheme;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 G2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001GB7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020&H\u0002J \u0010(\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u0002H\u0002J \u0010-\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0006\u0010.\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0018\u0010/\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u0002H\u0002J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u000201H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u0002012\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u00106\u001a\u0002042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u00107\u001a\u0002042\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020&H\u0002J\u0010\u0010;\u001a\u0002042\u0006\u0010:\u001a\u00020&H\u0002J\u0018\u0010<\u001a\u0002042\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020&H\u0002J\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020>012\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0010\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020\u0002H\u0016J\b\u0010C\u001a\u00020\u001bH\u0007J\u0016\u0010D\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00020\u000201H\u0002J\"\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0019R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/atlassian/jira/migration/export/core/project/NotificationSchemeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/utils/JiraServerNotificationScheme;", "Lcom/atlassian/migration/jira/classic/notification/NotificationScheme;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "eventTypeManager", "Lcom/atlassian/jira/event/type/EventTypeManager;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "projectRoleManager", "Lcom/atlassian/jira/security/roles/ProjectRoleManager;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/event/type/EventTypeManager;Lcom/atlassian/jira/issue/CustomFieldManager;Lcom/atlassian/jira/security/roles/ProjectRoleManager;Lcom/atlassian/jira/migration/export/utils/ExportFilters;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log$1", "addMessageToTheReport", "", "notification", "Lcom/atlassian/jira/migration/export/utils/JiraServerNotification;", "eventNotification", "Lcom/atlassian/jira/migration/export/utils/JiraServerEventNotifications;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportData", "entity", "exportUsersAndGroups", "fromAppUserKey", "", "schemeId", "fromCustomKey", "scheme", "fromEventType", "Lcom/atlassian/jira/event/type/EventType;", "eventType", "fromGroupKey", "groupName", "fromRoleKey", "getIssueArchivalEvents", "", "getStandardEventTypeIds", "isSupportedEventType", "", "jiraServerEventNotifications", "isSupportedNotification", "isValidGroupCfParameter", "notifyType", "Lcom/atlassian/jira/notification/type/NotificationType;", "paramString", "isValidGroupRef", "isValidNotification", "mapEvents", "Lcom/atlassian/migration/jira/classic/notification/EventNotifications;", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "standardEventTypeIds", "toNotification", "Lcom/atlassian/migration/jira/classic/notification/Notification;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nNotificationSchemeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/project/NotificationSchemeExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,221:1\n766#2:222\n857#2,2:223\n1549#2:225\n1620#2,2:226\n766#2:228\n857#2,2:229\n1603#2,9:231\n1855#2:240\n1856#2:242\n1612#2:243\n1622#2:244\n1603#2,9:245\n1855#2:254\n1856#2:257\n1612#2:258\n1855#2,2:259\n288#2,2:262\n1#3:241\n1#3:255\n1#3:256\n1#3:261\n1282#4,2:264\n*S KotlinDebug\n*F\n+ 1 NotificationSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/project/NotificationSchemeExporter\n*L\n75#1:222\n75#1:223,2\n76#1:225\n76#1:226,2\n78#1:228\n78#1:229,2\n79#1:231,9\n79#1:240\n79#1:242\n79#1:243\n76#1:244\n80#1:245,9\n80#1:254\n80#1:257\n80#1:258\n89#1:259,2\n170#1:262,2\n79#1:241\n80#1:256\n184#1:264,2\n*E\n"})
public final class NotificationSchemeExporter
implements Exporter<Long, JiraServerNotificationScheme, NotificationScheme> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EventTypeManager eventTypeManager;
    @NotNull
    private final CustomFieldManager customFieldManager;
    @NotNull
    private final ProjectRoleManager projectRoleManager;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log$1;
    private static final Logger log = LoggerFactory.getLogger(NotificationSchemeExporter.class);
    @NotNull
    private static final List<NotificationType> unsupportedNotifications = CollectionsKt.listOf((Object)NotificationType.USER_CUSTOM_FIELD_VALUE);
    @NotNull
    private static final String INVALID_GROUP_REF = "invalid-group-ref";
    private static final long ISSUE_ARCHIVED_EVENT_ID = 18L;
    private static final long ISSUE_RESTORED_EVENT_ID = 19L;

    @Inject
    public NotificationSchemeExporter(@NotNull ExportService exportService, @NotNull EventTypeManager eventTypeManager, @NotNull CustomFieldManager customFieldManager, @NotNull ProjectRoleManager projectRoleManager, @NotNull ExportFilters exportFilters, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)eventTypeManager, (String)"eventTypeManager");
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        Intrinsics.checkNotNullParameter((Object)projectRoleManager, (String)"projectRoleManager");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.exportService = exportService;
        this.eventTypeManager = eventTypeManager;
        this.customFieldManager = customFieldManager;
        this.projectRoleManager = projectRoleManager;
        this.exportFilters = exportFilters;
        this.migrationFeatures = migrationFeatures;
        this.log$1 = LoggerFactory.getLogger(NotificationSchemeExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, JiraServerNotificationScheme.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(NotificationScheme.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull JiraServerNotificationScheme entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(NotificationScheme.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public NotificationScheme exportData(@NotNull ExportContext ctx, @NotNull JiraServerNotificationScheme entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), ctx.getExportMode()};
        this.log$1.debug("[MigrationId:{}] Exporting notificationScheme {} under exportMode:{}", objectArray);
        return new NotificationScheme(this.mriForEntity(entity), entity.getName(), entity.getDescription(), this.mapEvents(ctx, entity), null, null, 48, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull JiraServerNotificationScheme entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log$1.debug("Exporting users and groups for jiraServerNotificationScheme with id {} for migration {} under exportMode {}", objectArray);
        this.mapEvents(ctx, entity);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EventNotifications> mapEvents(ExportContext ctx, JiraServerNotificationScheme entity) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        JiraServerEventNotifications notification;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = entity.getNotifications();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            notification = (JiraServerEventNotifications)element$iv$iv;
            boolean bl = false;
            if (!this.isSupportedEventType(notification, ctx)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv;
            Object it;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            void event;
            notification = (JiraServerEventNotifications)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = event.getNotifications();
            void var13_15 = event;
            boolean $i$f$filter2 = false;
            void var15_21 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (JiraServerNotification)element$iv$iv;
                boolean bl2 = false;
                if (!this.isSupportedNotification((JiraServerNotification)it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv2 = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                Notification it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl3 = false;
                JiraServerNotification it2 = (JiraServerNotification)element$iv$iv;
                boolean bl4 = false;
                if (this.toNotification(ctx, it2, entity) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            collection.add(TuplesKt.to((Object)var13_15, (Object)((List)destination$iv$iv2)));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            EventNotifications eventNotifications;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl6 = false;
            JiraServerEventNotifications eventNotification = (JiraServerEventNotifications)pair.component1();
            List notifications = (List)pair.component2();
            if (this.fromEventType(eventNotification.getEventType()) != null) {
                EventType it;
                boolean bl7 = false;
                Long l = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                eventNotifications = new EventNotifications(((Number)l).longValue(), notifications);
            } else {
                eventNotifications = null;
            }
            if (eventNotifications == null) continue;
            EventNotifications it$iv$iv = eventNotifications;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isSupportedEventType(JiraServerEventNotifications jiraServerEventNotifications, ExportContext ctx) {
        boolean isSupported = this.getStandardEventTypeIds(ctx).contains(jiraServerEventNotifications.getEventType());
        if (!isSupported) {
            Iterable $this$forEach$iv = jiraServerEventNotifications.getNotifications();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JiraServerNotification it = (JiraServerNotification)element$iv;
                boolean bl = false;
                this.addMessageToTheReport(it, jiraServerEventNotifications, ctx);
            }
        }
        return isSupported;
    }

    private final void addMessageToTheReport(JiraServerNotification notification, JiraServerEventNotifications eventNotification, ExportContext ctx) {
        ExportContext.handleUnsupported$default(ctx, String.valueOf(notification.getId()), String.valueOf(eventNotification.getEventType()), (Object)((Object)ProblemType.CUSTOM_EVENT_TYPE) + ':' + notification.getType(), String.valueOf(eventNotification.getEventType()), null, null, 48, null);
    }

    private final boolean isSupportedNotification(JiraServerNotification notification) {
        return !unsupportedNotifications.contains(NotificationType.from((String)notification.getType()));
    }

    private final Notification toNotification(ExportContext ctx, JiraServerNotification notification, JiraServerNotificationScheme scheme) {
        Notification notification2;
        String string;
        NotificationType notifyType;
        JiraServerNotification $this$toNotification_u24lambda_u247 = notification;
        boolean bl = false;
        NotificationType notificationType = notifyType = NotificationType.from((String)$this$toNotification_u24lambda_u247.getType());
        switch (notificationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
            case 1: {
                string = this.fromAppUserKey(ctx, $this$toNotification_u24lambda_u247.getParameter());
                break;
            }
            case 2: {
                string = $this$toNotification_u24lambda_u247.getParameter();
                break;
            }
            case 3: {
                string = this.fromGroupKey(ctx, $this$toNotification_u24lambda_u247.getParameter(), scheme);
                break;
            }
            case 4: {
                string = this.fromRoleKey(ctx, Long.parseLong($this$toNotification_u24lambda_u247.getParameter()));
                break;
            }
            case 5: 
            case 6: {
                string = this.fromCustomKey(ctx, $this$toNotification_u24lambda_u247.getParameter(), scheme);
                break;
            }
            default: {
                string = $this$toNotification_u24lambda_u247.getParameter();
            }
        }
        String paramString = string;
        Intrinsics.checkNotNull((Object)notifyType);
        if (this.isValidNotification(notifyType, paramString)) {
            long l = $this$toNotification_u24lambda_u247.getId();
            String string2 = notifyType.dbCode();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dbCode(...)");
            notification2 = new Notification(l, string2, paramString);
        } else {
            notification2 = null;
        }
        return notification2;
    }

    private final boolean isValidNotification(NotificationType notifyType, String paramString) {
        return this.isValidGroupRef(paramString) && this.isValidGroupCfParameter(notifyType, paramString);
    }

    private final boolean isValidGroupRef(String paramString) {
        return !Intrinsics.areEqual((Object)paramString, (Object)INVALID_GROUP_REF);
    }

    private final boolean isValidGroupCfParameter(NotificationType notifyType, String paramString) {
        CharSequence charSequence;
        return notifyType != NotificationType.GROUP_CUSTOM_FIELD_VALUE || !((charSequence = (CharSequence)paramString) == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    private final String fromRoleKey(ExportContext ctx, long schemeId) {
        Object object;
        block3: {
            block2: {
                object = this.projectRoleManager.getProjectRole(Long.valueOf(schemeId));
                if (object == null) break block2;
                ProjectRole it = object;
                boolean bl = false;
                String string = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null).value();
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String fromGroupKey(ExportContext ctx, String groupName, JiraServerNotificationScheme scheme) {
        GroupRefModel groupRefModel = new GroupRefModel(groupName, "Notification Scheme [" + scheme.getName() + ']', String.valueOf(scheme.getId()));
        Object object = this.exportService.groupRefSkipInvalid(ctx, groupRefModel);
        if (object == null || (object = object.value()) == null) {
            object = INVALID_GROUP_REF;
        }
        return object;
    }

    private final String fromAppUserKey(ExportContext ctx, String schemeId) {
        Object object;
        block3: {
            block2: {
                object = UserRef.Companion.fromString(schemeId);
                if (object == null) break block2;
                UserRef it = object;
                boolean bl = false;
                String string = this.exportService.userRef(ctx, it).value();
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String fromCustomKey(ExportContext ctx, String schemeId, JiraServerNotificationScheme scheme) {
        CustomField customField;
        CustomField customField2;
        CustomField customField3 = customField2 = this.customFieldManager.getCustomFieldObject(schemeId);
        boolean bl = false;
        if (customField3 == null) {
            this.log$1.warn("NotificationScheme " + scheme.getName() + '(' + scheme.getId() + ") has reference to field " + schemeId + " which cannot be found my CustomFieldManager. Skipping...");
        }
        CustomField customField4 = customField2;
        if (customField4 == null) return "";
        CustomField it = customField = customField4;
        boolean bl2 = false;
        if (!this.exportFilters.isSupportedField(ctx, (com.atlassian.jira.issue.fields.Field)it)) return "";
        CustomField customField5 = customField;
        customField2 = customField5;
        if (customField2 == null) return "";
        CustomField it2 = customField2;
        boolean bl3 = false;
        String string = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it2, false, 4, null).value();
        if (string == null) return "";
        String string2 = string;
        return string2;
    }

    private final EventType fromEventType(long eventType) {
        Object v2;
        block1: {
            Collection collection = this.eventTypeManager.getEventTypes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEventTypes(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EventType it = (EventType)element$iv;
                boolean bl = false;
                Long l = it.getId();
                long l2 = eventType;
                if (!(l != null && l == l2)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final List<Long> getIssueArchivalEvents() {
        Object[] objectArray;
        Object object;
        block2: {
            Field[] fieldArray = EventType.class.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getFields(...)");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"ISSUE_ARCHIVED_ID")) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        if (object == null) {
            objectArray = new Long[]{18L, 19L};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        objectArray = new Long[]{EventType.ISSUE_ARCHIVED_ID, EventType.ISSUE_RESTORED_ID};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<Long> getStandardEventTypeIds(ExportContext ctx) {
        if (MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssues(this.migrationFeatures, ctx.getMigrateArchivedIssues())) {
            this.log$1.debug("Exporting archival issue event");
            return CollectionsKt.plus((Collection)this.standardEventTypeIds(), (Iterable)this.getIssueArchivalEvents());
        }
        return this.standardEventTypeIds();
    }

    private final List<Long> standardEventTypeIds() {
        Object[] objectArray = new Long[]{EventType.ISSUE_CREATED_ID, EventType.ISSUE_UPDATED_ID, EventType.ISSUE_ASSIGNED_ID, EventType.ISSUE_RESOLVED_ID, EventType.ISSUE_CLOSED_ID, EventType.ISSUE_COMMENTED_ID, EventType.ISSUE_REOPENED_ID, EventType.ISSUE_DELETED_ID, EventType.ISSUE_MOVED_ID, EventType.ISSUE_WORKLOGGED_ID, EventType.ISSUE_WORKSTARTED_ID, EventType.ISSUE_WORKSTOPPED_ID, EventType.ISSUE_GENERICEVENT_ID, EventType.ISSUE_COMMENT_EDITED_ID, EventType.ISSUE_WORKLOG_UPDATED_ID, EventType.ISSUE_WORKLOG_DELETED_ID, EventType.ISSUE_COMMENT_DELETED_ID};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public JiraServerNotificationScheme extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull JiraServerNotificationScheme entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/core/project/NotificationSchemeExporter$Companion;", "", "()V", "INVALID_GROUP_REF", "", "ISSUE_ARCHIVED_EVENT_ID", "", "ISSUE_RESTORED_EVENT_ID", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "unsupportedNotifications", "", "Lcom/atlassian/jira/notification/type/NotificationType;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            try {
                nArray[NotificationType.SINGLE_USER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.SINGLE_EMAIL_ADDRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.GROUP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.PROJECT_ROLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.USER_CUSTOM_FIELD_VALUE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.GROUP_CUSTOM_FIELD_VALUE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

