/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.project;

import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.migration.export.core.CloudProductSupportService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.CustomPermissionHolderType;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.export.utils.ExportLoggers;
import com.atlassian.jira.migration.export.utils.SchemeExtensionsKt;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.permission.ApplicationRoleType;
import com.atlassian.migration.jira.classic.permission.PermissionGrant;
import com.atlassian.migration.jira.classic.permission.PermissionHolder;
import com.atlassian.migration.jira.classic.permission.PermissionScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 @2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001@B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u001e\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010'\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010(\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010)\u001a\u00020&H\u0002J\u001a\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u0003H\u0002J\u001e\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u0003H\u0002J*\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u00107\u001a\u0002082\u0006\u00101\u001a\u00020\u0003H\u0002J\u0010\u00109\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010:\u001a\u00020/2\u0006\u0010;\u001a\u00020\u0002H\u0016J\b\u0010<\u001a\u00020\u001fH\u0007J\u0014\u0010=\u001a\u00020!*\u00020>2\u0006\u0010?\u001a\u00020>H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0019R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/atlassian/jira/migration/export/core/project/PermissionSchemeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/permission/PermissionScheme;", "Lcom/atlassian/migration/jira/classic/permission/PermissionScheme;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "entityIdentifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "projectRoleManager", "Lcom/atlassian/jira/security/roles/ProjectRoleManager;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "cloudProductSupportService", "Lcom/atlassian/jira/migration/export/core/CloudProductSupportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/issue/CustomFieldManager;Lcom/atlassian/jira/security/roles/ProjectRoleManager;Lcom/atlassian/jira/migration/export/utils/ExportFilters;Lcom/atlassian/jira/migration/export/core/CloudProductSupportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log$1", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "isPermissionKeySupportedForJsdProduct", "", "supportedProducts", "", "Lcom/atlassian/cmpt/domain/Product;", "permissionKey", "Lcom/atlassian/jira/security/plugin/ProjectPermissionKey;", "isPermissionKeySupportedForJswProduct", "isSupportedPermission", "projectPermissionKey", "mapApplicationRoleType", "Lcom/atlassian/migration/jira/classic/permission/ApplicationRoleType;", "type", "", "mapCustomField", "Lcom/atlassian/migration/base/mri/MRI;", "customFieldId", "scheme", "mapGrants", "", "Lcom/atlassian/migration/jira/classic/permission/PermissionGrant;", "mapHolder", "Lcom/atlassian/migration/jira/classic/permission/PermissionHolder;", "holder", "Lcom/atlassian/jira/permission/PermissionHolder;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "isEqualTo", "Lcom/atlassian/jira/permission/PermissionHolderType;", "other", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPermissionSchemeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/project/PermissionSchemeExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1603#2,9:240\n1855#2:249\n1856#2:251\n1612#2:252\n1#3:250\n1#3:253\n*S KotlinDebug\n*F\n+ 1 PermissionSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/project/PermissionSchemeExporter\n*L\n93#1:240,9\n93#1:249\n93#1:251\n93#1:252\n93#1:250\n*E\n"})
public final class PermissionSchemeExporter
implements Exporter<Long, com.atlassian.jira.permission.PermissionScheme, PermissionScheme> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EntityIdentifierGenerator entityIdentifierGenerator;
    @NotNull
    private final CustomFieldManager customFieldManager;
    @NotNull
    private final ProjectRoleManager projectRoleManager;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final CloudProductSupportService cloudProductSupportService;
    private final Logger log$1;
    @NotNull
    private final ExporterKey key;
    @NotNull
    private static final CustomPermissionHolderType SERVICE_DESK_CUSTOMER_PORTAL_ONLY_HOLDER = new CustomPermissionHolderType("sd.customer.portal.only", null);
    @NotNull
    private static final PermissionHolderType APPLICATION_ROLE_ANYONE;
    private static final Logger log;

    @Inject
    public PermissionSchemeExporter(@NotNull ExportService exportService, @NotNull EntityIdentifierGenerator entityIdentifierGenerator, @NotNull CustomFieldManager customFieldManager, @NotNull ProjectRoleManager projectRoleManager, @NotNull ExportFilters exportFilters, @NotNull CloudProductSupportService cloudProductSupportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)entityIdentifierGenerator, (String)"entityIdentifierGenerator");
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        Intrinsics.checkNotNullParameter((Object)projectRoleManager, (String)"projectRoleManager");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        Intrinsics.checkNotNullParameter((Object)cloudProductSupportService, (String)"cloudProductSupportService");
        this.exportService = exportService;
        this.entityIdentifierGenerator = entityIdentifierGenerator;
        this.customFieldManager = customFieldManager;
        this.projectRoleManager = projectRoleManager;
        this.exportFilters = exportFilters;
        this.cloudProductSupportService = cloudProductSupportService;
        this.log$1 = LoggerFactory.getLogger(PermissionSchemeExporter.class);
        this.key = new ExporterKey(PermissionScheme.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.jira.permission.PermissionScheme.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.jira.permission.PermissionScheme entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(PermissionScheme.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public PermissionScheme exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.permission.PermissionScheme entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), ctx.getExportMode()};
        this.log$1.debug("[MigrationId:{}] Exporting permissionScheme with id {} under exportMode:{}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new PermissionScheme(mRI, string, entity.getDescription(), this.mapGrants(ctx, entity), null, null, 48, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.permission.PermissionScheme entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log$1.debug("Exporting users and groups for jiraPermissionScheme with id {} for migration {} under exportMode {}", objectArray);
        this.mapGrants(ctx, entity);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PermissionGrant> mapGrants(ExportContext ctx, com.atlassian.jira.permission.PermissionScheme scheme) {
        void $this$mapNotNullTo$iv$iv;
        Set<Product> supportedProducts = this.cloudProductSupportService.supportedProducts(ctx);
        Collection collection = scheme.getPermissions();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPermissions(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PermissionGrant permissionGrant;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            com.atlassian.jira.permission.PermissionGrant grant = (com.atlassian.jira.permission.PermissionGrant)element$iv$iv;
            boolean bl2 = false;
            ProjectPermissionKey projectPermissionKey = grant.getPermission();
            Intrinsics.checkNotNullExpressionValue((Object)projectPermissionKey, (String)"getPermission(...)");
            if (this.isSupportedPermission(supportedProducts, projectPermissionKey)) {
                ProjectPermissionKey projectPermissionKey2 = grant.getPermission();
                Intrinsics.checkNotNullExpressionValue((Object)projectPermissionKey2, (String)"getPermission(...)");
                com.atlassian.jira.permission.PermissionHolder permissionHolder = grant.getHolder();
                Intrinsics.checkNotNullExpressionValue((Object)permissionHolder, (String)"getHolder(...)");
                if (this.mapHolder(ctx, projectPermissionKey2, permissionHolder, scheme) != null) {
                    PermissionHolder it;
                    boolean bl3 = false;
                    String string = grant.getPermission().permissionKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"permissionKey(...)");
                    permissionGrant = new PermissionGrant(it, string);
                } else {
                    permissionGrant = null;
                }
            } else {
                Logger logger2 = this.log$1;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
                ProjectPermissionKey projectPermissionKey3 = grant.getPermission();
                Intrinsics.checkNotNullExpressionValue((Object)projectPermissionKey3, (String)"getPermission(...)");
                ExportLoggers.INSTANCE.logUnsupportedPermissions(logger2, projectPermissionKey3, "is referenced in permission scheme \"" + scheme.getName() + "\" (" + scheme.getId() + ')');
                permissionGrant = null;
            }
            if (permissionGrant == null) continue;
            PermissionGrant it$iv$iv = permissionGrant;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PermissionHolder mapHolder(ExportContext ctx, ProjectPermissionKey permissionKey, com.atlassian.jira.permission.PermissionHolder holder, com.atlassian.jira.permission.PermissionScheme scheme) {
        PermissionHolder permissionHolder;
        PermissionHolderType $this$mapHolder_u24lambda_u2410 = holder.getType();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$mapHolder_u24lambda_u2410);
        if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.ANYONE)) {
            permissionHolder = (PermissionHolder)new PermissionHolder.Anyone();
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.ASSIGNEE)) {
            permissionHolder = (PermissionHolder)new PermissionHolder.Assignee();
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.PROJECT_LEAD)) {
            permissionHolder = (PermissionHolder)new PermissionHolder.ProjectLead();
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.REPORTER)) {
            permissionHolder = (PermissionHolder)new PermissionHolder.Reporter();
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.USER)) {
            PermissionHolder.User user;
            UserRef userRef = UserRef.Companion.fromString(SchemeExtensionsKt.accessParameter(holder));
            if (userRef != null) {
                UserRef it = userRef;
                boolean bl2 = false;
                user = new PermissionHolder.User(this.exportService.userRef(ctx, it));
            } else {
                user = null;
            }
            permissionHolder = (PermissionHolder)user;
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.GROUP)) {
            PermissionHolder.Group group;
            String string = SchemeExtensionsKt.accessParameter(holder);
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                GroupRefModel groupRef = new GroupRefModel(it, "Permission Scheme [" + scheme.getName() + ']', String.valueOf(scheme.getId()));
                MRI mRI = this.exportService.groupRefSkipInvalid(ctx, groupRef);
                if (mRI != null) {
                    MRI group2 = mRI;
                    boolean bl4 = false;
                    group = new PermissionHolder.Group(group2);
                } else {
                    group = null;
                }
            } else {
                group = null;
            }
            permissionHolder = (PermissionHolder)group;
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.PROJECT_ROLE)) {
            PermissionHolder.ProjectRole projectRole;
            String string = SchemeExtensionsKt.accessParameter(holder);
            if (string != null) {
                String it = string;
                boolean bl5 = false;
                projectRole = new PermissionHolder.ProjectRole(ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, this.projectRoleManager.getProjectRole(Long.valueOf(Long.parseLong(it))), false, 4, null));
            } else {
                projectRole = null;
            }
            permissionHolder = (PermissionHolder)projectRole;
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.USER_CUSTOM_FIELD)) {
            PermissionHolder.UserCustomField userCustomField;
            String string = SchemeExtensionsKt.accessParameter(holder);
            if (string != null) {
                String customField = string;
                boolean bl6 = false;
                MRI mRI = this.mapCustomField(ctx, customField, scheme);
                if (mRI != null) {
                    MRI it = mRI;
                    boolean bl7 = false;
                    userCustomField = new PermissionHolder.UserCustomField(it);
                } else {
                    userCustomField = null;
                }
            } else {
                userCustomField = null;
            }
            permissionHolder = (PermissionHolder)userCustomField;
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.APPLICATION_ROLE) || this.isEqualTo($this$mapHolder_u24lambda_u2410, APPLICATION_ROLE_ANYONE)) {
            permissionHolder = (PermissionHolder)new PermissionHolder.ApplicationRole(this.mapApplicationRoleType(SchemeExtensionsKt.accessParameter(holder), scheme));
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, SERVICE_DESK_CUSTOMER_PORTAL_ONLY_HOLDER)) {
            permissionHolder = (PermissionHolder)new PermissionHolder.ServiceDeskCustomerPortalOnly();
        } else if (this.isEqualTo($this$mapHolder_u24lambda_u2410, (PermissionHolderType)JiraPermissionHolderType.GROUP_CUSTOM_FIELD)) {
            PermissionHolder.GroupCustomField groupCustomField;
            String string = SchemeExtensionsKt.accessParameter(holder);
            if (string != null) {
                String customField = string;
                boolean bl8 = false;
                MRI mRI = this.mapCustomField(ctx, customField, scheme);
                if (mRI != null) {
                    MRI it = mRI;
                    boolean bl9 = false;
                    groupCustomField = new PermissionHolder.GroupCustomField(it);
                } else {
                    groupCustomField = null;
                }
            } else {
                groupCustomField = null;
            }
            permissionHolder = (PermissionHolder)groupCustomField;
        } else {
            MRI mRI = this.mriForEntity(scheme);
            StringBuilder stringBuilder = new StringBuilder().append("Permission holder '").append(holder.getType().getKey()).append("' is not supported for ");
            String string = permissionKey.permissionKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"permissionKey(...)");
            String string2 = stringBuilder.append(this.entityIdentifierGenerator.generate("Permission Key", (Object)permissionKey, string)).append(" on ").append(EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, this.mriForEntity(scheme), scheme, null, 4, null)).append(' ').toString();
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_PERMISSION_SCHEME_PERMISSION_HOLDER_UNSUPPORTED;
            throw new ExportException(mRI, exportErrorCode, string2, null, null, null, null, 120, null);
        }
        return permissionHolder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MRI mapCustomField(ExportContext ctx, String customFieldId, com.atlassian.jira.permission.PermissionScheme scheme) {
        CustomField customField;
        CustomField customField2;
        CustomField it = customField2 = this.customFieldManager.getCustomFieldObject(customFieldId);
        boolean bl = false;
        if (it == null) {
            this.log$1.warn("PermissionScheme " + scheme.getName() + '(' + scheme.getId() + ") has reference to field " + customFieldId + " which cannot be found my CustomFieldManager. Skipping...");
        }
        CustomField customField3 = customField2;
        if (customField3 == null) return null;
        CustomField it2 = customField = customField3;
        boolean bl2 = false;
        if (!this.exportFilters.isSupportedField(ctx, (Field)it2)) return null;
        CustomField customField4 = customField;
        customField2 = customField4;
        if (customField2 == null) return null;
        it2 = customField2;
        boolean bl3 = false;
        MRI mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it2, false, 4, null);
        return mRI;
    }

    /*
     * Unable to fully structure code
     */
    private final ApplicationRoleType mapApplicationRoleType(String type, com.atlassian.jira.permission.PermissionScheme entity) {
        block8: {
            block6: {
                block7: {
                    v0 = var3_3 = type;
                    if (v0 == null) break block6;
                    switch (v0.hashCode()) {
                        case 488515375: {
                            if (var3_3.equals("jira-servicedesk")) break;
                            ** break;
                        }
                        case 645128422: {
                            if (!var3_3.equals("jira-software")) {
                                ** break;
                            }
                            break block7;
                        }
                        case 912696926: {
                            if (!var3_3.equals("jira-core")) ** break;
                            v1 = ApplicationRoleType.CORE;
                            break block8;
                        }
                    }
                    v1 = ApplicationRoleType.SERVICE_DESK;
                    break block8;
                }
                v1 = ApplicationRoleType.SOFTWARE;
                break block8;
            }
            v1 = ApplicationRoleType.ANY;
            break block8;
lbl23:
            // 4 sources

            mri = this.mriForEntity(entity);
            var5_5 = "Application role: " + type + " for " + EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, mri, entity, null, 4, null) + " is not supported";
            var6_6 = ExportErrorCode.PRJ_PERMISSION_SCHEME_APPLICATION_ROLE_TYPE_UNSUPPORTED;
            throw new ExportException(mri, var6_6, var5_5, null, null, null, null, 120, null);
        }
        return v1;
    }

    private final boolean isEqualTo(PermissionHolderType $this$isEqualTo, PermissionHolderType other) {
        return Intrinsics.areEqual((Object)$this$isEqualTo.getKey(), (Object)other.getKey()) && $this$isEqualTo.requiresParameter() == other.requiresParameter();
    }

    private final boolean isSupportedPermission(Set<? extends Product> supportedProducts, ProjectPermissionKey projectPermissionKey) {
        return this.exportFilters.isSupportedProjectPermission(projectPermissionKey) || this.isPermissionKeySupportedForJsdProduct(supportedProducts, projectPermissionKey) || this.isPermissionKeySupportedForJswProduct(supportedProducts, projectPermissionKey);
    }

    private final boolean isPermissionKeySupportedForJsdProduct(Set<? extends Product> supportedProducts, ProjectPermissionKey permissionKey) {
        return supportedProducts.contains(Product.JIRA_SERVICEDESK) && this.exportFilters.isSupportedProjectPermissionForJsd(permissionKey);
    }

    private final boolean isPermissionKeySupportedForJswProduct(Set<? extends Product> supportedProducts, ProjectPermissionKey permissionKey) {
        return supportedProducts.contains(Product.JIRA_SOFTWARE) && this.exportFilters.isSupportedProjectPermissionForJsw(permissionKey);
    }

    @Override
    @Nullable
    public com.atlassian.jira.permission.PermissionScheme extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.permission.PermissionScheme entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    static {
        String string = JiraPermissionHolderType.APPLICATION_ROLE.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        APPLICATION_ROLE_ANYONE = new CustomPermissionHolderType(string, null);
        log = LoggerFactory.getLogger(PermissionSchemeExporter.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/export/core/project/PermissionSchemeExporter$Companion;", "", "()V", "APPLICATION_ROLE_ANYONE", "Lcom/atlassian/jira/permission/PermissionHolderType;", "SERVICE_DESK_CUSTOMER_PORTAL_ONLY_HOLDER", "Lcom/atlassian/jira/migration/export/utils/CustomPermissionHolderType;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

