/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.project;

import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.PrioritySchemeWrapper;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.PriorityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/export/core/project/PrioritySchemeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/utils/PrioritySchemeWrapper;", "Lcom/atlassian/migration/jira/core/PriorityScheme;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "prioritySchemeManager", "Lcom/atlassian/jira/issue/fields/config/manager/PrioritySchemeManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/issue/fields/config/manager/PrioritySchemeManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPrioritySchemeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrioritySchemeExporter.kt\ncom/atlassian/jira/migration/export/core/project/PrioritySchemeExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1#2:60\n1549#3:61\n1620#3,3:62\n*S KotlinDebug\n*F\n+ 1 PrioritySchemeExporter.kt\ncom/atlassian/jira/migration/export/core/project/PrioritySchemeExporter\n*L\n54#1:61\n54#1:62,3\n*E\n"})
public final class PrioritySchemeExporter
implements Exporter<Long, PrioritySchemeWrapper, PriorityScheme> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final PrioritySchemeManager prioritySchemeManager;
    private final Logger log;

    @Inject
    public PrioritySchemeExporter(@NotNull ExportService exportService, @NotNull PrioritySchemeManager prioritySchemeManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)prioritySchemeManager, (String)"prioritySchemeManager");
        this.exportService = exportService;
        this.prioritySchemeManager = prioritySchemeManager;
        this.log = LoggerFactory.getLogger(PrioritySchemeExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, PrioritySchemeWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(PriorityScheme.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull PrioritySchemeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getFieldConfigScheme().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(PriorityScheme.Companion.getEntityType(), entityKey, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PriorityScheme exportData(@NotNull ExportContext ctx, @NotNull PrioritySchemeWrapper entity) {
        Collection<MRI> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        MRI mRI;
        MRI mRI2;
        MRI mRI3;
        String string;
        String string2;
        Priority priority;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        FieldConfigScheme fieldConfigScheme = entity.getFieldConfigScheme();
        FieldConfig fieldConfig = this.prioritySchemeManager.getFieldConfigForDefaultMapping(fieldConfigScheme);
        Collection collection2 = this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions(fieldConfig));
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getPrioritiesFromIds(...)");
        List priorities = CollectionsKt.toList((Iterable)collection2);
        String string3 = this.prioritySchemeManager.getDefaultOption(fieldConfig);
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            priority = this.prioritySchemeManager.getPriority(it);
        } else {
            priority = null;
        }
        Priority defaultPriority = priority;
        Object object = new Object[]{ctx.getMigrationId(), entity.getFieldConfigScheme().getId(), ctx.getExportMode()};
        this.log.debug("[MigrationId:{}] Exporting priorityScheme with id {} under exportMode:{}", object);
        MRI mRI4 = this.mriForEntity(entity);
        String string4 = fieldConfigScheme.getName();
        String string5 = string4;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        String string6 = fieldConfigScheme.getDescription();
        Priority priority2 = defaultPriority;
        if (priority2 != null) {
            void it;
            Priority priority3 = priority2;
            string2 = string6;
            string = string5;
            mRI3 = mRI4;
            boolean bl = false;
            mRI2 = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
            mRI4 = mRI3;
            string5 = string;
            string6 = string2;
            mRI = mRI2;
        } else {
            mRI = null;
        }
        object = priorities;
        mRI2 = mRI;
        string2 = string6;
        string = string5;
        mRI3 = mRI4;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void priority4;
            Priority priority5 = (Priority)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, priority4, false, 4, null));
        }
        collection = (List)destination$iv$iv;
        boolean bl3 = this.prioritySchemeManager.isDefaultScheme(fieldConfigScheme);
        Collection<MRI> collection3 = collection;
        MRI mRI5 = mRI2;
        String string7 = string2;
        String string8 = string;
        MRI mRI6 = mRI3;
        return new PriorityScheme(mRI6, string8, string7, mRI5, collection3, bl3);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull PrioritySchemeWrapper entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public PrioritySchemeWrapper extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull PrioritySchemeWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

