/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.project;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.Project;
import com.atlassian.migration.jira.core.ProjectComponent;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\u0018H\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/export/core/project/ProjectComponentExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/bc/project/component/ProjectComponent;", "Lcom/atlassian/migration/jira/core/ProjectComponent;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "identifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "projectComponentManager", "Lcom/atlassian/jira/bc/project/component/ProjectComponentManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/bc/project/component/ProjectComponentManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "extractServerEntity", "entityKey", "mapComponentAssigneeType", "Lcom/atlassian/migration/jira/core/ProjectComponent$AssigneeType;", "mapLead", "Lcom/atlassian/migration/base/mri/MRI;", "mriForEntity", "mriForKey", "postConstruct", "projectComponentNameCheck", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectComponentExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectComponentExporter.kt\ncom/atlassian/jira/migration/export/core/project/ProjectComponentExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class ProjectComponentExporter
implements Exporter<Long, ProjectComponent, com.atlassian.migration.jira.core.ProjectComponent> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EntityIdentifierGenerator identifierGenerator;
    @NotNull
    private final ProjectComponentManager projectComponentManager;
    private final Logger log;
    @NotNull
    private final ExporterKey key;

    @Inject
    public ProjectComponentExporter(@NotNull ExportService exportService, @NotNull EntityIdentifierGenerator identifierGenerator, @NotNull ProjectComponentManager projectComponentManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)identifierGenerator, (String)"identifierGenerator");
        Intrinsics.checkNotNullParameter((Object)projectComponentManager, (String)"projectComponentManager");
        this.exportService = exportService;
        this.identifierGenerator = identifierGenerator;
        this.projectComponentManager = projectComponentManager;
        this.log = LoggerFactory.getLogger(ProjectComponentExporter.class);
        this.key = new ExporterKey(com.atlassian.migration.jira.core.ProjectComponent.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ProjectComponent.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ProjectComponent entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.core.ProjectComponent.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public com.atlassian.migration.jira.core.ProjectComponent exportData(@NotNull ExportContext ctx, @NotNull ProjectComponent entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), entity.getProjectId(), ctx.getExportMode()};
        this.log.debug("[MigrationId:{}] Exporting projectComponent with id {} for projectId {} under exportMode:{}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        String string = this.projectComponentNameCheck(entity);
        String string2 = entity.getDescription();
        EntityType entityType = Project.Companion.getEntityType();
        Long l = entity.getProjectId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getProjectId(...)");
        return new com.atlassian.migration.jira.core.ProjectComponent(mRI, string, string2, MriExtensionsKt.mri$default(entityType, l, null, 2, null), this.mapLead(ctx, entity), this.mapComponentAssigneeType(entity));
    }

    @Override
    @Nullable
    public ProjectComponent extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this.projectComponentManager.getProjectComponent(Long.valueOf(entityKey));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ProjectComponent entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for projectComponent with id {} for migration {} under exportMode {}", objectArray);
        this.mapLead(ctx, entity);
    }

    private final MRI mapLead(ExportContext ctx, ProjectComponent entity) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(entity.getLead());
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final String projectComponentNameCheck(ProjectComponent entity) {
        CharSequence charSequence = entity.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = this.mriForEntity(entity);
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_COMPONENT_NAME_BLANK_EMPTY_NULL;
            throw new ExportException((MRI)charSequence, exportErrorCode, "Project component name cannot be empty or null", null, null, null, null, 120, null);
        }
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private final ProjectComponent.AssigneeType mapComponentAssigneeType(ProjectComponent entity) {
        ProjectComponent.AssigneeType assigneeType;
        long l = entity.getAssigneeType();
        if (l == 1L) {
            assigneeType = ProjectComponent.AssigneeType.COMPONENT_LEAD;
        } else if (l == 2L) {
            assigneeType = ProjectComponent.AssigneeType.PROJECT_LEAD;
        } else if (l == 0L) {
            assigneeType = ProjectComponent.AssigneeType.PROJECT_DEFAULT;
        } else if (l == 3L) {
            assigneeType = ProjectComponent.AssigneeType.UNASSIGNED;
        } else {
            MRI mRI = this.mriForEntity(entity);
            String string = "Project component assignee type: " + entity.getAssigneeType() + " for " + EntityIdentifierGenerator.generate$default(this.identifierGenerator, this.mriForEntity(entity), entity, null, 4, null) + " is not supported";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_COMPONENT_ASSIGNEE_TYPE_UNSUPPORTED;
            throw new ExportException(mRI, exportErrorCode, string, null, null, null, null, 120, null);
        }
        return assigneeType;
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ProjectComponent entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

