/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.project;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.datafilters.service.DataFilterService;
import com.atlassian.jira.migration.datafilters.utils.DataFiltersUtil;
import com.atlassian.jira.migration.events.DataFilterExportStatsEvent;
import com.atlassian.jira.migration.events.EntityType;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.core.entityProperty.service.EntityPropertyExportService;
import com.atlassian.jira.migration.export.core.fieldlayout.FieldConfigurationSchemeWrapper;
import com.atlassian.jira.migration.export.core.filter.service.FilterExportService;
import com.atlassian.jira.migration.export.core.issue.IssueChildrenExportService;
import com.atlassian.jira.migration.export.core.project.ProjectExporter;
import com.atlassian.jira.migration.export.core.project.ProjectRoleAssociationWrapper;
import com.atlassian.jira.migration.export.core.serviceconfig.service.ServiceConfigService;
import com.atlassian.jira.migration.export.core.workflow.WorkflowSchemeWrapper;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.jira.migration.export.dbexport.ChangeHistoryDirectExport;
import com.atlassian.jira.migration.export.directexport.DirectExportFacade;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.IncrementalMigrationContext;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.service.JsdExportService;
import com.atlassian.jira.migration.export.software.service.JswExportService;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import com.atlassian.jira.migration.export.utils.PrioritySchemeWrapper;
import com.atlassian.jira.migration.export.utils.SchemeExtensionsKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.migration.MigrationIncrement;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.preflight.entitycache.PreflightEntityCachePersistenceManager;
import com.atlassian.jira.migration.preflight.entitycache.ProjectExportPreflightCheckResult;
import com.atlassian.jira.migration.preflight.reports.ProblemType;
import com.atlassian.jira.migration.utils.IssueTypeSchemeManagerCache;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.migration.api.CloudId;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.app.dto.AppContainerDetails;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.core.text.TextDocument;
import com.atlassian.migration.jira.classic.DefaultAssigneeType;
import com.atlassian.migration.jira.classic.ProjectStatus;
import com.atlassian.migration.jira.classic.ProjectTypeKey;
import com.atlassian.migration.jira.classic.issuetype.IssueTypeScheme;
import com.atlassian.migration.jira.classic.screen.IssueTypeScreenScheme;
import com.atlassian.migration.jira.classic.workflow.WorkflowScheme;
import com.atlassian.migration.jira.core.PriorityScheme;
import com.atlassian.migration.jira.core.background.Background;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.module.propertyset.PropertySet;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00de\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u009a\u00012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\u009a\u0001B\u00ff\u0001\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010!\u001a\u00020\"\u0012\u0006\u0010#\u001a\u00020$\u0012\u0006\u0010%\u001a\u00020&\u0012\u0006\u0010'\u001a\u00020(\u0012\u0006\u0010)\u001a\u00020*\u0012\u0006\u0010+\u001a\u00020,\u0012\u0006\u0010-\u001a\u00020.\u0012\u0006\u0010/\u001a\u000200\u0012\u0006\u00101\u001a\u000202\u0012\u0006\u00103\u001a\u000204\u0012\u0006\u00105\u001a\u000206\u0012\u0006\u00107\u001a\u000208\u0012\u0006\u00109\u001a\u00020:\u0012\u0006\u0010;\u001a\u00020<\u0012\u0006\u0010=\u001a\u00020>\u0012\u0006\u0010?\u001a\u00020@\u0012\u0006\u0010A\u001a\u00020B\u00a2\u0006\u0002\u0010CJ$\u0010P\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020S0R0Q2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0016J\u0018\u0010W\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J\u0018\u0010Y\u001a\u00020\u00042\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0016J\u0018\u0010Z\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J\u0018\u0010[\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J\u0018\u0010\\\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J\u0018\u0010]\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J\u0018\u0010^\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J\u0018\u0010_\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J\u0018\u0010`\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J\u0018\u0010a\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0016J$\u0010b\u001a\b\u0012\u0004\u0012\u00020F0c2\u0006\u0010T\u001a\u00020U2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020F0cH\u0002J,\u0010e\u001a\b\u0012\u0004\u0012\u00020F0c2\u0006\u0010T\u001a\u00020U2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020F0c2\u0006\u0010f\u001a\u00020gH\u0002J\u0016\u0010h\u001a\b\u0012\u0004\u0012\u00020j0i2\u0006\u0010T\u001a\u00020UH\u0002J$\u0010k\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020Q0c2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J\u0016\u0010l\u001a\u00020m2\u0006\u0010T\u001a\u00020U2\u0006\u0010n\u001a\u00020mJ\u0018\u0010o\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0002J\u0010\u0010p\u001a\u00020G2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010q\u001a\u00020G2\u0006\u0010r\u001a\u00020sH\u0002J\u001a\u0010t\u001a\u0004\u0018\u00010u2\u0006\u0010T\u001a\u00020U2\u0006\u0010v\u001a\u00020\u0003H\u0007J\u0012\u0010w\u001a\u0004\u0018\u00010x2\u0006\u0010v\u001a\u00020\u0003H\u0007J\u0017\u0010y\u001a\u00020z2\b\u0010{\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0002\u0010|J\u001a\u0010}\u001a\u0004\u0018\u00010~2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0002J\u001a\u0010\u007f\u001a\u0004\u0018\u00010u2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0002J\u001b\u0010\u0080\u0001\u001a\u0004\u0018\u00010u2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0002J\u0019\u0010\u0081\u0001\u001a\u00020u2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0002J\u0019\u0010\u0082\u0001\u001a\u00020u2\u0006\u0010T\u001a\u00020U2\u0006\u0010v\u001a\u00020\u0003H\u0002J\u0019\u0010\u0083\u0001\u001a\u00020u2\u0006\u0010T\u001a\u00020U2\u0006\u0010v\u001a\u00020\u0003H\u0002J\u001b\u0010\u0084\u0001\u001a\u0004\u0018\u00010u2\u0006\u0010T\u001a\u00020U2\u0006\u0010v\u001a\u00020\u0003H\u0002J\u0012\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010v\u001a\u00020\u0003H\u0002J\u0019\u0010\u0087\u0001\u001a\u00020u2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0002J\u001c\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\u0006\u0010v\u001a\u00020\u00032\u0006\u0010T\u001a\u00020UH\u0007J\u0019\u0010\u008a\u0001\u001a\u00020u2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0002J\u0011\u0010\u008b\u0001\u001a\u00020u2\u0006\u0010V\u001a\u00020\u0003H\u0016J\u0012\u0010\u008c\u0001\u001a\u00020u2\u0007\u0010\u008d\u0001\u001a\u00020\u0002H\u0016J\t\u0010\u008e\u0001\u001a\u00020SH\u0007J%\u0010\u008f\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020Q0c2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J%\u0010\u0090\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020Q0c2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\u0003H\u0002J6\u0010\u0091\u0001\u001a\u00020S2\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0007\u0010\u0094\u0001\u001a\u00020m2\u0007\u0010\u0095\u0001\u001a\u00020m2\u0006\u0010f\u001a\u00020g2\u0007\u0010\u0096\u0001\u001a\u00020gH\u0002J\u0011\u0010\u0097\u0001\u001a\u00020G2\u0006\u0010T\u001a\u00020UH\u0002J\u0011\u0010\u0098\u0001\u001a\u00020G2\u0006\u0010T\u001a\u00020UH\u0002J\u0011\u0010\u0099\u0001\u001a\u00020G2\u0006\u0010T\u001a\u00020UH\u0002R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010D\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020G0E8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bH\u0010IR\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010L\u001a\u00020MX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009b\u0001"}, d2={"Lcom/atlassian/jira/migration/export/core/project/ProjectExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/project/Project;", "Lcom/atlassian/migration/jira/classic/Project;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "entityIdentifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "issueTypeSchemeManagerCache", "Lcom/atlassian/jira/migration/utils/IssueTypeSchemeManagerCache;", "prioritySchemeManager", "Lcom/atlassian/jira/issue/fields/config/manager/PrioritySchemeManager;", "issueTypeScreenSchemeManager", "Lcom/atlassian/jira/issue/fields/screen/issuetype/IssueTypeScreenSchemeManager;", "workflowSchemeManager", "Lcom/atlassian/jira/workflow/WorkflowSchemeManager;", "fieldLayoutManager", "Lcom/atlassian/jira/issue/fields/layout/field/FieldLayoutManager;", "projectRoleManager", "Lcom/atlassian/jira/security/roles/ProjectRoleManager;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "issueSecuritySchemeManager", "Lcom/atlassian/jira/issue/security/IssueSecuritySchemeManager;", "permissionSchemeManager", "Lcom/atlassian/jira/permission/PermissionSchemeManager;", "notificationSchemeManager", "Lcom/atlassian/jira/notification/NotificationSchemeManager;", "jswExportService", "Lcom/atlassian/jira/migration/export/software/service/JswExportService;", "jiraIssueReader", "Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;", "projectPropertiesManager", "Lcom/atlassian/jira/project/ProjectPropertiesManager;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "jsdExportService", "Lcom/atlassian/jira/migration/export/servicedesk/service/JsdExportService;", "jsdExportUtil", "Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;", "filterExportService", "Lcom/atlassian/jira/migration/export/core/filter/service/FilterExportService;", "serviceConfigService", "Lcom/atlassian/jira/migration/export/core/serviceconfig/service/ServiceConfigService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "issueChildrenExportService", "Lcom/atlassian/jira/migration/export/core/issue/IssueChildrenExportService;", "preflightEntityCachePersistenceManager", "Lcom/atlassian/jira/migration/preflight/entitycache/PreflightEntityCachePersistenceManager;", "changeHistoryDirectExport", "Lcom/atlassian/jira/migration/export/dbexport/ChangeHistoryDirectExport;", "entityPropertyExportService", "Lcom/atlassian/jira/migration/export/core/entityProperty/service/EntityPropertyExportService;", "directExportFacade", "Lcom/atlassian/jira/migration/export/directexport/DirectExportFacade;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "dataFilterService", "Lcom/atlassian/jira/migration/datafilters/service/DataFilterService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/migration/utils/IssueTypeSchemeManagerCache;Lcom/atlassian/jira/issue/fields/config/manager/PrioritySchemeManager;Lcom/atlassian/jira/issue/fields/screen/issuetype/IssueTypeScreenSchemeManager;Lcom/atlassian/jira/workflow/WorkflowSchemeManager;Lcom/atlassian/jira/issue/fields/layout/field/FieldLayoutManager;Lcom/atlassian/jira/security/roles/ProjectRoleManager;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/issue/security/IssueSecuritySchemeManager;Lcom/atlassian/jira/permission/PermissionSchemeManager;Lcom/atlassian/jira/notification/NotificationSchemeManager;Lcom/atlassian/jira/migration/export/software/service/JswExportService;Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;Lcom/atlassian/jira/project/ProjectPropertiesManager;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/export/servicedesk/service/JsdExportService;Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;Lcom/atlassian/jira/migration/export/core/filter/service/FilterExportService;Lcom/atlassian/jira/migration/export/core/serviceconfig/service/ServiceConfigService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/export/core/issue/IssueChildrenExportService;Lcom/atlassian/jira/migration/preflight/entitycache/PreflightEntityCachePersistenceManager;Lcom/atlassian/jira/migration/export/dbexport/ChangeHistoryDirectExport;Lcom/atlassian/jira/migration/export/core/entityProperty/service/EntityPropertyExportService;Lcom/atlassian/jira/migration/export/directexport/DirectExportFacade;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/datafilters/service/DataFilterService;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "hasArchived", "Lkotlin/Function1;", "Lcom/atlassian/jira/issue/Issue;", "", "getHasArchived", "()Lkotlin/jvm/functions/Function1;", "hasArchived$delegate", "Lkotlin/Lazy;", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "clearProjectExportCacheIfExpired", "jiraProject", "exportData", "exportIssues", "exportIssuesParallel", "exportIssuesSequential", "exportProjectComponents", "exportProjectRoles", "exportProjectVersions", "exportServiceDesk", "exportUsersAndGroups", "filterArchivedIssues", "Lkotlin/sequences/Sequence;", "issues", "filterIssues", "projectKey", "", "getAppContainers", "", "Lcom/atlassian/migration/app/dto/AppContainerDetails;", "getIssueIdsAsSequence", "getIssueParallelThreadPoolSize", "", "processorCount", "handleIssues", "isConfigOnlyExport", "isPrioritySchemePrioritiesNotEmpty", "prioritySchemeWrapper", "Lcom/atlassian/jira/migration/export/utils/PrioritySchemeWrapper;", "mapArchivedBy", "Lcom/atlassian/migration/base/mri/MRI;", "project", "mapArchivedDate", "Ljava/time/Instant;", "mapDefaultAssigneeType", "Lcom/atlassian/migration/jira/classic/DefaultAssigneeType;", "type", "(Ljava/lang/Long;)Lcom/atlassian/migration/jira/classic/DefaultAssigneeType;", "mapDescription", "Lcom/atlassian/migration/core/text/TextDocument$Wiki;", "mapFieldLayoutScheme", "mapIssueSecurityScheme", "mapIssueTypeScreenScheme", "mapNotificationSchemeOrDefault", "mapPermissionSchemeOrDefault", "mapPriorityScheme", "mapProjectKey", "Lcom/atlassian/migration/jira/classic/ProjectTypeKey;", "mapProjectLead", "mapProjectStatus", "Lcom/atlassian/migration/jira/classic/ProjectStatus;", "mapWorkflowScheme", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "processProjectExportCache", "processScopedUserCache", "sendFilteredIssueMetrics", "migrationTaskMetadata", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "totalCount", "filteredCount", "entityType", "shouldExportIssuesInParallel", "shouldUseProjectExportCache", "shouldUseScopedUserCache", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectExporter.kt\ncom/atlassian/jira/migration/export/core/project/ProjectExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,743:1\n1#2:744\n1855#3,2:745\n1855#3,2:747\n1313#4,2:749\n1313#4,2:759\n1313#4:761\n1314#4:768\n215#5,2:751\n17#6,6:753\n17#6,6:762\n17#6,6:769\n*S KotlinDebug\n*F\n+ 1 ProjectExporter.kt\ncom/atlassian/jira/migration/export/core/project/ProjectExporter\n*L\n288#1:745,2\n292#1:747,2\n313#1:749,2\n399#1:759,2\n440#1:761\n440#1:768\n344#1:751,2\n353#1:753,6\n446#1:762,6\n411#1:769,6\n*E\n"})
public final class ProjectExporter
implements Exporter<Long, Project, com.atlassian.migration.jira.classic.Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EntityIdentifierGenerator entityIdentifierGenerator;
    @NotNull
    private final IssueTypeSchemeManagerCache issueTypeSchemeManagerCache;
    @NotNull
    private final PrioritySchemeManager prioritySchemeManager;
    @NotNull
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    @NotNull
    private final WorkflowSchemeManager workflowSchemeManager;
    @NotNull
    private final FieldLayoutManager fieldLayoutManager;
    @NotNull
    private final ProjectRoleManager projectRoleManager;
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    @NotNull
    private final PermissionSchemeManager permissionSchemeManager;
    @NotNull
    private final NotificationSchemeManager notificationSchemeManager;
    @NotNull
    private final JswExportService jswExportService;
    @NotNull
    private final JiraIssueReader jiraIssueReader;
    @NotNull
    private final ProjectPropertiesManager projectPropertiesManager;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final JsdExportService jsdExportService;
    @NotNull
    private final JsdExportUtil jsdExportUtil;
    @NotNull
    private final FilterExportService filterExportService;
    @NotNull
    private final ServiceConfigService serviceConfigService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final IssueChildrenExportService issueChildrenExportService;
    @NotNull
    private final PreflightEntityCachePersistenceManager preflightEntityCachePersistenceManager;
    @NotNull
    private final ChangeHistoryDirectExport changeHistoryDirectExport;
    @NotNull
    private final EntityPropertyExportService entityPropertyExportService;
    @NotNull
    private final DirectExportFacade directExportFacade;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final DataFilterService dataFilterService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final ExporterKey key;
    @NotNull
    private final Lazy hasArchived$delegate;
    private static final Logger log = LoggerFactory.getLogger(ProjectExporter.class);
    private static final int DEFAULT_THREAD_COUNT = 2;
    private static final int PARALLEL_ISSUE_THREADPOOL_SIZE_EIGHT = 8;
    private static final long SEMAPHORE_ACQUIRE_TIMEOUT = 5L;
    private static final int SEMAPHORE_THREADPOOL_MULTIPLIER = 3;
    private static final long EXECUTOR_TERMINATION_TIMEOUT = 60L;
    private static final long CHILDREN_EXPORT_THRESHOLD_ISSUE_COUNT = 1000L;
    private static final long PROJECT_EXPORT_PREFLIGHT_HARD_REFRESH_TTL_IN_MILLIS = 2592000000L;

    @Inject
    public ProjectExporter(@NotNull ExportService exportService, @NotNull EntityIdentifierGenerator entityIdentifierGenerator, @NotNull IssueTypeSchemeManagerCache issueTypeSchemeManagerCache, @NotNull PrioritySchemeManager prioritySchemeManager, @NotNull IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, @NotNull WorkflowSchemeManager workflowSchemeManager, @NotNull FieldLayoutManager fieldLayoutManager, @NotNull ProjectRoleManager projectRoleManager, @NotNull IssueManager issueManager, @NotNull IssueSecuritySchemeManager issueSecuritySchemeManager, @NotNull PermissionSchemeManager permissionSchemeManager, @NotNull NotificationSchemeManager notificationSchemeManager, @NotNull JswExportService jswExportService, @NotNull JiraIssueReader jiraIssueReader, @NotNull ProjectPropertiesManager projectPropertiesManager, @NotNull UserManager userManager, @NotNull ProjectManager projectManager, @NotNull JsdExportService jsdExportService, @NotNull JsdExportUtil jsdExportUtil, @NotNull FilterExportService filterExportService, @NotNull ServiceConfigService serviceConfigService, @NotNull MigrationFeatures migrationFeatures, @NotNull MetricsEventService metricsEventService, @NotNull IssueChildrenExportService issueChildrenExportService, @NotNull PreflightEntityCachePersistenceManager preflightEntityCachePersistenceManager, @NotNull ChangeHistoryDirectExport changeHistoryDirectExport, @NotNull EntityPropertyExportService entityPropertyExportService, @NotNull DirectExportFacade directExportFacade, @NotNull PlatformService platformService, @NotNull DataFilterService dataFilterService, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)entityIdentifierGenerator, (String)"entityIdentifierGenerator");
        Intrinsics.checkNotNullParameter((Object)issueTypeSchemeManagerCache, (String)"issueTypeSchemeManagerCache");
        Intrinsics.checkNotNullParameter((Object)prioritySchemeManager, (String)"prioritySchemeManager");
        Intrinsics.checkNotNullParameter((Object)issueTypeScreenSchemeManager, (String)"issueTypeScreenSchemeManager");
        Intrinsics.checkNotNullParameter((Object)workflowSchemeManager, (String)"workflowSchemeManager");
        Intrinsics.checkNotNullParameter((Object)fieldLayoutManager, (String)"fieldLayoutManager");
        Intrinsics.checkNotNullParameter((Object)projectRoleManager, (String)"projectRoleManager");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)issueSecuritySchemeManager, (String)"issueSecuritySchemeManager");
        Intrinsics.checkNotNullParameter((Object)permissionSchemeManager, (String)"permissionSchemeManager");
        Intrinsics.checkNotNullParameter((Object)notificationSchemeManager, (String)"notificationSchemeManager");
        Intrinsics.checkNotNullParameter((Object)jswExportService, (String)"jswExportService");
        Intrinsics.checkNotNullParameter((Object)jiraIssueReader, (String)"jiraIssueReader");
        Intrinsics.checkNotNullParameter((Object)projectPropertiesManager, (String)"projectPropertiesManager");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)jsdExportService, (String)"jsdExportService");
        Intrinsics.checkNotNullParameter((Object)jsdExportUtil, (String)"jsdExportUtil");
        Intrinsics.checkNotNullParameter((Object)filterExportService, (String)"filterExportService");
        Intrinsics.checkNotNullParameter((Object)serviceConfigService, (String)"serviceConfigService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)issueChildrenExportService, (String)"issueChildrenExportService");
        Intrinsics.checkNotNullParameter((Object)preflightEntityCachePersistenceManager, (String)"preflightEntityCachePersistenceManager");
        Intrinsics.checkNotNullParameter((Object)changeHistoryDirectExport, (String)"changeHistoryDirectExport");
        Intrinsics.checkNotNullParameter((Object)entityPropertyExportService, (String)"entityPropertyExportService");
        Intrinsics.checkNotNullParameter((Object)directExportFacade, (String)"directExportFacade");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)dataFilterService, (String)"dataFilterService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.exportService = exportService;
        this.entityIdentifierGenerator = entityIdentifierGenerator;
        this.issueTypeSchemeManagerCache = issueTypeSchemeManagerCache;
        this.prioritySchemeManager = prioritySchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.projectRoleManager = projectRoleManager;
        this.issueManager = issueManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.jswExportService = jswExportService;
        this.jiraIssueReader = jiraIssueReader;
        this.projectPropertiesManager = projectPropertiesManager;
        this.userManager = userManager;
        this.projectManager = projectManager;
        this.jsdExportService = jsdExportService;
        this.jsdExportUtil = jsdExportUtil;
        this.filterExportService = filterExportService;
        this.serviceConfigService = serviceConfigService;
        this.migrationFeatures = migrationFeatures;
        this.metricsEventService = metricsEventService;
        this.issueChildrenExportService = issueChildrenExportService;
        this.preflightEntityCachePersistenceManager = preflightEntityCachePersistenceManager;
        this.changeHistoryDirectExport = changeHistoryDirectExport;
        this.entityPropertyExportService = entityPropertyExportService;
        this.directExportFacade = directExportFacade;
        this.platformService = platformService;
        this.dataFilterService = dataFilterService;
        this.migrationEventBus = migrationEventBus;
        this.key = new ExporterKey(com.atlassian.migration.jira.classic.Project.Companion.getEntityType());
        this.hasArchived$delegate = LazyKt.lazy((Function0)hasArchived.2.INSTANCE);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, Project.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull Project entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.classic.Project.Companion.getEntityType(), entityKey, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public com.atlassian.migration.jira.classic.Project exportData(@NotNull ExportContext ctx, @NotNull Project entity) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        log.info("Exporting project \"" + entity.getName() + "\"(" + entity.getKey() + ", " + entity.getId() + ") for id " + ctx.getMigrationId() + " to Cloud as " + ctx.getStartedBy());
        String uniqueProjectIdentifier = DigestUtils.sha256Hex((String)(entity.getKey() + ctx.getMigrationTaskMetadata().getCloudId()));
        Intrinsics.checkNotNull((Object)uniqueProjectIdentifier);
        MetricsEventService.sendEventForProjectExportHit$default(this.metricsEventService, uniqueProjectIdentifier, ctx.getMigrationTaskMetadata().getCloudId(), !this.migrationFeatures.getSkipPreflightReport(), 0.0, 8, null);
        ProjectTypeKey projectType = this.mapProjectKey(entity);
        ctx.setProjectTypeInStats(projectType);
        MRI mRI2 = this.mriForEntity(entity);
        String string = entity.getKey();
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        String string3 = entity.getName();
        String string4 = string3;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        ProjectTypeKey projectTypeKey = projectType;
        MRI mRI3 = this.mapProjectLead(ctx, entity);
        String string5 = null;
        TextDocument textDocument = (TextDocument)this.mapDescription(ctx, entity);
        MRI mRI4 = this.exportService.exportOrNull(ctx, entity.getAvatar());
        ProjectCategory projectCategory = entity.getProjectCategory();
        if (projectCategory != null) {
            void it;
            ProjectCategory projectCategory2 = projectCategory;
            MRI mRI5 = mRI4;
            TextDocument textDocument2 = textDocument;
            String string6 = string5;
            MRI mRI6 = mRI3;
            ProjectTypeKey projectTypeKey2 = projectTypeKey;
            String string7 = string4;
            String string8 = string2;
            MRI mRI7 = mRI2;
            boolean bl = false;
            MRI mRI8 = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
            mRI2 = mRI7;
            string2 = string8;
            string4 = string7;
            projectTypeKey = projectTypeKey2;
            mRI3 = mRI6;
            string5 = string6;
            textDocument = textDocument2;
            mRI4 = mRI5;
            mRI = mRI8;
        } else {
            mRI = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 0x800000;
        Background background = null;
        MRI mRI9 = null;
        Set set = this.projectManager.getAllProjectKeys(entity.getId());
        Instant instant = this.mapArchivedDate(entity);
        MRI mRI10 = this.mapArchivedBy(ctx, entity);
        ProjectStatus projectStatus = this.mapProjectStatus(entity, ctx);
        DefaultAssigneeType defaultAssigneeType = this.mapDefaultAssigneeType(entity.getAssigneeType());
        MRI mRI11 = this.mapPriorityScheme(ctx, entity);
        MRI mRI12 = this.mapNotificationSchemeOrDefault(ctx, entity);
        MRI mRI13 = this.mapPermissionSchemeOrDefault(ctx, entity);
        MRI mRI14 = this.mapIssueSecurityScheme(ctx, entity);
        MRI mRI15 = this.mapFieldLayoutScheme(ctx, entity);
        MRI mRI16 = this.mapWorkflowScheme(ctx, entity);
        MRI mRI17 = this.mapIssueTypeScreenScheme(ctx, entity);
        MRI mRI18 = this.exportService.exportOrDefault(ctx, this.issueTypeSchemeManagerCache.getConfigScheme(entity), MriExtensionsKt.mri$default(IssueTypeScheme.Companion.getEntityType(), "10000", null, 2, null));
        MRI mRI19 = mRI;
        MRI mRI20 = mRI4;
        TextDocument textDocument3 = textDocument;
        String string9 = string5;
        MRI mRI21 = mRI3;
        ProjectTypeKey projectTypeKey3 = projectTypeKey;
        String string10 = string4;
        String string11 = string2;
        MRI mRI22 = mRI2;
        return new com.atlassian.migration.jira.classic.Project(mRI22, string11, string10, projectTypeKey3, mRI21, string9, textDocument3, mRI20, mRI19, mRI18, mRI17, mRI16, mRI15, mRI14, mRI13, mRI12, mRI11, defaultAssigneeType, projectStatus, mRI10, instant, set, mRI9, background, n, defaultConstructorMarker);
    }

    private final MRI mapFieldLayoutScheme(ExportContext ctx, Project entity) {
        FieldConfigurationScheme fieldConfigurationScheme = this.fieldLayoutManager.getFieldConfigurationScheme(entity);
        return ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, new FieldConfigurationSchemeWrapper(fieldConfigurationScheme), false, 4, null);
    }

    private final MRI mapWorkflowScheme(ExportContext ctx, Project entity) {
        AssignableWorkflowScheme assignableWorkflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(entity);
        Intrinsics.checkNotNullExpressionValue((Object)assignableWorkflowScheme, (String)"getWorkflowSchemeObj(...)");
        return this.exportService.exportOrDefault(ctx, new WorkflowSchemeWrapper((com.atlassian.jira.workflow.WorkflowScheme)assignableWorkflowScheme), MriExtensionsKt.mri$default(WorkflowScheme.Companion.getEntityType(), "10000", null, 2, null));
    }

    private final MRI mapIssueTypeScreenScheme(ExportContext ctx, Project entity) {
        return this.exportService.exportOrDefault(ctx, this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(entity), MriExtensionsKt.mri$default(IssueTypeScreenScheme.Companion.getEntityType(), "10000", null, 2, null));
    }

    private final TextDocument.Wiki mapDescription(ExportContext ctx, Project entity) {
        TextDocument.Wiki wiki;
        String string = entity.getDescription();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.exportService.extractUserRefs(ctx, it);
            wiki = new TextDocument.Wiki(it);
        } else {
            wiki = null;
        }
        return wiki;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull Project entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getName(), entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        log.debug("Exporting users and groups for project {} with id {} for migration {} under exportMode {}", objectArray);
        this.mapProjectLead(ctx, entity);
        this.mapIssueSecurityScheme(ctx, entity);
        this.mapWorkflowScheme(ctx, entity);
        this.mapDescription(ctx, entity);
        this.mapPermissionSchemeOrDefault(ctx, entity);
        this.mapNotificationSchemeOrDefault(ctx, entity);
        if (!this.migrationFeatures.getDisableMissingUserForCFDefaultValueFix()) {
            this.mapIssueTypeScreenScheme(ctx, entity);
        }
        this.mapArchivedBy(ctx, entity);
        this.mapFieldLayoutScheme(ctx, entity);
    }

    private final MRI mapIssueSecurityScheme(ExportContext ctx, Project entity) {
        MRI mRI;
        Scheme scheme = this.issueSecuritySchemeManager.getSchemeFor(entity);
        if (scheme != null) {
            Scheme it = scheme;
            boolean bl = false;
            mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(it.getId()), false, 4, null);
        } else {
            mRI = null;
        }
        return mRI;
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull Project entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Function0[]{new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ Project $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ProjectExporter.access$exportProjectComponents(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ Project $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ProjectExporter.access$exportProjectRoles(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ Project $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ProjectExporter.access$exportServiceDesk(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                if (!ProjectExporter.access$isConfigOnlyExport(this.this$0, this.$ctx)) {
                    ProjectExporter.access$getJswExportService$p(this.this$0).exportSingleProjectRapidViews(this.$ctx);
                }
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ Project $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ProjectExporter.access$handleIssues(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ Project $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ProjectExporter.access$exportProjectVersions(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                if (!ProjectExporter.access$isConfigOnlyExport(this.this$0, this.$ctx)) {
                    ProjectExporter.access$getJswExportService$p(this.this$0).exportSprints(this.$ctx);
                }
            }
        }, new Function0<Unit>(this, ctx){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                if (!ProjectExporter.access$isConfigOnlyExport(this.this$0, this.$ctx)) {
                    ProjectExporter.access$getFilterExportService$p(this.this$0).exportSharedFilters(this.$ctx);
                }
            }
        }, new Function0<Unit>(this, ctx){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                if (!ProjectExporter.access$getMigrationFeatures$p(this.this$0).getDisableProjectMailHandlerMigration()) {
                    ProjectExporter.access$getServiceConfigService$p(this.this$0).exportMailHandlersWithProjectReference(this.$ctx);
                }
            }
        }, new Function0<Unit>(entity, ctx){
            final /* synthetic */ Project $entity;
            final /* synthetic */ ExportContext $ctx;
            {
                this.$entity = $entity;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                ProjectExporter.access$getLog$cp().info("Project \"" + this.$entity.getName() + "\"(" + this.$entity.getId() + ") export completed for id " + this.$ctx.getMigrationId() + "! under exportMode " + (Object)((Object)this.$ctx.getExportMode()));
            }
        }};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final MRI mapProjectLead(ExportContext ctx, Project entity) {
        MRI mRI;
        block3: {
            block2: {
                UserRef userRef = UserRef.Companion.fromString(entity.getLeadUserKey());
                if (userRef == null) break block2;
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
                if (mRI != null) break block3;
            }
            MRI mRI2 = this.mriForEntity(entity);
            String string = EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, this.mriForEntity(entity), entity, null, 4, null) + " has no project lead assigned.";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_PROJECT_HAS_NO_LEAD;
            throw new ExportException(mRI2, exportErrorCode, string, "Please specify a project lead in the project settings.", null, null, null, 112, null);
        }
        return mRI;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ProjectTypeKey mapProjectKey(Project project) {
        String string = project.getProjectTypeKey().getKey();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 110258: {
                    if (!string.equals("ops")) break;
                    n = 1;
                    break;
                }
                case 1319330215: {
                    if (!string.equals("software")) break;
                    n = 2;
                    break;
                }
                case -1146830912: {
                    if (!string.equals("business")) break;
                    n = 3;
                    break;
                }
                case 359586275: {
                    if (!string.equals("service_desk")) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    ProjectTypeKey projectTypeKey = ProjectTypeKey.SOFTWARE;
                    return projectTypeKey;
                }
                case 3: {
                    ProjectTypeKey projectTypeKey = ProjectTypeKey.BUSINESS;
                    return projectTypeKey;
                }
                case 4: {
                    ProjectTypeKey projectTypeKey = ProjectTypeKey.SERVICE_DESK;
                    return projectTypeKey;
                }
                case 1: {
                    ProjectTypeKey projectTypeKey = ProjectTypeKey.OPS;
                    return projectTypeKey;
                }
            }
        }
        MRI mRI = this.mriForEntity(project);
        String string2 = "Project type for " + EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, this.mriForEntity(project), project, null, 4, null) + " is not supported";
        ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_PROJECT_TYPE_UNSUPPORTED;
        throw new ExportException(mRI, exportErrorCode, string2, null, null, null, null, 120, null);
    }

    private final DefaultAssigneeType mapDefaultAssigneeType(Long type) {
        Long l = type;
        long l2 = 3L;
        return l != null && l == l2 ? DefaultAssigneeType.UNASSIGNED : DefaultAssigneeType.PROJECT_LEAD;
    }

    private final void exportProjectVersions(ExportContext ctx, Project jiraProject) {
        Collection collection = jiraProject.getVersions();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVersions(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Version it = (Version)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    private final void exportProjectComponents(ExportContext ctx, Project jiraProject) {
        Collection collection = jiraProject.getProjectComponents();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProjectComponents(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectComponent it = (ProjectComponent)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    private final void exportProjectRoles(ExportContext ctx, Project jiraProject) {
        Unit unit;
        Collection collection = this.projectRoleManager.getProjectRoles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProjectRoles(...)");
        Sequence $this$forEach$iv = SequencesKt.ifEmpty((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<ProjectRole, Pair<? extends ProjectRole, ? extends ProjectRoleActors>>(this, jiraProject){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ Project $jiraProject;
            {
                this.this$0 = $receiver;
                this.$jiraProject = $jiraProject;
                super(1);
            }

            @NotNull
            public final Pair<ProjectRole, ProjectRoleActors> invoke(ProjectRole projectRole) {
                return new Pair((Object)projectRole, (Object)ProjectExporter.access$getProjectRoleManager$p(this.this$0).getProjectRoleActors(projectRole, this.$jiraProject));
            }
        })), (Function1)exportProjectRoles.2.INSTANCE), (Function0)((Function0)new Function0<Sequence<? extends Pair<? extends ProjectRole, ? extends ProjectRoleActors>>>(this, ctx, jiraProject){
            final /* synthetic */ ProjectExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ Project $jiraProject;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$jiraProject = $jiraProject;
                super(0);
            }

            @NotNull
            public final Sequence<Pair<ProjectRole, ProjectRoleActors>> invoke() {
                Sequence sequence;
                if (ProjectExporter.access$isConfigOnlyExport(this.this$0, this.$ctx)) {
                    sequence = SequencesKt.emptySequence();
                } else {
                    ProjectExporter.access$getLog$cp().warn("Invalid references to roles have been skipped for project with id " + this.$jiraProject.getId());
                    sequence = SequencesKt.emptySequence();
                }
                return sequence;
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            ProjectRole projectRole = (ProjectRole)pair.component1();
            ProjectRoleActors projectRoleActors = (ProjectRoleActors)pair.component2();
            ExportOrThrow exportOrThrow = this.exportService;
            Intrinsics.checkNotNull((Object)projectRoleActors);
            Intrinsics.checkNotNull((Object)projectRole);
            ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow, ctx, new ProjectRoleAssociationWrapper(projectRoleActors, projectRole), false, 4, null);
        }
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        if (!this.isConfigOnlyExport(ctx) && ctx.getIncludeRoleActors() && ctx.getValidProjectRoleActorsExported().isEmpty()) {
            log.warn("Invalid references to roles have been skipped for project with id " + jiraProject.getId());
        }
    }

    private final void exportIssues(ExportContext ctx, Project jiraProject) {
        this.clearProjectExportCacheIfExpired(ctx, jiraProject);
        long totalIssueCountInProject = this.issueManager.getIssueCountForProject(jiraProject.getId());
        this.issueTypeSchemeManagerCache.getIssueTypesForProject(jiraProject);
        ctx.setExportIssueChildrenFromProject(totalIssueCountInProject >= 1000L);
        log.info("#exportIssues Exporting " + totalIssueCountInProject + " issues for project " + jiraProject.getKey() + " in mode " + (Object)((Object)ctx.getExportMode()));
        if (this.shouldExportIssuesInParallel(ctx)) {
            this.exportIssuesParallel(ctx, jiraProject);
        } else {
            this.exportIssuesSequential(ctx, jiraProject);
        }
        log.info("#exportIssues Exported " + totalIssueCountInProject + " issues for project " + jiraProject.getKey());
        log.info("#exportEntityProperties Exported entity properties for project " + jiraProject.getKey());
        Map<Long, Long> $this$forEach$iv = ctx.getDuplicatedIssueMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, Long>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, Long> element$iv;
            Map.Entry<Long, Long> it = element$iv = iterator2.next();
            boolean bl = false;
            log.info("Issue (" + ((Number)it.getKey()).longValue() + ") is duplicated by number, new number is: " + ((Number)it.getValue()).longValue());
        }
        if (MigrationModeUtil.INSTANCE.shouldExportChangeHistoryUseFlatRead(ctx, this.migrationFeatures)) {
            log.info("Exporting changeHistory for project " + jiraProject.getKey() + " via flat read");
            this.changeHistoryDirectExport.exportHistory(ctx);
        }
        if (ctx.getExportIssueChildrenFromProject()) {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            this.issueChildrenExportService.export(ctx, jiraProject);
            long issueChildrenExportTime = System.currentTimeMillis() - start$iv;
            ctx.addToIssueChildrenLatencyStats(issueChildrenExportTime);
        }
        if (!MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssues(this.migrationFeatures, ctx.getMigrateArchivedIssues())) {
            Long l = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            if (this.jiraIssueReader.doesProjectContainArchivedIssues(((Number)l).longValue())) {
                String string = String.valueOf(jiraProject.getId());
                String string2 = jiraProject.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
                ExportContext.handleUnsupported$default(ctx, string, string2, String.valueOf((Object)ProblemType.ARCHIVED_ISSUES), null, null, null, 56, null);
            }
        }
        this.issueTypeSchemeManagerCache.clearCacheForProject(jiraProject);
    }

    private final boolean shouldExportIssuesInParallel(ExportContext ctx) {
        boolean isBackgroundPreProcessingInParallel = this.migrationFeatures.getEnableParallelizationInProjectDataPreprocessing() && ctx.getExportMode() == ExportMode.BACKGROUND_PREPROCESSING;
        ExportMode[] exportModeArray = new ExportMode[]{ExportMode.PROJECT_DATA, ExportMode.SHADOW_PROJECT_DATA};
        boolean isProjectDataExport = SetsKt.setOf((Object[])exportModeArray).contains((Object)ctx.getExportMode());
        return isBackgroundPreProcessingInParallel || isProjectDataExport || this.isConfigOnlyExport(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void exportIssuesParallel(ExportContext ctx, Project jiraProject) {
        int threadCount = this.getIssueParallelThreadPoolSize(ctx, Runtime.getRuntime().availableProcessors());
        log.info("Exporting issues in parallel mode with threadpoolsize : " + threadCount);
        ctx.updateMetricThreadCount(threadCount);
        Semaphore semaphore = new Semaphore(threadCount * 3);
        ExecutorService executor = Executors.newFixedThreadPool(threadCount, new GroupedThreadFactory("ParallelIssueExporter-PID-" + jiraProject.getId()));
        try {
            void $this$forEach$iv;
            Sequence<List<Long>> issueIds = this.getIssueIdsAsSequence(ctx, jiraProject);
            Long l = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            Function1<Issue, Unit> duplicateAggregator = ctx.storeDuplicateIssues(this.jiraIssueReader.getMaxIssueNumber(((Number)l).longValue()));
            long startTime = System.currentTimeMillis();
            Set<AppContainerDetails> appContainerDetails = this.getAppContainers(ctx);
            Sequence sequence = SequencesKt.flatMap(issueIds, (Function1)((Function1)new Function1<List<? extends Long>, Sequence<? extends Issue>>(this){
                final /* synthetic */ ProjectExporter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Sequence<Issue> invoke(@NotNull List<Long> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    List list = ProjectExporter.access$getIssueManager$p(this.this$0).getIssueObjects((Collection)it);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIssueObjects(...)");
                    return CollectionsKt.asSequence((Iterable)list);
                }
            }));
            String string = jiraProject.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            Sequence sequence2 = SequencesKt.onEach(this.filterIssues(ctx, (Sequence<? extends Issue>)sequence, string), duplicateAggregator);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Issue issue2 = (Issue)element$iv;
                boolean bl = false;
                boolean acquire = semaphore.tryAcquire(5L, TimeUnit.MINUTES);
                if (!acquire) {
                    log.warn("Unable to acquire semaphore " + semaphore.getQueueLength());
                }
                executor.execute(() -> ProjectExporter.exportIssuesParallel$lambda$12$lambda$11(this, ctx, issue2, appContainerDetails, semaphore));
            }
            ctx.setTotalExportTime(System.currentTimeMillis() - startTime);
        }
        catch (ExecutionException e) {
            Thread.currentThread().interrupt();
            log.error("Failed to export issues in parallel mode ", (Throwable)e);
            throw e;
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(60L, TimeUnit.MINUTES);
        }
        log.info("Uploading attachments done project Id = " + jiraProject.getId());
    }

    /*
     * WARNING - void declaration
     */
    private final void exportIssuesSequential(ExportContext ctx, Project jiraProject) {
        void $this$forEach$iv;
        log.info("Exporting issues in sequential mode");
        Sequence<List<Long>> issueIds = this.getIssueIdsAsSequence(ctx, jiraProject);
        Long l = jiraProject.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        Function1<Issue, Unit> duplicateAggregator = ctx.storeDuplicateIssues(this.jiraIssueReader.getMaxIssueNumber(((Number)l).longValue()));
        Set<AppContainerDetails> appContainerDetails = this.getAppContainers(ctx);
        Sequence sequence = SequencesKt.flatMap(issueIds, (Function1)((Function1)new Function1<List<? extends Long>, Sequence<? extends Issue>>(this){
            final /* synthetic */ ProjectExporter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<Issue> invoke(@NotNull List<Long> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                List list = ProjectExporter.access$getIssueManager$p(this.this$0).getIssueObjects((Collection)it);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIssueObjects(...)");
                return CollectionsKt.asSequence((Iterable)list);
            }
        }));
        String string = jiraProject.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        Sequence sequence2 = SequencesKt.onEach(this.filterIssues(ctx, (Sequence<? extends Issue>)sequence, string), duplicateAggregator);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Issue issue2 = (Issue)element$iv;
            boolean bl = false;
            if (this.migrationFeatures.getEnableEntityPropertyGeneration()) {
                this.entityPropertyExportService.exportForIssue(ctx, issue2, appContainerDetails);
            }
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl2 = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, issue2, false, 4, null);
            long timeTaken2 = System.currentTimeMillis() - start$iv;
            ctx.addToIssueLatencyStats(timeTaken2);
        }
    }

    private final Set<AppContainerDetails> getAppContainers(ExportContext ctx) {
        return this.migrationFeatures.getEnableEntityPropertyGeneration() && ctx.getExportMode() == ExportMode.PROJECT_DATA ? this.platformService.getAppContainers(new CloudId(ctx.getMigrationTaskMetadata().getCloudId()), new MigrationId(ctx.getMigrationId())) : SetsKt.emptySet();
    }

    private final Sequence<List<Long>> getIssueIdsAsSequence(ExportContext ctx, Project jiraProject) {
        Sequence sequence;
        if (ctx.isIncrementalMigration() && ctx.getIncrementalMigrationContext() != null) {
            IncrementalMigrationContext it = ctx.getIncrementalMigrationContext();
            boolean bl = false;
            Long l = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            MigrationIncrement migrationIncrement = it.getPreviousIncrement();
            sequence = SequencesKt.chunked((Sequence)JiraIssueReader.getAllIdsOfNewOrUpdatedIssuesInProject$default(this.jiraIssueReader, ((Number)l).longValue(), migrationIncrement != null ? Long.valueOf(migrationIncrement.getCutoff()) : null, it.getCurrentIncrement().getCutoff(), MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssues(this.migrationFeatures, ctx.getMigrateArchivedIssues()), 0, null, 48, null), (int)100);
        } else if (this.shouldUseProjectExportCache(ctx)) {
            sequence = this.processProjectExportCache(ctx, jiraProject);
        } else if (this.shouldUseScopedUserCache(ctx)) {
            sequence = this.processScopedUserCache(ctx, jiraProject);
        } else {
            Long l = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            sequence = SequencesKt.chunked(this.jiraIssueReader.getAllIssueIdsForProject(((Number)l).longValue()), (int)100);
        }
        Sequence issueIds = sequence;
        return issueIds;
    }

    private final boolean shouldUseProjectExportCache(ExportContext ctx) {
        ExportMode[] exportModeArray;
        return this.migrationFeatures.getEnableProjectExportPreflightCaching() && MigrationTaskMetadata.Companion.isDummyMigration(ctx.getMigrationTaskMetadata()) && SetsKt.setOf((Object[])(exportModeArray = new ExportMode[]{ExportMode.COLLECT_PREFLIGHT_PROJECT_DATA, ExportMode.BACKGROUND_PREPROCESSING})).contains((Object)ctx.getExportMode()) && !DataFiltersUtil.INSTANCE.shouldApplyDataFilters(this.migrationFeatures, ctx.getDataFilterContext());
    }

    private final boolean shouldUseScopedUserCache(ExportContext ctx) {
        ExportMode[] exportModeArray;
        return this.migrationFeatures.getScopedUserPreflightCache() && MigrationTaskMetadata.Companion.isDummyMigration(ctx.getMigrationTaskMetadata()) && SetsKt.setOf((Object[])(exportModeArray = new ExportMode[]{ExportMode.COLLECT_USER_AND_GROUP_REFS, ExportMode.BACKGROUND_PREPROCESSING})).contains((Object)ctx.getExportMode()) && !DataFiltersUtil.INSTANCE.shouldApplyDataFilters(this.migrationFeatures, ctx.getDataFilterContext());
    }

    private final Sequence<List<Long>> processProjectExportCache(ExportContext ctx, Project jiraProject) {
        Sequence sequence;
        Long l = ctx.getProject().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        ProjectExportPreflightCheckResult result2 = this.preflightEntityCachePersistenceManager.fetchProjectExportPreflightCheckResult(((Number)l).longValue());
        if (result2 == null) {
            Long l2 = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getId(...)");
            sequence = SequencesKt.chunked(this.jiraIssueReader.getAllIssueIdsForProject(((Number)l2).longValue()), (int)100);
        } else {
            long currentTime = System.currentTimeMillis();
            Long l3 = ctx.getProject().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getId(...)");
            Sequence updatedIssueIds = JiraIssueReader.getAllIdsOfNewOrUpdatedIssuesInProject$default(this.jiraIssueReader, ((Number)l3).longValue(), result2.getSoftRefreshTime(), currentTime, MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssues(this.migrationFeatures, ctx.getMigrateArchivedIssues()), 0, null, 48, null);
            log.info("[ProjectExportCache] Filtering updated issues for project " + ctx.getProject().getId() + " from " + result2.getSoftRefreshTime() + " to " + currentTime);
            ctx.setEntityCachePersistedAndValidForExport(true);
            sequence = SequencesKt.chunked((Sequence)updatedIssueIds, (int)100);
        }
        return sequence;
    }

    private final Sequence<List<Long>> processScopedUserCache(ExportContext ctx, Project jiraProject) {
        Sequence sequence;
        if (ctx.getScopedUserCacheTimeStamp() == null) {
            Long l = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            sequence = SequencesKt.chunked(this.jiraIssueReader.getAllIssueIdsForProject(((Number)l).longValue()), (int)100);
        } else {
            long currentTime = System.currentTimeMillis();
            Long l = ctx.getProject().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            Sequence updatedIssueIds = JiraIssueReader.getAllIdsOfNewOrUpdatedIssuesInProject$default(this.jiraIssueReader, ((Number)l).longValue(), ctx.getScopedUserCacheTimeStamp().getLastSoftRefreshTimestamp().getTime(), currentTime, MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssues(this.migrationFeatures, ctx.getMigrateArchivedIssues()), 0, null, 48, null);
            log.info("[ScopedUserCache] Filtering updated issues for project " + ctx.getProject().getId() + " from " + ctx.getScopedUserCacheTimeStamp().getLastSoftRefreshTimestamp().getTime() + " to " + currentTime);
            sequence = SequencesKt.chunked((Sequence)updatedIssueIds, (int)100);
        }
        return sequence;
    }

    private final void clearProjectExportCacheIfExpired(ExportContext ctx, Project jiraProject) {
        if (this.shouldUseProjectExportCache(ctx)) {
            Long l = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            ProjectExportPreflightCheckResult result2 = this.preflightEntityCachePersistenceManager.fetchProjectExportPreflightCheckResult(((Number)l).longValue());
            if (result2 != null && System.currentTimeMillis() - result2.getHardRefreshTime() > 2592000000L && !this.migrationFeatures.getEnableProjectDataPreprocessing()) {
                log.info("Project (" + jiraProject.getKey() + ") preflight export cache is deleted as the result is outdated");
                Long l2 = jiraProject.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getId(...)");
                this.preflightEntityCachePersistenceManager.deleteProjectExportPreflightCheckResult(((Number)l2).longValue());
            }
        }
    }

    private final Sequence<Issue> filterIssues(ExportContext ctx, Sequence<? extends Issue> issues, String projectKey) {
        Sequence sequence;
        if (DataFiltersUtil.INSTANCE.shouldApplyDataFilters(this.migrationFeatures, ctx.getDataFilterContext())) {
            log.debug("Filtering issues using data filters");
            List filteredIssues2 = SequencesKt.toList((Sequence)SequencesKt.filter(issues, (Function1)((Function1)new Function1<Issue, Boolean>(this, ctx){
                final /* synthetic */ ProjectExporter this$0;
                final /* synthetic */ ExportContext $ctx;
                {
                    this.this$0 = $receiver;
                    this.$ctx = $ctx;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Issue issue2) {
                    Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
                    return ProjectExporter.access$getDataFilterService$p(this.this$0).shouldExportEntity(this.$ctx.getDataFilterContext(), issue2);
                }
            })));
            this.dataFilterService.logFilteringResults(ctx.getDataFilterContext());
            this.sendFilteredIssueMetrics(ctx.getMigrationTaskMetadata(), SequencesKt.count(issues), ((Collection)filteredIssues2).size(), projectKey, EntityType.ISSUE.getTypeName());
            sequence = CollectionsKt.asSequence((Iterable)filteredIssues2);
        } else {
            sequence = this.filterArchivedIssues(ctx, issues);
        }
        return sequence;
    }

    private final void sendFilteredIssueMetrics(MigrationTaskMetadata migrationTaskMetadata2, int totalCount, int filteredCount, String projectKey, String entityType) {
        this.migrationEventBus.post(new DataFilterExportStatsEvent(migrationTaskMetadata2.getCloudId(), migrationTaskMetadata2.getMigrationId(), filteredCount, totalCount, projectKey, entityType));
    }

    private final Sequence<Issue> filterArchivedIssues(ExportContext ctx, Sequence<? extends Issue> issues) {
        Sequence sequence;
        if (MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssuesAsActiveOrArchived(this.migrationFeatures, ctx.getMigrateArchivedIssues())) {
            log.debug("Exporting archived issues as part of issue export");
            sequence = issues;
        } else {
            sequence = SequencesKt.filterNot(issues, this.getHasArchived());
        }
        return sequence;
    }

    private final Function1<Issue, Boolean> getHasArchived() {
        Lazy lazy = this.hasArchived$delegate;
        return (Function1)lazy.getValue();
    }

    private final void exportServiceDesk(ExportContext ctx, Project jiraProject) {
        try {
            if (this.jsdExportUtil.isJsdProjectEligibleForMigration(ctx)) {
                this.jsdExportService.exportServiceDesk(ctx);
            }
        }
        catch (JsdExportUtil.Companion.JsmApiFailureException ex) {
            throw new ExportException(this.mriForEntity(jiraProject), ExportErrorCode.JSD_ENTITY_RETRIEVAL_ERROR, "Failed to retrieve servicedesk or a related JSM entity for projectId " + jiraProject.getId(), null, null, null, null, 120, null);
        }
    }

    public final int getIssueParallelThreadPoolSize(@NotNull ExportContext ctx, int processorCount) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int issueParallelCount = ctx.getPlanSize() > 8 ? processorCount / 8 : processorCount / Math.max(ctx.getPlanSize(), 1);
        int threadCount = Math.min(8, Math.max(2, issueParallelCount));
        return threadCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final MRI mapPermissionSchemeOrDefault(ExportContext ctx, Project project) {
        MRI mRI;
        Scheme scheme = this.permissionSchemeManager.getSchemeFor(project);
        if (scheme != null) {
            Scheme it = scheme;
            boolean bl = false;
            MRI mRI2 = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, SchemeExtensionsKt.toPermissionScheme(it), false, 4, null);
            if (mRI2 != null) {
                mRI = mRI2;
                return mRI;
            }
        }
        ExportOrThrow exportOrThrow = this.exportService;
        Scheme scheme2 = this.permissionSchemeManager.getDefaultSchemeObject();
        Intrinsics.checkNotNullExpressionValue((Object)scheme2, (String)"getDefaultSchemeObject(...)");
        mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow, ctx, SchemeExtensionsKt.toPermissionScheme(scheme2), false, 4, null);
        return mRI;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final MRI mapNotificationSchemeOrDefault(ExportContext ctx, Project project) {
        MRI mRI;
        Scheme scheme = this.notificationSchemeManager.getSchemeFor(project);
        if (scheme != null) {
            Scheme it = scheme;
            boolean bl = false;
            MRI mRI2 = this.exportService.exportOrNull(ctx, SchemeExtensionsKt.toNotificationScheme(it));
            if (mRI2 != null) {
                mRI = mRI2;
                return mRI;
            }
        }
        ExportOrThrow exportOrThrow = this.exportService;
        Object object = this.notificationSchemeManager.getDefaultSchemeObject();
        if (object == null || (object = SchemeExtensionsKt.toNotificationScheme(object)) == null) {
            List list = this.notificationSchemeManager.getSchemeObjects();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSchemeObjects(...)");
            Object object2 = CollectionsKt.first((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first(...)");
            object = SchemeExtensionsKt.toNotificationScheme((Scheme)object2);
        }
        mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow, ctx, object, false, 4, null);
        return mRI;
    }

    private final void handleIssues(ExportContext ctx, Project entity) {
        if (ctx.getProjectDataMigrationMode() != ProjectDataMigrationMode.ALL) {
            log.info("Skipping issue export for project " + entity.getKey() + " as projectDataMigrationMode is set to " + (Object)((Object)ctx.getProjectDataMigrationMode()));
            return;
        }
        this.exportIssues(ctx, entity);
        if (MigrationModeUtil.INSTANCE.shouldExportUseFlatRead(ctx, this.migrationFeatures)) {
            this.directExportFacade.exportDirectIssues(ctx, entity);
        }
    }

    private final MRI mapPriorityScheme(ExportContext ctx, Project project) {
        MRI mRI;
        FieldConfigScheme fieldConfigScheme = this.prioritySchemeManager.getScheme(project);
        Intrinsics.checkNotNullExpressionValue((Object)fieldConfigScheme, (String)"getScheme(...)");
        PrioritySchemeWrapper prioritySchemeWrapper = new PrioritySchemeWrapper(fieldConfigScheme);
        Boolean bl = this.isPrioritySchemePrioritiesNotEmpty(prioritySchemeWrapper);
        boolean it = bl;
        boolean bl2 = false;
        Boolean bl3 = it ? bl : null;
        if (bl3 != null) {
            it = bl3;
            boolean bl4 = false;
            mRI = this.exportService.exportOrDefault(ctx, prioritySchemeWrapper, MriExtensionsKt.mri$default(PriorityScheme.Companion.getEntityType(), "10000", null, 2, null));
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final boolean isPrioritySchemePrioritiesNotEmpty(PrioritySchemeWrapper prioritySchemeWrapper) {
        PrioritySchemeWrapper it = prioritySchemeWrapper;
        boolean bl = false;
        it = this.prioritySchemeManager.getFieldConfigForDefaultMapping(it.getFieldConfigScheme());
        boolean bl2 = false;
        List list = this.prioritySchemeManager.getOptions((FieldConfig)it);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"let(...)");
        return !((Collection)list).isEmpty();
    }

    private final boolean isConfigOnlyExport(ExportContext ctx) {
        return ctx.getExportMode() == ExportMode.COLLECT_CONFIG_ONLY;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @VisibleForTesting
    @Nullable
    public final ProjectStatus mapProjectStatus(@NotNull Project project, @NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        var4_3 = this.projectPropertiesManager.getPropertySet(project);
        if (var4_3 == null) ** GOTO lbl-1000
        it = var6_4 = var4_3;
        $i$a$-takeIf-ProjectExporter$mapProjectStatus$projectStatus$1 = false;
        v0 /* !! */  = var5_7 = it.exists("jira.archiving.projects") != false ? var6_4 : null;
        if (var5_7 != null) {
            isArchived = var5_7.getBoolean("jira.archiving.projects");
            $i$a$-let-ProjectExporter$mapProjectStatus$projectStatus$2 = false;
            v1 = isArchived ? ProjectStatus.ARCHIVED : ProjectStatus.ACTIVE;
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        projectStatus = v1;
        ctx.setProjectStatus(projectStatus);
        return projectStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @Nullable
    public final MRI mapArchivedBy(@NotNull ExportContext ctx, @NotNull Project project) {
        PropertySet propertySet;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PropertySet propertySet2 = this.projectPropertiesManager.getPropertySet(project);
        if (propertySet2 == null) return null;
        PropertySet it = propertySet = propertySet2;
        boolean bl = false;
        if (!it.exists("jira.archiving.projects.archived.by")) return null;
        PropertySet propertySet3 = propertySet;
        PropertySet propertySet4 = propertySet3;
        if (propertySet4 == null) return null;
        long userId = propertySet4.getLong("jira.archiving.projects.archived.by");
        boolean bl2 = false;
        ApplicationUser applicationUser = this.userManager.getUserById(Long.valueOf(userId)).orElseGet(ProjectExporter::mapArchivedBy$lambda$26$lambda$25);
        if (applicationUser == null) return null;
        ApplicationUser applicationUser2 = applicationUser;
        boolean bl3 = false;
        UserRef userRef = UserRef.Companion.fromString(applicationUser2.getKey());
        if (userRef == null) return null;
        UserRef userRef2 = userRef;
        boolean bl4 = false;
        MRI mRI = this.exportService.userRef(ctx, userRef2);
        return mRI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @Nullable
    public final Instant mapArchivedDate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PropertySet propertySet = this.projectPropertiesManager.getPropertySet(project);
        if (propertySet == null) return null;
        Object object = propertySet;
        PropertySet it = object;
        boolean bl = false;
        if (!it.exists("jira.archiving.projects.date")) return null;
        PropertySet propertySet2 = object;
        PropertySet propertySet3 = propertySet2;
        if (propertySet3 == null) return null;
        object = propertySet3.getDate("jira.archiving.projects.date");
        if (object == null) return null;
        Instant instant = ((Date)object).toInstant();
        return instant;
    }

    @Override
    @Nullable
    public Project extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void exportIssuesParallel$lambda$12$lambda$11(ProjectExporter this$0, ExportContext $ctx, Issue $issue, Set $appContainerDetails, Semaphore $semaphore) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        Intrinsics.checkNotNullParameter((Object)$issue, (String)"$issue");
        Intrinsics.checkNotNullParameter((Object)$appContainerDetails, (String)"$appContainerDetails");
        Intrinsics.checkNotNullParameter((Object)$semaphore, (String)"$semaphore");
        try {
            if (this$0.migrationFeatures.getEnableEntityPropertyGeneration()) {
                this$0.entityPropertyExportService.exportForIssue($ctx, $issue, $appContainerDetails);
            }
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this$0.exportService, $ctx, $issue, false, 4, null);
            long timeTaken2 = System.currentTimeMillis() - start$iv;
            $ctx.addToIssueLatencyStats(timeTaken2);
        }
        finally {
            $semaphore.release();
        }
    }

    private static final ApplicationUser mapArchivedBy$lambda$26$lambda$25() {
        return null;
    }

    public static final /* synthetic */ void access$exportProjectComponents(ProjectExporter $this, ExportContext ctx, Project jiraProject) {
        $this.exportProjectComponents(ctx, jiraProject);
    }

    public static final /* synthetic */ void access$exportProjectRoles(ProjectExporter $this, ExportContext ctx, Project jiraProject) {
        $this.exportProjectRoles(ctx, jiraProject);
    }

    public static final /* synthetic */ void access$exportServiceDesk(ProjectExporter $this, ExportContext ctx, Project jiraProject) {
        $this.exportServiceDesk(ctx, jiraProject);
    }

    public static final /* synthetic */ boolean access$isConfigOnlyExport(ProjectExporter $this, ExportContext ctx) {
        return $this.isConfigOnlyExport(ctx);
    }

    public static final /* synthetic */ JswExportService access$getJswExportService$p(ProjectExporter $this) {
        return $this.jswExportService;
    }

    public static final /* synthetic */ void access$handleIssues(ProjectExporter $this, ExportContext ctx, Project entity) {
        $this.handleIssues(ctx, entity);
    }

    public static final /* synthetic */ void access$exportProjectVersions(ProjectExporter $this, ExportContext ctx, Project jiraProject) {
        $this.exportProjectVersions(ctx, jiraProject);
    }

    public static final /* synthetic */ FilterExportService access$getFilterExportService$p(ProjectExporter $this) {
        return $this.filterExportService;
    }

    public static final /* synthetic */ MigrationFeatures access$getMigrationFeatures$p(ProjectExporter $this) {
        return $this.migrationFeatures;
    }

    public static final /* synthetic */ ServiceConfigService access$getServiceConfigService$p(ProjectExporter $this) {
        return $this.serviceConfigService;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ ProjectRoleManager access$getProjectRoleManager$p(ProjectExporter $this) {
        return $this.projectRoleManager;
    }

    public static final /* synthetic */ IssueManager access$getIssueManager$p(ProjectExporter $this) {
        return $this.issueManager;
    }

    public static final /* synthetic */ DataFilterService access$getDataFilterService$p(ProjectExporter $this) {
        return $this.dataFilterService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/export/core/project/ProjectExporter$Companion;", "", "()V", "CHILDREN_EXPORT_THRESHOLD_ISSUE_COUNT", "", "DEFAULT_THREAD_COUNT", "", "EXECUTOR_TERMINATION_TIMEOUT", "PARALLEL_ISSUE_THREADPOOL_SIZE_EIGHT", "PROJECT_EXPORT_PREFLIGHT_HARD_REFRESH_TTL_IN_MILLIS", "SEMAPHORE_ACQUIRE_TIMEOUT", "SEMAPHORE_THREADPOOL_MULTIPLIER", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

