/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.project;

import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.export.core.project.ProjectRoleAssociationWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.Project;
import com.atlassian.migration.jira.core.projectrole.ProjectRoleAssociation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/export/core/project/ProjectRoleAssociationExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/project/ProjectRoleAssociationWrapper;", "Lcom/atlassian/migration/jira/core/projectrole/ProjectRoleAssociation;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapProjectRole", "Lcom/atlassian/migration/base/mri/MRI;", "mapRoleActorToMri", "roleActor", "Lcom/atlassian/jira/security/roles/RoleActor;", "mapRoleActors", "", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectRoleAssociationExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectRoleAssociationExporter.kt\ncom/atlassian/jira/migration/export/core/project/ProjectRoleAssociationExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n766#2:98\n857#2,2:99\n1603#2,9:101\n1855#2:110\n1856#2:112\n1612#2:113\n1549#2:114\n1620#2,3:115\n1#3:111\n1#3:118\n*S KotlinDebug\n*F\n+ 1 ProjectRoleAssociationExporter.kt\ncom/atlassian/jira/migration/export/core/project/ProjectRoleAssociationExporter\n*L\n77#1:98\n77#1:99,2\n78#1:101,9\n78#1:110\n78#1:112\n78#1:113\n81#1:114\n81#1:115,3\n78#1:111\n*E\n"})
public final class ProjectRoleAssociationExporter
implements Exporter<String, ProjectRoleAssociationWrapper, ProjectRoleAssociation> {
    @NotNull
    private final ExportService exportService;
    private final Logger log;

    @Inject
    public ProjectRoleAssociationExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(ProjectRoleAssociationExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ProjectRoleAssociationWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(ProjectRoleAssociation.Companion.getEntityType());
    }

    @Override
    @NotNull
    public ProjectRoleAssociation exportData(@NotNull ExportContext ctx, @NotNull ProjectRoleAssociationWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), ctx.getExportMode()};
        this.log.debug("[MigrationId:{}] Exporting projectRoleAssociation with id {} under exportMode:{}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        EntityType entityType = Project.Companion.getEntityType();
        Long l = entity.getValue().getProjectId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getProjectId(...)");
        return new ProjectRoleAssociation(mRI, MriExtensionsKt.mri$default(entityType, l, null, 2, null), this.mapProjectRole(ctx, entity), (List)(ctx.getIncludeRoleActors() ? this.mapRoleActors(ctx, entity) : CollectionsKt.emptyList()));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ProjectRoleAssociationWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getProjectRole().getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for projectRole with id {} for migration {} under exportMode {}", objectArray);
        this.mapProjectRole(ctx, entity);
        if (ctx.getIncludeRoleActors()) {
            objectArray = new Object[]{entity.getValue().getProjectId(), ctx.getMigrationId(), ctx.getExportMode()};
            this.log.debug("Exporting users and groups for roleActors associated with project id {} for migration {} under exportMode {}", objectArray);
            this.mapRoleActors(ctx, entity);
        }
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ProjectRoleAssociationWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(ProjectRoleAssociation.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MRI mapProjectRole(ExportContext ctx, ProjectRoleAssociationWrapper entity) {
        return ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, entity.getProjectRole(), false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> mapRoleActors(ExportContext ctx, ProjectRoleAssociationWrapper entity) {
        List list;
        RoleActor it;
        void $this$mapNotNullTo$iv$iv;
        Object it2;
        Iterable $this$filterTo$iv$iv;
        Set set = entity.getValue().getRoleActors();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRoleActors(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable<MRI> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (RoleActor)element$iv$iv;
            boolean bl = false;
            if (!StringExtensionsKt.isNotNullOrBlank(it2.getParameter())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        it2 = $this$forEach$iv$iv$iv.iterator();
        while (it2.hasNext()) {
            MRI it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it2.next();
            boolean bl = false;
            it = (RoleActor)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.mapRoleActorToMri(ctx, it, entity) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it3 = list = (List)destination$iv$iv;
        boolean bl = false;
        if (!((Collection)it3).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            destination$iv$iv = it3;
            Set<String> set2 = ctx.getValidProjectRoleActorsExported();
            boolean $i$f$map = false;
            void $i$f$forEach2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void mri;
                it = (MRI)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(mri.value());
            }
            set2.addAll((List)destination$iv$iv2);
        }
        return list;
    }

    private final MRI mapRoleActorToMri(ExportContext ctx, RoleActor roleActor, ProjectRoleAssociationWrapper entity) {
        MRI mRI;
        String string = roleActor.getType();
        if (Intrinsics.areEqual((Object)string, (Object)"atlassian-group-role-actor")) {
            String string2 = roleActor.getParameter();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParameter(...)");
            GroupRefModel groupRef = new GroupRefModel(string2, "Role [" + entity.getProjectRole() + ']', entity.getId().toString());
            mRI = this.exportService.groupRefSkipInvalid(ctx, groupRef);
        } else if (Intrinsics.areEqual((Object)string, (Object)"atlassian-user-role-actor")) {
            UserRef userRef = UserRef.Companion.fromString(roleActor.getParameter());
            if (userRef != null) {
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
            } else {
                mRI = null;
            }
        } else {
            this.log.warn("Invalid roleActors have been skipped with entity id " + entity.getId());
            mRI = null;
        }
        return mRI;
    }

    @Override
    @Nullable
    public ProjectRoleAssociationWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ProjectRoleAssociationWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

