/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.project;

import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.Project;
import com.atlassian.migration.jira.core.version.ProjectVersion;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\n \u0010*\u0004\u0018\u00010\u001d0\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/export/core/project/ProjectVersionExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/project/version/Version;", "Lcom/atlassian/migration/jira/core/version/ProjectVersion;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "versionManager", "Lcom/atlassian/jira/project/version/VersionManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/project/version/VersionManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "extractServerEntity", "entityKey", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "postConstruct", "", "toLocalDate", "Ljava/time/LocalDate;", "date", "Ljava/util/Date;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectVersionExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectVersionExporter.kt\ncom/atlassian/jira/migration/export/core/project/ProjectVersionExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class ProjectVersionExporter
implements Exporter<Long, Version, ProjectVersion> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final VersionManager versionManager;
    private final Logger log;
    @NotNull
    private final ExporterKey key;

    @Inject
    public ProjectVersionExporter(@NotNull ExportService exportService, @NotNull VersionManager versionManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)versionManager, (String)"versionManager");
        this.exportService = exportService;
        this.versionManager = versionManager;
        this.log = LoggerFactory.getLogger(ProjectVersionExporter.class);
        this.key = new ExporterKey(ProjectVersion.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, Version.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull Version entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNull((Object)l);
        return this.mriForKey(l);
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(ProjectVersion.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public ProjectVersion exportData(@NotNull ExportContext ctx, @NotNull Version entity) {
        LocalDate localDate;
        LocalDate localDate2;
        LocalDate localDate3;
        Date p0;
        MRI mRI;
        MRI mRI2;
        String string;
        String string2;
        long l;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), entity.getProjectId(), ctx.getExportMode()};
        this.log.debug("[MigrationId:{}] Exporting projectVersion with id {} for projectId {} under exportMode:{}", objectArray);
        MRI mRI3 = this.mriForEntity(entity);
        EntityType entityType = Project.Companion.getEntityType();
        Long l2 = entity.getProjectId();
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getProjectId(...)");
        MRI mRI4 = MriExtensionsKt.mri$default(entityType, l2, null, 2, null);
        String string3 = entity.getName();
        String string4 = string3;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String string5 = entity.getDescription();
        Long l3 = entity.getSequence();
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getSequence(...)");
        long l4 = ((Number)l3).longValue();
        boolean bl3 = entity.isReleased();
        boolean bl4 = entity.isArchived();
        Date date = entity.getStartDate();
        if (date != null) {
            Date date2 = date;
            bl2 = bl4;
            bl = bl3;
            l = l4;
            string2 = string5;
            string = string4;
            mRI2 = mRI4;
            mRI = mRI3;
            boolean bl5 = false;
            localDate3 = this.toLocalDate(p0);
            mRI3 = mRI;
            mRI4 = mRI2;
            string4 = string;
            string5 = string2;
            l4 = l;
            bl3 = bl;
            bl4 = bl2;
            localDate2 = localDate3;
        } else {
            localDate2 = null;
        }
        Date date3 = entity.getReleaseDate();
        if (date3 != null) {
            p0 = date3;
            localDate3 = localDate2;
            bl2 = bl4;
            bl = bl3;
            l = l4;
            string2 = string5;
            string = string4;
            mRI2 = mRI4;
            mRI = mRI3;
            boolean bl6 = false;
            LocalDate localDate4 = this.toLocalDate(p0);
            mRI3 = mRI;
            mRI4 = mRI2;
            string4 = string;
            string5 = string2;
            l4 = l;
            bl3 = bl;
            bl4 = bl2;
            localDate2 = localDate3;
            localDate = localDate4;
        } else {
            localDate = null;
        }
        LocalDate localDate5 = localDate;
        LocalDate localDate6 = localDate2;
        boolean bl7 = bl4;
        boolean bl8 = bl3;
        long l5 = l4;
        String string6 = string5;
        String string7 = string4;
        MRI mRI5 = mRI4;
        MRI mRI6 = mRI3;
        return new ProjectVersion(mRI6, mRI5, string7, string6, l5, bl8, bl7, localDate6, localDate5);
    }

    @Override
    @Nullable
    public Version extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this.versionManager.getVersion(Long.valueOf(entityKey));
    }

    private final LocalDate toLocalDate(Date date) {
        Intrinsics.checkNotNull((Object)date, (String)"null cannot be cast to non-null type java.sql.Timestamp");
        return ((Timestamp)date).toLocalDateTime().toLocalDate();
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull Version entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull Version entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

