/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.screen;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.CustomFieldUtils;
import com.atlassian.jira.migration.export.utils.CustomFieldUtilsKt;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.export.utils.ExportLoggers;
import com.atlassian.jira.migration.export.utils.TextSanitizer;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.customfield.ManagedCustomFieldKey;
import com.atlassian.migration.jira.classic.scope.EntityScope;
import com.atlassian.migration.jira.classic.screen.Screen;
import com.atlassian.migration.jira.classic.screen.Tab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 ,2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001,B'\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0002H\u0016J\b\u0010$\u001a\u00020\u001bH\u0007J&\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0015\u00a8\u0006-"}, d2={"Lcom/atlassian/jira/migration/export/core/screen/ScreenExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/fields/screen/FieldScreen;", "Lcom/atlassian/migration/jira/classic/screen/Screen;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "customFieldUtils", "Lcom/atlassian/jira/migration/export/utils/CustomFieldUtils;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/issue/CustomFieldManager;Lcom/atlassian/jira/migration/export/utils/ExportFilters;Lcom/atlassian/jira/migration/export/utils/CustomFieldUtils;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log$1", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapTab", "Lcom/atlassian/migration/jira/classic/screen/Tab;", "tab", "Lcom/atlassian/jira/issue/fields/screen/FieldScreenTab;", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "shouldExportField", "", "item", "Lcom/atlassian/jira/issue/fields/screen/FieldScreenLayoutItem;", "managedCustomFieldsAdded", "", "Lcom/atlassian/migration/jira/classic/customfield/ManagedCustomFieldKey;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nScreenExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenExporter.kt\ncom/atlassian/jira/migration/export/core/screen/ScreenExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1549#2:145\n1620#2,3:146\n766#2:149\n857#2,2:150\n1549#2:152\n1620#2,3:153\n1549#2:156\n1620#2,3:157\n1#3:160\n*S KotlinDebug\n*F\n+ 1 ScreenExporter.kt\ncom/atlassian/jira/migration/export/core/screen/ScreenExporter\n*L\n64#1:145\n64#1:146,3\n81#1:149\n81#1:150,2\n82#1:152\n82#1:153,3\n90#1:156\n90#1:157,3\n*E\n"})
public final class ScreenExporter
implements Exporter<Long, FieldScreen, Screen> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final CustomFieldManager customFieldManager;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final CustomFieldUtils customFieldUtils;
    private final Logger log$1;
    private static final Logger log = LoggerFactory.getLogger(ScreenExporter.class);

    @Inject
    public ScreenExporter(@NotNull ExportService exportService, @NotNull CustomFieldManager customFieldManager, @NotNull ExportFilters exportFilters, @NotNull CustomFieldUtils customFieldUtils) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        Intrinsics.checkNotNullParameter((Object)customFieldUtils, (String)"customFieldUtils");
        this.exportService = exportService;
        this.customFieldManager = customFieldManager;
        this.exportFilters = exportFilters;
        this.customFieldUtils = customFieldUtils;
        this.log$1 = LoggerFactory.getLogger(ScreenExporter.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(Screen.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, FieldScreen.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Screen exportData(@NotNull ExportContext ctx, @NotNull FieldScreen entity) {
        Collection<Tab> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object = new Object[]{ctx.getMigrationId(), entity.getId(), ctx.getExportMode()};
        this.log$1.debug("[MigrationId:{}] Exporting screen with id {}  under exportMode:{}", object);
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = entity.getDescription();
        Logger logger2 = this.log$1;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        String string3 = TextSanitizer.INSTANCE.sanitizedNullableText(string2, logger2, "Screen " + entity.getName(), 219);
        List list = entity.getTabs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTabs(...)");
        object = list;
        String string4 = string3;
        String string5 = string;
        MRI mRI2 = mRI;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            FieldScreenTab fieldScreenTab = (FieldScreenTab)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)item);
            collection.add(this.mapTab(ctx, (FieldScreenTab)item));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 48;
        MRI mRI3 = null;
        EntityScope entityScope = null;
        Collection<Tab> collection2 = collection;
        String string6 = string4;
        String string7 = string5;
        MRI mRI4 = mRI2;
        return new Screen(mRI4, string7, string6, collection2, entityScope, mRI3, n, defaultConstructorMarker);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull FieldScreen entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(Screen.Companion.getEntityType(), entityKey, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Tab mapTab(ExportContext ctx, FieldScreenTab tab) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FieldScreenLayoutItem it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set managedCustomFieldsAdded = new LinkedHashSet();
        String string = tab.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        List list = tab.getFieldScreenLayoutItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFieldScreenLayoutItems(...)");
        Iterable iterable = list;
        String string2 = string;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FieldScreenLayoutItem)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.shouldExportField(ctx, it, managedCustomFieldsAdded)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            it = (FieldScreenLayoutItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = item.getFieldId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFieldId(...)");
            collection.add(this.exportService.exportField(ctx, string3));
        }
        List list2 = (List)destination$iv$iv;
        String string4 = string2;
        return new Tab(string4, list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull FieldScreen entity) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log$1.debug("Exporting users and groups for fieldScreen with id {} for migration {} under exportMode {}", objectArray);
        List list = entity.getTabs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTabs(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            FieldScreenTab fieldScreenTab = (FieldScreenTab)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)item);
            collection.add(this.mapTab(ctx, (FieldScreenTab)item));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final boolean shouldExportField(ExportContext ctx, FieldScreenLayoutItem item, Set<ManagedCustomFieldKey> managedCustomFieldsAdded) {
        String fieldId = item.getFieldId();
        Intrinsics.checkNotNull((Object)fieldId);
        if (StringsKt.startsWith$default((String)fieldId, (String)"customfield_", (boolean)false, (int)2, null)) {
            boolean bl;
            FieldScreen screen;
            FieldScreenTab tab;
            CustomField customField = this.customFieldManager.getCustomFieldObject(fieldId);
            FieldScreenTab fieldScreenTab = tab = item.getFieldScreenTab();
            Object object = screen = fieldScreenTab != null ? fieldScreenTab.getFieldScreen() : null;
            if (customField == null) {
                Object[] objectArray = new Object[3];
                FieldScreenTab fieldScreenTab2 = tab;
                String string = fieldScreenTab2 != null ? fieldScreenTab2.getName() : null;
                if (string == null) {
                    string = "n/a";
                }
                objectArray[0] = string;
                FieldScreenTab fieldScreenTab3 = tab;
                Object object2 = fieldScreenTab3 != null ? fieldScreenTab3.getId() : null;
                if (object2 == null) {
                    object2 = "n/a";
                }
                objectArray[1] = object2;
                objectArray[2] = fieldId;
                this.log$1.warn("tab {}({}) has a reference to field {} which is not known to custom field manager. Skipping the field...", objectArray);
                bl = false;
            } else {
                ManagedCustomFieldKey managedCustomFieldKey = this.customFieldUtils.getManagedCustomFieldKey(customField);
                if (CollectionsKt.contains((Iterable)managedCustomFieldsAdded, (Object)managedCustomFieldKey)) {
                    Object[] objectArray = new Object[3];
                    FieldScreenTab fieldScreenTab4 = tab;
                    String string = fieldScreenTab4 != null ? fieldScreenTab4.getName() : null;
                    if (string == null) {
                        string = "n/a";
                    }
                    objectArray[0] = string;
                    FieldScreenTab fieldScreenTab5 = tab;
                    Object object3 = fieldScreenTab5 != null ? fieldScreenTab5.getId() : null;
                    if (object3 == null) {
                        object3 = "n/a";
                    }
                    objectArray[1] = object3;
                    objectArray[2] = fieldId;
                    this.log$1.warn("tab {}({}) has duplicate reference to managed custom field {}. Skipping the field...", objectArray);
                    bl = false;
                } else if (this.exportFilters.isSupportedField(ctx, (Field)customField)) {
                    ManagedCustomFieldKey managedCustomFieldKey2 = managedCustomFieldKey;
                    if (managedCustomFieldKey2 != null) {
                        ManagedCustomFieldKey it = managedCustomFieldKey2;
                        boolean bl2 = false;
                        managedCustomFieldsAdded.add(it);
                    }
                    bl = true;
                } else {
                    CustomFieldUtilsKt.handleUnsupported(customField, ctx);
                    Logger logger2 = this.log$1;
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
                    FieldScreenTab fieldScreenTab6 = tab;
                    FieldScreenTab fieldScreenTab7 = tab;
                    FieldScreen fieldScreen = screen;
                    FieldScreen fieldScreen2 = screen;
                    ExportLoggers.INSTANCE.logUnsupportedCustomField(logger2, customField, "is referenced from tab \"" + (fieldScreenTab6 != null ? fieldScreenTab6.getName() : null) + "\"(" + (fieldScreenTab7 != null ? fieldScreenTab7.getId() : null) + ") of screen \"" + (fieldScreen != null ? fieldScreen.getName() : null) + "\"(" + (fieldScreen2 != null ? fieldScreen2.getId() : null) + ')');
                    bl = false;
                }
            }
            return bl;
        }
        return this.exportFilters.isSupportedField(ctx, (Field)item.getOrderableField());
    }

    @Override
    @Nullable
    public FieldScreen extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull FieldScreen entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/screen/ScreenExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

