/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.screen;

import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.TextSanitizer;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.screen.ScreenScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 %2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002%&B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J.\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0002H\u0016J\b\u0010$\u001a\u00020\u001eH\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0011\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/export/core/screen/ScreenSchemeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/fields/screen/FieldScreenScheme;", "Lcom/atlassian/migration/jira/classic/screen/ScreenScheme;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "entityIdentifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log$1", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportScreen", "Lcom/atlassian/migration/base/mri/MRI;", "map", "", "Lcom/atlassian/jira/migration/export/core/screen/ScreenSchemeExporter$Operation;", "Lcom/atlassian/jira/issue/fields/screen/FieldScreenSchemeItem;", "operation", "exportUsersAndGroups", "", "mapItems", "fieldScreenSchemeItem", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "Companion", "Operation", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nScreenSchemeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/screen/ScreenSchemeExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1549#2:111\n1620#2,3:112\n1549#2:115\n1620#2,3:116\n1#3:119\n*S KotlinDebug\n*F\n+ 1 ScreenSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/screen/ScreenSchemeExporter\n*L\n46#1:111\n46#1:112,3\n78#1:115\n78#1:116,3\n*E\n"})
public final class ScreenSchemeExporter
implements Exporter<Long, FieldScreenScheme, ScreenScheme> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EntityIdentifierGenerator entityIdentifierGenerator;
    private final Logger log$1;
    private static final Logger log = LoggerFactory.getLogger(ScreenSchemeExporter.class);

    @Inject
    public ScreenSchemeExporter(@NotNull ExportService exportService, @NotNull EntityIdentifierGenerator entityIdentifierGenerator) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)entityIdentifierGenerator, (String)"entityIdentifierGenerator");
        this.exportService = exportService;
        this.entityIdentifierGenerator = entityIdentifierGenerator;
        this.log$1 = LoggerFactory.getLogger(ScreenSchemeExporter.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(ScreenScheme.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, FieldScreenScheme.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScreenScheme exportData(@NotNull ExportContext ctx, @NotNull FieldScreenScheme entity) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Collection collection = entity.getFieldScreenSchemeItems();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFieldScreenSchemeItems(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FieldScreenSchemeItem fieldScreenSchemeItem = (FieldScreenSchemeItem)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection2.add(TuplesKt.to((Object)((Object)this.mapItems((FieldScreenSchemeItem)it)), (Object)it));
        }
        Map itemMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), ctx.getExportMode()};
        this.log$1.debug("[MigrationId:{}] Exporting fieldScreenScheme with id {}  under exportMode:{}", objectArray);
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        MRI mRI = this.mriForKey(((Number)l).longValue());
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = entity.getDescription();
        Logger logger2 = this.log$1;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        MRI mRI2 = this.exportScreen(ctx, itemMap, Operation.DEFAULT);
        if (mRI2 == null) {
            MRI mRI3 = this.mriForEntity(entity);
            object = EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, this.mriForEntity(entity), entity, null, 4, null) + " has no screen configured for the default issue operation";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_SCREEN_SCHEME_NO_SCREEN_FOR_DEFAULT_ISSUE_OPERATION;
            throw new ExportException(mRI3, exportErrorCode, (String)object, "Please configure a screen for the default issue operation", null, null, null, 112, null);
        }
        return new ScreenScheme(mRI, string, TextSanitizer.INSTANCE.sanitizedNullableText(string2, logger2, "Screen Scheme " + entity.getName(), 219), mRI2, this.exportScreen(ctx, itemMap, Operation.CREATE), this.exportScreen(ctx, itemMap, Operation.EDIT), this.exportScreen(ctx, itemMap, Operation.VIEW), null, null, 384, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull FieldScreenScheme entity) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log$1.debug("Exporting users and groups for fieldScreenScheme with id {} for migration {} under exportMode {}", objectArray);
        Collection collection = entity.getFieldScreenSchemeItems();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFieldScreenSchemeItems(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FieldScreenSchemeItem fieldScreenSchemeItem = (FieldScreenSchemeItem)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection2.add(TuplesKt.to((Object)((Object)this.mapItems((FieldScreenSchemeItem)it)), (Object)it));
        }
        Map itemMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.exportScreen(ctx, itemMap, Operation.DEFAULT);
        this.exportScreen(ctx, itemMap, Operation.CREATE);
        this.exportScreen(ctx, itemMap, Operation.EDIT);
        this.exportScreen(ctx, itemMap, Operation.VIEW);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull FieldScreenScheme entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(ScreenScheme.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MRI exportScreen(ExportContext ctx, Map<Operation, ? extends FieldScreenSchemeItem> map, Operation operation) {
        MRI mRI;
        FieldScreenSchemeItem fieldScreenSchemeItem = map.get((Object)operation);
        if (fieldScreenSchemeItem != null) {
            FieldScreenSchemeItem it = fieldScreenSchemeItem;
            boolean bl = false;
            mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it.getFieldScreen(), false, 4, null);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final Operation mapItems(FieldScreenSchemeItem fieldScreenSchemeItem) {
        ScreenableIssueOperation it = fieldScreenSchemeItem.getIssueOperation();
        boolean bl = false;
        ScreenableIssueOperation screenableIssueOperation = it;
        return Intrinsics.areEqual((Object)screenableIssueOperation, (Object)IssueOperations.CREATE_ISSUE_OPERATION) ? Operation.CREATE : (Intrinsics.areEqual((Object)screenableIssueOperation, (Object)IssueOperations.EDIT_ISSUE_OPERATION) ? Operation.EDIT : (Intrinsics.areEqual((Object)screenableIssueOperation, (Object)IssueOperations.VIEW_ISSUE_OPERATION) ? Operation.VIEW : Operation.DEFAULT));
    }

    @Override
    @Nullable
    public FieldScreenScheme extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull FieldScreenScheme entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/screen/ScreenSchemeExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/export/core/screen/ScreenSchemeExporter$Operation;", "", "(Ljava/lang/String;I)V", "DEFAULT", "CREATE", "EDIT", "VIEW", "jira-migration-plugin"})
    public static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation DEFAULT = new Operation();
        public static final /* enum */ Operation CREATE = new Operation();
        public static final /* enum */ Operation EDIT = new Operation();
        public static final /* enum */ Operation VIEW = new Operation();
        private static final /* synthetic */ Operation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String value) {
            return Enum.valueOf(Operation.class, value);
        }

        @NotNull
        public static EnumEntries<Operation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationArray = new Operation[]{Operation.DEFAULT, Operation.CREATE, Operation.EDIT, Operation.VIEW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

