/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.serviceconfig;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.log.MessageEntityIdentifier;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.PropertyEntryValue;
import com.atlassian.migration.jira.core.ServiceConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 -2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001-B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J,\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001aH\u0002J(\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001aH\u0002J \u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0002H\u0016J\b\u0010*\u001a\u00020\u001fH\u0007J\f\u0010+\u001a\u00020,*\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0013\u00a8\u0006."}, d2={"Lcom/atlassian/jira/migration/export/core/serviceconfig/ServiceConfigExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/service/JiraServiceContainer;", "Lcom/atlassian/migration/jira/core/ServiceConfig;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "identifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "issueTypeManager", "Lcom/atlassian/jira/config/IssueTypeManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/config/IssueTypeManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log$1", "convert", "Lcom/atlassian/migration/jira/core/PropertyEntryValue;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "paramKey", "", "convertParams", "", "exportData", "exportUsersAndGroups", "", "getHandlerMap", "paramValue", "getReferencesIfExist", "value", "mapUser", "Lcom/atlassian/migration/base/mri/MRI;", "username", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "identifier", "Lcom/atlassian/jira/migration/log/MessageEntityIdentifier;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nServiceConfigExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceConfigExporter.kt\ncom/atlassian/jira/migration/export/core/serviceconfig/ServiceConfigExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n819#2:129\n847#2,2:130\n1208#2,2:132\n1238#2,4:134\n1549#2:138\n1620#2,3:139\n1179#2,2:142\n1253#2,4:144\n1238#2,4:150\n453#3:148\n403#3:149\n1#4:154\n*S KotlinDebug\n*F\n+ 1 ServiceConfigExporter.kt\ncom/atlassian/jira/migration/export/core/serviceconfig/ServiceConfigExporter\n*L\n58#1:129\n58#1:130,2\n58#1:132,2\n58#1:134,4\n77#1:138\n77#1:139,3\n77#1:142,2\n77#1:144,4\n92#1:150,4\n92#1:148\n92#1:149\n*E\n"})
public final class ServiceConfigExporter
implements Exporter<Long, JiraServiceContainer, ServiceConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EntityIdentifierGenerator identifierGenerator;
    @NotNull
    private final IssueTypeManager issueTypeManager;
    private final Logger log$1;
    @NotNull
    private final ExporterKey key;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String HANDLER_PARAMS_KEY = "handler.params";
    @NotNull
    private static final String ISSUE_TYPE_KEY = "issuetype";
    @NotNull
    private static final String REPORTER_USER_KEY = "reporteruserkey";
    @NotNull
    private static final String POPSERVER_KEY = "popserver";
    @NotNull
    private static final String CREATE_USERS_KEY = "createusers";
    @NotNull
    private static final String NOTIFY_USERS_KEY = "notifyusers";
    @NotNull
    private static final String TRUE_VALUE = "true";
    @NotNull
    private static final String FALSE_VALUE = "false";

    @Inject
    public ServiceConfigExporter(@NotNull ExportService exportService, @NotNull EntityIdentifierGenerator identifierGenerator, @NotNull IssueTypeManager issueTypeManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)identifierGenerator, (String)"identifierGenerator");
        Intrinsics.checkNotNullParameter((Object)issueTypeManager, (String)"issueTypeManager");
        this.exportService = exportService;
        this.identifierGenerator = identifierGenerator;
        this.issueTypeManager = issueTypeManager;
        this.log$1 = LoggerFactory.getLogger(ServiceConfigExporter.class);
        this.key = new ExporterKey(ServiceConfig.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, JiraServiceContainer.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull JiraServiceContainer entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(ServiceConfig.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MessageEntityIdentifier identifier(JiraServiceContainer $this$identifier) {
        return EntityIdentifierGenerator.generate$default(this.identifierGenerator, this.mriForEntity($this$identifier), $this$identifier, null, 4, null);
    }

    @Override
    @NotNull
    public ServiceConfig exportData(@NotNull ExportContext ctx, @NotNull JiraServiceContainer entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), ctx.getExportMode()};
        this.log$1.debug("[MigrationId:{}] Exporting jiraServiceContainer with id {}  under exportMode:{}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getServiceClass();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getServiceClass(...)");
        String string2 = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return new ServiceConfig(mRI, string, string2, Long.valueOf(entity.getDelay()), entity.getCronExpression(), this.convertParams(ctx, entity));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, PropertyEntryValue> convertParams(ExportContext ctx, JiraServiceContainer entity) {
        Map map;
        Object object = entity.getProperties();
        if (object != null && (object = object.getKeys()) != null) {
            void $this$associateByTo$iv$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = (Iterable)object;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo22 = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)String.valueOf(it), (Object)POPSERVER_KEY)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$associateBy$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable $i$f$filterNotTo22 = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            Iterator iterator3 = $this$associateByTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object element$iv$iv;
                Object t = element$iv$iv = iterator3.next();
                Map map2 = destination$iv$iv2;
                boolean bl = false;
                Object it = element$iv$iv;
                String string = String.valueOf(it);
                boolean bl2 = false;
                PropertyEntryValue propertyEntryValue = this.convert(ctx, entity, String.valueOf(it));
                map2.put(string, propertyEntryValue);
            }
            map = destination$iv$iv2;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final PropertyEntryValue convert(ExportContext ctx, JiraServiceContainer entity, String paramKey) {
        PropertyEntryValue propertyEntryValue;
        if (Intrinsics.areEqual((Object)paramKey, (Object)HANDLER_PARAMS_KEY)) {
            String paramValue = entity.getProperties().getString(paramKey);
            CharSequence charSequence = paramValue;
            if (charSequence == null || charSequence.length() == 0) {
                propertyEntryValue = (PropertyEntryValue)PropertyEntryValue.NullPropertyEntryValue.INSTANCE;
            } else {
                Intrinsics.checkNotNull((Object)paramValue);
                propertyEntryValue = (PropertyEntryValue)new PropertyEntryValue.MultiPropertyEntryValue(this.getHandlerMap(ctx, entity, paramValue));
            }
        } else {
            String string = entity.getProperties().getString(paramKey);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            propertyEntryValue = (PropertyEntryValue)new PropertyEntryValue.StringPropertyEntryValue(string);
        }
        return propertyEntryValue;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, PropertyEntryValue> getHandlerMap(ExportContext ctx, JiraServiceContainer entity, String paramValue) {
        void $this$mapValuesTo$iv$iv;
        void $this$associateTo$iv$iv;
        Map $this$associate$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)paramValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = new String[]{"="};
            object2.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])object, (boolean)false, (int)0, (int)6, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associate2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associate$iv), (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv2;
            object = (List)element$iv$iv;
            boolean bl2 = false;
            String key = (String)object.get(0);
            String value = (String)object.get(1);
            object = TuplesKt.to((Object)key, (Object)value);
            bl.put(object.getFirst(), object.getSecond());
        }
        Map params = MapsKt.toMutableMap((Map)destination$iv$iv2);
        if (Intrinsics.areEqual(params.get(CREATE_USERS_KEY), (Object)TRUE_VALUE)) {
            params.put(CREATE_USERS_KEY, FALSE_VALUE);
            $this$associate$iv = params;
            String $i$f$associate2 = REPORTER_USER_KEY;
            String string = ctx.getStartedBy().getUsername();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUsername(...)");
            String capacity$iv2 = string;
            $this$associate$iv.put($i$f$associate2, capacity$iv2);
            this.log$1.warn("Setting createusers to false for mail handler " + entity.getName() + " - setting reporteruserkey to " + ctx.getStartedBy().getUsername());
        }
        if (Intrinsics.areEqual(params.get(NOTIFY_USERS_KEY), (Object)TRUE_VALUE)) {
            params.put(NOTIFY_USERS_KEY, FALSE_VALUE);
        }
        Map $this$mapValues$iv = params;
        boolean $i$f$mapValues = false;
        Map capacity$iv2 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object2 = object3;
            boolean bl3 = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            PropertyEntryValue propertyEntryValue = this.getReferencesIfExist(ctx, entity, value, key);
            object2.put(k, propertyEntryValue);
        }
        return destination$iv$iv;
    }

    private final PropertyEntryValue getReferencesIfExist(ExportContext ctx, JiraServiceContainer entity, String value, String key) {
        String string = key;
        return Intrinsics.areEqual((Object)string, (Object)ISSUE_TYPE_KEY) ? (PropertyEntryValue)new PropertyEntryValue.MRIPropertyEntryValue(ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, this.issueTypeManager.getIssueType(value), false, 4, null)) : (Intrinsics.areEqual((Object)string, (Object)REPORTER_USER_KEY) ? (PropertyEntryValue)new PropertyEntryValue.MRIPropertyEntryValue(this.mapUser(ctx, value, entity)) : (PropertyEntryValue)new PropertyEntryValue.StringPropertyEntryValue(value));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull JiraServiceContainer entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log$1.debug("Exporting users and groups for jiraServiceContainer {} for migration {} under exportMode {}", objectArray);
        this.convertParams(ctx, entity);
    }

    private final MRI mapUser(ExportContext ctx, String username, JiraServiceContainer entity) {
        MRI mRI;
        block3: {
            block2: {
                UserRef userRef = UserRef.Companion.fromString(username);
                if (userRef == null) break block2;
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
                if (mRI != null) break block3;
            }
            MRI mRI2 = this.mriForEntity(entity);
            String string = this.identifier(entity) + " has no reporter assigned or no longer exists";
            ExportErrorCode exportErrorCode = ExportErrorCode.SVC_CONFIG_HAS_NO_REPORTER_USER;
            throw new ExportException(mRI2, exportErrorCode, string, "Please set a valid reporter for this service config.", null, null, null, 112, null);
        }
        return mRI;
    }

    @Override
    @Nullable
    public JiraServiceContainer extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull JiraServiceContainer entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(ServiceConfigExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/export/core/serviceconfig/ServiceConfigExporter$Companion;", "", "()V", "CREATE_USERS_KEY", "", "FALSE_VALUE", "HANDLER_PARAMS_KEY", "ISSUE_TYPE_KEY", "NOTIFY_USERS_KEY", "POPSERVER_KEY", "REPORTER_USER_KEY", "TRUE_VALUE", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

