/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.serviceconfig.service;

import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/export/core/serviceconfig/service/ServiceConfigService;", "", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "serviceManager", "Lcom/atlassian/jira/service/ServiceManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/service/ServiceManager;)V", "checkIfMailHandlerHasProjectReference", "", "paramValue", "", "projectKey", "exportGlobalMailHandlers", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportMailHandlersWithProjectReference", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nServiceConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceConfigService.kt\ncom/atlassian/jira/migration/export/core/serviceconfig/service/ServiceConfigService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n766#2:54\n857#2,2:55\n766#2:57\n857#2,2:58\n1855#2,2:60\n766#2:62\n857#2,2:63\n819#2:65\n847#2,2:66\n1855#2,2:68\n1549#2:70\n1620#2,3:71\n1747#2,3:74\n1549#2:77\n1620#2,3:78\n1747#2,3:81\n*S KotlinDebug\n*F\n+ 1 ServiceConfigService.kt\ncom/atlassian/jira/migration/export/core/serviceconfig/service/ServiceConfigService\n*L\n26#1:54\n26#1:55,2\n27#1:57\n27#1:58,2\n30#1:60,2\n36#1:62\n36#1:63,2\n37#1:65\n37#1:66,2\n40#1:68,2\n46#1:70\n46#1:71,3\n46#1:74,3\n51#1:77\n51#1:78,3\n51#1:81,3\n*E\n"})
public final class ServiceConfigService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ServiceManager serviceManager;
    private static final Logger log = LoggerFactory.getLogger(ServiceConfigService.class);
    @NotNull
    public static final String MAIL_HANDLER_CLASS = "com.atlassian.jira.service.services.mail.MailFetcherService";
    @NotNull
    public static final String MAIL_HANDLER_PARAMS_KEY = "handler.params";
    @NotNull
    public static final String PROJECT_KEY = "project";

    @Inject
    public ServiceConfigService(@NotNull ExportService exportService, @NotNull ServiceManager serviceManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)serviceManager, (String)"serviceManager");
        this.exportService = exportService;
        this.serviceManager = serviceManager;
    }

    public final void exportMailHandlersWithProjectReference(@NotNull ExportContext ctx) {
        JiraServiceContainer it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        log.info("Exporting mail handlers With project reference " + ctx.getProject().getId() + " for migration " + ctx.getMigrationId());
        Collection collection = this.serviceManager.getServices();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getServices(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JiraServiceContainer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getServiceClass(), (Object)MAIL_HANDLER_CLASS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JiraServiceContainer)element$iv$iv;
            boolean bl = false;
            String string = it.getProperties().getString(MAIL_HANDLER_PARAMS_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = ctx.getProject().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
            if (!this.checkIfMailHandlerHasProjectReference(string, string2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JiraServiceContainer it2 = (JiraServiceContainer)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it2, false, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void exportGlobalMailHandlers(@NotNull ExportContext ctx) {
        void $this$filterNotTo$iv$iv;
        JiraServiceContainer it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        log.info("Exporting all global mail handlers for migration " + ctx.getMigrationId());
        Collection collection = this.serviceManager.getServices();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getServices(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JiraServiceContainer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getServiceClass(), (Object)MAIL_HANDLER_CLASS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (JiraServiceContainer)element$iv$iv;
            boolean bl = false;
            String string = it.getProperties().getString(MAIL_HANDLER_PARAMS_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (this.checkIfMailHandlerHasProjectReference(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JiraServiceContainer it2 = (JiraServiceContainer)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it2, false, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkIfMailHandlerHasProjectReference(String paramValue, String projectKey) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)paramValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String[] stringArray2 = new String[]{"="};
                collection.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it = (List)element$iv;
                    boolean bl3 = false;
                    if (!(it.indexOf(PROJECT_KEY) != -1 && it.indexOf(projectKey) != -1)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkIfMailHandlerHasProjectReference(String paramValue) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)paramValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String[] stringArray2 = new String[]{"="};
                collection.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it = (List)element$iv;
                    boolean bl3 = false;
                    if (!(it.indexOf(PROJECT_KEY) != -1)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/export/core/serviceconfig/service/ServiceConfigService$Companion;", "", "()V", "MAIL_HANDLER_CLASS", "", "MAIL_HANDLER_PARAMS_KEY", "PROJECT_KEY", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

