/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.workflow;

import com.atlassian.jira.migration.app.ConnectWorkflowRule;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.export.core.workflow.Condition;
import com.atlassian.jira.migration.export.core.workflow.RuleExportInfo;
import com.atlassian.jira.migration.export.core.workflow.SwfConditionExportServiceKt;
import com.atlassian.jira.migration.export.core.workflowrule.RuleDescriptor;
import com.atlassian.jira.migration.export.core.workflowrule.WorkflowRuleExporter;
import com.atlassian.jira.migration.export.core.workflowrule.WorkflowRuleExporterKt;
import com.atlassian.jira.migration.export.framework.ProjectExportContext;
import com.atlassian.migration.jira.classic.workflow.transition.ConditionSubType;
import com.atlassian.migration.jira.classic.workflow.transition.ConditionType;
import com.atlassian.migration.jira.classic.workflow.transition.WorkflowCondition;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J$\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0001H\u0002J\b\u0010\"\u001a\u00020#H\u0007J \u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0007H\u0002R)\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR0\u0010\r\u001a$\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/export/core/workflow/SwfConditionExportService;", "", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "conditionExporters", "", "Lcom/atlassian/jira/migration/export/core/workflowrule/WorkflowRuleExporter;", "Lcom/atlassian/jira/migration/export/core/workflowrule/RuleDescriptor$ConditionRuleDescriptor;", "Lcom/atlassian/migration/jira/classic/workflow/transition/ConditionSubType;", "Lcom/atlassian/migration/jira/classic/workflow/transition/WorkflowCondition$InternalWorkflowCondition;", "(Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Ljava/util/List;)V", "getConditionExporters", "()Ljava/util/List;", "conditionTypeToExporterMap", "", "", "Lcom/atlassian/jira/migration/common/ClassName;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "exportCondition", "Lcom/atlassian/migration/jira/classic/workflow/transition/WorkflowCondition;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ProjectExportContext;", "ruleExportInfo", "Lcom/atlassian/jira/migration/export/core/workflow/RuleExportInfo;", "findConnectRule", "Lcom/atlassian/jira/migration/app/ConnectWorkflowRule;", "condition", "findInternalExporter", "mapCompoundedCondition", "conditions", "Lcom/opensymphony/workflow/loader/ConditionsDescriptor;", "mapCondition", "conditionOrConditions", "postConstruct", "", "toWorkflowRule", "Lcom/atlassian/jira/migration/export/core/workflow/Condition;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSwfConditionExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwfConditionExportService.kt\ncom/atlassian/jira/migration/export/core/workflow/SwfConditionExportService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n1#2:157\n1603#3,9:147\n1855#3:156\n1856#3:158\n1612#3:159\n*S KotlinDebug\n*F\n+ 1 SwfConditionExportService.kt\ncom/atlassian/jira/migration/export/core/workflow/SwfConditionExportService\n*L\n58#1:157\n58#1:147,9\n58#1:156\n58#1:158\n58#1:159\n*E\n"})
public final class SwfConditionExportService {
    @NotNull
    private final List<WorkflowRuleExporter<RuleDescriptor.ConditionRuleDescriptor, ConditionSubType, WorkflowCondition.InternalWorkflowCondition>> conditionExporters;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final Map<String, WorkflowRuleExporter<RuleDescriptor.ConditionRuleDescriptor, ConditionSubType, WorkflowCondition.InternalWorkflowCondition>> conditionTypeToExporterMap;

    @Inject
    public SwfConditionExportService(@NotNull ObjectMapperFactory objectMapperFactory, @NotNull List<? extends WorkflowRuleExporter<? super RuleDescriptor.ConditionRuleDescriptor, ConditionSubType, WorkflowCondition.InternalWorkflowCondition>> conditionExporters) {
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter(conditionExporters, (String)"conditionExporters");
        this.conditionExporters = conditionExporters;
        this.mapper = objectMapperFactory.createObjectMapper();
        this.conditionTypeToExporterMap = WorkflowRuleExporterKt.toClassNameToExporterMap(this.conditionExporters);
    }

    @NotNull
    public final List<WorkflowRuleExporter<RuleDescriptor.ConditionRuleDescriptor, ConditionSubType, WorkflowCondition.InternalWorkflowCondition>> getConditionExporters() {
        return this.conditionExporters;
    }

    @PostConstruct
    public final void postConstruct() {
        WorkflowRuleExporterKt.verifyNoMultipleExportersMapWithSameClassName(this.conditionExporters);
    }

    @Nullable
    public final WorkflowCondition exportCondition(@NotNull ProjectExportContext ctx, @NotNull RuleExportInfo ruleExportInfo) {
        WorkflowCondition workflowCondition;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)ruleExportInfo, (String)"ruleExportInfo");
        ConditionsDescriptor conditionsDescriptor = ruleExportInfo.getConditions();
        if (conditionsDescriptor != null) {
            ConditionsDescriptor it = conditionsDescriptor;
            boolean bl = false;
            workflowCondition = this.mapCompoundedCondition(ctx, ruleExportInfo, it);
        } else {
            workflowCondition = null;
        }
        return workflowCondition;
    }

    /*
     * WARNING - void declaration
     */
    private final WorkflowCondition mapCompoundedCondition(ProjectExportContext ctx, RuleExportInfo ruleExportInfo, ConditionsDescriptor conditions2) {
        WorkflowCondition.CompoundedWorkflowCondition compoundedWorkflowCondition;
        ConditionType conditionType = (ConditionType)SwfConditionExportServiceKt.access$getConditionTypes$p().get(SwfConditionExportServiceKt.access$getConditionType(conditions2));
        if (conditionType != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            ConditionType conditionType2 = conditionType;
            boolean bl = false;
            List list = conditions2.getConditions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConditions(...)");
            Iterable iterable = CollectionsKt.filterNotNull((Iterable)list);
            ConditionType conditionType3 = conditionType2;
            boolean $i$f$mapNotNull = false;
            void var9_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                WorkflowCondition it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                Object it = element$iv$iv;
                boolean bl3 = false;
                if (this.mapCondition(ctx, ruleExportInfo, it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            ConditionType conditionType4 = conditionType3;
            compoundedWorkflowCondition = new WorkflowCondition.CompoundedWorkflowCondition(conditionType4, list2);
        } else {
            compoundedWorkflowCondition = null;
        }
        return (WorkflowCondition)compoundedWorkflowCondition;
    }

    private final WorkflowCondition mapCondition(ProjectExportContext ctx, RuleExportInfo ruleExportInfo, Object conditionOrConditions) {
        Object object = conditionOrConditions;
        return object instanceof ConditionsDescriptor ? this.mapCompoundedCondition(ctx, ruleExportInfo, (ConditionsDescriptor)conditionOrConditions) : (object instanceof ConditionDescriptor ? this.toWorkflowRule(ctx, ruleExportInfo, new RuleDescriptor.ConditionRuleDescriptor((ConditionDescriptor)conditionOrConditions)).export() : null);
    }

    private final Condition toWorkflowRule(ProjectExportContext ctx, RuleExportInfo ruleExportInfo, RuleDescriptor.ConditionRuleDescriptor condition) {
        Condition condition2;
        WorkflowRuleExporter<RuleDescriptor.ConditionRuleDescriptor, ConditionSubType, WorkflowCondition.InternalWorkflowCondition> workflowRuleExporter = this.findInternalExporter(condition);
        if (workflowRuleExporter != null) {
            WorkflowRuleExporter<RuleDescriptor.ConditionRuleDescriptor, ConditionSubType, WorkflowCondition.InternalWorkflowCondition> exporter = workflowRuleExporter;
            boolean bl = false;
            condition2 = new Condition.Internal(ctx, exporter, ruleExportInfo, condition);
        } else {
            ConnectWorkflowRule connectWorkflowRule = this.findConnectRule(ctx, condition);
            if (connectWorkflowRule != null) {
                ConnectWorkflowRule connectRule = connectWorkflowRule;
                boolean bl = false;
                condition2 = new Condition.Connect(connectRule, condition, this.mapper);
            } else {
                condition2 = new Condition.Unsupported(ctx, ruleExportInfo, condition);
            }
        }
        return condition2;
    }

    private final ConnectWorkflowRule findConnectRule(ProjectExportContext ctx, RuleDescriptor.ConditionRuleDescriptor condition) {
        return ctx.getSupportedConnectWorkflowRules().get(condition.getClassName());
    }

    private final WorkflowRuleExporter<RuleDescriptor.ConditionRuleDescriptor, ConditionSubType, WorkflowCondition.InternalWorkflowCondition> findInternalExporter(RuleDescriptor.ConditionRuleDescriptor condition) {
        return this.conditionTypeToExporterMap.get(condition.getClassName());
    }
}

