/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.workflow;

import com.atlassian.jira.migration.export.core.workflow.RuleExportInfo;
import com.atlassian.jira.migration.export.core.workflow.SwfExportFacadeKt;
import com.atlassian.jira.migration.export.core.workflowrule.RuleDescriptor;
import com.atlassian.jira.migration.export.core.workflowrule.RuleValidationFailure;
import com.atlassian.jira.migration.export.core.workflowrule.WorkflowRuleExporter;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.workflow.Workflow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001aU\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\b\b\u0000\u0010\b*\u00020\t\"\u0004\b\u0001\u0010\n\"\u0004\b\u0002\u0010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\b\u00a2\u0006\u0002\u0010\u0012\u001a \u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0018H\u0002\u001a$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001cH\u0002\u001a\u001a\u0010 \u001a\u00020\u001a*\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006$"}, d2={"log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "exportWorkflowRule", "CloudRule", "Descriptor", "Lcom/atlassian/jira/migration/export/core/workflowrule/RuleDescriptor;", "CloudType", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exporter", "Lcom/atlassian/jira/migration/export/core/workflowrule/WorkflowRuleExporter;", "ruleExportInfo", "Lcom/atlassian/jira/migration/export/core/workflow/RuleExportInfo;", "descriptor", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/jira/migration/export/core/workflowrule/WorkflowRuleExporter;Lcom/atlassian/jira/migration/export/core/workflow/RuleExportInfo;Lcom/atlassian/jira/migration/export/core/workflowrule/RuleDescriptor;)Ljava/lang/Object;", "getClassName", "", "T", "", "clazz", "Ljava/lang/Class;", "handleUnsupportedWorkflowRule", "", "detailSupplier", "Lkotlin/Function0;", "logger", "Lkotlin/Lazy;", "lambda", "handleRuleValidationFailures", "failures", "", "Lcom/atlassian/jira/migration/export/core/workflowrule/RuleValidationFailure;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSwfExportFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwfExportFacade.kt\ncom/atlassian/jira/migration/export/core/workflow/SwfExportFacadeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1549#2:271\n1620#2,3:272\n2634#2:275\n1855#2,2:277\n1#3:276\n*S KotlinDebug\n*F\n+ 1 SwfExportFacade.kt\ncom/atlassian/jira/migration/export/core/workflow/SwfExportFacadeKt\n*L\n227#1:271\n227#1:272,3\n228#1:275\n251#1:277,2\n228#1:276\n*E\n"})
public final class SwfExportFacadeKt {
    @NotNull
    private static final Lazy log$delegate = SwfExportFacadeKt.logger((Function0<Unit>)((Function0)log.2.INSTANCE));

    public static final void handleUnsupportedWorkflowRule(@NotNull ExportContext ctx, @NotNull RuleExportInfo ruleExportInfo, @NotNull Function0<String> detailSupplier) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)ruleExportInfo, (String)"ruleExportInfo");
        Intrinsics.checkNotNullParameter(detailSupplier, (String)"detailSupplier");
        RuleExportInfo $this$handleUnsupportedWorkflowRule_u24lambda_u240 = ruleExportInfo;
        boolean bl = false;
        ExportContext.handleUnsupported$default(ctx, $this$handleUnsupportedWorkflowRule_u24lambda_u240.getWorkflowName(), $this$handleUnsupportedWorkflowRule_u24lambda_u240.getWorkflowName(), (String)detailSupplier.invoke(), $this$handleUnsupportedWorkflowRule_u24lambda_u240.getTransitionName(), null, null, 48, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <Descriptor extends RuleDescriptor, CloudType, CloudRule> CloudRule exportWorkflowRule(@NotNull ExportContext ctx, @NotNull WorkflowRuleExporter<? super Descriptor, CloudType, ? extends CloudRule> exporter, @NotNull RuleExportInfo ruleExportInfo, @NotNull Descriptor descriptor) {
        Iterable<Object> iterable;
        void $this$onEach$iv;
        RuleValidationFailure it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(exporter, (String)"exporter");
        Intrinsics.checkNotNullParameter((Object)ruleExportInfo, (String)"ruleExportInfo");
        Intrinsics.checkNotNullParameter(descriptor, (String)"descriptor");
        List<RuleValidationFailure> validationFailures2 = exporter.validateRule(ctx, descriptor);
        ctx.sendProgressUpdate();
        Iterable<Object> iterable2 = validationFailures2;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RuleValidationFailure ruleValidationFailure = (RuleValidationFailure)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.enrichWithTransitionInfo(ruleExportInfo.getWorkflowName(), ruleExportInfo.getTransitionName()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = $this$mapTo$iv$iv = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            it = (RuleValidationFailure)element$iv;
            boolean bl2 = false;
            SwfExportFacadeKt.getLog().warn(it.getMsg());
        }
        List failures = (List)$this$mapTo$iv$iv;
        if (failures.isEmpty()) {
            try {
                iterable2 = exporter.exportWorkflowRule(ctx, descriptor);
            }
            catch (ExportException e) {
                RuleValidationFailure ruleValidationFailure = new RuleValidationFailure("Failed to export workflow rule: " + ruleExportInfo.getWorkflowName() + " with descriptor: " + descriptor.getClassName() + " due to: " + e.getReason(), MriExtensionsKt.mri$default(Workflow.Companion.getEntityType(), ruleExportInfo.getWorkflowName(), null, 2, null));
                SwfExportFacadeKt.handleRuleValidationFailures(ctx, CollectionsKt.listOf((Object)ruleValidationFailure));
                iterable2 = null;
            }
            iterable = iterable2;
        } else {
            if (!ruleExportInfo.getShouldSkipInvalidRules()) {
                SwfExportFacadeKt.handleRuleValidationFailures(ctx, failures);
            }
            iterable = null;
        }
        return (CloudRule)iterable;
    }

    private static final void handleRuleValidationFailures(ExportContext $this$handleRuleValidationFailures, List<RuleValidationFailure> failures) {
        Iterable $this$forEach$iv = failures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuleValidationFailure failure = (RuleValidationFailure)element$iv;
            boolean bl = false;
            MRI mRI = failure.getMri();
            String string = failure.getMsg();
            ExportErrorCode exportErrorCode = ExportErrorCode.SWF_RULE_VALIDATION_FAILED;
            $this$handleRuleValidationFailures.handleExportFailure(failure.getMri(), new ExportException(mRI, exportErrorCode, string, "Double-check the workflow rule for missing config values or references", null, null, null, 112, null), failure.getMsg());
        }
    }

    private static final Lazy<Logger> logger(Function0<Unit> lambda) {
        return LazyKt.lazy((Function0)((Function0)new Function0<Logger>(lambda){
            final /* synthetic */ Function0<Unit> $lambda;
            {
                this.$lambda = $lambda;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger((String)SwfExportFacadeKt.access$getClassName(this.$lambda.getClass()));
            }
        }));
    }

    private static final <T> String getClassName(Class<T> clazz) {
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("\\$.*$");
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    @NotNull
    public static final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public static final /* synthetic */ String access$getClassName(Class clazz) {
        return SwfExportFacadeKt.getClassName(clazz);
    }
}

