/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.workflow;

import com.atlassian.jira.migration.app.ConnectWorkflowRule;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.export.core.workflow.RuleExportInfo;
import com.atlassian.jira.migration.export.core.workflow.Validator;
import com.atlassian.jira.migration.export.core.workflowrule.RuleDescriptor;
import com.atlassian.jira.migration.export.core.workflowrule.WorkflowRuleExporter;
import com.atlassian.jira.migration.export.core.workflowrule.WorkflowRuleExporterKt;
import com.atlassian.jira.migration.export.framework.ProjectExportContext;
import com.atlassian.migration.jira.classic.workflow.transition.InternalValidatorType;
import com.atlassian.migration.jira.classic.workflow.transition.WorkflowValidator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J$\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0007J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\r\u001a$\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/export/core/workflow/SwfValidatorExportService;", "", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "validatorExporters", "", "Lcom/atlassian/jira/migration/export/core/workflowrule/WorkflowRuleExporter;", "Lcom/atlassian/jira/migration/export/core/workflowrule/RuleDescriptor$ValidatorRuleDescriptor;", "Lcom/atlassian/migration/jira/classic/workflow/transition/InternalValidatorType;", "Lcom/atlassian/migration/jira/classic/workflow/transition/WorkflowValidator$InternalValidator;", "(Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Ljava/util/List;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "serverValidatorTypeToExporterMap", "", "", "Lcom/atlassian/jira/migration/common/ClassName;", "exportValidators", "Lcom/atlassian/migration/jira/classic/workflow/transition/WorkflowValidator;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ProjectExportContext;", "ruleExportInfo", "Lcom/atlassian/jira/migration/export/core/workflow/RuleExportInfo;", "findConnectRule", "Lcom/atlassian/jira/migration/app/ConnectWorkflowRule;", "validator", "findInternalExporter", "postConstruct", "", "toWorkflowRule", "Lcom/atlassian/jira/migration/export/core/workflow/Validator;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSwfValidatorExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwfValidatorExportService.kt\ncom/atlassian/jira/migration/export/core/workflow/SwfValidatorExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n800#2,11:111\n1549#2:122\n1620#2,3:123\n1549#2:126\n1620#2,3:127\n1603#2,9:130\n1855#2:139\n1856#2:141\n1612#2:142\n1#3:140\n1#3:143\n*S KotlinDebug\n*F\n+ 1 SwfValidatorExportService.kt\ncom/atlassian/jira/migration/export/core/workflow/SwfValidatorExportService\n*L\n44#1:111,11\n45#1:122\n45#1:123,3\n46#1:126\n46#1:127,3\n47#1:130,9\n47#1:139\n47#1:141\n47#1:142\n47#1:140\n*E\n"})
public final class SwfValidatorExportService {
    @NotNull
    private final List<WorkflowRuleExporter<RuleDescriptor.ValidatorRuleDescriptor, InternalValidatorType, WorkflowValidator.InternalValidator>> validatorExporters;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final Map<String, WorkflowRuleExporter<RuleDescriptor.ValidatorRuleDescriptor, InternalValidatorType, WorkflowValidator.InternalValidator>> serverValidatorTypeToExporterMap;

    @Inject
    public SwfValidatorExportService(@NotNull ObjectMapperFactory objectMapperFactory, @NotNull List<? extends WorkflowRuleExporter<? super RuleDescriptor.ValidatorRuleDescriptor, InternalValidatorType, WorkflowValidator.InternalValidator>> validatorExporters) {
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter(validatorExporters, (String)"validatorExporters");
        this.validatorExporters = validatorExporters;
        this.mapper = objectMapperFactory.createObjectMapper();
        this.serverValidatorTypeToExporterMap = WorkflowRuleExporterKt.toClassNameToExporterMap(this.validatorExporters);
    }

    @PostConstruct
    public final void postConstruct() {
        WorkflowRuleExporterKt.verifyNoMultipleExportersMapWithSameClassName(this.validatorExporters);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WorkflowValidator> exportValidators(@NotNull ProjectExportContext ctx, @NotNull RuleExportInfo ruleExportInfo) {
        void $this$mapNotNullTo$iv$iv;
        RuleDescriptor.ValidatorRuleDescriptor p0;
        Collection collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)ruleExportInfo, (String)"ruleExportInfo");
        Iterable $this$filterIsInstance$iv = ruleExportInfo.getValidators();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ValidatorDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (ValidatorDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RuleDescriptor.ValidatorRuleDescriptor((ValidatorDescriptor)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (RuleDescriptor.ValidatorRuleDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toWorkflowRule(ctx, ruleExportInfo, (RuleDescriptor.ValidatorRuleDescriptor)it));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            WorkflowValidator it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Validator p02 = (Validator)element$iv$iv;
            boolean bl2 = false;
            if (p02.export() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Validator toWorkflowRule(ProjectExportContext ctx, RuleExportInfo ruleExportInfo, RuleDescriptor.ValidatorRuleDescriptor validator) {
        Validator validator2;
        WorkflowRuleExporter<RuleDescriptor.ValidatorRuleDescriptor, InternalValidatorType, WorkflowValidator.InternalValidator> workflowRuleExporter = this.findInternalExporter(validator);
        if (workflowRuleExporter != null) {
            WorkflowRuleExporter<RuleDescriptor.ValidatorRuleDescriptor, InternalValidatorType, WorkflowValidator.InternalValidator> exporter = workflowRuleExporter;
            boolean bl = false;
            validator2 = new Validator.Internal(ctx, exporter, ruleExportInfo, validator);
        } else {
            ConnectWorkflowRule connectWorkflowRule = this.findConnectRule(ctx, validator);
            if (connectWorkflowRule != null) {
                ConnectWorkflowRule connectRule = connectWorkflowRule;
                boolean bl = false;
                validator2 = new Validator.Connect(connectRule, validator, this.mapper);
            } else {
                validator2 = new Validator.Unsupported(ctx, ruleExportInfo, validator);
            }
        }
        return validator2;
    }

    private final ConnectWorkflowRule findConnectRule(ProjectExportContext ctx, RuleDescriptor.ValidatorRuleDescriptor validator) {
        return ctx.getSupportedConnectWorkflowRules().get(validator.getClassName());
    }

    private final WorkflowRuleExporter<RuleDescriptor.ValidatorRuleDescriptor, InternalValidatorType, WorkflowValidator.InternalValidator> findInternalExporter(RuleDescriptor.ValidatorRuleDescriptor validator) {
        return this.serverValidatorTypeToExporterMap.get(validator.getClassName());
    }
}

