/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.workflow;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.migration.export.core.workflow.WorkflowSchemeWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.workflow.IssueTypeWorkflowLink;
import com.atlassian.migration.jira.classic.workflow.WorkflowScheme;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0007JT\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!2\u0006\u0010\u0016\u001a\u00020\u000326\u0010\"\u001a2\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0004\u0012\u0002H!0#H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/atlassian/jira/migration/export/core/workflow/WorkflowSchemeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/workflow/WorkflowSchemeWrapper;", "Lcom/atlassian/migration/jira/classic/workflow/WorkflowScheme;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "workflowManager", "Lcom/atlassian/jira/workflow/WorkflowManager;", "issueTypeManager", "Lcom/atlassian/jira/config/IssueTypeManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/workflow/WorkflowManager;Lcom/atlassian/jira/config/IssueTypeManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapDefaultWorkflow", "Lcom/atlassian/migration/base/mri/MRI;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "zipIssueTypesWithWorkflowNames", "", "T", "transform", "Lkotlin/Function2;", "Lcom/atlassian/jira/issue/issuetype/IssueType;", "Lkotlin/ParameterName;", "name", "issueType", "workflow", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nWorkflowSchemeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkflowSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/workflow/WorkflowSchemeExporter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,94:1\n526#2:95\n511#2,6:96\n125#3:102\n152#3,3:103\n*S KotlinDebug\n*F\n+ 1 WorkflowSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/workflow/WorkflowSchemeExporter\n*L\n80#1:95\n80#1:96,6\n81#1:102\n81#1:103,3\n*E\n"})
public final class WorkflowSchemeExporter
implements Exporter<String, WorkflowSchemeWrapper, WorkflowScheme> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final WorkflowManager workflowManager;
    @NotNull
    private final IssueTypeManager issueTypeManager;
    private final Logger log;

    @Inject
    public WorkflowSchemeExporter(@NotNull ExportService exportService, @NotNull WorkflowManager workflowManager, @NotNull IssueTypeManager issueTypeManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)workflowManager, (String)"workflowManager");
        Intrinsics.checkNotNullParameter((Object)issueTypeManager, (String)"issueTypeManager");
        this.exportService = exportService;
        this.workflowManager = workflowManager;
        this.issueTypeManager = issueTypeManager;
        this.log = LoggerFactory.getLogger(WorkflowSchemeExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, WorkflowSchemeWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(WorkflowScheme.Companion.getEntityType());
    }

    @Override
    @NotNull
    public WorkflowScheme exportData(@NotNull ExportContext ctx, @NotNull WorkflowSchemeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getName(), ctx.getExportMode()};
        this.log.debug("[MigrationId:{}] Exporting workflowScheme with name {}  under exportMode:{}", objectArray);
        return new WorkflowScheme(this.mriForEntity(entity), entity.getName(), entity.getDescription(), this.mapDefaultWorkflow(ctx, entity), this.zipIssueTypesWithWorkflowNames(entity, (Function2)new Function2<IssueType, String, IssueTypeWorkflowLink>(this, ctx){
            final /* synthetic */ WorkflowSchemeExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(2);
            }

            @NotNull
            public final IssueTypeWorkflowLink invoke(@NotNull IssueType issueType, @NotNull String workflow) {
                Intrinsics.checkNotNullParameter((Object)issueType, (String)"issueType");
                Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
                return new IssueTypeWorkflowLink(ExportOrThrow.DefaultImpls.exportOrThrow$default(WorkflowSchemeExporter.access$getExportService$p(this.this$0), this.$ctx, issueType, false, 4, null), ExportOrThrow.DefaultImpls.exportOrThrow$default(WorkflowSchemeExporter.access$getExportService$p(this.this$0), this.$ctx, WorkflowSchemeExporter.access$getWorkflowManager$p(this.this$0).getWorkflow(workflow), false, 4, null));
            }
        }), null, null, 96, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull WorkflowSchemeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getWorkflowSchemeId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for workflowScheme {} for migration {} under exportMode {}", objectArray);
        this.mapDefaultWorkflow(ctx, entity);
        this.zipIssueTypesWithWorkflowNames(entity, (Function2)new Function2<IssueType, String, MRI>(this, ctx){
            final /* synthetic */ WorkflowSchemeExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(2);
            }

            @NotNull
            public final MRI invoke(@NotNull IssueType issueType, @NotNull String workflow) {
                Intrinsics.checkNotNullParameter((Object)issueType, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
                return ExportOrThrow.DefaultImpls.exportOrThrow$default(WorkflowSchemeExporter.access$getExportService$p(this.this$0), this.$ctx, WorkflowSchemeExporter.access$getWorkflowManager$p(this.this$0).getWorkflow(workflow), false, 4, null);
            }
        });
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull WorkflowSchemeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getWorkflowSchemeId());
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(WorkflowScheme.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MRI mapDefaultWorkflow(ExportContext ctx, WorkflowSchemeWrapper entity) {
        return ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, this.workflowManager.getWorkflow(entity.getActualDefaultWorkflow()), false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<T> zipIssueTypesWithWorkflowNames(WorkflowSchemeWrapper entity, Function2<? super IssueType, ? super String, ? extends T> transform) {
        void $this$mapTo$iv$iv;
        Map $this$filterTo$iv$iv;
        Map<String, String> map = entity.getMappings();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getMappings(...)");
        Map<String, String> $this$filter$iv = map;
        boolean $i$f$filter = false;
        Map<String, String> map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(it.getKey() != null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            String issueTypeId = (String)entry.getKey();
            String workflow = (String)entry.getValue();
            IssueType issueType = this.issueTypeManager.getIssueType(issueTypeId);
            Intrinsics.checkNotNullExpressionValue((Object)issueType, (String)"getIssueType(...)");
            Intrinsics.checkNotNull((Object)workflow);
            object.add(transform.invoke((Object)issueType, (Object)workflow));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public WorkflowSchemeWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull WorkflowSchemeWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    public static final /* synthetic */ ExportService access$getExportService$p(WorkflowSchemeExporter $this) {
        return $this.exportService;
    }

    public static final /* synthetic */ WorkflowManager access$getWorkflowManager$p(WorkflowSchemeExporter $this) {
        return $this.workflowManager;
    }
}

