/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.workflowrule;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.migration.export.core.workflowrule.RuleDescriptor;
import com.atlassian.jira.migration.export.core.workflowrule.RuleDescriptorKt;
import com.atlassian.jira.migration.export.core.workflowrule.RuleValidationFailure;
import com.atlassian.jira.migration.export.core.workflowrule.WorkflowRuleExporterKt;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001f\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u000fH\u0002J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cJ$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000fJ.\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000f2\b\b\u0002\u0010*\u001a\u00020\u000fJ$\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fJ\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000fJ4\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J&\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000f2\b\b\u0002\u0010*\u001a\u00020\u000fJ&\u00100\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000f2\b\b\u0002\u0010*\u001a\u00020\u000fJ4\u00101\u001a\u0004\u0018\u00010\u0016*\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00012\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010 03H\u0002J0\u00104\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c*\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000f2\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010 03H\u0002J\"\u00105\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c*\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002R\"\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/atlassian/jira/migration/export/core/workflowrule/RuleConfigValidator;", "", "statusManager", "Lcom/atlassian/jira/config/StatusManager;", "fieldManager", "Lcom/atlassian/jira/issue/fields/FieldManager;", "jiraRoleManager", "Lcom/atlassian/jira/security/roles/ProjectRoleManager;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "(Lcom/atlassian/jira/config/StatusManager;Lcom/atlassian/jira/issue/fields/FieldManager;Lcom/atlassian/jira/security/roles/ProjectRoleManager;Lcom/atlassian/jira/migration/export/utils/ExportFilters;Lcom/atlassian/jira/issue/CustomFieldManager;)V", "availableStatusIds", "", "", "kotlin.jvm.PlatformType", "getAvailableStatusIds", "()Ljava/util/Set;", "availableStatusNames", "getAvailableStatusNames", "createRuleValidationFailure", "Lcom/atlassian/jira/migration/export/core/workflowrule/RuleValidationFailure;", "fieldName", "statusName", "ruleDescriptor", "Lcom/atlassian/jira/migration/export/core/workflowrule/RuleDescriptor;", "createRuleValidationForMissingItems", "", "missingItems", "configName", "hasFieldExistsAndSupported", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "fieldId", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/String;)Ljava/lang/Boolean;", "isRoleName", "role", "skipInvalidGroupIfExists", "validateFieldValueIfExists", "validateFieldValuesIfExists", "delimiter", "validateRoleIfExists", "validateStatusByNameIfConfigExists", "validateStatuses", "statuses", "validateStatusesById", "validateStatusesByName", "checkFieldSupported", "isSupportedField", "Lkotlin/Function1;", "validateField", "validateUnsupportedField", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nRuleConfigValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleConfigValidator.kt\ncom/atlassian/jira/migration/export/core/workflowrule/RuleConfigValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1549#2:163\n1620#2,3:164\n1549#2:167\n1620#2,3:168\n766#2:171\n857#2,2:172\n1603#2,9:174\n1855#2:183\n1856#2:185\n1612#2:186\n766#2:187\n857#2,2:188\n1#3:184\n1#3:190\n*S KotlinDebug\n*F\n+ 1 RuleConfigValidator.kt\ncom/atlassian/jira/migration/export/core/workflowrule/RuleConfigValidator\n*L\n21#1:163\n21#1:164,3\n22#1:167\n22#1:168,3\n39#1:171\n39#1:172,2\n40#1:174,9\n40#1:183\n40#1:185\n40#1:186\n54#1:187\n54#1:188,2\n40#1:184\n*E\n"})
public final class RuleConfigValidator {
    @NotNull
    private final StatusManager statusManager;
    @NotNull
    private final FieldManager fieldManager;
    @NotNull
    private final ProjectRoleManager jiraRoleManager;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final CustomFieldManager customFieldManager;

    @Inject
    public RuleConfigValidator(@NotNull StatusManager statusManager, @NotNull FieldManager fieldManager, @NotNull ProjectRoleManager jiraRoleManager, @NotNull ExportFilters exportFilters, @NotNull CustomFieldManager customFieldManager) {
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)fieldManager, (String)"fieldManager");
        Intrinsics.checkNotNullParameter((Object)jiraRoleManager, (String)"jiraRoleManager");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        this.statusManager = statusManager;
        this.fieldManager = fieldManager;
        this.jiraRoleManager = jiraRoleManager;
        this.exportFilters = exportFilters;
        this.customFieldManager = customFieldManager;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getAvailableStatusIds() {
        void $this$mapTo$iv$iv;
        Collection collection = this.statusManager.getStatuses();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getStatuses(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Status status = (Status)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(p0.getId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getAvailableStatusNames() {
        void $this$mapTo$iv$iv;
        Collection collection = this.statusManager.getStatuses();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getStatuses(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Status status = (Status)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(p0.getName());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final List<RuleValidationFailure> validateFieldValueIfExists(@NotNull ExportContext ctx, @NotNull RuleDescriptor ruleDescriptor, @NotNull String configName) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)ruleDescriptor, (String)"ruleDescriptor");
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        RuleDescriptor $this$validateFieldValueIfExists_u24lambda_u241 = ruleDescriptor;
        boolean bl = false;
        return WorkflowRuleExporterKt.thenOnSuccess($this$validateFieldValueIfExists_u24lambda_u241.validateConfigReference(configName, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, Object>(this){
            final /* synthetic */ RuleConfigValidator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RuleConfigValidator.access$getFieldManager$p(this.this$0).getField(it);
            }
        })), (Function0<? extends List<RuleValidationFailure>>)((Function0)new Function0<List<? extends RuleValidationFailure>>(this, $this$validateFieldValueIfExists_u24lambda_u241, ctx, configName){
            final /* synthetic */ RuleConfigValidator this$0;
            final /* synthetic */ RuleDescriptor $this_run;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ String $configName;
            {
                this.this$0 = $receiver;
                this.$this_run = $receiver2;
                this.$ctx = $ctx;
                this.$configName = $configName;
                super(0);
            }

            @NotNull
            public final List<RuleValidationFailure> invoke() {
                return RuleConfigValidator.access$validateUnsupportedField(this.this$0, this.$this_run, this.$ctx, this.$configName);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RuleValidationFailure> validateFieldValuesIfExists(@NotNull ExportContext ctx, @NotNull RuleDescriptor ruleDescriptor, @NotNull String configName, @NotNull String delimiter) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)ruleDescriptor, (String)"ruleDescriptor");
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        Iterable iterable = ruleDescriptor.getConfigValuesIfExists(configName, delimiter);
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.customFieldManager.exists(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String fieldId = (String)element$iv$iv;
            boolean bl2 = false;
            RuleValidationFailure ruleValidationFailure = ruleDescriptor.checkForJiraEntity(configName, (Function0<? extends Object>)((Function0)new Function0<Object>(this, fieldId){
                final /* synthetic */ RuleConfigValidator this$0;
                final /* synthetic */ String $fieldId;
                {
                    this.this$0 = $receiver;
                    this.$fieldId = $fieldId;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return RuleConfigValidator.access$getFieldManager$p(this.this$0).getField(this.$fieldId);
                }
            }));
            if (ruleValidationFailure == null) {
                ruleValidationFailure = this.checkFieldSupported(ruleDescriptor, configName, fieldId, (Function1<Object, Boolean>)((Function1)new Function1<Object, Boolean>(this, ctx, fieldId){
                    final /* synthetic */ RuleConfigValidator this$0;
                    final /* synthetic */ ExportContext $ctx;
                    final /* synthetic */ String $fieldId;
                    {
                        this.this$0 = $receiver;
                        this.$ctx = $ctx;
                        this.$fieldId = $fieldId;
                        super(1);
                    }

                    @Nullable
                    public final Boolean invoke(@NotNull Object it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return RuleConfigValidator.access$hasFieldExistsAndSupported(this.this$0, this.$ctx, this.$fieldId);
                    }
                }));
            }
            if (ruleValidationFailure == null) continue;
            RuleValidationFailure it$iv$iv = ruleValidationFailure;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List validateFieldValuesIfExists$default(RuleConfigValidator ruleConfigValidator, ExportContext exportContext, RuleDescriptor ruleDescriptor, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = ",";
        }
        return ruleConfigValidator.validateFieldValuesIfExists(exportContext, ruleDescriptor, string, string2);
    }

    @NotNull
    public final List<RuleValidationFailure> skipInvalidGroupIfExists() {
        return CollectionsKt.listOfNotNull((Object)WorkflowRuleExporterKt.getNullRuleValidationFailure());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RuleValidationFailure> validateRoleIfExists(@NotNull RuleDescriptor ruleDescriptor, @NotNull String configName, @NotNull String delimiter) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)ruleDescriptor, (String)"ruleDescriptor");
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        Iterable iterable = ruleDescriptor.getConfigValuesIfExists(configName, delimiter);
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = this.isRoleName(it) ? this.jiraRoleManager.getProjectRole(it) == null : this.jiraRoleManager.getProjectRole(Long.valueOf(Long.parseLong(it))) == null;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingRoles = (List)destination$iv$iv;
        return this.createRuleValidationForMissingItems(missingRoles, configName, ruleDescriptor);
    }

    private final List<RuleValidationFailure> validateUnsupportedField(RuleDescriptor $this$validateUnsupportedField, ExportContext ctx, String configName) {
        return this.validateField($this$validateUnsupportedField, configName, (Function1<Object, Boolean>)((Function1)new Function1<Object, Boolean>(this, ctx){
            final /* synthetic */ RuleConfigValidator this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            @Nullable
            public final Boolean invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RuleConfigValidator.access$hasFieldExistsAndSupported(this.this$0, this.$ctx, (String)it);
            }
        }));
    }

    private final Boolean hasFieldExistsAndSupported(ExportContext ctx, String fieldId) {
        Boolean bl;
        Field field = this.fieldManager.getField(fieldId);
        if (field != null) {
            Field field2 = field;
            boolean bl2 = false;
            bl = this.exportFilters.isSupportedField(ctx, field2);
        } else {
            bl = null;
        }
        return bl;
    }

    private final List<RuleValidationFailure> validateField(RuleDescriptor $this$validateField, String configName, Function1<Object, Boolean> isSupportedField) {
        RuleValidationFailure ruleValidationFailure;
        Object object = $this$validateField.getArgs().get(configName);
        if (object != null) {
            Object fieldId = object;
            boolean bl = false;
            ruleValidationFailure = this.checkFieldSupported($this$validateField, configName, fieldId, isSupportedField);
        } else {
            ruleValidationFailure = null;
        }
        return CollectionsKt.listOfNotNull(ruleValidationFailure);
    }

    private final RuleValidationFailure checkFieldSupported(RuleDescriptor $this$checkFieldSupported, String configName, Object fieldId, Function1<Object, Boolean> isSupportedField) {
        RuleValidationFailure ruleValidationFailure;
        Boolean bl = (Boolean)isSupportedField.invoke(fieldId);
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            ruleValidationFailure = !it ? new RuleValidationFailure("has unsupported custom field reference in config " + configName + " for workflow rule " + $this$checkFieldSupported.getName() + " [" + $this$checkFieldSupported.getShortName() + ']', null, 2, null) : WorkflowRuleExporterKt.getNullRuleValidationFailure();
        } else {
            ruleValidationFailure = null;
        }
        return ruleValidationFailure;
    }

    @NotNull
    public final List<RuleValidationFailure> validateStatusesById(@NotNull RuleDescriptor ruleDescriptor, @NotNull String fieldName, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter((Object)ruleDescriptor, (String)"ruleDescriptor");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        return this.validateStatuses(ruleDescriptor, fieldName, delimiter, this.getAvailableStatusIds());
    }

    public static /* synthetic */ List validateStatusesById$default(RuleConfigValidator ruleConfigValidator, RuleDescriptor ruleDescriptor, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = ",";
        }
        return ruleConfigValidator.validateStatusesById(ruleDescriptor, string, string2);
    }

    @NotNull
    public final List<RuleValidationFailure> validateStatusesByName(@NotNull RuleDescriptor ruleDescriptor, @NotNull String configName, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter((Object)ruleDescriptor, (String)"ruleDescriptor");
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        return this.validateStatuses(ruleDescriptor, configName, delimiter, this.getAvailableStatusNames());
    }

    public static /* synthetic */ List validateStatusesByName$default(RuleConfigValidator ruleConfigValidator, RuleDescriptor ruleDescriptor, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = ",";
        }
        return ruleConfigValidator.validateStatusesByName(ruleDescriptor, string, string2);
    }

    @NotNull
    public final List<RuleValidationFailure> validateStatusByNameIfConfigExists(@NotNull RuleDescriptor ruleDescriptor, @NotNull String configName) {
        RuleValidationFailure ruleValidationFailure;
        Intrinsics.checkNotNullParameter((Object)ruleDescriptor, (String)"ruleDescriptor");
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Object object = ruleDescriptor.getArgs().get(configName);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            String statusName = ((Object)StringsKt.trim((CharSequence)((String)it))).toString();
            ruleValidationFailure = !RuleDescriptorKt.getSET_OF_DEFAULT_VALUES().contains(statusName) && !this.getAvailableStatusNames().contains(statusName) ? this.createRuleValidationFailure(configName, statusName, ruleDescriptor) : WorkflowRuleExporterKt.getNullRuleValidationFailure();
        } else {
            ruleValidationFailure = null;
        }
        RuleValidationFailure ruleValidationFailure2 = ruleValidationFailure;
        return CollectionsKt.listOfNotNull(ruleValidationFailure2);
    }

    private final List<RuleValidationFailure> validateStatuses(RuleDescriptor ruleDescriptor, String configName, String delimiter, Set<String> statuses) {
        List missingStatuses = CollectionsKt.minus((Iterable)ruleDescriptor.getConfigValuesIfExists(configName, delimiter), (Iterable)statuses);
        return this.createRuleValidationForMissingItems(missingStatuses, configName, ruleDescriptor);
    }

    private final List<RuleValidationFailure> createRuleValidationForMissingItems(List<String> missingItems, String configName, RuleDescriptor ruleDescriptor) {
        RuleValidationFailure ruleValidationFailure = !((Collection)missingItems).isEmpty() ? this.createRuleValidationFailure(configName, missingItems, ruleDescriptor) : WorkflowRuleExporterKt.getNullRuleValidationFailure();
        return CollectionsKt.listOfNotNull((Object)ruleValidationFailure);
    }

    private final RuleValidationFailure createRuleValidationFailure(String fieldName, Object statusName, RuleDescriptor ruleDescriptor) {
        return new RuleValidationFailure("Missing config [" + fieldName + "] value reference " + statusName + " in workflow rule " + ruleDescriptor.getName() + " [" + ruleDescriptor.getShortName() + ']', null, 2, null);
    }

    private final boolean isRoleName(String role) {
        Long roleId = StringsKt.toLongOrNull((String)role);
        return roleId == null;
    }

    public static final /* synthetic */ Boolean access$hasFieldExistsAndSupported(RuleConfigValidator $this, ExportContext ctx, String fieldId) {
        return $this.hasFieldExistsAndSupported(ctx, fieldId);
    }

    public static final /* synthetic */ FieldManager access$getFieldManager$p(RuleConfigValidator $this) {
        return $this.fieldManager;
    }

    public static final /* synthetic */ List access$validateUnsupportedField(RuleConfigValidator $this, RuleDescriptor $receiver, ExportContext ctx, String configName) {
        return $this.validateUnsupportedField($receiver, ctx, configName);
    }
}

