/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.db.ProjectVersionTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsExcludedVersionData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsExcludedVersionTable;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ExcludedVersionDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getExcludedVersionsForPlan", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsExcludedVersionData;", "planId", "", "getExcludedVersionsForPlanId", "getExcludedVersionsForPlanIdAndProjectIds", "projectIds", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExcludedVersionDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExcludedVersionDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/ExcludedVersionDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1549#2:131\n1620#2,3:132\n1549#2:135\n1620#2,3:136\n1549#2:139\n1620#2,3:140\n*S KotlinDebug\n*F\n+ 1 ExcludedVersionDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/ExcludedVersionDataReader\n*L\n39#1:131\n39#1:132,3\n66#1:135\n66#1:136,3\n94#1:139\n94#1:140,3\n*E\n"})
public final class ExcludedVersionDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public ExcludedVersionDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(ExcludedVersionDataReader.class);
    }

    @NotNull
    public final List<AdvancedRoadmapsExcludedVersionData> getExcludedVersionsForPlan(long planId) {
        this.log.debug("Executing db query for fetching excluded versions associated with plan {}", (Object)planId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> ExcludedVersionDataReader.getExcludedVersionsForPlan$lambda$0(planId, arg_0), ExcludedVersionDataReader::getExcludedVersionsForPlan$lambda$1);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched excluded versions associated with plan: {}", (Object)planId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching excludedVersions associated with plan {}: {}", (Object)planId, (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsExcludedVersionData> getExcludedVersionsForPlanId(long planId) {
        this.log.debug("Executing db query for fetching excluded versions associated with planId {}", (Object)planId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> ExcludedVersionDataReader.getExcludedVersionsForPlanId$lambda$4(planId, arg_0), ExcludedVersionDataReader::getExcludedVersionsForPlanId$lambda$5);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched excluded versions associated with planId: {}", (Object)planId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching excludedVersions associated with planId {}: {}", (Object)planId, (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsExcludedVersionData> getExcludedVersionsForPlanIdAndProjectIds(long planId, @NotNull List<Long> projectIds) {
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        try {
            this.log.debug("Executing db query for fetching excluded versions associated with planId {} and projectIds {}", (Object)planId, projectIds);
            Object object = this.databaseAccessor.run(arg_0 -> ExcludedVersionDataReader.getExcludedVersionsForPlanIdAndProjectIds$lambda$8(planId, projectIds, arg_0), ExcludedVersionDataReader::getExcludedVersionsForPlanIdAndProjectIds$lambda$9);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched excluded versions associated with planId {} and projectIds {}", (Object)planId, projectIds);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            Object[] objectArray = new Object[]{planId, projectIds, ex.getMessage()};
            this.log.error("Exception occurred while fetching excludedVersions associated with plan {} and projects {} : {}", objectArray);
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List getExcludedVersionsForPlan$lambda$0(long $planId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsExcludedVersionTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsExcludedVersionTable.INSTANCE)).where((Predicate)AdvancedRoadmapsExcludedVersionTable.INSTANCE.getPLAN_ID().eq((Object)$planId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsExcludedVersionTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsExcludedVersionTable)((Object)object)).toAdvancedRoadmapsExcludedVersionData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getExcludedVersionsForPlan$lambda$1() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getExcludedVersionsForPlanId$lambda$4(long $planId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new SpreadBuilder(2);
        object.addSpread((Object)AdvancedRoadmapsExcludedVersionTable.INSTANCE.all());
        object.add(ProjectVersionTable.INSTANCE.getPROJECT());
        Iterable iterable = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])object.toArray((Object[])new Expression[object.size()])).from((Expression)AdvancedRoadmapsExcludedVersionTable.INSTANCE)).where((Predicate)AdvancedRoadmapsExcludedVersionTable.INSTANCE.getPLAN_ID().eq((Object)$planId))).innerJoin((EntityPath)ProjectVersionTable.INSTANCE)).on((Predicate)AdvancedRoadmapsExcludedVersionTable.INSTANCE.getVERSION().eq((Expression)ProjectVersionTable.INSTANCE.getID()))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        object = AdvancedRoadmapsExcludedVersionTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsExcludedVersionTable)((Object)object)).toAdvancedRoadmapsExcludedVersionDataWithProject((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getExcludedVersionsForPlanId$lambda$5() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getExcludedVersionsForPlanIdAndProjectIds$lambda$8(long $planId, List $projectIds, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$projectIds, (String)"$projectIds");
        Object object = AdvancedRoadmapsExcludedVersionTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsExcludedVersionTable.INSTANCE)).where((Predicate)AdvancedRoadmapsExcludedVersionTable.INSTANCE.getPLAN_ID().eq((Object)$planId))).innerJoin((EntityPath)ProjectVersionTable.INSTANCE)).on((Predicate)AdvancedRoadmapsExcludedVersionTable.INSTANCE.getVERSION().eq((Expression)ProjectVersionTable.INSTANCE.getID()));
        NumberPath<Long> numberPath = ProjectVersionTable.INSTANCE.getPROJECT();
        Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-PROJECT>(...)");
        SimpleExpression simpleExpression = (SimpleExpression)numberPath;
        Collection collection = $projectIds;
        Intrinsics.checkNotNull((Object)db);
        Iterable iterable = ((SQLQuery)sQLQuery.where((Predicate)QuerydslHelpersKt.bigIn(simpleExpression, collection, db))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        object = AdvancedRoadmapsExcludedVersionTable.INSTANCE;
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((AdvancedRoadmapsExcludedVersionTable)((Object)object)).toAdvancedRoadmapsExcludedVersionData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getExcludedVersionsForPlanIdAndProjectIds$lambda$9() {
    }
}

