/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.db.ProjectTable;
import com.atlassian.jira.migration.db.SearchRequestTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsIssueSourceData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsIssueSourceTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.IssueSourceType;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.jira.migration.export.db.software.RapidViewReader;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "rapidViewReader", "Lcom/atlassian/jira/migration/export/db/software/RapidViewReader;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/export/db/software/RapidViewReader;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAllExistentBoardIds", "", "", "getAllExistentIssueSourcesForPlan", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsIssueSourceData;", "planId", "", "getAllExistentIssueSourcesForPlans", "planIds", "getAllExistentProjectIds", "getAllFilterIds", "getAllIssueSources", "getAllIssueSourcesForPlans", "getAllNonExistentIssueSources", "allIssueSources", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueSourceDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueSourceDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1549#2:181\n1620#2,3:182\n766#2:185\n857#2,2:186\n1549#2:188\n1620#2,3:189\n1549#2:192\n1620#2,3:193\n766#2:196\n857#2,2:197\n1549#2:199\n1620#2,3:200\n1549#2:203\n1620#2,3:204\n1549#2:207\n1620#2,3:208\n1549#2:211\n1620#2,3:212\n*S KotlinDebug\n*F\n+ 1 IssueSourceDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader\n*L\n48#1:181\n48#1:182,3\n50#1:185\n50#1:186,2\n56#1:188\n56#1:189,3\n58#1:192\n58#1:193,3\n60#1:196\n60#1:197,2\n159#1:199\n159#1:200,3\n78#1:203\n78#1:204,3\n102#1:207\n102#1:208,3\n126#1:211\n126#1:212,3\n*E\n"})
public final class IssueSourceDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final RapidViewReader rapidViewReader;
    private final Logger log;

    @Inject
    public IssueSourceDataReader(@NotNull DatabaseAccessor databaseAccessor, @NotNull RapidViewReader rapidViewReader) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)rapidViewReader, (String)"rapidViewReader");
        this.databaseAccessor = databaseAccessor;
        this.rapidViewReader = rapidViewReader;
        this.log = LoggerFactory.getLogger(IssueSourceDataReader.class);
    }

    @NotNull
    public final List<AdvancedRoadmapsIssueSourceData> getAllExistentIssueSourcesForPlan(long planId) {
        List<Long> list = Collections.singletonList(planId);
        Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
        return this.getAllExistentIssueSourcesForPlans(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AdvancedRoadmapsIssueSourceData> getAllExistentIssueSourcesForPlans(@NotNull List<Long> planIds) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(planIds, (String)"planIds");
        List<AdvancedRoadmapsIssueSourceData> allIssueSourcesForPlans = this.getAllIssueSourcesForPlans(planIds);
        Iterable $this$map$iv = this.getAllNonExistentIssueSources(allIssueSourcesForPlans);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void issueSource;
            AdvancedRoadmapsIssueSourceData advancedRoadmapsIssueSourceData = (AdvancedRoadmapsIssueSourceData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(issueSource.getId());
        }
        Set allNonExistentIssueSourceIdsSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = allIssueSourcesForPlans;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AdvancedRoadmapsIssueSourceData it = (AdvancedRoadmapsIssueSourceData)element$iv$iv;
            boolean bl = false;
            if (!(!allNonExistentIssueSourceIdsSet.contains(it.getId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AdvancedRoadmapsIssueSourceData> getAllNonExistentIssueSources(@Nullable List<AdvancedRoadmapsIssueSourceData> allIssueSources) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<AdvancedRoadmapsIssueSourceData> list = allIssueSources;
        if (list == null) {
            list = this.getAllIssueSources();
        }
        List<AdvancedRoadmapsIssueSourceData> allIssueSources2 = list;
        Set<String> projectIds = this.getAllExistentProjectIds();
        Iterable $this$map$iv = this.getAllFilterIds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf((long)it));
        }
        Set filterIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set<String> boardIds = this.getAllExistentBoardIds();
        Iterable $this$map$iv2 = this.rapidViewReader.fetchRapidViewsIdWithNonExistentIssueSource();
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            long bl = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(String.valueOf((long)it));
        }
        Set allBoardsWithNonExistentFilterSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filter$iv = allIssueSources2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AdvancedRoadmapsIssueSourceData it = (AdvancedRoadmapsIssueSourceData)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it.getSourceValue();
            boolean bl3 = charSequence == null || charSequence.length() == 0 || StringsKt.equals$default((String)it.getSourceType(), (String)IssueSourceType.PROJECT.getValue(), (boolean)false, (int)2, null) && !projectIds.contains(it.getSourceValue()) || StringsKt.equals$default((String)it.getSourceType(), (String)IssueSourceType.FILTER.getValue(), (boolean)false, (int)2, null) && !filterIds.contains(it.getSourceValue()) || StringsKt.equals$default((String)it.getSourceType(), (String)IssueSourceType.BOARD.getValue(), (boolean)false, (int)2, null) && (!boardIds.contains(it.getSourceValue()) || allBoardsWithNonExistentFilterSet.contains(it.getSourceValue()));
            if (!bl3) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    public static /* synthetic */ List getAllNonExistentIssueSources$default(IssueSourceDataReader issueSourceDataReader, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return issueSourceDataReader.getAllNonExistentIssueSources(list);
    }

    private final List<AdvancedRoadmapsIssueSourceData> getAllIssueSources() {
        this.log.debug("Executing db query for getting all issueSources");
        try {
            Object object = this.databaseAccessor.run(IssueSourceDataReader::getAllIssueSources$lambda$5, IssueSourceDataReader::getAllIssueSources$lambda$6);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all issueSources");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching all issueSources: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    private final List<AdvancedRoadmapsIssueSourceData> getAllIssueSourcesForPlans(List<Long> planIds) {
        this.log.debug("Executing db query for getting all issueSources associated with planIds {}", planIds);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> IssueSourceDataReader.getAllIssueSourcesForPlans$lambda$9(planIds, arg_0), OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all issueSources associated with planIds {}", planIds);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching issueSources associated with planIds {}: {}", planIds, (Object)ex.getMessage());
            throw ex;
        }
    }

    private final Set<String> getAllExistentProjectIds() {
        this.log.debug("Executing db query for fetching all projectIds");
        try {
            Object object = this.databaseAccessor.run(IssueSourceDataReader::getAllExistentProjectIds$lambda$12, IssueSourceDataReader::getAllExistentProjectIds$lambda$13);
            Set it = (Set)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all projectIds from db");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Set)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching projectIds: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<Long> getAllFilterIds() {
        this.log.debug("Executing db query for fetching all filterIds");
        try {
            Object object = this.databaseAccessor.run(IssueSourceDataReader::getAllFilterIds$lambda$15, IssueSourceDataReader::getAllFilterIds$lambda$16);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all filterIds from db");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching filterIds: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getAllExistentBoardIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.rapidViewReader.fetchAllRapidViewsIds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf((long)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final List getAllIssueSources$lambda$5(DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path[] pathArray = AdvancedRoadmapsIssueSourceTable.INSTANCE.all();
        ProjectableSQLQuery projectableSQLQuery = db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)AdvancedRoadmapsIssueSourceTable.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)projectableSQLQuery, (String)"from(...)");
        Iterable iterable = QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)projectableSQLQuery).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        AdvancedRoadmapsIssueSourceTable advancedRoadmapsIssueSourceTable = AdvancedRoadmapsIssueSourceTable.INSTANCE;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(advancedRoadmapsIssueSourceTable.toAdvancedRoadmapsIssueSourceData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getAllIssueSources$lambda$6() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getAllIssueSourcesForPlans$lambda$9(List $planIds, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$planIds, (String)"$planIds");
        Path[] pathArray = AdvancedRoadmapsIssueSourceTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)AdvancedRoadmapsIssueSourceTable.INSTANCE);
        NumberPath<Long> numberPath = AdvancedRoadmapsIssueSourceTable.INSTANCE.getPLAN_ID();
        Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-PLAN_ID>(...)");
        SimpleExpression simpleExpression = (SimpleExpression)numberPath;
        Collection collection = $planIds;
        Intrinsics.checkNotNull((Object)db);
        Object object = sQLQuery.where((Predicate)QuerydslHelpersKt.bigIn(simpleExpression, collection, db));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"where(...)");
        Iterable iterable = QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)object).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        object = AdvancedRoadmapsIssueSourceTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((AdvancedRoadmapsIssueSourceTable)((Object)object)).toAdvancedRoadmapsIssueSourceData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set getAllExistentProjectIds$lambda$12(DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        List list = ((SQLQuery)db.select((Expression)ProjectTable.Companion.getPROJECT_TABLE().getID()).from((Expression)ProjectTable.Companion.getPROJECT_TABLE())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf(it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final void getAllExistentProjectIds$lambda$13() {
    }

    private static final List getAllFilterIds$lambda$15(DatabaseConnection db) {
        return ((SQLQuery)db.select((Expression)SearchRequestTable.Companion.getSEARCH_REQUEST_TABLE().getID()).from((Expression)SearchRequestTable.Companion.getSEARCH_REQUEST_TABLE())).fetch();
    }

    private static final void getAllFilterIds$lambda$16() {
    }
}

