/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.export.db.advancedroadmaps.IssueTypeData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.IssueTypeTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.JiraIssueTypeDataReader;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/JiraIssueTypeDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getIssueTypeDataByIds", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueTypeData;", "ids", "", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraIssueTypeDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraIssueTypeDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/JiraIssueTypeDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1549#2:97\n1620#2,3:98\n*S KotlinDebug\n*F\n+ 1 JiraIssueTypeDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/JiraIssueTypeDataReader\n*L\n62#1:97\n62#1:98,3\n*E\n"})
public final class JiraIssueTypeDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public JiraIssueTypeDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(JiraIssueTypeDataReader.class);
    }

    @NotNull
    public final List<IssueTypeData> getIssueTypeDataByIds(@NotNull Set<Long> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.log.debug("Executing db query for fetching issueTypes corresponding to ids {}", ids);
        if (!((Collection)ids).isEmpty()) {
            try {
                Object object = this.databaseAccessor.run(arg_0 -> JiraIssueTypeDataReader.getIssueTypeDataByIds$lambda$1(ids, arg_0), JiraIssueTypeDataReader::getIssueTypeDataByIds$lambda$2);
                List it = (List)object;
                boolean bl = false;
                this.log.debug("Successfully fetched issueTypes corresponding to ids {}", ids);
                Object object2 = object;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
                return (List)object2;
            }
            catch (QueryException ex) {
                this.log.error("Exception occurred while fetching issueTypes associated with ids {}: {}", ids, (Object)ex.getMessage());
                throw ex;
            }
        }
        return CollectionsKt.emptyList();
    }

    private static final String getIssueTypeDataByIds$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getIssueTypeDataByIds$lambda$1(Set $ids, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$ids, (String)"$ids");
        Object object = IssueTypeTable.INSTANCE.all();
        Iterable iterable = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)IssueTypeTable.INSTANCE)).where((Predicate)IssueTypeTable.INSTANCE.getID().in((Collection)$ids.stream().map(arg_0 -> JiraIssueTypeDataReader.getIssueTypeDataByIds$lambda$1$lambda$0(getIssueTypeDataByIds.1.1.INSTANCE, arg_0)).collect(Collectors.toSet())))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        object = IssueTypeTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((IssueTypeTable)((Object)object)).toIssueTypeData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getIssueTypeDataByIds$lambda$2() {
    }
}

