/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPersonData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPersonTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanTeamTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsResourceTable;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PersonDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAllPersons", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsPersonData;", "getPersonsForPlans", "planIds", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPersonDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersonDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PersonDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1549#2:92\n1620#2,3:93\n1549#2:96\n1620#2,3:97\n*S KotlinDebug\n*F\n+ 1 PersonDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PersonDataReader\n*L\n40#1:92\n40#1:93,3\n69#1:96\n69#1:97,3\n*E\n"})
public final class PersonDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public PersonDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(PersonDataReader.class);
    }

    @NotNull
    public final List<AdvancedRoadmapsPersonData> getAllPersons() {
        this.log.debug("Executing db query for fetching all person data");
        try {
            Object object = this.databaseAccessor.run(PersonDataReader::getAllPersons$lambda$0, PersonDataReader::getAllPersons$lambda$1);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all person data");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching all persons: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsPersonData> getPersonsForPlans(@NotNull List<Long> planIds) {
        Intrinsics.checkNotNullParameter(planIds, (String)"planIds");
        this.log.debug("Executing db query for fetching all persons corresponding to planIds {}", planIds);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> PersonDataReader.getPersonsForPlans$lambda$4(planIds, arg_0), PersonDataReader::getPersonsForPlans$lambda$5);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all persons corresponding to planIds {}", planIds);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching persons associated with planIds {}: {}", planIds, (Object)ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List getAllPersons$lambda$0(DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new Expression[]{AdvancedRoadmapsPersonTable.INSTANCE.getID(), AdvancedRoadmapsPersonTable.INSTANCE.getJIRA_USER_ID().max()};
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])object).from((Expression)AdvancedRoadmapsPersonTable.INSTANCE)).where((Predicate)AdvancedRoadmapsPersonTable.INSTANCE.getJIRA_USER_ID().notEqualsIgnoreCase("anonymized"))).groupBy((Expression)AdvancedRoadmapsPersonTable.INSTANCE.getID())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsPersonTable.INSTANCE;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsPersonTable)((Object)object)).toAdvancedRoadmapsPersonData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getAllPersons$lambda$1() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPersonsForPlans$lambda$4(List $planIds, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$planIds, (String)"$planIds");
        Expression[] expressionArray = new Expression[]{AdvancedRoadmapsPersonTable.INSTANCE.getID(), AdvancedRoadmapsPersonTable.INSTANCE.getJIRA_USER_ID().max()};
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)AdvancedRoadmapsPersonTable.INSTANCE)).join((EntityPath)AdvancedRoadmapsResourceTable.INSTANCE)).on((Predicate)AdvancedRoadmapsPersonTable.INSTANCE.getID().eq((Expression)AdvancedRoadmapsResourceTable.INSTANCE.getPERSON_ID()))).join((EntityPath)AdvancedRoadmapsPlanTeamTable.INSTANCE)).on((Predicate)AdvancedRoadmapsResourceTable.INSTANCE.getTEAM_ID().eq((Expression)AdvancedRoadmapsPlanTeamTable.INSTANCE.getTEAM_ID()));
        NumberPath<Long> numberPath = AdvancedRoadmapsPlanTeamTable.INSTANCE.getPLAN_ID();
        Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-PLAN_ID>(...)");
        SimpleExpression simpleExpression = (SimpleExpression)numberPath;
        Collection collection = $planIds;
        Intrinsics.checkNotNull((Object)db);
        QueryBase queryBase = sQLQuery.where((Predicate)QuerydslHelpersKt.bigIn(simpleExpression, collection, db));
        Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
        Iterable iterable = ((SQLQuery)((SQLQuery)QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)queryBase).where((Predicate)AdvancedRoadmapsPersonTable.INSTANCE.getJIRA_USER_ID().notEqualsIgnoreCase("anonymized"))).groupBy((Expression)AdvancedRoadmapsPersonTable.INSTANCE.getID())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        AdvancedRoadmapsPersonTable advancedRoadmapsPersonTable = AdvancedRoadmapsPersonTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(advancedRoadmapsPersonTable.toAdvancedRoadmapsPersonData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getPersonsForPlans$lambda$5() {
    }
}

