/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanTable;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0006\u0010\u000f\u001a\u00020\u0010J/\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAllAdvancedRoadmapIds", "", "", "getAllPlans", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsPlanData;", "getPlans", "ids", "hasPlans", "", "pagination", "offset", "", "limit", "isDescending", "(Ljava/lang/Integer;Ljava/lang/Integer;Z)Ljava/util/List;", "totalPlansCount", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,263:1\n1549#2:264\n1620#2,3:265\n1549#2:268\n1620#2,3:269\n1549#2:272\n1620#2,3:273\n*S KotlinDebug\n*F\n+ 1 PlanDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader\n*L\n88#1:264\n88#1:265,3\n110#1:268\n110#1:269,3\n142#1:272\n142#1:273,3\n*E\n"})
public final class PlanDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public PlanDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(PlanDataReader.class);
    }

    public final boolean hasPlans() {
        return this.databaseAccessor.run(PlanDataReader::hasPlans$lambda$0, PlanDataReader::hasPlans$lambda$1) != null;
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanData> getAllPlans() {
        this.log.debug("Executing db query for fetching all ar plans");
        try {
            Object object = this.databaseAccessor.run(PlanDataReader::getAllPlans$lambda$2, PlanDataReader::getAllPlans$lambda$3);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all ar plans");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching all ARPlans {}:", (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanData> getPlans(@NotNull List<Long> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.log.debug("Executing db query for fetching all plans having ids {}", ids);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> PlanDataReader.getPlans$lambda$6(ids, arg_0), PlanDataReader::getPlans$lambda$7);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all plans having ids {}", ids);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching all ARPlans with ids {}: {}", ids, (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanData> pagination(@Nullable Integer offset, @Nullable Integer limit, boolean isDescending) {
        OrderSpecifier orderSpecifier = isDescending ? AdvancedRoadmapsPlanTable.INSTANCE.getTITLE().desc() : AdvancedRoadmapsPlanTable.INSTANCE.getTITLE().asc();
        Object object = this.databaseAccessor.run(arg_0 -> PlanDataReader.pagination$lambda$10(offset, orderSpecifier, limit, arg_0), PlanDataReader::pagination$lambda$11);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    public static /* synthetic */ List pagination$default(PlanDataReader planDataReader, Integer n, Integer n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return planDataReader.pagination(n, n2, bl);
    }

    @NotNull
    public final List<Long> getAllAdvancedRoadmapIds() {
        try {
            this.log.debug("Executing db query for fetching all arPlanIds");
            Object object = this.databaseAccessor.run(PlanDataReader::getAllAdvancedRoadmapIds$lambda$12, PlanDataReader::getAllAdvancedRoadmapIds$lambda$13);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all arPlanIds");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching arPlanIds: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    public final long totalPlansCount() {
        try {
            this.log.debug("Executing db query for fetching count of arPlans");
            Object object = this.databaseAccessor.run(PlanDataReader::totalPlansCount$lambda$15, PlanDataReader::totalPlansCount$lambda$16);
            Long it = (Long)object;
            boolean bl = false;
            this.log.debug("Successfully fetched count of arPlans");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return ((Number)object2).longValue();
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching count of arPlans: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    private static final Long hasPlans$lambda$0(DatabaseConnection db) {
        return (Long)((SQLQuery)db.select((Expression)AdvancedRoadmapsPlanTable.INSTANCE.getID()).from((Expression)AdvancedRoadmapsPlanTable.INSTANCE)).fetchFirst();
    }

    private static final void hasPlans$lambda$1() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getAllPlans$lambda$2(DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsPlanTable.INSTANCE.all();
        List list = ((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsPlanTable.INSTANCE)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsPlanTable.INSTANCE;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsPlanTable)((Object)object)).toAdvancedRoadmapsPlanData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getAllPlans$lambda$3() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPlans$lambda$6(List $ids, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$ids, (String)"$ids");
        Path[] pathArray = AdvancedRoadmapsPlanTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)AdvancedRoadmapsPlanTable.INSTANCE);
        NumberPath<Long> numberPath = AdvancedRoadmapsPlanTable.INSTANCE.getID();
        Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-ID>(...)");
        SimpleExpression simpleExpression = (SimpleExpression)numberPath;
        Collection collection = $ids;
        Intrinsics.checkNotNull((Object)db);
        QueryBase queryBase = sQLQuery.where((Predicate)QuerydslHelpersKt.bigIn(simpleExpression, collection, db));
        Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
        Iterable iterable = QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)queryBase).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        AdvancedRoadmapsPlanTable advancedRoadmapsPlanTable = AdvancedRoadmapsPlanTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(advancedRoadmapsPlanTable.toAdvancedRoadmapsPlanData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getPlans$lambda$7() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List pagination$lambda$10(Integer $offset, OrderSpecifier $orderSpecifier, Integer $limit, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsPlanTable.INSTANCE.all();
        Integer n = $offset;
        SQLQuery selectQuery = (SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsPlanTable.INSTANCE)).offset(n != null ? (long)n.intValue() : 0L)).orderBy($orderSpecifier);
        if ($limit != null) {
            selectQuery = (SQLQuery)selectQuery.limit((long)$limit.intValue());
        }
        List list = selectQuery.fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        object = list;
        AdvancedRoadmapsPlanTable advancedRoadmapsPlanTable = AdvancedRoadmapsPlanTable.INSTANCE;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(advancedRoadmapsPlanTable.toAdvancedRoadmapsPlanData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void pagination$lambda$11() {
    }

    private static final List getAllAdvancedRoadmapIds$lambda$12(DatabaseConnection db) {
        return ((SQLQuery)db.select((Expression)AdvancedRoadmapsPlanTable.INSTANCE.getID()).from((Expression)AdvancedRoadmapsPlanTable.INSTANCE)).fetch();
    }

    private static final void getAllAdvancedRoadmapIds$lambda$13() {
    }

    private static final Long totalPlansCount$lambda$15(DatabaseConnection db) {
        Path[] pathArray = AdvancedRoadmapsPlanTable.INSTANCE.all();
        return ((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)AdvancedRoadmapsPlanTable.INSTANCE)).fetchCount();
    }

    private static final void totalPlansCount$lambda$16() {
    }
}

