/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanPermissionData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.PlanPermissionsModificationHandler;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.spi.querydsl.EnhancedRelationalPathBase;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanPermissionDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getOriginalPlanPermissions", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsPlanPermissionData;", "planId", "", "getPlanPermissions", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "AdvancedRoadmapsPlanPermissionTable", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanPermissionDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanPermissionDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PlanPermissionDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1549#2:71\n1620#2,3:72\n*S KotlinDebug\n*F\n+ 1 PlanPermissionDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PlanPermissionDataReader\n*L\n42#1:71\n42#1:72,3\n*E\n"})
public final class PlanPermissionDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public PlanPermissionDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(PlanPermissionDataReader.class);
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanPermissionData> getPlanPermissions(long planId, @NotNull ApplicationUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        List<AdvancedRoadmapsPlanPermissionData> planPermissions = this.getOriginalPlanPermissions(planId);
        return PlanPermissionsModificationHandler.INSTANCE.modify(this.databaseAccessor, planPermissions, user);
    }

    private final List<AdvancedRoadmapsPlanPermissionData> getOriginalPlanPermissions(long planId) {
        this.log.debug("Executing db query for fetching original planPermissions corresponding to planId {}", (Object)planId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> PlanPermissionDataReader.getOriginalPlanPermissions$lambda$0(planId, arg_0), PlanPermissionDataReader::getOriginalPlanPermissions$lambda$1);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched original planPermissions corresponding to planId {}", (Object)planId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching original planPermissions corresponding to planId {}: {}", (Object)planId, (Object)ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List getOriginalPlanPermissions$lambda$0(long $planId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsPlanPermissionTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsPlanPermissionTable.INSTANCE)).where((Predicate)AdvancedRoadmapsPlanPermissionTable.INSTANCE.getPLAN_ID().eq((Object)$planId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsPlanPermissionTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsPlanPermissionTable)((Object)object)).toAdvancedRoadmapsPlanPermissionData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getOriginalPlanPermissions$lambda$1() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R5\u0010\b\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\n0\n \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR5\u0010\r\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000e0\u000e \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR5\u0010\u0010\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\n0\n \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR5\u0010\u0012\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000e0\u000e \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanPermissionDataReader$AdvancedRoadmapsPlanPermissionTable;", "Lcom/atlassian/pocketknife/spi/querydsl/EnhancedRelationalPathBase;", "()V", "HOLDER_KEY", "Lcom/querydsl/core/types/dsl/StringPath;", "kotlin.jvm.PlatformType", "getHOLDER_KEY", "()Lcom/querydsl/core/types/dsl/StringPath;", "HOLDER_TYPE", "Lcom/querydsl/core/types/dsl/NumberPath;", "", "getHOLDER_TYPE", "()Lcom/querydsl/core/types/dsl/NumberPath;", "ID", "", "getID", "PERMISSION", "getPERMISSION", "PLAN_ID", "getPLAN_ID", "toAdvancedRoadmapsPlanPermissionData", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsPlanPermissionData;", "record", "Lcom/querydsl/core/Tuple;", "jira-migration-plugin"})
    public static final class AdvancedRoadmapsPlanPermissionTable
    extends EnhancedRelationalPathBase<AdvancedRoadmapsPlanPermissionTable> {
        @NotNull
        public static final AdvancedRoadmapsPlanPermissionTable INSTANCE = new AdvancedRoadmapsPlanPermissionTable();
        private static final NumberPath<Long> ID = (NumberPath)INSTANCE.createLongCol("ID").ofType(-5).asPrimaryKey().build();
        private static final NumberPath<Long> PLAN_ID = (NumberPath)INSTANCE.createLongCol("PLAN_ID").ofType(-5).build();
        private static final NumberPath<Integer> PERMISSION = (NumberPath)INSTANCE.createIntegerCol("PERMISSION").ofType(4).notNull().build();
        private static final StringPath HOLDER_KEY = (StringPath)INSTANCE.createStringCol("HOLDER_KEY").ofType(12).notNull().build();
        private static final NumberPath<Integer> HOLDER_TYPE = (NumberPath)INSTANCE.createIntegerCol("HOLDER_TYPE").ofType(4).notNull().build();

        private AdvancedRoadmapsPlanPermissionTable() {
            super(AdvancedRoadmapsPlanPermissionTable.class, "AO_D9132D_PERMISSIONS");
        }

        public final NumberPath<Long> getID() {
            return ID;
        }

        public final NumberPath<Long> getPLAN_ID() {
            return PLAN_ID;
        }

        public final NumberPath<Integer> getPERMISSION() {
            return PERMISSION;
        }

        public final StringPath getHOLDER_KEY() {
            return HOLDER_KEY;
        }

        public final NumberPath<Integer> getHOLDER_TYPE() {
            return HOLDER_TYPE;
        }

        @NotNull
        public final AdvancedRoadmapsPlanPermissionData toAdvancedRoadmapsPlanPermissionData(@NotNull Tuple record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Object object = record.get((Expression)ID);
            Intrinsics.checkNotNull((Object)object);
            long l = ((Number)object).longValue();
            Object object2 = record.get((Expression)PERMISSION);
            Intrinsics.checkNotNull((Object)object2);
            int n = ((Number)object2).intValue();
            Object object3 = record.get((Expression)HOLDER_TYPE);
            Intrinsics.checkNotNull((Object)object3);
            int n2 = ((Number)object3).intValue();
            Object object4 = record.get((Expression)HOLDER_KEY);
            Intrinsics.checkNotNull((Object)object4);
            return new AdvancedRoadmapsPlanPermissionData(l, n, n2, (String)object4);
        }
    }
}

