/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanTeamData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanTeamTable;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanTeamDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getPlanTeamsForPlans", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsPlanTeamData;", "planIds", "", "getPlanTeamsForTeam", "teamId", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanTeamDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanTeamDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PlanTeamDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1549#2:101\n1620#2,3:102\n1549#2:105\n1620#2,3:106\n*S KotlinDebug\n*F\n+ 1 PlanTeamDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PlanTeamDataReader\n*L\n42#1:101\n42#1:102,3\n64#1:105\n64#1:106,3\n*E\n"})
public final class PlanTeamDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public PlanTeamDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(PlanTeamDataReader.class);
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanTeamData> getPlanTeamsForTeam(long teamId) {
        this.log.debug("Executing db query for fetching all plan Teams for team {}", (Object)teamId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> PlanTeamDataReader.getPlanTeamsForTeam$lambda$0(teamId, arg_0), PlanTeamDataReader::getPlanTeamsForTeam$lambda$1);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all plan Teams for team {}", (Object)teamId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching all plan Teams for team {}: {}", (Object)teamId, (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanTeamData> getPlanTeamsForPlans(@NotNull List<Long> planIds) {
        Intrinsics.checkNotNullParameter(planIds, (String)"planIds");
        this.log.debug("Executing db query for fetching all planTeams corresponding to planIds {}", planIds);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> PlanTeamDataReader.getPlanTeamsForPlans$lambda$4(planIds, arg_0), PlanTeamDataReader::getPlanTeamsForPlans$lambda$5);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all planTeams corresponding to planIds {}", planIds);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching planTeams associated with planIds {}: {}", planIds, (Object)ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPlanTeamsForTeam$lambda$0(long $teamId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsPlanTeamTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsPlanTeamTable.INSTANCE)).where((Predicate)AdvancedRoadmapsPlanTeamTable.INSTANCE.getTEAM_ID().eq((Object)$teamId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsPlanTeamTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsPlanTeamTable)((Object)object)).toAdvancedRoadmapsPlanTeamData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getPlanTeamsForTeam$lambda$1() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPlanTeamsForPlans$lambda$4(List $planIds, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$planIds, (String)"$planIds");
        Path[] pathArray = AdvancedRoadmapsPlanTeamTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)AdvancedRoadmapsPlanTeamTable.INSTANCE);
        NumberPath<Long> numberPath = AdvancedRoadmapsPlanTeamTable.INSTANCE.getPLAN_ID();
        Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-PLAN_ID>(...)");
        SimpleExpression simpleExpression = (SimpleExpression)numberPath;
        Collection collection = $planIds;
        Intrinsics.checkNotNull((Object)db);
        QueryBase queryBase = sQLQuery.where((Predicate)QuerydslHelpersKt.bigIn(simpleExpression, collection, db));
        Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
        Iterable iterable = QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)queryBase).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        AdvancedRoadmapsPlanTeamTable advancedRoadmapsPlanTeamTable = AdvancedRoadmapsPlanTeamTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(advancedRoadmapsPlanTeamTable.toAdvancedRoadmapsPlanTeamData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getPlanTeamsForPlans$lambda$5() {
    }
}

