/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.db.ProjectVersionTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsCrossProjectVersionTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanVersionData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanVersionTable;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\fJ\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanVersionDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getFilteredPlanVersionsForCrossProjectVersion", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsPlanVersionData;", "crossProjectVersionId", "", "planId", "projectIds", "", "getPlanVersions", "getPlanVersionsForCrossProjectVersion", "getPlanVersionsForCrossProjectVersionById", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanVersionDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanVersionDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PlanVersionDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1549#2:190\n1620#2,3:191\n1549#2:194\n1620#2,3:195\n1549#2:198\n1620#2,3:199\n1549#2:202\n1620#2,3:203\n*S KotlinDebug\n*F\n+ 1 PlanVersionDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/PlanVersionDataReader\n*L\n40#1:190\n40#1:191,3\n73#1:194\n73#1:195,3\n108#1:198\n108#1:199,3\n148#1:202\n148#1:203,3\n*E\n"})
public final class PlanVersionDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public PlanVersionDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(PlanVersionDataReader.class);
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanVersionData> getPlanVersions(long planId) {
        this.log.debug("Executing db query for fetching planVersions corresponding to plan {}", (Object)planId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> PlanVersionDataReader.getPlanVersions$lambda$0(planId, arg_0), PlanVersionDataReader::getPlanVersions$lambda$1);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all planVersions corresponding to plan {}", (Object)planId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching planVersions corresponding to plan {}: {}", (Object)planId, (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanVersionData> getPlanVersionsForCrossProjectVersionById(long crossProjectVersionId, long planId) {
        this.log.debug("Executing db query for fetching planVersions corresponding to plan {} and crossProjectVersion {} by id", (Object)planId, (Object)crossProjectVersionId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> PlanVersionDataReader.getPlanVersionsForCrossProjectVersionById$lambda$4(crossProjectVersionId, planId, arg_0), PlanVersionDataReader::getPlanVersionsForCrossProjectVersionById$lambda$5);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched planVersions corresponding to plan {} and crossProjectVersion {} by id", (Object)planId, (Object)crossProjectVersionId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            Object[] objectArray = new Object[]{planId, crossProjectVersionId, ex.getMessage()};
            this.log.error("Exception occurred while fetching planVersions corresponding to plan {} and crossProjectVersion {} by id: {}", objectArray);
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanVersionData> getPlanVersionsForCrossProjectVersion(long crossProjectVersionId, long planId) {
        this.log.debug("Executing db query for fetching planVersions corresponding to plan {} and crossProjectVersion {}", (Object)planId, (Object)crossProjectVersionId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> PlanVersionDataReader.getPlanVersionsForCrossProjectVersion$lambda$8(planId, crossProjectVersionId, arg_0), PlanVersionDataReader::getPlanVersionsForCrossProjectVersion$lambda$9);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched planVersions corresponding to plan {} and crossProjectVersion {}", (Object)planId, (Object)crossProjectVersionId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            Object[] objectArray = new Object[]{planId, crossProjectVersionId, ex.getMessage()};
            this.log.error("Exception occurred while fetching planVersions corresponding to plan {} and crossProjectVersion {}: {}", objectArray);
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsPlanVersionData> getFilteredPlanVersionsForCrossProjectVersion(long crossProjectVersionId, long planId, @NotNull Set<Long> projectIds) {
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        Object[] objectArray = new Object[]{planId, crossProjectVersionId, projectIds};
        this.log.debug("Executing db query for fetching filtered planVersions corresponding to plan {} and crossProjectVersion {} and projectIds {}", objectArray);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> PlanVersionDataReader.getFilteredPlanVersionsForCrossProjectVersion$lambda$12(crossProjectVersionId, planId, projectIds, arg_0), PlanVersionDataReader::getFilteredPlanVersionsForCrossProjectVersion$lambda$13);
            List it = (List)object;
            boolean bl = false;
            Object[] objectArray2 = new Object[]{planId, crossProjectVersionId, projectIds};
            this.log.debug("Successfully fetched filtered planVersions corresponding to plan {} and crossProjectVersion {} and projectIds {}", objectArray2);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            Object[] objectArray3 = new Object[]{planId, crossProjectVersionId, projectIds, ex.getMessage()};
            this.log.error("Exception occurred while fetching filtered planVersions corresponding to plan {} and crossProjectVersion {} and projectIds: {}: {}", objectArray3);
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPlanVersions$lambda$0(long $planId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsPlanVersionTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsPlanVersionTable.INSTANCE)).where((Predicate)AdvancedRoadmapsPlanVersionTable.INSTANCE.getPLAN_ID().eq((Object)$planId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsPlanVersionTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsPlanVersionTable)((Object)object)).toAdvancedRoadmapsPlanVersionData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getPlanVersions$lambda$1() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPlanVersionsForCrossProjectVersionById$lambda$4(long $crossProjectVersionId, long $planId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new SpreadBuilder(2);
        object.addSpread((Object)AdvancedRoadmapsPlanVersionTable.INSTANCE.all());
        object.add(ProjectVersionTable.INSTANCE.getPROJECT());
        Iterable iterable = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])object.toArray((Object[])new Expression[object.size()])).from((Expression)AdvancedRoadmapsPlanVersionTable.INSTANCE)).join((EntityPath)AdvancedRoadmapsCrossProjectVersionTable.INSTANCE)).on((Predicate)AdvancedRoadmapsCrossProjectVersionTable.INSTANCE.getPLAN_ID().eq((Expression)AdvancedRoadmapsPlanVersionTable.INSTANCE.getPLAN_ID()))).innerJoin((EntityPath)ProjectVersionTable.INSTANCE)).on((Predicate)AdvancedRoadmapsPlanVersionTable.INSTANCE.getVERSION_ID().eq((Expression)ProjectVersionTable.INSTANCE.getID()))).where((Predicate)AdvancedRoadmapsPlanVersionTable.INSTANCE.getXPROJECT_VERSION_ID().eq((Object)$crossProjectVersionId))).where((Predicate)AdvancedRoadmapsPlanVersionTable.INSTANCE.getPLAN_ID().eq((Object)$planId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        object = AdvancedRoadmapsPlanVersionTable.INSTANCE;
        boolean $i$f$map = false;
        void var8_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsPlanVersionTable)((Object)object)).toAdvancedRoadmapsPlanVersionDataWithProject((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getPlanVersionsForCrossProjectVersionById$lambda$5() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPlanVersionsForCrossProjectVersion$lambda$8(long $planId, long $crossProjectVersionId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsPlanVersionTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsPlanVersionTable.INSTANCE)).join((EntityPath)AdvancedRoadmapsPlanVersionTable.INSTANCE)).on((Predicate)AdvancedRoadmapsCrossProjectVersionTable.INSTANCE.getPLAN_ID().eq((Object)$planId))).where((Predicate)AdvancedRoadmapsPlanVersionTable.INSTANCE.getXPROJECT_VERSION_ID().eq((Object)$crossProjectVersionId))).where((Predicate)AdvancedRoadmapsPlanVersionTable.INSTANCE.getPLAN_ID().eq((Object)$planId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsPlanVersionTable.INSTANCE;
        boolean $i$f$map = false;
        void var8_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsPlanVersionTable)((Object)object)).toAdvancedRoadmapsPlanVersionData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getPlanVersionsForCrossProjectVersion$lambda$9() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getFilteredPlanVersionsForCrossProjectVersion$lambda$12(long $crossProjectVersionId, long $planId, Set $projectIds, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$projectIds, (String)"$projectIds");
        Object object = AdvancedRoadmapsPlanVersionTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsPlanVersionTable.INSTANCE)).join((EntityPath)AdvancedRoadmapsCrossProjectVersionTable.INSTANCE)).on((Predicate)AdvancedRoadmapsCrossProjectVersionTable.INSTANCE.getPLAN_ID().eq((Expression)AdvancedRoadmapsPlanVersionTable.INSTANCE.getPLAN_ID()))).innerJoin((EntityPath)ProjectVersionTable.INSTANCE)).on((Predicate)AdvancedRoadmapsPlanVersionTable.INSTANCE.getVERSION_ID().eq((Expression)ProjectVersionTable.INSTANCE.getID()))).where((Predicate)AdvancedRoadmapsPlanVersionTable.INSTANCE.getXPROJECT_VERSION_ID().eq((Object)$crossProjectVersionId))).where((Predicate)AdvancedRoadmapsPlanVersionTable.INSTANCE.getPLAN_ID().eq((Object)$planId));
        NumberPath<Long> numberPath = ProjectVersionTable.INSTANCE.getPROJECT();
        Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-PROJECT>(...)");
        SimpleExpression simpleExpression = (SimpleExpression)numberPath;
        Collection collection = $projectIds;
        Intrinsics.checkNotNull((Object)db);
        Iterable iterable = ((SQLQuery)sQLQuery.where((Predicate)QuerydslHelpersKt.bigIn(simpleExpression, collection, db))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        object = AdvancedRoadmapsPlanVersionTable.INSTANCE;
        boolean $i$f$map = false;
        void var9_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((AdvancedRoadmapsPlanVersionTable)((Object)object)).toAdvancedRoadmapsPlanVersionData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getFilteredPlanVersionsForCrossProjectVersion$lambda$13() {
    }
}

