/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.db.ProjectVersionTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.ProjectVersionData;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ProjectVersionDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getProjectVersionById", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ProjectVersionData;", "versionId", "", "getProjectVersionIdByProjectId", "", "projectId", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectVersionDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectVersionDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/ProjectVersionDataReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class ProjectVersionDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public ProjectVersionDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(ProjectVersionDataReader.class);
    }

    @Nullable
    public final ProjectVersionData getProjectVersionById(long versionId) {
        this.log.debug("Executing db query for fetching projectVersion by versionId {}", (Object)versionId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> ProjectVersionDataReader.getProjectVersionById$lambda$0(versionId, arg_0), ProjectVersionDataReader::getProjectVersionById$lambda$1);
            ProjectVersionData it = (ProjectVersionData)object;
            boolean bl = false;
            this.log.debug("Successfully fetched projectVersion by versionId {}", (Object)versionId);
            return (ProjectVersionData)object;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching projectVersion by versionId {}: {}", (Object)versionId, (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<Long> getProjectVersionIdByProjectId(long projectId) {
        this.log.debug("Executing db query for fetching projectVersion by projectId {}", (Object)projectId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> ProjectVersionDataReader.getProjectVersionIdByProjectId$lambda$3(projectId, arg_0), OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched projectVersion by projectId {}", (Object)projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching projectVersion associated with projectId {}: {}", (Object)projectId, (Object)ex.getMessage());
            throw ex;
        }
    }

    private static final ProjectVersionData getProjectVersionById$lambda$0(long $versionId, DatabaseConnection db) {
        ProjectVersionData projectVersionData;
        Tuple tuple = ProjectVersionTable.INSTANCE.all();
        Tuple tuple2 = (Tuple)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(tuple, ((Path[])tuple).length)).from((Expression)ProjectVersionTable.INSTANCE)).where((Predicate)ProjectVersionTable.INSTANCE.getID().eq((Object)$versionId))).fetchOne();
        if (tuple2 != null) {
            tuple = tuple2;
            ProjectVersionTable projectVersionTable = ProjectVersionTable.INSTANCE;
            Tuple p0 = tuple;
            boolean bl = false;
            projectVersionData = projectVersionTable.toProjectVersionData(p0);
        } else {
            projectVersionData = null;
        }
        return projectVersionData;
    }

    private static final void getProjectVersionById$lambda$1() {
    }

    private static final List getProjectVersionIdByProjectId$lambda$3(long $projectId, DatabaseConnection db) {
        List list = ((SQLQuery)((SQLQuery)db.select((Expression)ProjectVersionTable.INSTANCE.getID()).from((Expression)ProjectVersionTable.INSTANCE)).where((Predicate)ProjectVersionTable.INSTANCE.getPROJECT().eq((Object)$projectId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return CollectionsKt.toList((Iterable)list);
    }
}

