/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsResourceData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsResourceTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ResourceDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getResourcesForPerson", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsResourceData;", "personId", "", "getResourcesForTeam", "teamId", "resourcesExistForTeam", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nResourceDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/ResourceDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1549#2:105\n1620#2,3:106\n1549#2:109\n1620#2,3:110\n*S KotlinDebug\n*F\n+ 1 ResourceDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/ResourceDataReader\n*L\n35#1:105\n35#1:106,3\n56#1:109\n56#1:110,3\n*E\n"})
public final class ResourceDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public ResourceDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(ResourceDataReader.class);
    }

    @NotNull
    public final List<AdvancedRoadmapsResourceData> getResourcesForPerson(long personId) {
        this.log.debug("Executing db query for fetching resources for person with id {}", (Object)personId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> ResourceDataReader.getResourcesForPerson$lambda$0(personId, arg_0), ResourceDataReader::getResourcesForPerson$lambda$1);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched resources for person with id {}", (Object)personId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching resources associated with person {}: {}", (Object)personId, (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<AdvancedRoadmapsResourceData> getResourcesForTeam(long teamId) {
        this.log.debug("Executing db query for fetching resources for team with id {}", (Object)teamId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> ResourceDataReader.getResourcesForTeam$lambda$4(teamId, arg_0), ResourceDataReader::getResourcesForTeam$lambda$5);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched resources for team with id {}", (Object)teamId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching resources associated with team {}: {}", (Object)teamId, (Object)ex.getMessage());
            throw ex;
        }
    }

    public final boolean resourcesExistForTeam(long teamId) {
        this.log.debug("Executing db query for knowing whether resources exist for team {}", (Object)teamId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> ResourceDataReader.resourcesExistForTeam$lambda$7(teamId, arg_0), ResourceDataReader::resourcesExistForTeam$lambda$8);
            Boolean it = (Boolean)object;
            boolean bl = false;
            this.log.debug("Successfully fetched count of resources for team {}", (Object)teamId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Boolean)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching count of resources associated with team {}: {}", (Object)teamId, (Object)ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List getResourcesForPerson$lambda$0(long $personId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsResourceTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsResourceTable.INSTANCE)).where((Predicate)AdvancedRoadmapsResourceTable.INSTANCE.getPERSON_ID().eq((Object)$personId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsResourceTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsResourceTable)((Object)object)).toAdvancedRoadmapsResourceData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getResourcesForPerson$lambda$1() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getResourcesForTeam$lambda$4(long $teamId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsResourceTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsResourceTable.INSTANCE)).where((Predicate)AdvancedRoadmapsResourceTable.INSTANCE.getTEAM_ID().eq((Object)$teamId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsResourceTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsResourceTable)((Object)object)).toAdvancedRoadmapsResourceData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getResourcesForTeam$lambda$5() {
    }

    private static final Boolean resourcesExistForTeam$lambda$7(long $teamId, DatabaseConnection db) {
        return ((SQLQuery)((SQLQuery)db.query().from((Expression)AdvancedRoadmapsResourceTable.INSTANCE)).where((Predicate)AdvancedRoadmapsResourceTable.INSTANCE.getTEAM_ID().eq((Object)$teamId))).fetchCount() > 0L;
    }

    private static final void resourcesExistForTeam$lambda$8() {
    }
}

