/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsIssueSourceData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsTeamData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsTeamTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.IssueSourceDataReader;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/TeamDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "issueSourceDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAllNonExistentIssueSourceIds", "", "", "getAllTeams", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsTeamData;", "getTeam", "teamId", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTeamDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/TeamDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n1549#2:88\n1620#2,3:89\n1#3:87\n*S KotlinDebug\n*F\n+ 1 TeamDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/TeamDataReader\n*L\n47#1:83\n47#1:84,3\n58#1:88\n58#1:89,3\n*E\n"})
public final class TeamDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final IssueSourceDataReader issueSourceDataReader;
    private final Logger log;

    @Inject
    public TeamDataReader(@NotNull DatabaseAccessor databaseAccessor, @NotNull IssueSourceDataReader issueSourceDataReader) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)issueSourceDataReader, (String)"issueSourceDataReader");
        this.databaseAccessor = databaseAccessor;
        this.issueSourceDataReader = issueSourceDataReader;
        this.log = LoggerFactory.getLogger(TeamDataReader.class);
    }

    @Nullable
    public final AdvancedRoadmapsTeamData getTeam(long teamId) {
        this.log.debug("Executing db query for fetching team by id {}", (Object)teamId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> TeamDataReader.getTeam$lambda$0(teamId, arg_0), TeamDataReader::getTeam$lambda$1);
            AdvancedRoadmapsTeamData it = (AdvancedRoadmapsTeamData)object;
            boolean bl = false;
            this.log.debug("Successfully fetched team by id {}", (Object)teamId);
            return (AdvancedRoadmapsTeamData)object;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching team by id {}: {}", (Object)teamId, (Object)ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> getAllNonExistentIssueSourceIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = IssueSourceDataReader.getAllNonExistentIssueSources$default(this.issueSourceDataReader, null, 1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void issueSource;
            AdvancedRoadmapsIssueSourceData advancedRoadmapsIssueSourceData = (AdvancedRoadmapsIssueSourceData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(issueSource.getId());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<AdvancedRoadmapsTeamData> getAllTeams() {
        this.log.debug("Executing db query for fetching all teams");
        try {
            Object object = this.databaseAccessor.run(TeamDataReader::getAllTeams$lambda$5, TeamDataReader::getAllTeams$lambda$6);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched all teams");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching all teams: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    private static final AdvancedRoadmapsTeamData getTeam$lambda$0(long $teamId, DatabaseConnection db) {
        AdvancedRoadmapsTeamData advancedRoadmapsTeamData;
        Tuple tuple = AdvancedRoadmapsTeamTable.INSTANCE.all();
        Tuple tuple2 = (Tuple)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(tuple, ((Path[])tuple).length)).from((Expression)AdvancedRoadmapsTeamTable.INSTANCE)).where((Predicate)AdvancedRoadmapsTeamTable.INSTANCE.getID().eq((Object)$teamId))).fetchOne();
        if (tuple2 != null) {
            tuple = tuple2;
            AdvancedRoadmapsTeamTable advancedRoadmapsTeamTable = AdvancedRoadmapsTeamTable.INSTANCE;
            Tuple p0 = tuple;
            boolean bl = false;
            advancedRoadmapsTeamData = advancedRoadmapsTeamTable.toAdvancedRoadmapsTeamData(p0);
        } else {
            advancedRoadmapsTeamData = null;
        }
        return advancedRoadmapsTeamData;
    }

    private static final void getTeam$lambda$1() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getAllTeams$lambda$5(DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = AdvancedRoadmapsTeamTable.INSTANCE.all();
        List list = ((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)AdvancedRoadmapsTeamTable.INSTANCE)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = AdvancedRoadmapsTeamTable.INSTANCE;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsTeamTable)((Object)object)).toAdvancedRoadmapsTeamData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getAllTeams$lambda$6() {
    }
}

