/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.advancedroadmaps;

import com.atlassian.jira.migration.db.ProjectVersionTable;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsVersionEnrichmentData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsVersionEnrichmentTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/export/db/advancedroadmaps/VersionEnrichmentDataReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getVersionEnrichmentsForProject", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsVersionEnrichmentData;", "projectId", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nVersionEnrichmentDataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionEnrichmentDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/VersionEnrichmentDataReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1549#2:65\n1620#2,3:66\n*S KotlinDebug\n*F\n+ 1 VersionEnrichmentDataReader.kt\ncom/atlassian/jira/migration/export/db/advancedroadmaps/VersionEnrichmentDataReader\n*L\n37#1:65\n37#1:66,3\n*E\n"})
public final class VersionEnrichmentDataReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public VersionEnrichmentDataReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(VersionEnrichmentDataReader.class);
    }

    @NotNull
    public final List<AdvancedRoadmapsVersionEnrichmentData> getVersionEnrichmentsForProject(long projectId) {
        this.log.debug("Executing db query for fetching version enrichments for project with id {}", (Object)projectId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> VersionEnrichmentDataReader.getVersionEnrichmentsForProject$lambda$0(projectId, arg_0), VersionEnrichmentDataReader::getVersionEnrichmentsForProject$lambda$1);
            List it = (List)object;
            boolean bl = false;
            this.log.debug("Successfully fetched version enrichments for project with id {}", (Object)projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            this.log.error("Exception occurred while fetching versionEnrichments associated with project {}: {}", (Object)projectId, (Object)ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List getVersionEnrichmentsForProject$lambda$0(long $projectId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new SpreadBuilder(2);
        object.addSpread((Object)AdvancedRoadmapsVersionEnrichmentTable.INSTANCE.all());
        object.add(ProjectVersionTable.INSTANCE.getSTARTDATE());
        Iterable iterable = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])object.toArray((Object[])new Expression[object.size()])).from((Expression)AdvancedRoadmapsVersionEnrichmentTable.INSTANCE)).join((EntityPath)ProjectVersionTable.INSTANCE)).on((Predicate)AdvancedRoadmapsVersionEnrichmentTable.INSTANCE.getENV_ID().eq((Expression)ProjectVersionTable.INSTANCE.getID()))).where((Predicate)ProjectVersionTable.INSTANCE.getPROJECT().eq((Object)$projectId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        object = AdvancedRoadmapsVersionEnrichmentTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AdvancedRoadmapsVersionEnrichmentTable)((Object)object)).toAdvancedRoadmapsEnrichmentVersionData((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getVersionEnrichmentsForProject$lambda$1() {
    }
}

