/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.assets;

import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.export.db.assets.ObjectJiraIssueLinkTable;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaPropertiesTable;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaPropertiesWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaReader;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaTable;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectTable;
import com.atlassian.jira.migration.export.db.assets.ObjectTypeAttributeTable;
import com.atlassian.jira.migration.export.db.assets.ObjectTypeTable;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fJ\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getAllObjectSchemas", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaWrapper;", "getObjectSchemaById", "objectSchemaId", "", "getObjectSchemaByKey", "key", "", "getObjectSchemaByKeys", "", "schemasKeys", "getObjectSchemaByProjectsIds", "projectIds", "", "getRelatedObjectSchemaBySchemaIds", "schemaIds", "getSchemaPropertiesById", "Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaPropertiesWrapper;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nObjectSchemaReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectSchemaReader.kt\ncom/atlassian/jira/migration/export/db/assets/ObjectSchemaReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1549#2:270\n1620#2,3:271\n1549#2:274\n1620#2,3:275\n*S KotlinDebug\n*F\n+ 1 ObjectSchemaReader.kt\ncom/atlassian/jira/migration/export/db/assets/ObjectSchemaReader\n*L\n148#1:270\n148#1:271,3\n232#1:274\n232#1:275,3\n*E\n"})
public final class ObjectSchemaReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public ObjectSchemaReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @Nullable
    public final ObjectSchemaWrapper getObjectSchemaByKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (ObjectSchemaWrapper)this.databaseAccessor.run(arg_0 -> ObjectSchemaReader.getObjectSchemaByKey$lambda$1(key, arg_0), OnRollback.NOOP);
    }

    @NotNull
    public final Sequence<ObjectSchemaWrapper> getAllObjectSchemas() {
        Object object = this.databaseAccessor.run(ObjectSchemaReader::getAllObjectSchemas$lambda$2, OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Sequence)object;
    }

    @NotNull
    public final Sequence<ObjectSchemaWrapper> getObjectSchemaByProjectsIds(@NotNull List<Long> projectIds) {
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        Object object = this.databaseAccessor.run(arg_0 -> ObjectSchemaReader.getObjectSchemaByProjectsIds$lambda$3(projectIds, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Sequence)object;
    }

    @NotNull
    public final List<ObjectSchemaWrapper> getRelatedObjectSchemaBySchemaIds(@NotNull List<Integer> schemaIds) {
        Intrinsics.checkNotNullParameter(schemaIds, (String)"schemaIds");
        ObjectTypeTable ObjectTypeReferenceTable = new ObjectTypeTable("OBJECT_TYPE_REFERENCE");
        Object object = this.databaseAccessor.run(arg_0 -> ObjectSchemaReader.getRelatedObjectSchemaBySchemaIds$lambda$5(ObjectTypeReferenceTable, schemaIds, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    @Nullable
    public final ObjectSchemaWrapper getObjectSchemaById(int objectSchemaId) {
        return (ObjectSchemaWrapper)this.databaseAccessor.run(arg_0 -> ObjectSchemaReader.getObjectSchemaById$lambda$7(objectSchemaId, arg_0), OnRollback.NOOP);
    }

    @Nullable
    public final ObjectSchemaPropertiesWrapper getSchemaPropertiesById(int objectSchemaId) {
        return (ObjectSchemaPropertiesWrapper)this.databaseAccessor.run(arg_0 -> ObjectSchemaReader.getSchemaPropertiesById$lambda$9(objectSchemaId, arg_0), OnRollback.NOOP);
    }

    @NotNull
    public final List<ObjectSchemaWrapper> getObjectSchemaByKeys(@NotNull List<String> schemasKeys) {
        Intrinsics.checkNotNullParameter(schemasKeys, (String)"schemasKeys");
        Object object = this.databaseAccessor.run(arg_0 -> ObjectSchemaReader.getObjectSchemaByKeys$lambda$12(schemasKeys, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    private static final ObjectSchemaWrapper getObjectSchemaByKey$lambda$1(String $key, DatabaseConnection db) {
        ObjectSchemaWrapper objectSchemaWrapper;
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Expression[] expressionArray = new Expression[]{ObjectSchemaTable.INSTANCE.getID(), ObjectSchemaTable.INSTANCE.getCREATED(), ObjectSchemaTable.INSTANCE.getDESCRIPTION(), ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY(), ObjectSchemaTable.INSTANCE.getUPDATED(), ObjectSchemaTable.INSTANCE.getNAME()};
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)ObjectSchemaTable.INSTANCE)).where((Predicate)ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY().eq((Object)$key))).fetchOne();
        if (tuple != null) {
            Tuple tuple2 = tuple;
            boolean bl = false;
            Object object = tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getID());
            Intrinsics.checkNotNull((Object)object);
            int n = ((Number)object).intValue();
            Timestamp timestamp = (Timestamp)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getCREATED());
            String string = (String)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getDESCRIPTION());
            String string2 = (String)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY());
            Timestamp timestamp2 = (Timestamp)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getUPDATED());
            String string3 = (String)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getNAME());
            objectSchemaWrapper = new ObjectSchemaWrapper(n, string3, timestamp, string, string2, timestamp2);
        } else {
            objectSchemaWrapper = null;
        }
        return objectSchemaWrapper;
    }

    private static final Sequence getAllObjectSchemas$lambda$2(DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{ObjectSchemaTable.INSTANCE.getID(), ObjectSchemaTable.INSTANCE.getCREATED(), ObjectSchemaTable.INSTANCE.getDESCRIPTION(), ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY(), ObjectSchemaTable.INSTANCE.getUPDATED(), ObjectSchemaTable.INSTANCE.getNAME()};
        List list = ((SQLQuery)db.select(expressionArray).from((Expression)ObjectSchemaTable.INSTANCE)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getAllObjectSchemas.1.1.INSTANCE);
    }

    private static final Sequence getObjectSchemaByProjectsIds$lambda$3(List $projectIds, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$projectIds, (String)"$projectIds");
        Expression[] expressionArray = new Expression[]{ObjectSchemaTable.INSTANCE.getID(), ObjectSchemaTable.INSTANCE.getCREATED(), ObjectSchemaTable.INSTANCE.getDESCRIPTION(), ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY(), ObjectSchemaTable.INSTANCE.getUPDATED(), ObjectSchemaTable.INSTANCE.getNAME()};
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).distinct()).from((Expression)ObjectJiraIssueLinkTable.INSTANCE)).join((EntityPath)ObjectTable.INSTANCE)).on((Predicate)ObjectJiraIssueLinkTable.INSTANCE.getOBJECT_ID().eq((Expression)ObjectTable.INSTANCE.getID().longValue()))).join((EntityPath)ObjectTypeTable.Companion.getOBJECT_TYPE_TABLE())).on((Predicate)ObjectTable.INSTANCE.getOBJECT_TYPE_ID().eq((Expression)ObjectTypeTable.Companion.getOBJECT_TYPE_TABLE().getID()))).join((EntityPath)ObjectSchemaTable.INSTANCE)).on((Predicate)ObjectTypeTable.Companion.getOBJECT_TYPE_TABLE().getOBJECT_SCHEMA_ID().eq((Expression)ObjectSchemaTable.INSTANCE.getID()))).join((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)ObjectJiraIssueLinkTable.INSTANCE.getJIRA_ISSUE_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()));
        NumberPath<Long> numberPath = JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT();
        Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-PROJECT>(...)");
        SimpleExpression simpleExpression = (SimpleExpression)numberPath;
        Collection collection = $projectIds;
        Intrinsics.checkNotNull((Object)db);
        List list = ((SQLQuery)sQLQuery.where((Predicate)QuerydslHelpersKt.bigIn(simpleExpression, collection, db))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getObjectSchemaByProjectsIds.1.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getRelatedObjectSchemaBySchemaIds$lambda$5(ObjectTypeTable $ObjectTypeReferenceTable, List $schemaIds, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)$ObjectTypeReferenceTable), (String)"$ObjectTypeReferenceTable");
        Intrinsics.checkNotNullParameter((Object)$schemaIds, (String)"$schemaIds");
        Expression[] expressionArray = new Expression[]{ObjectSchemaTable.INSTANCE.getID(), ObjectSchemaTable.INSTANCE.getCREATED(), ObjectSchemaTable.INSTANCE.getDESCRIPTION(), ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY(), ObjectSchemaTable.INSTANCE.getUPDATED(), ObjectSchemaTable.INSTANCE.getNAME()};
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).distinct()).from((Expression)ObjectTypeTable.Companion.getOBJECT_TYPE_TABLE())).join((EntityPath)ObjectTypeAttributeTable.INSTANCE)).on((Predicate)ObjectTypeTable.Companion.getOBJECT_TYPE_TABLE().getID().eq((Expression)ObjectTypeAttributeTable.INSTANCE.getOBJECT_TYPE_ID()))).join((EntityPath)$ObjectTypeReferenceTable)).on((Predicate)ObjectTypeAttributeTable.INSTANCE.getREFERENCE_OBJECT_TYPE_ID().eq((Expression)$ObjectTypeReferenceTable.getID()))).join((EntityPath)ObjectSchemaTable.INSTANCE)).on((Predicate)$ObjectTypeReferenceTable.getOBJECT_SCHEMA_ID().eq((Expression)ObjectSchemaTable.INSTANCE.getID()));
        expressionArray = new Predicate[2];
        expressionArray[0] = ObjectTypeAttributeTable.INSTANCE.getTYPE().eq((Object)1);
        NumberPath<Integer> numberPath = ObjectTypeTable.Companion.getOBJECT_TYPE_TABLE().getOBJECT_SCHEMA_ID();
        Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-OBJECT_SCHEMA_ID>(...)");
        SimpleExpression simpleExpression = (SimpleExpression)numberPath;
        Collection collection = $schemaIds;
        Intrinsics.checkNotNull((Object)db);
        expressionArray[1] = QuerydslHelpersKt.bigIn(simpleExpression, collection, db);
        SQLQuery query = (SQLQuery)sQLQuery.where((Predicate[])expressionArray);
        List list = query.fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tuple;
            Tuple tuple2 = (Tuple)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Object object = tuple.get((Expression)ObjectSchemaTable.INSTANCE.getID());
            Intrinsics.checkNotNull((Object)object);
            int n = ((Number)object).intValue();
            Timestamp timestamp = (Timestamp)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getCREATED());
            String string = (String)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getDESCRIPTION());
            String string2 = (String)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY());
            Timestamp timestamp2 = (Timestamp)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getUPDATED());
            String string3 = (String)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getNAME());
            collection2.add(new ObjectSchemaWrapper(n, string3, timestamp, string, string2, timestamp2));
        }
        return (List)destination$iv$iv;
    }

    private static final ObjectSchemaWrapper getObjectSchemaById$lambda$7(int $objectSchemaId, DatabaseConnection db) {
        ObjectSchemaWrapper objectSchemaWrapper;
        Expression[] expressionArray = new Expression[]{ObjectSchemaTable.INSTANCE.getID(), ObjectSchemaTable.INSTANCE.getCREATED(), ObjectSchemaTable.INSTANCE.getDESCRIPTION(), ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY(), ObjectSchemaTable.INSTANCE.getUPDATED(), ObjectSchemaTable.INSTANCE.getNAME()};
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)ObjectSchemaTable.INSTANCE)).where((Predicate)ObjectSchemaTable.INSTANCE.getID().eq((Object)$objectSchemaId))).fetchOne();
        if (tuple != null) {
            Tuple tuple2 = tuple;
            boolean bl = false;
            Object object = tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getID());
            Intrinsics.checkNotNull((Object)object);
            int n = ((Number)object).intValue();
            Timestamp timestamp = (Timestamp)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getCREATED());
            String string = (String)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getDESCRIPTION());
            String string2 = (String)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY());
            Timestamp timestamp2 = (Timestamp)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getUPDATED());
            String string3 = (String)tuple2.get((Expression)ObjectSchemaTable.INSTANCE.getNAME());
            objectSchemaWrapper = new ObjectSchemaWrapper(n, string3, timestamp, string, string2, timestamp2);
        } else {
            objectSchemaWrapper = null;
        }
        return objectSchemaWrapper;
    }

    private static final ObjectSchemaPropertiesWrapper getSchemaPropertiesById$lambda$9(int $objectSchemaId, DatabaseConnection db) {
        ObjectSchemaPropertiesWrapper objectSchemaPropertiesWrapper;
        Expression[] expressionArray = new Expression[]{ObjectSchemaPropertiesTable.INSTANCE.getID(), ObjectSchemaPropertiesTable.INSTANCE.getOBJECT_SCHEMA_ID(), ObjectSchemaPropertiesTable.INSTANCE.getALLOW_OTHER_OBJECT_SCHEMA(), ObjectSchemaPropertiesTable.INSTANCE.getQUICK_CREATE_OBJECTS(), ObjectSchemaPropertiesTable.INSTANCE.getCREATE_OBJECT_CUSTOM_FIELD(), ObjectSchemaPropertiesTable.INSTANCE.getSERVICE_DESC_CUSTOMERS_ENABLED(), ObjectSchemaPropertiesTable.INSTANCE.getVALIDATE_QUICK_CREATE()};
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)ObjectSchemaPropertiesTable.INSTANCE)).where((Predicate)ObjectSchemaPropertiesTable.INSTANCE.getOBJECT_SCHEMA_ID().eq((Object)$objectSchemaId))).fetchOne();
        if (tuple != null) {
            Boolean bl;
            Boolean bl2;
            Boolean bl3;
            Boolean bl4;
            Boolean bl5;
            Boolean bl6;
            Boolean bl7;
            Boolean bl8;
            Tuple record = tuple;
            boolean bl9 = false;
            Object object = record.get((Expression)ObjectSchemaPropertiesTable.INSTANCE.getID());
            Intrinsics.checkNotNull((Object)object);
            int n = ((Number)object).intValue();
            Object object2 = record.get((Expression)ObjectSchemaPropertiesTable.INSTANCE.getOBJECT_SCHEMA_ID());
            Intrinsics.checkNotNull((Object)object2);
            int n2 = ((Number)object2).intValue();
            Boolean bl10 = (Boolean)record.get((Expression)ObjectSchemaPropertiesTable.INSTANCE.getALLOW_OTHER_OBJECT_SCHEMA());
            if (bl10 == null) {
                bl10 = bl8 = Boolean.valueOf(false);
            }
            if ((bl7 = (Boolean)record.get((Expression)ObjectSchemaPropertiesTable.INSTANCE.getQUICK_CREATE_OBJECTS())) == null) {
                bl7 = bl6 = Boolean.valueOf(false);
            }
            if ((bl5 = (Boolean)record.get((Expression)ObjectSchemaPropertiesTable.INSTANCE.getCREATE_OBJECT_CUSTOM_FIELD())) == null) {
                bl5 = bl4 = Boolean.valueOf(false);
            }
            if ((bl3 = (Boolean)record.get((Expression)ObjectSchemaPropertiesTable.INSTANCE.getSERVICE_DESC_CUSTOMERS_ENABLED())) == null) {
                bl3 = bl2 = Boolean.valueOf(false);
            }
            if ((bl = (Boolean)record.get((Expression)ObjectSchemaPropertiesTable.INSTANCE.getVALIDATE_QUICK_CREATE())) == null) {
                bl = false;
            }
            Boolean bl11 = bl;
            Intrinsics.checkNotNull((Object)bl8);
            boolean bl12 = bl8;
            Intrinsics.checkNotNull((Object)bl4);
            boolean bl13 = bl4;
            Intrinsics.checkNotNull((Object)bl6);
            boolean bl14 = bl6;
            Intrinsics.checkNotNull((Object)bl2);
            boolean bl15 = bl2;
            Intrinsics.checkNotNull((Object)bl11);
            objectSchemaPropertiesWrapper = new ObjectSchemaPropertiesWrapper(n, n2, bl12, bl13, bl14, bl15, bl11);
        } else {
            objectSchemaPropertiesWrapper = null;
        }
        return objectSchemaPropertiesWrapper;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getObjectSchemaByKeys$lambda$12(List $schemasKeys, DatabaseConnection db) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$schemasKeys, (String)"$schemasKeys");
        Expression[] expressionArray = new Expression[]{ObjectSchemaTable.INSTANCE.getID(), ObjectSchemaTable.INSTANCE.getCREATED(), ObjectSchemaTable.INSTANCE.getDESCRIPTION(), ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY(), ObjectSchemaTable.INSTANCE.getUPDATED(), ObjectSchemaTable.INSTANCE.getNAME()};
        List list2 = ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)ObjectSchemaTable.INSTANCE)).where((Predicate)ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY().in((Collection)$schemasKeys))).fetch();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            List tuples = list2;
            boolean bl = false;
            Iterable $this$map$iv = tuples;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void tuple;
                Tuple tuple2 = (Tuple)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object object = tuple.get((Expression)ObjectSchemaTable.INSTANCE.getID());
                Intrinsics.checkNotNull((Object)object);
                int n = ((Number)object).intValue();
                Timestamp timestamp = (Timestamp)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getCREATED());
                String string = (String)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getDESCRIPTION());
                String string2 = (String)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getOBJECT_SCHEMA_KEY());
                Timestamp timestamp2 = (Timestamp)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getUPDATED());
                String string3 = (String)tuple.get((Expression)ObjectSchemaTable.INSTANCE.getNAME());
                collection.add(new ObjectSchemaWrapper(n, string3, timestamp, string, string2, timestamp2));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }
}

