/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.core;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.migration.db.EntityProperty;
import com.atlassian.jira.migration.db.EntityPropertyTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.export.db.core.BaselineDatesData;
import com.atlassian.jira.migration.export.db.core.BaselineDatesReader;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/db/core/BaselineDatesReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getAllBaselineDatesForProject", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/export/db/core/BaselineDatesData;", "projectId", "", "Companion", "jira-migration-plugin"})
public final class BaselineDatesReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(BaselineDatesReader.class);

    @Inject
    public BaselineDatesReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.mapper = ExtensionsKt.jacksonObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    @NotNull
    public final Sequence<BaselineDatesData> getAllBaselineDatesForProject(long projectId) {
        try {
            log.debug("Executing db query for fetching all baseline dates associated with project " + projectId);
            Object object = this.databaseAccessor.run(arg_0 -> BaselineDatesReader.getAllBaselineDatesForProject$lambda$0(projectId, this, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched all baseline dates associated with project " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching all baseline dates associated with project " + projectId, (Throwable)ex);
            throw ex;
        }
    }

    private static final Sequence getAllBaselineDatesForProject$lambda$0(long $projectId, BaselineDatesReader this$0, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Expression[] expressionArray = new Expression[]{EntityPropertyTable.INSTANCE.getENTITY_ID(), EntityPropertyTable.INSTANCE.getJSON_VALUE()};
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)EntityPropertyTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)EntityPropertyTable.INSTANCE.getENTITY_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()));
        expressionArray = new Predicate[]{EntityPropertyTable.INSTANCE.getENTITY_NAME().eq((Object)EntityPropertyType.ISSUE_PROPERTY.getDbEntityName()), EntityPropertyTable.INSTANCE.getPROPERTY_KEY().eq((Object)"jpo-issue-properties"), JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId)};
        List list = ((SQLQuery)((SQLQuery)sQLQuery.where((Predicate[])expressionArray)).orderBy(EntityPropertyTable.INSTANCE.getID().desc())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.distinctBy((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, BaselineDatesData>(this$0){
            final /* synthetic */ BaselineDatesReader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final BaselineDatesData invoke(Tuple tuple) {
                BaselineDatesData baselineDatesData;
                void $this$readValue$iv;
                ObjectMapper objectMapper2 = BaselineDatesReader.access$getMapper$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"access$getMapper$p(...)");
                Object object = objectMapper2;
                Object object2 = tuple.get((Expression)EntityPropertyTable.INSTANCE.getJSON_VALUE());
                Intrinsics.checkNotNull((Object)object2);
                String content$iv = (String)object2;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                object = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<EntityProperty>(){});
                EntityProperty it = (EntityProperty)object;
                boolean bl = false;
                EntityProperty entityProperty = (EntityProperty)(it.getBaselineEnd() != null || it.getBaselineStart() != null ? object : null);
                if (entityProperty != null) {
                    EntityProperty $this$invoke_u24lambda_u241 = entityProperty;
                    boolean bl2 = false;
                    Object object3 = tuple.get((Expression)EntityPropertyTable.INSTANCE.getENTITY_ID());
                    Intrinsics.checkNotNull((Object)object3);
                    baselineDatesData = new BaselineDatesData($this$invoke_u24lambda_u241, ((Number)object3).longValue());
                } else {
                    baselineDatesData = null;
                }
                return baselineDatesData;
            }
        })), (Function1)getAllBaselineDatesForProject.1.2.INSTANCE);
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(BaselineDatesReader $this) {
        return $this.mapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/db/core/BaselineDatesReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

