/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.core;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.db.ChangeGroupTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.db.JiraIssueTableWithArchivedColumns;
import com.atlassian.jira.migration.export.db.core.ChangeHistoryEntity;
import com.atlassian.jira.migration.export.db.core.ChangeHistoryReader;
import com.atlassian.jira.migration.export.db.core.ChangeItemTable;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.schema.SchemaStateProvider;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0016\u001a\u00020\bR!\u0010\u0007\u001a\u00020\b8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/export/db/core/ChangeHistoryReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "schemaStateProvider", "Lcom/atlassian/pocketknife/api/querydsl/schema/SchemaStateProvider;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/pocketknife/api/querydsl/schema/SchemaStateProvider;)V", "archivedFieldExists", "", "getArchivedFieldExists$annotations", "()V", "getArchivedFieldExists", "()Z", "archivedFieldExists$delegate", "Lkotlin/Lazy;", "iterateChangeHistoryItemsForProjectOrderByGroupId", "", "projectId", "", "block", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/export/db/core/ChangeHistoryEntity;", "migrateArchivedIssues", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nChangeHistoryReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeHistoryReader.kt\ncom/atlassian/jira/migration/export/db/core/ChangeHistoryReader\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,143:1\n32#2,2:144\n*S KotlinDebug\n*F\n+ 1 ChangeHistoryReader.kt\ncom/atlassian/jira/migration/export/db/core/ChangeHistoryReader\n*L\n97#1:144,2\n*E\n"})
public final class ChangeHistoryReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final SchemaStateProvider schemaStateProvider;
    @NotNull
    private final Lazy archivedFieldExists$delegate;
    @NotNull
    private static final String ARCHIVED_FIELD_NAME = "archived";
    private static final Logger log = LoggerFactory.getLogger(ChangeHistoryReader.class);

    @Inject
    public ChangeHistoryReader(@NotNull DatabaseAccessor databaseAccessor, @NotNull SchemaStateProvider schemaStateProvider) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)schemaStateProvider, (String)"schemaStateProvider");
        this.databaseAccessor = databaseAccessor;
        this.schemaStateProvider = schemaStateProvider;
        this.archivedFieldExists$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ChangeHistoryReader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                Object object;
                try {
                    ChangeHistoryReader.access$getLog$cp().debug("Executing db query to identify if archived field exists in Jira Issue table");
                    object = ChangeHistoryReader.access$getDatabaseAccessor$p(this.this$0).run(arg_0 -> archivedFieldExists.2.invoke$lambda$1(this.this$0, arg_0), OnRollback.NOOP);
                    Boolean it = (Boolean)object;
                    boolean bl = false;
                    ChangeHistoryReader.access$getLog$cp().debug("Successfully executed db query to identify if archived field exists in Jira Issue table");
                    object = (Boolean)object;
                }
                catch (Exception ex) {
                    ChangeHistoryReader.access$getLog$cp().error("Error while executing db query to identify if archived field exists in Jira Issue table", (Throwable)ex);
                    throw ex;
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            private static final Boolean invoke$lambda$1(ChangeHistoryReader this$0, DatabaseConnection db) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Set set = ChangeHistoryReader.access$getSchemaStateProvider$p(this$0).getSchemaState(db.getJdbcConnection(), (RelationalPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE()).getAddedColumns();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAddedColumns(...)");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    void var11_11 = it;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string2 = var11_11.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    collection.add(string2);
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).contains("archived");
            }
        }));
    }

    public final boolean getArchivedFieldExists() {
        Lazy lazy = this.archivedFieldExists$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Boolean)object;
    }

    @VisibleForTesting
    public static /* synthetic */ void getArchivedFieldExists$annotations() {
    }

    public final void iterateChangeHistoryItemsForProjectOrderByGroupId(long projectId, @NotNull Function1<? super ChangeHistoryEntity, Unit> block, boolean migrateArchivedIssues) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        JiraIssueTable issueTable = this.getArchivedFieldExists() ? (JiraIssueTable)new JiraIssueTableWithArchivedColumns() : JiraIssueTable.Companion.getJIRA_ISSUE_TABLE();
        try {
            log.debug("Executing db query for fetching change history items associated with project " + projectId);
            Object object = this.databaseAccessor.run(arg_0 -> ChangeHistoryReader.iterateChangeHistoryItemsForProjectOrderByGroupId$lambda$1(issueTable, projectId, migrateArchivedIssues, block, arg_0), OnRollback.NOOP);
            Unit it = (Unit)object;
            boolean bl = false;
            log.debug("Successfully fetched change history items associated with project " + projectId);
        }
        catch (Exception ex) {
            log.error("Error while fetching change history items associated with project " + projectId, (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit iterateChangeHistoryItemsForProjectOrderByGroupId$lambda$1(JiraIssueTable $issueTable, long $projectId, boolean $migrateArchivedIssues, Function1 $block, DatabaseConnection db) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)$issueTable), (String)"$issueTable");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Expression[] expressionArray = new Expression[]{ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getID(), ChangeItemTable.INSTANCE.getFIELDTYPE(), ChangeItemTable.INSTANCE.getFIELD(), ChangeItemTable.INSTANCE.getOLDVALUE(), ChangeItemTable.INSTANCE.getOLDSTRING(), ChangeItemTable.INSTANCE.getNEWVALUE(), ChangeItemTable.INSTANCE.getNEWSTRING(), ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getISSUE_ID(), ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getAUTHOR(), ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getCREATED(), $issueTable.getPROJECT(), $issueTable.getISSUE_TYPE()};
        CloseableIterator closeableIterator = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE())).leftJoin((EntityPath)ChangeItemTable.INSTANCE)).on((Predicate)ChangeItemTable.INSTANCE.getGROUPID().eq((Expression)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getID()))).innerJoin((EntityPath)$issueTable)).on((Predicate)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getISSUE_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).where((Predicate)JiraIssueReader.Companion.belongsToProject($projectId, $issueTable, $migrateArchivedIssues))).orderBy(ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getID().asc())).iterate();
        Intrinsics.checkNotNullExpressionValue((Object)closeableIterator, (String)"iterate(...)");
        Iterator iterator2 = (Iterator)closeableIterator;
        boolean $i$f$forEach = false;
        void var8_8 = $this$forEach$iv;
        while (var8_8.hasNext()) {
            Object element$iv = var8_8.next();
            Tuple it = (Tuple)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            $block.invoke((Object)Companion.buildChangeHistoryData(it));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ DatabaseAccessor access$getDatabaseAccessor$p(ChangeHistoryReader $this) {
        return $this.databaseAccessor;
    }

    public static final /* synthetic */ SchemaStateProvider access$getSchemaStateProvider$p(ChangeHistoryReader $this) {
        return $this.schemaStateProvider;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/db/core/ChangeHistoryReader$Companion;", "", "()V", "ARCHIVED_FIELD_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildChangeHistoryData", "Lcom/atlassian/jira/migration/export/db/core/ChangeHistoryEntity;", "row", "Lcom/querydsl/core/Tuple;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final ChangeHistoryEntity buildChangeHistoryData(@NotNull Tuple row) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            Object object = row.get((Expression)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getID());
            Intrinsics.checkNotNull((Object)object);
            long l = ((Number)object).longValue();
            Object object2 = row.get((Expression)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getISSUE_ID());
            Intrinsics.checkNotNull((Object)object2);
            long l2 = ((Number)object2).longValue();
            Object object3 = row.get((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT());
            Intrinsics.checkNotNull((Object)object3);
            return new ChangeHistoryEntity(l, l2, ((Number)object3).longValue(), (String)row.get((Expression)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getAUTHOR()), (Timestamp)row.get((Expression)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getCREATED()), (String)row.get((Expression)ChangeItemTable.INSTANCE.getFIELDTYPE()), (String)row.get((Expression)ChangeItemTable.INSTANCE.getFIELD()), (String)row.get((Expression)ChangeItemTable.INSTANCE.getOLDVALUE()), (String)row.get((Expression)ChangeItemTable.INSTANCE.getOLDSTRING()), (String)row.get((Expression)ChangeItemTable.INSTANCE.getNEWVALUE()), (String)row.get((Expression)ChangeItemTable.INSTANCE.getNEWSTRING()), (String)row.get((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getISSUE_TYPE()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

