/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.core;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.export.advancedroadmaps.ParentLinkData;
import com.atlassian.jira.migration.export.db.core.IssueLinkData;
import com.atlassian.jira.migration.export.db.core.IssueLinkTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\n\u001a\u00020\tJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\n\u001a\u00020\tJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/export/db/core/IssueLinkReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getChildLink", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/export/advancedroadmaps/ParentLinkData;", "issueLinkTypeId", "", "projectId", "getInwardIssueLinksForProject", "Lcom/atlassian/jira/migration/export/db/core/IssueLinkData;", "getOutwardIssueLinksForProject", "getParentLink", "Companion", "jira-migration-plugin"})
public final class IssueLinkReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(IssueLinkReader.class);

    @Inject
    public IssueLinkReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @NotNull
    public final Sequence<IssueLinkData> getInwardIssueLinksForProject(long projectId) {
        try {
            log.debug("Executing db query for fetching inward issue links for project " + projectId);
            Object object = this.databaseAccessor.run(arg_0 -> IssueLinkReader.getInwardIssueLinksForProject$lambda$0(projectId, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched inward issue links for project " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching inward issue links for project " + projectId, (Throwable)ex);
            throw ex;
        }
    }

    @NotNull
    public final Sequence<IssueLinkData> getOutwardIssueLinksForProject(long projectId) {
        try {
            log.debug("Executing db query for fetching outward issue links for project " + projectId);
            Object object = this.databaseAccessor.run(arg_0 -> IssueLinkReader.getOutwardIssueLinksForProject$lambda$2(projectId, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched outward issue links for project " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching outward issue links for project " + projectId, (Throwable)ex);
            throw ex;
        }
    }

    @NotNull
    public final Sequence<ParentLinkData> getChildLink(long issueLinkTypeId, long projectId) {
        try {
            log.debug("Executing db query for fetching child links for issue link type with id: {} and project: {}", (Object)issueLinkTypeId, (Object)projectId);
            Object object = this.databaseAccessor.run(arg_0 -> IssueLinkReader.getChildLink$lambda$4(projectId, issueLinkTypeId, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched child links for issue link type with id: " + issueLinkTypeId + " and project: " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching child links for issue link type with id: " + issueLinkTypeId + ", project: " + projectId, (Throwable)ex);
            throw ex;
        }
    }

    @NotNull
    public final Sequence<ParentLinkData> getParentLink(long issueLinkTypeId, long projectId) {
        try {
            log.debug("Executing db query for fetching parent links for issue link type with id: {} and project: {}", (Object)issueLinkTypeId, (Object)projectId);
            Object object = this.databaseAccessor.run(arg_0 -> IssueLinkReader.getParentLink$lambda$6(projectId, issueLinkTypeId, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched parent links for issue link type with id: " + issueLinkTypeId + " and project: " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching parent links for issue link type with id: " + issueLinkTypeId + ", project: " + projectId, (Throwable)ex);
            throw ex;
        }
    }

    private static final Sequence getInwardIssueLinksForProject$lambda$0(long $projectId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{IssueLinkTable.INSTANCE.getID(), IssueLinkTable.INSTANCE.getLINKTYPE(), IssueLinkTable.INSTANCE.getSOURCE(), IssueLinkTable.INSTANCE.getDESTINATION(), IssueLinkTable.INSTANCE.getSEQUENCE()};
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)IssueLinkTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId))).where((Predicate)IssueLinkTable.INSTANCE.getLINKTYPE().isNotNull())).on((Predicate)IssueLinkTable.INSTANCE.getDESTINATION().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, IssueLinkData>((Object)Companion){

            @Nullable
            public final IssueLinkData invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).buildIssueLink(p0);
            }
        }));
    }

    private static final Sequence getOutwardIssueLinksForProject$lambda$2(long $projectId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{IssueLinkTable.INSTANCE.getID(), IssueLinkTable.INSTANCE.getLINKTYPE(), IssueLinkTable.INSTANCE.getSOURCE(), IssueLinkTable.INSTANCE.getDESTINATION(), IssueLinkTable.INSTANCE.getSEQUENCE()};
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)IssueLinkTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId))).where((Predicate)IssueLinkTable.INSTANCE.getLINKTYPE().isNotNull())).on((Predicate)IssueLinkTable.INSTANCE.getSOURCE().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, IssueLinkData>((Object)Companion){

            @Nullable
            public final IssueLinkData invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).buildIssueLink(p0);
            }
        }));
    }

    private static final Sequence getChildLink$lambda$4(long $projectId, long $issueLinkTypeId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{IssueLinkTable.INSTANCE.getSOURCE(), IssueLinkTable.INSTANCE.getDESTINATION()};
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)IssueLinkTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId))).where((Predicate)IssueLinkTable.INSTANCE.getLINKTYPE().eq((Object)$issueLinkTypeId))).on((Predicate)IssueLinkTable.INSTANCE.getSOURCE().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, ParentLinkData>((Object)Companion){

            @Nullable
            public final ParentLinkData invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).buildParentLinkData(p0);
            }
        }));
    }

    private static final Sequence getParentLink$lambda$6(long $projectId, long $issueLinkTypeId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{IssueLinkTable.INSTANCE.getSOURCE(), IssueLinkTable.INSTANCE.getDESTINATION()};
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)IssueLinkTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId))).where((Predicate)IssueLinkTable.INSTANCE.getLINKTYPE().eq((Object)$issueLinkTypeId))).on((Predicate)IssueLinkTable.INSTANCE.getDESTINATION().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, ParentLinkData>((Object)Companion){

            @Nullable
            public final ParentLinkData invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).buildParentLinkData(p0);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/db/core/IssueLinkReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildIssueLink", "Lcom/atlassian/jira/migration/export/db/core/IssueLinkData;", "row", "Lcom/querydsl/core/Tuple;", "buildParentLinkData", "Lcom/atlassian/jira/migration/export/advancedroadmaps/ParentLinkData;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final IssueLinkData buildIssueLink(@NotNull Tuple row) {
            IssueLinkData issueLinkData;
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            Long l = (Long)row.get((Expression)IssueLinkTable.INSTANCE.getLINKTYPE());
            if (l != null) {
                Long it = l;
                boolean bl = false;
                Long l2 = (Long)row.get((Expression)IssueLinkTable.INSTANCE.getSOURCE());
                if (l2 != null) {
                    Long it1 = l2;
                    boolean bl2 = false;
                    Long l3 = (Long)row.get((Expression)IssueLinkTable.INSTANCE.getDESTINATION());
                    if (l3 != null) {
                        Long it2 = l3;
                        boolean bl3 = false;
                        Object object = row.get((Expression)IssueLinkTable.INSTANCE.getID());
                        Intrinsics.checkNotNull((Object)object);
                        long l4 = ((Number)object).longValue();
                        long l5 = it;
                        Intrinsics.checkNotNull((Object)it1);
                        long l6 = it1;
                        Intrinsics.checkNotNull((Object)it2);
                        issueLinkData = new IssueLinkData(l4, l5, l6, it2, (Long)row.get((Expression)IssueLinkTable.INSTANCE.getSEQUENCE()));
                    } else {
                        issueLinkData = null;
                    }
                } else {
                    issueLinkData = null;
                }
            } else {
                issueLinkData = null;
            }
            return issueLinkData;
        }

        @VisibleForTesting
        @Nullable
        public final ParentLinkData buildParentLinkData(@NotNull Tuple row) {
            ParentLinkData parentLinkData;
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            Long l = (Long)row.get((Expression)IssueLinkTable.INSTANCE.getSOURCE());
            if (l != null) {
                Long it = l;
                boolean bl = false;
                Long l2 = (Long)row.get((Expression)IssueLinkTable.INSTANCE.getDESTINATION());
                if (l2 != null) {
                    Long it1 = l2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it1);
                    parentLinkData = new ParentLinkData(it1, it);
                } else {
                    parentLinkData = null;
                }
            } else {
                parentLinkData = null;
            }
            return parentLinkData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

